<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class ORPHANIX_Dashboard {
    public function render() {
        global $wpdb;

        $scans_table = $wpdb->prefix . 'orphanix_scans';
        $live_details_table = $wpdb->prefix . 'orphanix_live_scan_details';

        $last_media_scan = wp_cache_get( 'orphanix_last_media_scan', 'orphanix' );
        if ( false === $last_media_scan ) {
            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
            $last_media_scan = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM {$scans_table} WHERE scan_type = %s ORDER BY started_at DESC LIMIT 1", 'media' ), ARRAY_A );
            wp_cache_set( 'orphanix_last_media_scan', $last_media_scan, 'orphanix', 300 );
        }

        $last_broken_scan = wp_cache_get( 'orphanix_last_broken_scan', 'orphanix' );
        if ( false === $last_broken_scan ) {
            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
            $last_broken_scan = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM {$scans_table} WHERE scan_type = %s ORDER BY started_at DESC LIMIT 1", 'broken' ), ARRAY_A );
            wp_cache_set( 'orphanix_last_broken_scan', $last_broken_scan, 'orphanix', 300 );
        }

        $last_any_scan = wp_cache_get( 'orphanix_last_any_scan', 'orphanix' );
        if ( false === $last_any_scan ) {
            // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
            $last_any_sql = "SELECT * FROM {$scans_table} ORDER BY started_at DESC LIMIT 1";
            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
            $last_any_scan = $wpdb->get_row( $last_any_sql, ARRAY_A );
            wp_cache_set( 'orphanix_last_any_scan', $last_any_scan, 'orphanix', 300 );
        }

        $format_date = function($mysql_date) {
            if (empty($mysql_date)) {
                return __('Never','orphanix-media-cleanup');
            }
            $timestamp = strtotime($mysql_date);
            if (!$timestamp) {
                return __('Never','orphanix-media-cleanup');
            }
            return date_i18n(get_option('date_format') . ' ' . get_option('time_format'), $timestamp);
        };

        $scan_date = function($scan) use ($format_date) {
            if (empty($scan)) {
                return __('Never','orphanix-media-cleanup');
            }
            $date = !empty($scan['completed_at']) ? $scan['completed_at'] : $scan['started_at'];
            return $format_date($date);
        };

        $scan_mode_label = function($scan) {
            if (empty($scan) || empty($scan['scan_mode'])) {
                return __('-','orphanix-media-cleanup');
            }
            return ucfirst($scan['scan_mode']);
        };

        $scan_status_label = function($scan) {
            if (empty($scan) || empty($scan['status'])) {
                return __('-','orphanix-media-cleanup');
            }
            return ucfirst($scan['status']);
        };

        $last_live_scan_at = get_option('orphanix_last_live_scan_at', '');
        $last_live_status = get_option('orphanix_last_live_scan_status', '');
        $last_live_mode = get_option('orphanix_last_live_scan_mode', '');

        if (empty($last_live_scan_at)) {
            $last_live_scan_at = wp_cache_get( 'orphanix_last_live_scan_at', 'orphanix' );
            if ( false === $last_live_scan_at ) {
                // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
                $last_live_scan_at = $wpdb->get_var("SELECT MAX(created_at) FROM {$live_details_table}");
                wp_cache_set( 'orphanix_last_live_scan_at', $last_live_scan_at, 'orphanix', 300 );
            }
        }

        $last_live_scan_date = $format_date($last_live_scan_at);
        $live_status_label = $last_live_status ? ucfirst($last_live_status) : (empty($last_live_scan_at) ? __('-','orphanix-media-cleanup') : __('Completed','orphanix-media-cleanup'));
        $live_mode_label = $last_live_mode ? $last_live_mode : (empty($last_live_scan_at) ? __('-','orphanix-media-cleanup') : __('Full Site','orphanix-media-cleanup'));

        $last_any_scan_time = $last_any_scan && !empty($last_any_scan['started_at']) ? strtotime($last_any_scan['started_at']) : 0;
        $last_live_time = !empty($last_live_scan_at) ? strtotime($last_live_scan_at) : 0;

        if ($last_live_time > $last_any_scan_time) {
            $analytics_last_scan_date = $last_live_scan_date;
            $analytics_scan_mode = __('Live Site Scan','orphanix-media-cleanup');
            $analytics_status = $live_status_label;
        } elseif (!empty($last_any_scan)) {
            $analytics_last_scan_date = $scan_date($last_any_scan);
            $analytics_status = $scan_status_label($last_any_scan);
            $analytics_scan_mode = $last_any_scan['scan_type'] === 'broken'
                ? __('Broken Media Scan','orphanix-media-cleanup')
                : __('Media Scan','orphanix-media-cleanup');
        } else {
            $analytics_last_scan_date = __('Never','orphanix-media-cleanup');
            $analytics_status = __('-','orphanix-media-cleanup');
            $analytics_scan_mode = __('-','orphanix-media-cleanup');
        }

        ?>
        <div class="wrap">
            <h1><?php esc_html_e('Orphanix Media Cleanup - Dashboard','orphanix-media-cleanup'); ?></h1>

            <div class="orphanix-dashboard-grid">
                <div class="card">
                    <h2><?php esc_html_e('Media Scan','orphanix-media-cleanup'); ?></h2>
                    <p><?php esc_html_e('Finds unused and orphaned media in your library and uploads folder.','orphanix-media-cleanup'); ?></p>
                    <p><strong><?php esc_html_e('Features:','orphanix-media-cleanup'); ?></strong> <?php esc_html_e('Regular & Deep scans, checks featured images, content, custom fields, and builders; safe preview & bulk delete.','orphanix-media-cleanup'); ?></p>
                    <p><strong><?php esc_html_e('Benefits:','orphanix-media-cleanup'); ?></strong> <?php esc_html_e('Clean media library, save storage, improve performance, prevent accidental deletion.','orphanix-media-cleanup'); ?></p>
                    <div class="orphanix-status">
                        <strong><?php esc_html_e('Status Indicator:','orphanix-media-cleanup'); ?></strong>
                        <div><?php esc_html_e('Last Scan:','orphanix-media-cleanup'); ?> <span class="orphanix-status-value"><?php echo esc_html($scan_date($last_media_scan)); ?></span></div>
                        <div><?php esc_html_e('Last Scan Type:','orphanix-media-cleanup'); ?> <span class="orphanix-status-value"><?php echo esc_html($scan_mode_label($last_media_scan)); ?></span></div>
                    </div>
                    <a href="<?php echo esc_url( admin_url('admin.php?page=orphanix-scan') ); ?>" class="button button-primary">
                        <?php esc_html_e('Start New Media Scan','orphanix-media-cleanup'); ?>
                    </a>
                </div>

                <div class="card">
                    <h2><?php esc_html_e('Broken Media Scan','orphanix-media-cleanup'); ?></h2>
                    <p><?php esc_html_e('Detects missing, corrupted, or unreachable media files.','orphanix-media-cleanup'); ?></p>
                    <p><strong><?php esc_html_e('Features:','orphanix-media-cleanup'); ?></strong> <?php esc_html_e('Finds broken files, missing sizes, references in builders, fields, widgets, menus; safe cleanup with trash/restore.','orphanix-media-cleanup'); ?></p>
                    <p><strong><?php esc_html_e('Benefits:','orphanix-media-cleanup'); ?></strong> <?php esc_html_e('Avoid broken images, improve SEO & UX, safely remove invalid media.','orphanix-media-cleanup'); ?></p>
                    <div class="orphanix-status">
                        <strong><?php esc_html_e('Status Indicator:','orphanix-media-cleanup'); ?></strong>
                        <div><?php esc_html_e('Last Broken Scan:','orphanix-media-cleanup'); ?> <span class="orphanix-status-value"><?php echo esc_html($scan_date($last_broken_scan)); ?></span></div>
                        <div><?php esc_html_e('Scan Coverage:','orphanix-media-cleanup'); ?> <span class="orphanix-status-value"><?php echo esc_html($scan_mode_label($last_broken_scan)); ?></span></div>
                    </div>
                    <a href="<?php echo esc_url( admin_url('admin.php?page=orphanix-broken') ); ?>" class="button button-primary">
                        <?php esc_html_e('Start Broken Media Scan','orphanix-media-cleanup'); ?>
                    </a>
                </div>

                <div class="card">
                    <h2><?php esc_html_e('Live Site Scan','orphanix-media-cleanup'); ?></h2>
                    <p><?php esc_html_e('Checks frontend usage to see which media files are actually displayed to visitors.','orphanix-media-cleanup'); ?></p>
                    <p><strong><?php esc_html_e('Features:','orphanix-media-cleanup'); ?></strong> <?php esc_html_e('Crawls pages, detects dynamic & builder media, identifies missing live files, safe read-only scan.','orphanix-media-cleanup'); ?></p>
                    <p><strong><?php esc_html_e('Benefits:','orphanix-media-cleanup'); ?></strong> <?php esc_html_e('Accurate usage detection, avoid deleting live media, catch broken images visible to users.','orphanix-media-cleanup'); ?></p>
                    <div class="orphanix-status">
                        <strong><?php esc_html_e('Scan Status','orphanix-media-cleanup'); ?></strong>
                        <div><?php esc_html_e('Last Live Scan:','orphanix-media-cleanup'); ?> <span class="orphanix-status-value"><?php echo esc_html($last_live_scan_date); ?></span></div>
                        <div><?php esc_html_e('Scan Mode:','orphanix-media-cleanup'); ?> <span class="orphanix-status-value"><?php echo esc_html($live_mode_label); ?></span></div>
                        <div><?php esc_html_e('Status:','orphanix-media-cleanup'); ?> <span class="orphanix-status-value"><?php echo esc_html($live_status_label); ?></span></div>
                    </div>
                    <a href="<?php echo esc_url( admin_url('admin.php?page=orphanix-live') ); ?>" class="button button-primary">
                        <?php esc_html_e('Start Live Site Scan','orphanix-media-cleanup'); ?>
                    </a>
                </div>

                <div class="card">
                    <h2><?php esc_html_e('Analytics','orphanix-media-cleanup'); ?></h2>
                    <p><?php esc_html_e('Tracks scan history, actions, and system events.','orphanix-media-cleanup'); ?></p>
                    <p><strong><?php esc_html_e('Features:','orphanix-media-cleanup'); ?></strong> <?php esc_html_e('Scan stats, delete/restore tracking, error reporting, exportable reports.','orphanix-media-cleanup'); ?></p>
                    <p><strong><?php esc_html_e('Benefits:','orphanix-media-cleanup'); ?></strong> <?php esc_html_e('Audit cleanup activity, troubleshoot issues, monitor scan performance over time.','orphanix-media-cleanup'); ?></p>
                    <div class="orphanix-status">
                        <strong><?php esc_html_e('Scan Status','orphanix-media-cleanup'); ?></strong>
                        <div><?php esc_html_e('Last Scan:','orphanix-media-cleanup'); ?> <span class="orphanix-status-value"><?php echo esc_html($analytics_last_scan_date); ?></span></div>
                        <div><?php esc_html_e('Scan Mode:','orphanix-media-cleanup'); ?> <span class="orphanix-status-value"><?php echo esc_html($analytics_scan_mode); ?></span></div>
                        <div><?php esc_html_e('Status:','orphanix-media-cleanup'); ?> <span class="orphanix-status-value"><?php echo esc_html($analytics_status); ?></span></div>
                    </div>
                    <a href="<?php echo esc_url( admin_url('admin.php?page=orphanix-analytics') ); ?>" class="button button-primary">
                        <?php esc_html_e('View Detailed Analytics','orphanix-media-cleanup'); ?>
                    </a>
                </div>
            </div>

            <p>
                <a href="<?php echo esc_url( admin_url('admin.php?page=orphanix-settings') ); ?>" class="button"><?php esc_html_e('Go to Settings','orphanix-media-cleanup'); ?></a>
                <a href="https://wordpress.org/plugins/orphanix-media-cleanup/" target="_blank" class="button"><?php esc_html_e('Rate this Plugin','orphanix-media-cleanup'); ?></a>
            </p>
        </div>
        <?php
    }

}
