<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class ORPHANIX_Admin_Menu {
	public function __construct() {
		add_action( 'admin_menu', array( $this, 'register_menu' ) );
	}

	public function register_menu() {
		add_menu_page(
			__( 'Orphanix', 'orphanix-media-cleanup' ),
			__( 'Orphanix', 'orphanix-media-cleanup' ),
			'manage_options',
			'orphanix-dashboard',
			array( $this, 'render_dashboard' ),
			'dashicons-trash'
		);

		add_submenu_page( 'orphanix-dashboard', 'Dashboard', 'Dashboard', 'manage_options', 'orphanix-dashboard', array( $this, 'render_dashboard' ) );
		add_submenu_page( 'orphanix-dashboard', 'Media Scan', 'Media Scan', 'manage_options', 'orphanix-scan', array( $this, 'render_scan' ) );
		add_submenu_page( 'orphanix-dashboard', 'Broken Media Scan', 'Broken Media Scan', 'manage_options', 'orphanix-broken', array( $this, 'render_broken' ) );
		add_submenu_page( 'orphanix-dashboard', 'Live Site Scan', 'Live Site Scan', 'manage_options', 'orphanix-live', array( $this, 'render_live_scan' ) );
		add_submenu_page( 'orphanix-dashboard', 'Analytics', 'Analytics', 'manage_options', 'orphanix-analytics', array( $this, 'render_analytics' ) );
		add_submenu_page( 'orphanix-dashboard', 'Settings', 'Settings', 'manage_options', 'orphanix-settings', array( $this, 'render_settings' ) );
	}

	public function render_dashboard() {
		( new ORPHANIX_Dashboard() )->render();
	}

	public function render_scan() {
		( new ORPHANIX_Media_Scan() )->render();
	}

	public function render_broken() {
		( new ORPHANIX_Broken_Scan() )->render();
	}

	public function render_analytics() {
		( new ORPHANIX_Analytics() )->render();
	}

	public function render_settings() {
		( new ORPHANIX_Settings() )->render();
	}

	public function render_live_scan() {
		( new ORPHANIX_Live_Scan_Page() )->render();
	}
}
