<?php
if (!defined('ABSPATH')) {
    exit();
}

/**
 * OrkestaPay_Helper class.
 *
 */
class OrkestaPay_Helper
{
    public static function transform_data_4_checkout($order, $successUrl, $cancelUrl)
    {
        $products = [];
        foreach ($order->get_items() as $item) {
            $product = wc_get_product($item->get_product_id());
            $prouctID = $product->get_id();
            $productType = $product->get_type();
            $name = trim(preg_replace('/[[:^print:]]/', '', strip_tags($product->get_title())));
            $desc = trim(preg_replace('/[[:^print:]]/', '', strip_tags($product->get_description())));
            $thumbnailUrl = wp_get_attachment_image_url($product->get_image_id());
            $productPrice = wc_get_price_including_tax($product);
            $isDigital = $product->is_virtual() || $product->is_downloadable();

            // If product has variations, image, price and ID is taken from here
            if ($productType == 'variable') {
                $prouctID = $item->get_variation_id();
                $variable_product = new WC_Product_Variation($item->get_variation_id());
                $thumbnailUrl = wp_get_attachment_image_url($variable_product->get_image_id());
                $productPrice = wc_get_price_including_tax($variable_product);
            }

            $products[] = [
                'product_id' => "$prouctID",
                'name' => $name,
                'description' => substr($desc, 0, 250),
                'quantity' => $item->get_quantity(),
                'unit_price' => $productPrice,
                'thumbnail_url' => $thumbnailUrl,
                'is_digital' => $isDigital,
                'url' => $product->get_permalink(),
            ];
        }

        // Definir la fecha futura (en este ejemplo, 1 hora en el futuro)
        $expiresAt = strtotime('+1 hour') * 1000; // Convertir a milisegundos
        $checkoutData = [
            'completed_redirect_url' => $successUrl,
            'canceled_redirect_url' => $cancelUrl,
            'allow_save_payment_methods' => false,
            'order' => [
                'expires_at' => $expiresAt,
                'merchant_order_id' => $order->get_id() . '_' . time(),
                'currency' => $order->get_currency(),
                'country_code' => $order->get_billing_country(),
                'subtotal_amount' => $order->get_subtotal(),
                'total_amount' => $order->get_total(),
                'products' => $products,
                'customer' => [
                    'merchant_customer_id' => "{$order->get_user_id()}",
                    'first_name' => $order->get_billing_first_name(),
                    'last_name' => $order->get_billing_last_name(),
                    'email' => $order->get_billing_email(),
                    'phone' => [
                        'number' => $order->get_billing_phone(),
                        'country_code' => '52',
                    ],
                ],
            ],
        ];

        // Si no existe un user_id, se remueve el índice
        if ($order->get_user_id() === 0) {
            unset($checkoutData['order']['customer']['merchant_customer_id']);
        }

        // Validar dirección de facturación
        if ($order->get_billing_address_1() && $order->get_billing_city() && $order->get_billing_state() && $order->get_billing_country() && $order->get_billing_postcode()) {
            $checkoutData['order']['billing_address'] = [
                'first_name' => $order->get_billing_first_name(),
                'last_name' => $order->get_billing_last_name(),
                'email' => $order->get_billing_email(),
                'line_1' => $order->get_billing_address_1(),
                'line_2' => $order->get_billing_address_2(),
                'city' => $order->get_billing_city(),
                'state' => $order->get_billing_state(),
                'country' => $order->get_billing_country(),
                'zip_code' => $order->get_billing_postcode(),
            ];
        }

        // Validar dirección de envío
        if ($order->get_shipping_address_1() && $order->get_shipping_city() && $order->get_shipping_state() && $order->get_shipping_country() && $order->get_shipping_postcode()) {
            $checkoutData['order']['shipping_address'] = [
                'first_name' => $order->get_billing_first_name(),
                'last_name' => $order->get_billing_last_name(),
                'email' => $order->get_billing_email(),
                'line_1' => $order->get_shipping_address_1(),
                'line_2' => $order->get_shipping_address_2(),
                'city' => $order->get_shipping_city(),
                'state' => $order->get_shipping_state(),
                'country' => $order->get_shipping_country(),
                'zip_code' => $order->get_shipping_postcode(),
            ];
        }

        // Si hay gastos de envío, se agrega el índice
        if ($order->get_shipping_total() > 0) {
            $shipping = $order->get_shipping_total() + $order->get_shipping_tax();
            $checkoutData['order']['shipping_details'] = [
                'amount' => $shipping,
            ];
        }

        // Si hay descuentos, se agrega el índice
        if ($order->get_discount_total() > 0) {
            $checkoutData['order']['discounts'] = [
                ['amount' => $order->get_discount_total()],
            ];
        }

        return $checkoutData;
    }

    public static function remove_string_spaces($text)
    {
        return preg_replace('/\s+/', '', wc_clean($text));
    }

    public static function get_expiration_month($exp_date)
    {
        $exp_date = self::remove_string_spaces($exp_date);
        $exp_date = explode('/', $exp_date);
        return $exp_date[0];
    }

    public static function get_expiration_year($exp_date)
    {
        $exp_date = self::remove_string_spaces($exp_date);
        $exp_date = explode('/', $exp_date);
        return $exp_date[1];
    }

    public static function is_null_or_empty_string($string)
    {
        return !isset($string) || trim($string) === '';
    }

    public static function get_signature_from_url($url)
    {
        $url_components = explode('&signature=', $url);
        return $url_components[1];
    }

    public static function get_order_id_from_url($url)
    {
        $url_components = explode('order_id=', $url);
        return $url_components[1];
    }
}
