const orkestapaySettings = window.wc.wcSettings.getSetting("orkestapay_data", {});

const orkestapayLabel = window.wp.htmlEntities.decodeEntities(orkestapaySettings.title) || window.wp.i18n.__("Orkestapay", "orkestapay");

const OrkestaPayContent = (props) => {
  const { eventRegistration, emitResponse, billing } = props;
  const { onPaymentProcessing } = eventRegistration;

  wp.element.useEffect(() => {
    const unsubscribe = onPaymentProcessing(async () => {
      // Realizar la llamada AJAX
      try {
        return {
          type: emitResponse.responseTypes.SUCCESS,
          message: "",
        };
      } catch (error) {
        console.error("Error:", error.message);
        return {
          type: emitResponse.responseTypes.ERROR,
          message: response.statusText,
        };
      }
    });
    // Unsubscribes when this component is unmounted.
    return () => {
      unsubscribe();
    };
  }, [onPaymentProcessing, billing.billingAddress]);

  return window.wp.htmlEntities.decodeEntities(orkestapaySettings.description || "");
};

const OrkestaPay_Block_Gateway = {
  name: "orkestapay",
  label: orkestapayLabel,
  content: Object(window.wp.element.createElement)(OrkestaPayContent, null),
  edit: Object(window.wp.element.createElement)(OrkestaPayContent, null),
  canMakePayment: () => true,
  ariaLabel: orkestapayLabel,
  supports: {
    features: orkestapaySettings.supports,
  },
};

window.wc.wcBlocksRegistry.registerPaymentMethod(OrkestaPay_Block_Gateway);
