<?php
if (!defined('ABSPATH')) {
    exit();
}

/**
 * OrkestaPayCard_Helper class.
 *
 */
class OrkestaPayCard_Helper
{
    const PAYMENT_METHOD_CARD = 'CARD';

    /**
     * Description
     *
     * @return array
     */
    public static function transform_data_4_orders($order)
    {
        $products = [];
        foreach ($order->get_items() as $item) {
            $product = wc_get_product($item->get_product_id());
            $prouctID = $product->get_id();
            $productType = $product->get_type();
            $name = trim(preg_replace('/[[:^print:]]/', '', strip_tags($product->get_title())));
            $desc = trim(preg_replace('/[[:^print:]]/', '', strip_tags($product->get_description())));
            $thumbnailUrl = wp_get_attachment_image_url($product->get_image_id());
            $productPrice = wc_get_price_including_tax($product);
            $isDigital = $product->is_virtual() || $product->is_downloadable();

            // If product has variations, image, price and ID is taken from here
            if ($productType == 'variable') {
                $prouctID = $item->get_variation_id();
                $variable_product = new WC_Product_Variation($item->get_variation_id());
                $thumbnailUrl = wp_get_attachment_image_url($variable_product->get_image_id());
                $productPrice = wc_get_price_including_tax($variable_product);
            }

            $products[] = [
                'product_id' => "$prouctID",
                'name' => $name,
                'description' => substr($desc, 0, 250),
                'quantity' => $item->get_quantity(),
                'unit_price' => $productPrice,
                'thumbnail_url' => $thumbnailUrl,
                'is_digital' => $isDigital,
                'url' => $product->get_permalink(),
            ];
        }

        $orderData = [
            'merchant_order_id' => $order->get_id() . '_' . time(),
            'currency' => $order->get_currency(),
            'country_code' => $order->get_billing_country(),
            'subtotal_amount' => $order->get_subtotal(),
            'total_amount' => $order->get_total(),
            'products' => $products,
            'customer' => [
                'first_name' => $order->get_billing_first_name(),
                'last_name' => $order->get_billing_last_name(),
                'email' => $order->get_billing_email(),
                'phone' => [
                    'number' => $order->get_billing_phone(),
                    'country_code' => '52',
                ],
            ],
        ];

        $user_id = get_current_user_id();
        $orkestapay_client_id = get_user_meta($user_id, 'orkestapay_customer_id', true);

        // Si orkestapay_client_id existe, se remueve el customer y se agrega el customer_id
        if (!empty($orkestapay_client_id)) {
            unset($orderData['customer']);
            $orderData['customer_id'] = $orkestapay_client_id;
        }

        // Validar dirección de envío
        if ($order->get_shipping_address_1() && $order->get_shipping_city() && $order->get_shipping_state() && $order->get_shipping_country() && $order->get_shipping_postcode()) {
            $orderData['shipping_address'] = [
                'first_name' => $order->get_billing_first_name(),
                'last_name' => $order->get_billing_last_name(),
                'email' => $order->get_billing_email(),
                'line_1' => $order->get_shipping_address_1(),
                'line_2' => $order->get_shipping_address_2(),
                'city' => $order->get_shipping_city(),
                'state' => $order->get_shipping_state(),
                'country' => $order->get_shipping_country(),
                'zip_code' => $order->get_shipping_postcode(),
            ];
        }

        // Si hay gastos de envío, se agrega el índice
        if ($order->get_shipping_total() > 0) {
            $shipping = $order->get_shipping_total() + $order->get_shipping_tax();
            $orderData['shipping_details'] = [
                'amount' => $shipping,
            ];
        }

        // Si hay descuentos, se agrega el índice
        if ($order->get_discount_total() > 0) {
            $orderData['discounts'][] = ['amount' => $order->get_discount_total()];
        }

        // Obtener el descuento aplicado por el afiliado
        $affiliate_discount = get_post_meta($order->get_id(), '_yith_affiliate_discount', true);
        if (!empty($affiliate_discount)) {
            $orderData['discounts'][] = ['amount' => $affiliate_discount];
        }

        return $orderData;
    }

    /**
     * Description
     *
     * @return array
     */
    public static function transform_data_4_payment($orkestaOrderId, $orkestaPaymentMethodId, $orderId, $deviceSessionId, $successUrl, $cancelUrl)
    {
        $paymentData = [
            'order_id' => $orkestaOrderId,
            'payment_source' => [
                'type' => self::PAYMENT_METHOD_CARD,
                'payment_method_id' => $orkestaPaymentMethodId,
                'settings' => [
                    'card' => [
                        'capture' => true,
                    ],
                    'redirection_url' => [
                        'completed_redirect_url' => $successUrl,
                        'canceled_redirect_url' => $cancelUrl,
                    ],
                ],
            ],
            'device_session_id' => $deviceSessionId,
            'metadata' => [
                'merchant_order_id' => $orderId,
            ],
        ];

        return $paymentData;
    }

    public static function remove_string_spaces($text)
    {
        return preg_replace('/\s+/', '', wc_clean($text));
    }

    public static function get_expiration_month($exp_date)
    {
        $exp_date = self::remove_string_spaces($exp_date);
        $exp_date = explode('/', $exp_date);
        return $exp_date[0];
    }

    public static function get_expiration_year($exp_date)
    {
        $exp_date = self::remove_string_spaces($exp_date);
        $exp_date = explode('/', $exp_date);
        return $exp_date[1];
    }

    public static function is_null_or_empty_string($string)
    {
        return !isset($string) || trim($string) === '';
    }

    public static function get_signature_from_url($url)
    {
        $url_components = explode('&signature=', $url);
        return $url_components[1];
    }

    public static function get_order_id_from_url($url)
    {
        $url_components = explode('orderId=', $url);
        return $url_components[1];
    }
}
