const orkestapayCardSettings = window.wc.wcSettings.getSetting('orkestapay-card_data', {});
const orkestapayCardLabel = window.wp.htmlEntities.decodeEntities(orkestapayCardSettings.title) || window.wp.i18n.__('Orkestapay', 'orkestapay-card');

var orkestapay = initOrkestaPay({
    merchant_id: orkestapayCardSettings.merchant_id,
    public_key: orkestapayCardSettings.public_key,
    is_sandbox: orkestapayCardSettings.is_sandbox,
});

console.log('orkestapay.js v1.2.0', orkestapay);

const cardExpiryValue = (value) => {
    var month, prefix, year, _ref;
    value = value.replace(/\s/g, '');
    (_ref = value.split('/', 2)), (month = _ref[0]), (year = _ref[1]);
    if ((year != null ? year.length : void 0) === 2 && /^\d+$/.test(year)) {
        prefix = new Date().getFullYear();
        prefix = prefix.toString().slice(0, 2);
        year = prefix + year;
    }

    return {
        month: month,
        year: year,
    };
};

const OrkestapayCardContent = (props) => {
    const { eventRegistration, emitResponse, billing, shippingData } = props;
    const { onPaymentProcessing } = eventRegistration;

    wp.element.useEffect(() => {
        jQuery('.wc-credit-card-form-card-number').payment('formatCardNumber');
        jQuery('.wc-credit-card-form-card-expiry').payment('formatCardExpiry');
        jQuery('.wc-credit-card-form-card-cvc').payment('formatCardCVC');
    }, []);

    wp.element.useEffect(() => {
        const unsubscribe = onPaymentProcessing(async () => {
            try {
                const deviceSessionid = document.getElementById('orkestapay_device_session_id');
                const cardNumber = document.getElementById('orkestapay-card-number');
                const holderName = document.getElementById('orkestapay-holder-name');
                const verificationCode = document.getElementById('orkestapay-card-cvc');
                const expirationDate = document.getElementById('orkestapay-card-expiry');
                const expiry = cardExpiryValue(expirationDate.value);

                const card = {
                    card_number: cardNumber.value,
                    expiration_date: { expiration_month: expiry['month'], expiration_year: expiry['year'] },
                    verification_code: verificationCode.value,
                    holder_name: holderName.value,
                };

                const orkestapayCard = await orkestapay.createCard();
                const paymentMethodData = {
                    card,
                    one_time_use: true,
                    billing_address: {
                        first_name: billing.billingAddress.first_name,
                        last_name: billing.billingAddress.first_name,
                        email: billing.billingAddress.email,
                        line_1: billing.billingAddress.address_1,
                        line_2: billing.billingAddress.address_2,
                        city: billing.billingAddress.city,
                        state: billing.billingAddress.state,
                        country: billing.billingAddress.country,
                        zip_code: billing.billingAddress.postcode,
                    },
                };

                // Crea un token de pago
                const paymentMethod = await orkestapayCard.createToken(paymentMethodData);

                // Asigna un valor al campo de texto "orkestapay_payment_method_id"
                const paymentMethodInput = document.getElementById('orkestapay_payment_method_id');
                paymentMethodInput.value = paymentMethod.payment_method_id;

                // Submit the form
                return {
                    type: emitResponse.responseTypes.SUCCESS,
                    meta: {
                        paymentMethodData: {
                            orkestapay_payment_method_id: paymentMethod.payment_method_id,
                            orkestapay_device_session_id: deviceSessionid.value,
                        },
                    },
                };
            } catch (error) {
                console.error('Error:', error.message);
                return {
                    type: emitResponse.responseTypes.ERROR,
                    message: error.message,
                };
            }
        });
        // Unsubscribes when this component is unmounted.
        return () => {
            unsubscribe();
        };
    }, [emitResponse.responseTypes.ERROR, emitResponse.responseTypes.SUCCESS, onPaymentProcessing, billing.billingAddress]);

    return wp.element.RawHTML({
        children: orkestapayCardSettings.orkestapay_form,
    });
};

const Orkestapay_Card_Block_Gateway = {
    name: 'orkestapay-card',
    label: orkestapayCardLabel,
    content: window.wp.element.createElement(OrkestapayCardContent, null),
    edit: window.wp.element.createElement(OrkestapayCardContent, null),
    canMakePayment: () => true,
    ariaLabel: orkestapayCardLabel,
    supports: {
        features: orkestapayCardSettings.supports,
    },
};

window.wc.wcBlocksRegistry.registerPaymentMethod(Orkestapay_Card_Block_Gateway);
