jQuery(document).ready(async function () {
    var $form = jQuery('form.checkout');

    // Orkesta params
    const plugin_payment_gateway_id = orkestapay_card_payment_args.plugin_payment_gateway_id;
    const merchant_id = orkestapay_card_payment_args.merchant_id;
    const public_key = orkestapay_card_payment_args.public_key;
    const is_sandbox = orkestapay_card_payment_args.is_sandbox === '1';
    const orkestapay_create_customer_url = orkestapay_card_payment_args.orkestapay_create_customer_url;
    const orkestapay_customer_id = orkestapay_card_payment_args.orkestapay_customer_id;
    // const promotions_params = { currency: orkestapay_card_payment_args.currency, total_amount: orkestapay_card_payment_args.total_amount };

    const orkestapay = initOrkestaPay({ merchant_id, public_key, is_sandbox });
    console.log('orkestapay.js v1.2.0', orkestapay);

    const orkestapay_card = await orkestapay.createCard();

    // Gestiona el selector de tarjetas guardadas
    jQuery('#wc-orkestapay-card-payment-token').on('change', function () {
        jQuery('#wc-' + plugin_payment_gateway_id + '-new-payment-method').prop('checked', false);

        const value = jQuery(this).val();

        if (value === 'new') {
            jQuery('#orkestapay-container-card').show();
        } else {
            jQuery('#orkestapay-container-card').hide();
        }
    });

    // Se genera el device_session_id
    await setDeviceSessionId(orkestapay);

    jQuery('body').on('click', 'form.checkout button:submit', function () {
        jQuery('.woocommerce-error').remove();
        // Make sure there's not an old orkestapay_payment_method_id on the form
        jQuery('#orkestapay_payment_method_id').val('');
    });

    // Bind to the checkout_place_order event to add the token
    jQuery('form.checkout').bind('checkout_place_order', function (e) {
        if (jQuery('input[name=payment_method]:checked').val() !== plugin_payment_gateway_id) {
            return true;
        }

        // Revisa si existe una tarjeta guardada
        if (jQuery('#wc-orkestapay-card-payment-token').length) {
            const savedCard = jQuery('#wc-orkestapay-card-payment-token').val();
            // Si existe una tarjeta guardada, la asignamos al campo orkestapay_payment_method_id
            if (savedCard !== 'new') {
                jQuery('#orkestapay_payment_method_id').val(savedCard);
                jQuery('#wc-' + plugin_payment_gateway_id + '-new-payment-method').prop('checked', false);
            }
        }

        // Pass if we have a orkestapay_payment_method_id
        if (jQuery('#orkestapay_payment_method_id').val() !== '') {
            return true;
        }

        $form.block({ message: null, overlayCSS: { background: '#fff', opacity: 0.6 } });

        handleRequests();

        return false; // Prevent the form from submitting with the default action
    });

    async function handleRequests() {
        try {
            const new_payment_method = document.getElementById('wc-' + plugin_payment_gateway_id + '-new-payment-method');
            const should_save_payment_method = new_payment_method && new_payment_method.checked;

            const card_number = document.getElementById('orkestapay-card-number');
            const holder_name = document.getElementById('orkestapay-holder-name');
            const verification_code = document.getElementById('orkestapay-card-cvc');
            const expiration_date = document.getElementById('orkestapay-card-expiry');
            const expiry = cardExpiryVal(expiration_date.value);

            const card = {
                card_number: card_number.value,
                expiration_date: { expiration_month: expiry['month'], expiration_year: expiry['year'] },
                verification_code: verification_code.value,
                holder_name: holder_name.value,
            };

            let payment_method_data = {
                card,
                one_time_use: !should_save_payment_method, // If the user is saving the payment method, we set it to one_time_use=false
            };

            if (jQuery('#billing_address_1').length && jQuery('#billing_address_1').val() && jQuery('#billing_state').val() && jQuery('#billing_city').val() && jQuery('#billing_postcode').val()) {
                const billing_address = {
                    first_name: jQuery('#billing_first_name').val(),
                    last_name: jQuery('#billing_last_name').val(),
                    email: jQuery('#billing_email').val(),
                    line_1: jQuery('#billing_address_1').val(),
                    line_2: jQuery('#billing_address_2').val(),
                    city: jQuery('#billing_city').val(),
                    state: jQuery('#billing_state').val(),
                    country: jQuery('#billing_country').val(),
                    zip_code: jQuery('#billing_postcode').val(),
                };

                payment_method_data = { ...payment_method_data, billing_address };
            }

            // If the user is saving the payment method, we need to create a customer
            if (should_save_payment_method) {
                const customerId = orkestapay_customer_id !== '' ? orkestapay_customer_id : await customerRequest();
                payment_method_data = { ...payment_method_data, customer_id: customerId };
            }

            const payment_method = await orkestapay_card.createToken(payment_method_data);

            jQuery('#orkestapay_payment_method_id').val(payment_method.payment_method_id);

            $form.submit();
        } catch (err) {
            logError(handleRequests.name, err);
            displayErrorMessage(err);
        }
    }

    function customerRequest() {
        return new Promise((resolve, reject) => {
            jQuery.ajax({
                type: 'POST',
                url: orkestapay_create_customer_url,
                contentType: 'application/json; charset=UTF-8',
                data: JSON.stringify({}),
                success: async function (response) {
                    const { data } = response;
                    resolve(data.customer_id); // Resolvemos con el ID del cliente
                },
                error: function (error) {
                    console.error('customerRequest error', error.responseJSON); // For testing (to be removed)
                    reject(error); // Rechazamos para que pueda capturarse con .catch()
                },
            });
        });
    }
});

async function setDeviceSessionId(orkestapay) {
    try {
        const { device_session_id } = await orkestapay.getDeviceInfo();
        console.log('setDeviceSessionId', device_session_id);
        jQuery('#orkestapay_device_session_id').val(device_session_id);
    } catch (err) {
        console.error('setDeviceSessionId', err);
    }
}

function handlePromotionChanges(orkestapay_card) {
    const card_promotions = document.getElementById('orkestapay-installments');

    orkestapay_card.card_number.promotions$.subscribe((promotions) => {
        card_promotions.replaceChildren();

        const option = document.createElement('option');
        option.value = null;
        option.textContent = 'Select promotion';
        card_promotions.appendChild(option);

        for (const type of promotions) {
            for (const promotion of type.installments) {
                const option = document.createElement('option');
                option.value = promotion;
                option.textContent = `${promotion} ${type.type}`;
                card_promotions.appendChild(option);
            }
        }
    });
}

function displayErrorMessage(error) {
    jQuery('form.checkout').unblock();
    jQuery('.woocommerce-error').remove();
    jQuery('html, body').animate({ scrollTop: jQuery('.woocommerce-notices-wrapper').offset().top });
    jQuery('form.checkout')
        .closest('div')
        .before(
            '<ul style="background-color: #e2401c; color: #fff; margin-bottom: 10px; margin-top: 10px; border-radius: 8px;" class="woocommerce_error woocommerce-error"><li> ' + error + ' </li></ul>'
        );
}

function logError(origin, error) {
    error && console.error(origin, error.code, error);
}

function cardExpiryVal(value) {
    var month, prefix, year, _ref;
    value = value.replace(/\s/g, '');
    (_ref = value.split('/', 2)), (month = _ref[0]), (year = _ref[1]);
    if ((year != null ? year.length : void 0) === 2 && /^\d+$/.test(year)) {
        prefix = new Date().getFullYear();
        prefix = prefix.toString().slice(0, 2);
        year = prefix + year;
    }

    return {
        month: month,
        year: year,
    };
}
