<?php
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

if (!current_user_can('activate_plugins')) {
    exit;
}

require_once plugin_dir_path(__FILE__) . 'includes/functions.php';

if (is_multisite()) {
    $sites = get_sites();
    $delete_data_any_site = false;
    foreach ($sites as $site) {
        switch_to_blog($site->blog_id);
        if (get_option('tulipwork_orderstock_delete_data_on_uninstall', 0)) {
            $delete_data_any_site = true;
        }
        restore_current_blog();
    }
    foreach ($sites as $site) {
        tulipwork_orderstock_cleanup_site($site->blog_id);
    }
} else {
    tulipwork_orderstock_cleanup_site(get_current_blog_id());
}