jQuery(document).ready(function($) {
    var inlineEditPost = inlineEditPost;
    inlineEditPost.edit = function(id) {
        inlineEditPost.edit.apply(this, arguments);

        var postId = 0;
        if (typeof id === 'object') {
            postId = parseInt(this.getId(id));
        }

        if (postId > 0) {
            var $row = $('#post-' + postId);
            var $editRow = $('#edit-' + postId);

            var supplierId = $row.find('.column-suppliers').data('supplier-id') || '-1';
            var taxRate = $row.find('.column-tax_rate').text().trim();
            var assignedStores = $row.find('.column-assigned_stores').data('stores') || [];
            var isInternalRecipe = $row.find('.column-suppliers').data('is-internal-recipe') || 0;

            $editRow.find('select[name="tulipwork_orderstock_supplier_quick"]').val(supplierId);
            $editRow.find('select[name="tax_rate_quick"]').val(taxRate || '-1');
            if ($editRow.find('input[name="tulipwork_orderstock_assigned_stores_quick[]"]').length) {
                $editRow.find('input[name="tulipwork_orderstock_assigned_stores_quick[]"]').each(function() {
                    $(this).prop('checked', assignedStores.includes(parseInt($(this).val())));
                });
            }
            if ($editRow.find('select[name="is_internal_recipe_quick"]').length) {
                $editRow.find('select[name="is_internal_recipe_quick"]').val(isInternalRecipe ? '1' : '0');
            }
        }
    };
});