<?php
/**
 * HPOS Compatibility class
 *
 * @package ExportOrdersWC
 */

namespace ExportOrdersWC;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * HPOS Compatibility checker.
 *
 * Single Responsibility Principle: Handles only HPOS detection.
 *
 * @since 1.0.0
 */
class HposCompatibility {

	/**
	 * Check if HPOS is enabled.
	 *
	 * @return bool
	 */
	public function is_hpos_enabled() {
		if ( ! class_exists( 'Automattic\WooCommerce\Utilities\OrderUtil' ) ) {
			return false;
		}

		return \Automattic\WooCommerce\Utilities\OrderUtil::custom_orders_table_usage_is_enabled();
	}

	/**
	 * Get the current order screen ID.
	 *
	 * @return string
	 */
	public function get_order_screen_id() {
		if ( $this->is_hpos_enabled() ) {
			return 'woocommerce_page_wc-orders';
		}

		return 'edit-shop_order';
	}

	/**
	 * Get the order list URL.
	 *
	 * @return string
	 */
	public function get_order_list_url() {
		if ( $this->is_hpos_enabled() ) {
			return admin_url( 'admin.php?page=wc-orders' );
		}

		return admin_url( 'edit.php?post_type=shop_order' );
	}
}
