<?php
/**
 * Autoloader class
 *
 * @package ExportOrdersWC
 */

namespace ExportOrdersWC;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Autoloader class.
 *
 * @since 1.0.0
 */
class Autoloader {

	/**
	 * Register autoloader.
	 *
	 * @return void
	 */
	public static function register() {
		spl_autoload_register( array( __CLASS__, 'autoload' ) );
	}

	/**
	 * Autoload classes.
	 *
	 * @param string $class_name Class name.
	 * @return void
	 */
	public static function autoload( $class_name ) {
		// Check if class belongs to our namespace.
		if ( strpos( $class_name, 'ExportOrdersWC\\' ) !== 0 ) {
			return;
		}

		// Remove namespace prefix.
		$class_name = str_replace( 'ExportOrdersWC\\', '', $class_name );

		// Convert class name to file name.
		$class_name = strtolower( $class_name );
		$class_name = str_replace( '_', '-', $class_name );
		$file       = 'class-' . $class_name . '.php';

		// Determine subdirectory based on class name.
		$subdirs = array( 'includes', 'admin', 'includes/interfaces', 'includes/exporters' );

		foreach ( $subdirs as $subdir ) {
			$path = EXPORT_ORDERS_WC_PLUGIN_DIR . $subdir . '/' . $file;
			if ( file_exists( $path ) ) {
				require_once $path;
				return;
			}
		}
	}
}
