<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://wijnberg.dev
 * @since             1.0.0
 * @package           Wdevs_Customer_Order_Export
 *
 * @wordpress-plugin
 * Plugin Name:          OrderBridge – Multi-Channel Export for WooCommerce
 * Plugin URI:           https://wijnberg.dev
 * Description:          Save time with automated multi-format WooCommerce order exports sent instantly to customers via email or cloud.
 * Version:              1.0.2
 * Author URI:           https://wijnberg.dev/
 * License:              GPL-2.0+
 * License URI:          http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:          orderbridge-for-woocommerce
 * Domain Path:          /languages
 * Tested up to:         6.9
 * Requires PHP:         8.3
 * Requires at least:    6.4
 * WC requires at least: 8.3.0
 * WC tested up to:      10.3.6
 * Requires Plugins:     woocommerce
 */
// If this file is called directly, abort.
if ( !defined( 'WPINC' ) ) {
    die;
}
if ( file_exists( __DIR__ . '/vendor/autoload.php' ) ) {
    require_once __DIR__ . '/vendor/autoload.php';
}
if ( function_exists( 'wdevs_coe_fs' ) ) {
    wdevs_coe_fs()->set_basename( false, __FILE__ );
} else {
    /**
     * DO NOT REMOVE THIS IF, IT IS ESSENTIAL FOR THE
     * `function_exists` CALL ABOVE TO PROPERLY WORK.
     */
    if ( !function_exists( 'wdevs_coe_fs' ) ) {
        // Create a helper function for easy SDK access.
        function wdevs_coe_fs() {
            global $wdevs_coe_fs;
            if ( !isset( $wdevs_coe_fs ) ) {
                // Include Freemius SDK.
                // SDK is auto-loaded through composer
                $wdevs_coe_fs = fs_dynamic_init( array(
                    'id'               => '19875',
                    'slug'             => 'orderbridge-for-woocommerce',
                    'premium_slug'     => 'orderbridge-pro-for-woocommerce',
                    'type'             => 'plugin',
                    'public_key'       => 'pk_5e8ff8531a33df4d247d6842507bd',
                    'is_premium'       => false,
                    'premium_suffix'   => 'Pro',
                    'has_addons'       => false,
                    'has_paid_plans'   => true,
                    'menu'             => array(
                        'contact'     => false,
                        'support'     => false,
                        'affiliation' => false,
                        'account'     => true,
                        'pricing'     => true,
                        'addons'      => false,
                        'navigation'  => 'tabs',
                        'slug'        => 'wc-settings',
                        'parent'      => array(
                            'slug' => 'woocommerce',
                        ),
                    ),
                    'is_org_compliant' => true,
                    'is_live'          => true,
                ) );
            }
            return $wdevs_coe_fs;
        }

    }
    // Init Freemius.
    wdevs_coe_fs();
    // Signal that SDK was initiated.
    do_action( 'wdevs_coe_fs_loaded' );
    function wdevs_coe_fs_settings_url() {
        return admin_url( 'admin.php?page=wc-settings&tab=wdevs_coe' );
    }

    wdevs_coe_fs()->add_filter( 'connect_url', 'wdevs_coe_fs_settings_url' );
    wdevs_coe_fs()->add_filter( 'after_skip_url', 'wdevs_coe_fs_settings_url' );
    wdevs_coe_fs()->add_filter( 'after_connect_url', 'wdevs_coe_fs_settings_url' );
    wdevs_coe_fs()->add_filter( 'after_pending_connect_url', 'wdevs_coe_fs_settings_url' );
    wdevs_coe_fs()->add_filter(
        'is_submenu_visible',
        function ( $is_visible, $id ) {
            $page = ( isset( $_GET['page'] ) ? sanitize_text_field( wp_unslash( $_GET['page'] ) ) : '' );
            $tab = ( isset( $_GET['tab'] ) ? sanitize_text_field( wp_unslash( $_GET['tab'] ) ) : '' );
            if ( $page === 'wc-settings' && $tab === 'wdevs_coe' ) {
                return $is_visible;
            }
            return false;
        },
        10,
        2
    );
    function wdevs_coe_fs_uninstall_cleanup() {
    }

    wdevs_coe_fs()->add_action( 'after_uninstall', 'wdevs_coe_fs_uninstall_cleanup' );
}
/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'WDEVS_CUSTOMER_ORDER_EXPORT_VERSION', '1.0.2' );
/**
 * The code that runs during plugin activation.
 * This action is documented in includes/Activator.php
 */
function wdevs_customer_order_export_activate() {
    \WDevs\CustomerOrderExport\Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/Deactivator.php
 */
function wdevs_customer_order_export_deactivate() {
    \WDevs\CustomerOrderExport\Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'wdevs_customer_order_export_activate' );
register_deactivation_hook( __FILE__, 'wdevs_customer_order_export_deactivate' );
/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_wdevs_customer_order_export() {
    $plugin = new \WDevs\CustomerOrderExport\CustomerOrderExport();
    $plugin->run();
}

run_wdevs_customer_order_export();