<?php

/**
 * Export Channels
 *
 * Shows export channels on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/wdevs-order-export-channels.php.
 *
 * @link       https://wijnberg.dev
 * @since      1.0.0
 *
 * @package    CustomerOrderExport
 * @subpackage CustomerOrderExport/public/partials
 */

defined( 'ABSPATH' ) || exit;

do_action( 'wdevs_coe_before_account_export_channels' );

?>

<div class="wdevs-customer-order-export">
	<p>
		<?php esc_html_e( 'Configure how your order exports are delivered. You can enable multiple channels and customize each one to your needs.', 'orderbridge-for-woocommerce' ); ?>
	</p>

	<?php if ( ! empty( $view_data['channels'] ) ) : ?>
		<?php foreach ( $view_data['channels'] as $channel ) : ?>
			<div class="export-channel">
				<details>
					<summary>
						<?php echo esc_html( $channel->get_name() ); ?>
						<span class="channel-status-badge <?php echo $channel->is_connected() ? esc_attr( 'connected' ) : esc_attr( 'disconnected' ); ?>">
							<?php echo $channel->is_connected() ? esc_html__( 'Connected', 'orderbridge-for-woocommerce' ) : esc_html__( 'Not connected', 'orderbridge-for-woocommerce' ); ?>
						</span>
					</summary>
					<div class="channel-content">
						<p class="channel-description">
							<?php echo esc_html( $channel->get_account_page_description() ); ?>
						</p>

						<div class="channel-actions">
							<a href="<?php echo esc_url( wc_get_endpoint_url( $view_data['endpoint'], $channel->get_slug() ) ); ?>" class="button<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>">
								<?php echo esc_html( sprintf( __( 'Configure %s', 'orderbridge-for-woocommerce' ), $channel->get_name() ) ); ?>
							</a>
						</div>
					</div>
				</details>
			</div>
		<?php endforeach; ?>
	<?php endif; ?>

</div>

<?php do_action( 'wdevs_coe_after_account_export_channels' ); ?>