<?php

namespace WDevs\CustomerOrderExport;

/**
 * The helper functionality of the plugin.
 *
 * @link       https://wijnberg.dev
 * @since      1.0.0
 *
 * @package    Wdevs_Customer_Order_Export
 * @subpackage Wdevs_Customer_Order_Export/includes
 */

/**
 * The helper functionality of the plugin.
 *
 * Defines helper methods for string manipulation.
 *
 * @package    Wdevs_Customer_Order_Export
 * @subpackage Wdevs_Customer_Order_Export/includes
 * @author     Wijnberg Developments <contact@wijnberg.dev>
 */
trait Helper {

	/**
	 * Retrieve the configured columns
	 *
	 * @return array The sorted columns configuration
	 * @since 1.0.0
	 */
	public function get_templates() {
		$columns = get_option( 'wdevs_coe_templates', array() );

		return apply_filters( 'wdevs_coe_get_templates', $columns );
	}

	/**
	 * Converts an array of templates into a select options format
	 *
	 * @param array $templates Array of templates (id => [name => string, ...])
	 *
	 * @return array Options array formatted for select dropdown:
	 *              [
	 *                  '' => 'Select an option',
	 *                  template_id => template_name,
	 *                  ...
	 *              ]
	 * @since 1.0.0
	 */
	public function get_template_options( $templates ) {

		$options = array( '' => __( 'Select an option', 'orderbridge-for-woocommerce' ) );

		foreach ( $templates as $template_id => $template ) {
			$options[ $template_id ] = $template['name'];
		}

		return $options;
	}

}