<?php

namespace WDevs\CustomerOrderExport\Generators;

/**
 * File generator factory
 *
 * Creates the appropriate file generator based on requested format
 *
 * @since      1.0.0
 * @package    Wdevs_Customer_Order_Export
 * @subpackage Wdevs_Customer_Order_Export/includes
 * @author     Wijnberg Developments <contact@wijnberg.dev>
 */
class FileGeneratorFactory {
    /**
     * Creates a file generator instance for the specified type
     *
     * @return FileProcessor
     * @since 1.0.0
     */
    public static function create( string $type = null ) {
        return new CsvGenerator();
    }

}
