<?php


namespace WDevs\CustomerOrderExport\ColumnCategories;


class Order extends ColumnCategoryProcessor implements ColumnCategoryInterface {

	public static $category_id = 'order_fields';

	public function __construct( $order_item, $column_id, $column_data ) {
		parent::__construct( $order_item, $column_id, $column_data );
	}

	/**
	 * @param array $excluded_keys
	 *
	 * @return array $fields The fields that can be selected as column
	 * @since 1.0.0
	 */
	public static function get_fields( $excluded_keys = [] ) {
		return [
			'order_id'         => [
				'field'       => __( 'Order ID', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Order ID', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The ID of the order', 'orderbridge-for-woocommerce' ),
			],
			'status'           => [
				'field'       => __( 'Status', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Status', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The status of the order', 'orderbridge-for-woocommerce' ),
			],
			'currency'         => [
				'field'       => __( 'Currency', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Currency', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The currency used for the order (e.g., EUR, USD)', 'orderbridge-for-woocommerce' ),
			],
			'date_created'     => [
				'field'       => __( 'Order Date', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Order Date', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The date and time when the order was placed', 'orderbridge-for-woocommerce' ),
			],
			'billing_first_name'  => [
				'field'       => __( 'Billing First Name', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Billing First Name', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The first name provided in the billing address', 'orderbridge-for-woocommerce' ),
			],
			'billing_last_name'   => [
				'field'       => __( 'Billing Last Name', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Billing Last Name', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The last name provided in the billing address', 'orderbridge-for-woocommerce' ),
			],
			'billing_company'  => [
				'field'       => __( 'Billing Company', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Billing Company', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The company name provided in the billing address', 'orderbridge-for-woocommerce' ),
			],
			'billing_address_1'   => [
				'field'       => __( 'Billing Address 1', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Billing Address 1', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The first line of the billing address', 'orderbridge-for-woocommerce' ),
			],
			'billing_address_2'   => [
				'field'       => __( 'Billing Address 2', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Billing Address 2', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The second line of the billing address', 'orderbridge-for-woocommerce' ),
			],
			'billing_city'        => [
				'field'       => __( 'Billing City', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Billing City', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The city provided in the billing address', 'orderbridge-for-woocommerce' ),
			],
			'billing_postcode'    => [
				'field'       => __( 'Billing Postal/Zip Code', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Billing Postal/Zip Code', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The postal/zip code provided in the billing address', 'orderbridge-for-woocommerce' ),
			],
			'billing_state'       => [
				'field'       => __( 'Billing State', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Billing State', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The state/province provided in the billing address', 'orderbridge-for-woocommerce' ),
			],
			'billing_country'     => [
				'field'       => __( 'Billing Country / Region', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Billing Country / Region', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The country/region provided in the billing address', 'orderbridge-for-woocommerce' ),
			],
			'billing_phone'       => [
				'field'       => __( 'Billing Phone Number', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Billing Phone Number', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The phone number provided in the billing address', 'orderbridge-for-woocommerce' ),
			],
			'billing_email'       => [
				'field'       => __( 'Email Address', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Email Address', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The email address provided by the customer', 'orderbridge-for-woocommerce' ),
			],
			'shipping_first_name' => [
				'field'       => __( 'Shipping First Name', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Shipping First Name', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The first name provided in the shipping address', 'orderbridge-for-woocommerce' ),
			],
			'shipping_last_name'  => [
				'field'       => __( 'Shipping Last Name', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Shipping Last Name', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The last name provided in the shipping address', 'orderbridge-for-woocommerce' ),
			],
			'shipping_company' => [
				'field'       => __( 'Shipping Company', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Shipping Company', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The company name provided in the shipping address', 'orderbridge-for-woocommerce' ),
			],
			'shipping_address_1'  => [
				'field'       => __( 'Shipping Address 1', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Shipping Address 1', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The first line of the shipping address', 'orderbridge-for-woocommerce' ),
			],
			'shipping_address_2'  => [
				'field'       => __( 'Shipping Address 2', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Shipping Address 2', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The second line of the shipping address', 'orderbridge-for-woocommerce' ),
			],
			'shipping_city'       => [
				'field'       => __( 'Shipping City', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Shipping City', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The city provided in the shipping address', 'orderbridge-for-woocommerce' ),
			],
			'shipping_postcode'   => [
				'field'       => __( 'Shipping Postal/Zip Code', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Shipping Postal/Zip Code', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The postal/zip code provided in the shipping address', 'orderbridge-for-woocommerce' ),
			],
			'shipping_state'      => [
				'field'       => __( 'Shipping State', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Shipping State', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The state/province provided in the shipping address', 'orderbridge-for-woocommerce' ),
			],
			'shipping_country'    => [
				'field'       => __( 'Shipping Country / Region', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Shipping Country / Region', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The country/region provided in the shipping address', 'orderbridge-for-woocommerce' ),
			],
			'shipping_phone'      => [
				'field'       => __( 'Shipping Phone Number', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Shipping Phone Number', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The phone number provided in the shipping address', 'orderbridge-for-woocommerce' ),
			],
		];
	}

	/**
	 * @return string $name returns the name of the category
	 * @since 1.0.0
	 */
	public static function get_category_name() {
		return __( 'Order fields', 'orderbridge-for-woocommerce' );
	}

	/**
	 * Returns the value for the current column
	 *
	 * @return null|string
	 * @since 1.0.0
	 */
	public function get_column_value() {
		if ( ! $this->order_item_is_set() ) {
			return null;
		}

		$order = $this->order_item->get_order();


		if ( ! $order || ! is_a( $order, \WC_Order::class ) ) {
			return null;
		}

		return $this->get_order_value( $order, $this->column_id );

	}

	/**
	 * Gets the specific order field value
	 *
	 * @param \WC_Order $order The WooCommerce order object
	 * @param string $column_id The column/field ID to retrieve
	 * @return string|null The requested order value or null if not found
	 *
	 * @since 1.0.0
	 */
	private function get_order_value( $order, $column_id ) {
		switch ( $column_id ) {
			case 'order_id':
				return $order->get_id();
			case 'status':
				return $order->get_status();
			case 'currency':
				return $order->get_currency();
			case 'date_created':
				return $order->get_date_created() ? $order->get_date_created()->format( 'Y-m-d H:i:s' ) : '';
			case 'billing_first_name':
				return $order->get_billing_first_name();
			case 'billing_last_name':
				return $order->get_billing_last_name();
			case 'billing_company':
				return $order->get_billing_company();
			case 'billing_address_1':
				return $order->get_billing_address_1();
			case 'billing_address_2':
				return $order->get_billing_address_2();
			case 'billing_city':
				return $order->get_billing_city();
			case 'billing_postcode':
				return $order->get_billing_postcode();
			case 'billing_state':
				return $order->get_billing_state();
			case 'billing_country':
				return $order->get_billing_country();
			case 'billing_phone':
				return $order->get_billing_phone();
			case 'billing_email':
				return $order->get_billing_email();
			case 'shipping_first_name':
				return $order->get_shipping_first_name();
			case 'shipping_last_name':
				return $order->get_shipping_last_name();
			case 'shipping_company':
				return $order->get_shipping_company();
			case 'shipping_address_1':
				return $order->get_shipping_address_1();
			case 'shipping_address_2':
				return $order->get_shipping_address_2();
			case 'shipping_city':
				return $order->get_shipping_city();
			case 'shipping_postcode':
				return $order->get_shipping_postcode();
			case 'shipping_state':
				return $order->get_shipping_state();
			case 'shipping_country':
				return $order->get_shipping_country();
			case 'shipping_phone':
				return $order->get_shipping_phone();
			default:
				return null;
		}
	}

}