<?php


namespace WDevs\CustomerOrderExport\ColumnCategories;


abstract class ColumnCategoryProcessor {

	protected $order_item;
	protected $column_id;
	protected $column_data;

	public static $category_id = '';

	/**
	 * @param $order_item \WC_Order_Item_Product
	 * @param $column_id 'name', 'price', 'sku', etc
	 * @param $column_data Array ( [field] => '' [name] => '' [order] => '' [description] => '' [category] => '' )
	 */
	public function __construct($order_item, $column_id, $column_data){
		$this->order_item = $order_item;
		$this->column_id = $column_id;
		$this->column_data = $column_data;
	}

	/**
	 * Checks if the order_item is set.
	 *
	 * @return bool
	 * @since 1.0.0
	 */
	public function order_item_is_set(){
		if (!$this->order_item || !is_a($this->order_item, \WC_Order_Item_Product::class)) {
			return false;
		}

		return true;
	}
}