<?php

namespace WDevs\CustomerOrderExport\ColumnCategories;

interface ColumnCategoryInterface {

	/**
	 * @param array $excluded_keys
	 *
	 * @return array $fields The fields that can be selected as column
	 * @since 1.0.0
	 */
	public static function get_fields($excluded_keys = []);

	/**
	 * @return string $name returns the name of the category
	 * @since 1.0.0
	 */
	public static function get_category_name();

	/**
	 * Returns the value for the current column
	 *
	 * @return null|string
	 * @since 1.0.0
	 */
	public function get_column_value();
}