<?php

/**
 * Channel Edit Form
 *
 * Shows the channel configuration form on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/wdevs-channel-edit.php.
 *
 * @link       https://wijnberg.dev
 * @since      1.0.0
 *
 * @package    CustomerOrderExport
 * @subpackage CustomerOrderExport/public/partials
 */

defined( 'ABSPATH' ) || exit;

$channel = $view_data['channel'];
?>

<?php do_action( 'wdevs_coe_before_edit_channel_form', $channel ); ?>

<form method="post" novalidate="novalidate">

	<h2><?php echo esc_html( $channel->get_name() ); ?></h2>

	<div class="wdevs-coe-channel-fields">
		<?php $channel->render_account_form_fields(); ?>
	</div>

	<p>
		<?php wp_nonce_field( 'wdevs_coe_edit_channel_' . $channel->get_slug(), $view_data['nonce_field'] ); ?>
        <input type="hidden" name="action" value="edit_channel" />
        <input type="hidden" name="channel_slug" value="<?php echo esc_attr( $channel->get_slug() ); ?>" />
		<?php if ( $channel->show_save_button() ) : ?>
			<button type="submit" class="button<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="save_channel" value="<?php esc_attr_e( 'Save settings', 'orderbridge-for-woocommerce' ); ?>">
				<?php esc_html_e( 'Save settings', 'orderbridge-for-woocommerce' ); ?>
			</button>
		<?php endif; ?>
	</p>

</form>

<p>
	<a href="<?php echo esc_url( wc_get_endpoint_url( $view_data['endpoint'] ) ); ?>" class="button">
		&larr; <?php esc_html_e( 'Back to Channels', 'orderbridge-for-woocommerce' ); ?>
	</a>
</p>

<?php do_action( 'wdevs_coe_after_edit_channel_form', $channel ); ?>