<?php

namespace WDevs\CustomerOrderExport\Generators;

use WDevs\CustomerOrderExport\Template;

/**
 * Interface for file generators in the Customer Order Export for WooCommerce plugin
 *
 * Defines the contract that all file generator classes must implement
 * to ensure consistent generation capabilities across different file formats.
 *
 * @since      1.0.0
 * @package    Wdevs_Customer_Order_Export
 * @subpackage Wdevs_Customer_Order_Export/includes/Generators
 */
interface FileGeneratorInterface {

	/**
	 * Generates the output file for a specified WooCommerce order
	 *
	 * @param Template $template The template configuration object
	 * @param string $file_name The name/path for the output file
	 * @param int|null $order_id The ID of the WooCommerce order to process.
	 *                          If null, processes all orders or uses template default
	 * @param string $delimiter The delimiter character to use in output (default: ',')
	 * @return string The full file path of the generated output
	 *
	 * @since 1.0.0
	 */
	public function generate( $template, $file_name, $order_id = null, $delimiter = ',' );
}