<?php


namespace WDevs\CustomerOrderExport\ColumnCategories;


class OrderItem extends ColumnCategoryProcessor implements ColumnCategoryInterface {

	public static $category_id = 'order_item_fields';

	public function __construct( $order_item, $column_id, $column_data ) {
		parent::__construct( $order_item, $column_id, $column_data );
	}

	/**
	 * @param array $excluded_keys
	 *
	 * @return array $fields The fields that can be selected as column
	 * @since 1.0.0
	 */
	public static function get_fields($excluded_keys = []) {
		return [
			'name'         => [
				'field'       => __( 'Product/variation name', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Product/variation name', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The name of the product', 'orderbridge-for-woocommerce' ),
			],
			'product_id'   => [
				'field'       => __( 'Product ID', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Product ID', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The unique identifier of the product', 'orderbridge-for-woocommerce' ),
			],
			'variation_id' => [
				'field'       => __( 'Variation ID', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Variation ID', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The unique identifier of the product variation', 'orderbridge-for-woocommerce' ),
			],
			'quantity'     => [
				'field'       => __( 'Quantity', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Quantity', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The quantity of this item in the order', 'orderbridge-for-woocommerce' ),
			],
			'tax_class'    => [
				'field'       => __( 'Tax class', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Tax class', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'The tax class applied to this item (e.g., standard, reduced-rate)', 'orderbridge-for-woocommerce' ),
			],
			'subtotal'     => [
				'field'       => __( 'Subtotal', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Subtotal', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'Item price × quantity BEFORE discounts/taxes', 'orderbridge-for-woocommerce' ),
			],
			'subtotal_tax' => [
				'field'       => __( 'Subtotal Tax', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Subtotal Tax', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'Tax amount for the subtotal', 'orderbridge-for-woocommerce' ),
			],
			'total'        => [
				'field'       => __( 'Total', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Total', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'Item price × quantity AFTER discounts (excluding tax)', 'orderbridge-for-woocommerce' ),
			],
			'total_tax'    => [
				'field'       => __( 'Total Tax', 'orderbridge-for-woocommerce' ),
				'name'        => __( 'Total Tax', 'orderbridge-for-woocommerce' ),
				'category'    => self::$category_id,
				'description' => __( 'Total tax amount after discounts', 'orderbridge-for-woocommerce' ),
			],
		];
	}

	/**
	 * @return string $name returns the name of the category
	 * @since 1.0.0
	 */
	public static function get_category_name() {
		return __( 'Order item fields', 'orderbridge-for-woocommerce' );
	}

	/**
	 * Returns the value for the current column
	 *
	 * @return null|string
	 * @since 1.0.0
	 */
	public function get_column_value() {
		if(!$this->order_item_is_set()){
			return null;
		}
		return $this->get_order_item_field_value( $this->order_item, $this->column_id );
	}

	/**
	 * Retrieves the value of a specific order item field
	 *
	 * @param \WC_Order_Item_Product $order_item The WooCommerce order item object
	 * @param string $column_id The field/column identifier to retrieve
	 * @return mixed|null The requested field value or null if not found
	 *                    Returns string for text fields, float for amounts, int for IDs
	 * @since 1.0.0
	 */
	private function get_order_item_field_value( $order_item, $column_id ) {

		switch ( $column_id ) {
			case 'name':
				return $order_item->get_name();
			case 'product_id':
				return $order_item->get_product_id();
			case 'variation_id':
				return $order_item->get_variation_id();
			case 'quantity':
				return $order_item->get_quantity();
			case 'tax_class':
				return $order_item->get_tax_class();
			case 'subtotal':
				return $order_item->get_subtotal();
			case 'subtotal_tax':
				return $order_item->get_subtotal_tax();
			case 'total':
				return $order_item->get_total();
			case 'total_tax':
				return $order_item->get_total_tax();
			default:
				return null;
		}
	}
}