<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$templates   = is_array( $view_data['templates'] ) ? $view_data['templates'] : array();

$show_empty_state = empty( $templates );

?>

<h2 class="wc-shipping-zones-heading">
	<span><?php esc_html_e( 'Templates', 'orderbridge-for-woocommerce' ); ?></span>
	<a href="<?php echo esc_url( admin_url( 'admin.php?page=wc-settings&tab=wdevs_coe&section=templates&template_id=new' ) ); ?>" class="page-title-action"><?php esc_html_e( 'Add template', 'orderbridge-for-woocommerce' ); ?></a>
</h2>
<p class="wc-shipping-zone-heading-help-text">
	<?php esc_html_e('Templates let you choose which columns to include in your export file. You can create as many templates as you need, each with its own set of columns.', 'orderbridge-for-woocommerce'); ?>
</p>
<table class="wdevs-coe-templates wc-shipping-zones widefat">
	<thead>
		<tr>
			<th><?php esc_html_e( 'Template name', 'orderbridge-for-woocommerce' ); ?></th>
			<th></th>
		</tr>
	</thead>
	<tbody class="wc-shipping-zone-rows wc-shipping-tables-tbody">
	<?php if ( $show_empty_state ) : ?>
        <tr>
            <td class="wc-shipping-classes-blank-state" colspan="2">
                <p><?php esc_html_e( 'No templates have been added.', 'orderbridge-for-woocommerce' ); ?></p>
            </td>
        </tr>
	<?php else : ?>
		<?php foreach ($templates as $template_id => $template) : ?>
            <tr data-id="<?php echo esc_attr($template_id); ?>">
                <td class="wc-shipping-zone-name">
	                <?php echo esc_html($template['name']); ?>
                </td>
                <td class="wc-shipping-zone-actions">
                    <div>
                        <a class="wc-shipping-zone-action-edit" href="admin.php?page=wc-settings&amp;tab=wdevs_coe&amp;section=templates&amp;template_id=<?php echo esc_attr($template_id); ?>"><?php esc_html_e( 'Edit', 'orderbridge-for-woocommerce' ); ?></a> | <a href="#" class="wdevs-coe-template-delete wc-shipping-zone-delete wc-shipping-zone-actions"><?php esc_html_e( 'Delete', 'orderbridge-for-woocommerce' ); ?></a>
                    </div>
                </td>
            </tr>
		<?php endforeach; ?>
	<?php endif; ?>
    </tbody>
</table>