<?php
/**
 * Shipping zone admin
 *
 * @package WooCommerce\Admin\Shipping
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$template = $view_data['template'];
?>


<?php wc_back_header( $template->get_name() ? $template->get_name() : __( 'Add template', 'orderbridge-for-woocommerce' ), __( 'Return to templates', 'orderbridge-for-woocommerce' ), admin_url( 'admin.php?page=wc-settings&tab=wdevs_coe&section=templates' ) ); ?>

<table class="form-table wc-shipping-zone-settings">
    <tbody>
    <tr valign="top" class="">
        <th scope="row" class="titledesc">
            <label for="name">
				<?php esc_html_e( 'Template name', 'orderbridge-for-woocommerce' ); ?>
            </label>
            <p class="wc-shipping-zone-help-text">
				<?php esc_html_e( 'The name of the template, for example "B2B" or "General".', 'orderbridge-for-woocommerce' ); ?>
            </p>
        </th>
        <td class="forminp">
            <input type="text" data-attribute="name" name="name" id="name"
                   value="<?php echo esc_attr( $template->get_name() ); ?>"
                   placeholder="<?php esc_attr_e( 'Template name', 'orderbridge-for-woocommerce' ); ?>">
        </td>
    </tr>
    <tr valign="top" class="">
        <th scope="row" class="titledesc">
            <label>
				<?php esc_html_e( 'Columns', 'orderbridge-for-woocommerce' ); ?>
            </label>
            <p class="wc-shipping-zone-help-text">
				<?php esc_html_e( 'Select the columns you\'d like to include in the export file.', 'orderbridge-for-woocommerce' ); ?>
				<?php
				if ( ! wdevs_coe_fs()->is_premium() ) {
					$upgrade_url = wdevs_coe_fs()->get_upgrade_url();
					$upsell_text = __( 'Unlock additional columns with Pro, including custom fields and specific product attributes.', 'orderbridge-for-woocommerce' );

					/* translators: %s: Link to the plugin upgrade (Pro) page */
					echo sprintf(
						' <a href="%s" target="_blank" rel="noopener noreferrer">%s</a>',
						esc_url( $upgrade_url ),
						esc_html( $upsell_text )
					);
				}
				?>
            </p>
        </th>
        <td class="">
            <table class="wdevs-coe-template-columns wc-shipping-zone-methods widefat">
                <thead>
                <tr>
                    <th class="wc-shipping-zone-method-sort"></th>
                    <th class="wc-shipping-zone-method-title"><?php esc_html_e( 'Field', 'orderbridge-for-woocommerce' ); ?></th>
                    <th class="wc-shipping-zone-method-name"><?php esc_html_e( 'Name', 'orderbridge-for-woocommerce' ); ?></th>
                    <th class="wc-shipping-zone-method-id"><?php esc_html_e( 'Column id', 'orderbridge-for-woocommerce' ); ?></th>
                    <th></th>
                </tr>
                </thead>
                <tbody class="wdevs-coe-template-columns-rows wc-shipping-zone-method-rows wc-shipping-tables-tbody"></tbody>
            </table>
        </td>
    </tr>
    <tr>
        <th scope="row"></th>
        <td>
            <button type="submit" class="wdevs-coe-template-configure-column-button components-button is-primary"
                    value="<?php esc_attr_e( 'Add column', 'orderbridge-for-woocommerce' ); ?>"><?php esc_html_e( 'Add column', 'orderbridge-for-woocommerce' ); ?></button>
        </td>
    </tr>
    </tbody>
</table>

<p class="submit">
    <button type="submit" name="submit" id="submit"
            class="button-primary button-large wdevs-coe-template-columns-save components-button is-primary"
            value="<?php esc_attr_e( 'Save changes', 'orderbridge-for-woocommerce' ); ?>"
            disabled><?php esc_html_e( 'Save changes', 'orderbridge-for-woocommerce' ); ?></button>
</p>

<script type="text/html" id="tmpl-wdevs-coe-template-columns-row-blank">
    <tr>
        <td class="wdevs-coe-template-columns-blank-state" colspan="3">
            <p><?php esc_html_e( 'You can add multiple columns within this template.', 'orderbridge-for-woocommerce' ); ?></p>
        </td>
    </tr>
</script>

<script type="text/html" id="tmpl-wdevs-coe-template-columns-row">
    <tr data-id="{{ data.column_id }}">
        <td width="1%" class="wc-shipping-zone-method-sort"></td>
        <td class="wdevs-ceo-column-field wc-shipping-zone-method-title">
            <div class="view">{{ data.field }}</div>
        </td>
        <td class="devs-ceo-column-name wc-shipping-zone-method-title">
            <div class="view">{{ data.name }}</div>
        </td>
        <td class="devs-ceo-column-column_id wc-shipping-zone-method-title">
            <div class="view">{{ data.column_id }}</div>
        </td>
        <td class="wc-shipping-zone-actions">
            <div>
                <a class="wdevs-ceo-column-edit wc-shipping-zone-action-edit"
                   href="#"><?php esc_html_e( 'Edit', 'orderbridge-for-woocommerce' ); ?></a> |
                <a href="#"
                   class="wdevs-ceo-column-delete wc-shipping-zone-actions"><?php esc_html_e( 'Delete', 'orderbridge-for-woocommerce' ); ?></a>
            </div>
        </td>
    </tr>
</script>

<script type="text/template" id="tmpl-wdevs-coe-template-configure-column">
    <div class="wc-backbone-modal wc-shipping-class-modal wdevs-coe-column-modal">
        <div class="wc-backbone-modal-content" data-template_id="{{ data.template_id }}"
             data-column_id="{{ data.column_id }}">
            <section class="wc-backbone-modal-main" role="main">
                <header class="wc-backbone-modal-header">
                    <h1>{{{data.action==='create' ? '<?php esc_html_e('Add column', 'orderbridge-for-woocommerce'); ?>' : '<?php esc_html_e('Edit column', 'orderbridge-for-woocommerce'); ?>'}}}</h1>
                    <button class="modal-close modal-close-link dashicons dashicons-no-alt">
                        <span class="screen-reader-text"><?php esc_html_e( 'Close modal panel', 'orderbridge-for-woocommerce' ); ?></span>
                    </button>
                </header>
                <article>
                    <form action="" method="post">
                        <input type="hidden" name="template_id" value="{{{ data.template_id }}}"/>

                        <div class="wc-shipping-class-modal-input wc-order-item-column-modal-input wdevs-coe-column-category">
                            <div class="view">
								<?php esc_html_e( 'Category', 'orderbridge-for-woocommerce' ); ?> *
                            </div>
                            <div class="edit">
                                <select name="category_id" data-attribute="category_id">
                                    <option value=""><?php esc_html_e( 'Select a category', 'orderbridge-for-woocommerce' ); ?></option>
                                </select>
                            </div>
                            <div class="wc-order-item-column-modal-help-text">
								<?php esc_html_e( 'Select the data category', 'orderbridge-for-woocommerce' ); ?>
                            </div>
                        </div>

                        <div class="wc-shipping-class-modal-input wc-order-item-column-modal-input wdevs-coe-column-field">
                            <div class="view">
								<?php esc_html_e( 'Field', 'orderbridge-for-woocommerce' ); ?> *
                            </div>
                            <div class="edit">
                                <select name="field_id" data-attribute="field_id">
                                    <option value=""><?php esc_html_e( 'Select a field', 'orderbridge-for-woocommerce' ); ?></option>
                                </select>
                            </div>
                            <div class="wc-order-item-column-modal-help-text" id="field-help-text">
								<?php esc_html_e( 'Select which field should be included in the export file', 'orderbridge-for-woocommerce' ); ?>
                            </div>
                        </div>

                        <div class="wc-shipping-class-modal-input wc-order-item-column-modal-input wdevs-coe-column-name">
                            <div class="view">
								<?php esc_html_e( 'Column name', 'orderbridge-for-woocommerce' ); ?> *
                            </div>
                            <div class="edit">
                                <input type="text" name="name" data-attribute="name" value="{{{ data.name }}}"
                                       placeholder="<?php esc_attr_e( 'e.g. Product title', 'orderbridge-for-woocommerce' ); ?>"/>
                            </div>
                            <div class="wc-order-item-column-modal-help-text">
								<?php esc_html_e( 'This will be the column name in the attached files', 'orderbridge-for-woocommerce' ); ?>
                            </div>
                        </div>
                    </form>
                </article>
                <footer>
                    <div class="inner">
                        <button id="btn-ok" class="button button-primary button-large">
                            <div class="wc-backbone-modal-action-{{ data.action === 'create' ? 'active' : 'inactive' }}"><?php esc_html_e( 'Create', 'orderbridge-for-woocommerce' ); ?></div>
                            <div class="wc-backbone-modal-action-{{ data.action === 'edit' ? 'active' : 'inactive' }}"><?php esc_html_e( 'Save', 'orderbridge-for-woocommerce' ); ?></div>
                        </button>
                    </div>
                </footer>
            </section>
        </div>
    </div>
    <div class="wc-backbone-modal-backdrop modal-close"></div>
</script>
