( function ( $ ) {
	'use strict';

	//document ready
	$( function () {
		const $formatSelect = $( '.wdevs_coe_file_format_select' );

		function toggleDelimiterField() {
			const $formatSelect = $( this );
			const $delimiter = $formatSelect
				.closest( 'table' )
				.find( '.wdevs_coe_csv_delimiter_select' );
			const $delimiterRow = $delimiter.length
				? $delimiter.closest( 'tr' )
				: null;

			if ( ! $delimiterRow ) {
				return;
			}

			if ( $formatSelect.val() === 'csv' ) {
				$delimiterRow.show();
			} else {
				$delimiterRow.hide();
			}
		}

		if ( $formatSelect.length ) {
			$formatSelect
				.on( 'change', toggleDelimiterField )
				.trigger( 'change' );
		}
	} );
} )( jQuery );
