<?php
defined( 'ABSPATH' ) || exit;

/* @var WC_Order $order */
/* @var string   $email_heading */
/* @var bool     $sent_to_admin */
/* @var bool     $plain_text */
/* @var WC_Email $email */

echo esc_html( (string) $email_heading ) . "\n\n";

$oste_first_name = '';
if ( $order instanceof WC_Order ) {
    $oste_first_name = (string) $order->get_billing_first_name();
}

if ( '' !== $oste_first_name ) {
    /* translators: %s is the customer's first name. */
    echo esc_html( sprintf( __( 'Hi %s,', 'order-status-tracking-emails-for-woocommerce' ), $oste_first_name ) ) . "\n\n";
} else {
    echo esc_html__( 'Hi,', 'order-status-tracking-emails-for-woocommerce' ) . "\n\n";
}

if ( isset( $intro ) && '' !== $intro ) {
    echo esc_html( wp_strip_all_tags( (string) $intro ) ) . "\n\n";
}

if ( ! empty( $additional_content ) ) {
    echo esc_html( wp_strip_all_tags( (string) $additional_content ) ) . "\n\n";
}

$oste_footer_text = (string) apply_filters( 'woocommerce_email_footer_text', (string) get_option( 'woocommerce_email_footer_text' ) );
echo esc_html( $oste_footer_text ) . "\n";
