<?php
/**
 * Email Header
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/email-header.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates\Emails
 * @version 10.0.0
 */

use Automattic\WooCommerce\Utilities\FeaturesUtil;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$oste_email_improvements_enabled = FeaturesUtil::feature_is_enabled( 'email_improvements' );
$oste_store_name                 = isset( $store_name ) ? $store_name : get_bloginfo( 'name', 'display' );
$oste_email_opts                 = get_option( 'oste_gestione_email_stati_ordine', array() );
$oste_show_site_name             = ! isset( $oste_email_opts['show_site_name'] ) || '1' === (string) $oste_email_opts['show_site_name'];

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=<?php bloginfo( 'charset' ); ?>" />
		<meta content="width=device-width, initial-scale=1.0" name="viewport">
		<title><?php echo esc_html( $oste_store_name ); ?></title>
	</head>
	<body <?php echo is_rtl() ? 'rightmargin' : 'leftmargin'; ?>="0" marginwidth="0" topmargin="0" marginheight="0" offset="0">
		<table width="100%" id="outer_wrapper">
			<tr>
				<td><!-- Deliberately empty to support consistent sizing and layout across multiple email clients. --></td>
				<td width="600">
					<div id="wrapper" dir="<?php echo is_rtl() ? 'rtl' : 'ltr'; ?>">
						<table border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" id="inner_wrapper">
							<tr>
								<td align="center" valign="top">
									<?php
									$oste_img = get_option( 'woocommerce_email_header_image' );
									/**
									 * This filter is documented in templates/emails/email-styles.php
									 *
									 * @since 9.6.0
									 */
									if ( apply_filters( 'woocommerce_is_email_preview', false ) ) {
										$oste_img_transient = get_transient( 'woocommerce_email_header_image' );
										$oste_img           = false !== $oste_img_transient ? $oste_img_transient : $oste_img;
									}

									$oste_has_header_logo = (bool) $oste_img;
									$oste_has_header_text = ( ! $oste_img && $oste_show_site_name );
									$oste_show_header_block = $oste_has_header_logo || $oste_has_header_text;

									if ( $oste_email_improvements_enabled ) :
										?>
										<?php if ( $oste_show_header_block ) : ?>
											<table border="0" cellpadding="0" cellspacing="0" width="100%">
												<tr>
													<td id="template_header_image">
														<?php
														if ( $oste_has_header_logo ) {
															echo '<p style="margin-top:0;"><img src="' . esc_url( $oste_img ) . '" alt="' . esc_attr( $oste_store_name ) . '" /></p>';
														} elseif ( $oste_has_header_text ) {
															echo '<p class="email-logo-text">' . esc_html( $oste_store_name ) . '</p>';
														}
														?>
													</td>
												</tr>
											</table>
										<?php endif; ?>
									<?php else : ?>
										<?php if ( $oste_has_header_logo ) : ?>
											<div id="template_header_image">
												<?php
												echo '<p style="margin-top:0;"><img src="' . esc_url( $oste_img ) . '" alt="' . esc_attr( $oste_store_name ) . '" /></p>';
												?>
											</div>
										<?php endif; ?>
									<?php endif; ?>
									<table border="0" cellpadding="0" cellspacing="0" width="100%" id="template_container">
										<tr>
											<td align="center" valign="top">
												<!-- Header -->
												<table border="0" cellpadding="0" cellspacing="0" width="100%" id="template_header">
													<tr>
														<td id="header_wrapper">
															<h1><?php echo wp_kses_post( $email_heading ); ?></h1>
														</td>
													</tr>
												</table>
												<!-- End Header -->
											</td>
										</tr>
										<tr>
											<td align="center" valign="top">
												<!-- Body -->
												<table border="0" cellpadding="0" cellspacing="0" width="100%" id="template_body">
													<tr>
														<td valign="top" id="body_content">
															<!-- Content -->
															<table border="0" cellpadding="20" cellspacing="0" width="100%">
																<tr>
																	<td valign="top" id="body_content_inner_cell">
																		<div id="body_content_inner">
