<?php
/**
 * Email Addresses (OSTE override)
 *
 * Rende cliccabile l'email di fatturazione e mantiene lo styling della preview admin.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates\Emails
 * @version 9.8.0
 */

use Automattic\WooCommerce\Utilities\FeaturesUtil;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$oste_address  = $order->get_formatted_billing_address();
$oste_shipping = $order->get_formatted_shipping_address();

$oste_email_improvements_enabled = FeaturesUtil::feature_is_enabled( 'email_improvements' );

$oste_styling_opts = [];
if ( function_exists( 'oste_email_styling_default_options' ) ) {
	$oste_styling_opts = wp_parse_args(
		get_option( 'oste_email_styling', [] ),
		oste_email_styling_default_options()
	);
}
$oste_address_link_color = esc_attr( $oste_styling_opts['order_address_link_color'] ?? $oste_styling_opts['link_color'] ?? '#1e73be' );
$oste_address_font       = esc_attr( $oste_styling_opts['order_address_font'] ?? $oste_styling_opts['text_font'] ?? 'Arial, sans-serif' );
$oste_address_link_style = sprintf(
	'color:%s !important; font-family:%s !important; text-decoration:underline !important;',
	$oste_address_link_color,
	$oste_address_font
);
$oste_phone_link_style = $oste_address_link_style;

?>
<table id="addresses" cellspacing="0" cellpadding="0" style="width: 100%; vertical-align: top; margin-bottom: <?php echo $oste_email_improvements_enabled ? '0' : '40px'; ?>; padding:0;" border="0">
	<tr>
		<td class="font-family text-align-left" style="border:0; padding:0;" valign="top" width="50%">
			<?php if ( $oste_email_improvements_enabled ) { ?>
				<b class="address-title" style="display:block;margin-bottom:6px;">
					<?php
					/* translators: email section title for billing address */
					echo esc_html__( 'Billing address', 'order-status-tracking-emails-for-woocommerce' );
					?>
				</b>
			<?php } else { ?>
				<h2>
					<?php
					/* translators: email section title for billing address */
					echo esc_html__( 'Billing address', 'order-status-tracking-emails-for-woocommerce' );
					?>
				</h2>
			<?php } ?>

			<address class="address">
				<?php echo wp_kses_post( $oste_address ? $oste_address : esc_html__( 'N/A', 'order-status-tracking-emails-for-woocommerce' ) ); ?>
				<?php if ( $order->get_billing_phone() ) : ?>
					<br/>
					<?php
					$oste_billing_phone      = $order->get_billing_phone();
					$oste_sanitized_billing  = wc_sanitize_phone_number( $oste_billing_phone );
					$oste_billing_phone_href = $oste_sanitized_billing ? 'tel:' . $oste_sanitized_billing : '';
					if ( $oste_billing_phone_href ) :
						?>
						<a href="<?php echo esc_attr( $oste_billing_phone_href ); ?>" style="<?php echo esc_attr( $oste_phone_link_style ); ?>" class="oste-address-link">
							<?php echo esc_html( $oste_billing_phone ); ?>
						</a>
					<?php else : ?>
						<?php echo esc_html( $oste_billing_phone ); ?>
					<?php endif; ?>
				<?php endif; ?>
				<?php if ( $order->get_billing_email() ) : ?>
					<br/><a href="mailto:<?php echo esc_attr( $order->get_billing_email() ); ?>" style="<?php echo esc_attr( $oste_address_link_style ); ?>" class="oste-address-link"><?php echo esc_html( $order->get_billing_email() ); ?></a>
				<?php endif; ?>
				<?php
				/**
				 * Fires after the core address fields in emails.
				 *
				 * @since 8.6.0
				 *
				 * @param string   $type           Address type. Either 'billing' or 'shipping'.
				 * @param WC_Order $order          Order instance.
				 * @param bool     $sent_to_admin  If this email is being sent to the admin or not.
				 * @param bool     $plain_text     If this email is plain text or not.
				 */
				do_action( 'woocommerce_email_customer_address_section', 'billing', $order, $sent_to_admin, false );
				?>
			</address>
		</td>
		<?php if ( ! wc_ship_to_billing_address_only() && $order->needs_shipping_address() && $oste_shipping ) : ?>
			<td class="font-family text-align-left" style="padding:0;" valign="top" width="50%">
				<?php if ( $oste_email_improvements_enabled ) { ?>
				<b class="address-title" style="display:block;margin-bottom:6px;">
					<?php
					/* translators: email section title for shipping address */
					echo esc_html__( 'Shipping address', 'order-status-tracking-emails-for-woocommerce' );
					?>
				</b>
				<?php } else { ?>
					<h2>
						<?php
						/* translators: email section title for shipping address */
						echo esc_html__( 'Shipping address', 'order-status-tracking-emails-for-woocommerce' );
						?>
					</h2>
				<?php } ?>

				<address class="address">
					<?php echo wp_kses_post( $oste_shipping ); ?>
					<?php if ( $order->get_shipping_phone() ) : ?>
						<br />
						<?php
						$oste_shipping_phone      = $order->get_shipping_phone();
						$oste_sanitized_shipping  = wc_sanitize_phone_number( $oste_shipping_phone );
						$oste_shipping_phone_href = $oste_sanitized_shipping ? 'tel:' . $oste_sanitized_shipping : '';
						if ( $oste_shipping_phone_href ) :
							?>
							<a href="<?php echo esc_attr( $oste_shipping_phone_href ); ?>" style="<?php echo esc_attr( $oste_phone_link_style ); ?>" class="oste-address-link">
								<?php echo esc_html( $oste_shipping_phone ); ?>
							</a>
						<?php else : ?>
							<?php echo esc_html( $oste_shipping_phone ); ?>
						<?php endif; ?>
					<?php endif; ?>
					<?php
					/**
					 * Fires after the core address fields in emails.
					 *
					 * @since 8.6.0
					 *
					 * @param string   $type           Address type. Either 'billing' or 'shipping'.
					 * @param WC_Order $order          Order instance.
					 * @param bool     $sent_to_admin  If this email is being sent to the admin or not.
					 * @param bool     $plain_text     If this email is plain text or not.
					 */
					do_action( 'woocommerce_email_customer_address_section', 'shipping', $order, $sent_to_admin, false );
					?>
				</address>
			</td>
		<?php endif; ?>
	</tr>
</table>
<?php echo $oste_email_improvements_enabled ? '<br>' : ''; ?>
