<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

use Automattic\WooCommerce\Utilities\FeaturesUtil;
$oste_email_improvements_enabled = FeaturesUtil::feature_is_enabled( 'email_improvements' );


// HEADER
do_action( 'woocommerce_email_header', $email_heading, $email );
// Testo introduttivo personalizzato (fuori da email-introduction)
if ( function_exists( 'oste_get_opzioni_stato' ) ) {
    $oste_slug       = 'wc-' . $order->get_status();
    $oste_opts_all   = get_option( 'oste_gestione_email_stati_ordine', [] );
    $oste_stato_opts = $oste_opts_all[ $oste_slug ] ?? [];

    if ( ! empty( $oste_stato_opts['intro'] ) ) {
        echo '<div class="woocommerce-email-intro">';
        echo wp_kses_post( wpautop( oste_sostituisci_variabili_email( $oste_stato_opts['intro'], $order ) ) );
        echo '</div>';
    }
}

// Saluto iniziale
echo $oste_email_improvements_enabled ? '<div class="email-introduction">' : '';
?>
<p>
<?php
$oste_first_name = (string) $order->get_billing_first_name();

if ( '' !== $oste_first_name ) {
    printf(
        /* translators: %s is the customer's first name. */
        esc_html__( 'Hi %s,', 'order-status-tracking-emails-for-woocommerce' ),
        esc_html( $oste_first_name )
    );
} else {
    esc_html_e( 'Hi,', 'order-status-tracking-emails-for-woocommerce' );
}
?>
</p>
<?php
echo $oste_email_improvements_enabled ? '</div>' : '';



// ------ A questo punto WooCommerce chiamerà automaticamente l’hook -------
// do_action( 'woocommerce_email_before_order_table', ... );
// che tramite il tuo add_action stampa il "Testo aggiuntivo in cima" (extra_top).
// Quindi NON serve stamparlo a mano qui!

// Dettagli ordine
do_action( 'woocommerce_email_order_details', $order, $sent_to_admin, $plain_text, $email );
do_action( 'woocommerce_email_order_meta', $order, $sent_to_admin, $plain_text, $email );
do_action( 'woocommerce_email_customer_details', $order, $sent_to_admin, $plain_text, $email );

// Testo aggiuntivo in fondo (dopo la tabella ordine)
// Testo aggiuntivo in fondo (dopo la tabella ordine)
if ( ! empty( $extra ) ) {
    if ( $oste_email_improvements_enabled ) {
        echo '<table border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td class="email-additional-content">';
    }
    echo wp_kses_post( wpautop( $extra ) );
    if ( $oste_email_improvements_enabled ) {
        echo '</td></tr></table>';
    }
}

// Stampa anche l'additional_content se esiste (come WooCommerce fa per le email standard)
if ( ! empty( $additional_content ) ) {
    if ( $oste_email_improvements_enabled ) {
        echo '<table border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td class="email-additional-content">';
    }
    echo wp_kses_post( wpautop( wptexturize( $additional_content ) ) );
    if ( $oste_email_improvements_enabled ) {
        echo '</td></tr></table>';
    }
}



// Footer personalizzato (già gestito con hook email_footer se serve)
do_action( 'woocommerce_email_footer', $email );
?>
