<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Aggiungi la colonna dopo azioni
add_filter('manage_edit-shop_order_columns', function($columns) {
    $new_columns = [];
    $inserted = false;
    foreach ($columns as $key => $label) {
        $new_columns[$key] = $label;
        if ($key === 'order_actions') {
            $new_columns['oste_tracking'] = __( 'Tracking/Carrier', 'order-status-tracking-emails-for-woocommerce' );
            $inserted = true;
        }
    }
    if (!$inserted) {
        $new_columns['oste_tracking'] = __( 'Tracking/Carrier', 'order-status-tracking-emails-for-woocommerce' );
    }
    return $new_columns;
}, 20); // priority 20 per farlo dopo i default

// Contenuto colonna (editabile)
add_action('manage_shop_order_posts_custom_column', function($column, $post_id){
    if ($column === 'oste_tracking') {
        $carriers = get_option('oste_tracking_carriers', []);
        $carriers = is_array($carriers) ? $carriers : [];

        $carrier  = get_post_meta($post_id, '_oste_carrier', true);
        $tracking = get_post_meta($post_id, '_oste_tracking', true);

        $tracking_url = '';
        foreach ($carriers as $c) {
            if (
                isset($c['nome'], $c['url']) &&
                $c['nome'] === $carrier &&
                $tracking
            ) {
                if ( function_exists( 'oste_build_tracking_url' ) ) {
                    $tracking_url = oste_build_tracking_url( $c['url'], (string) $tracking );
                } else {
                    $url = rtrim((string) $c['url'], '/');
                    $tracking_url = $url . '/' . rawurlencode((string) $tracking);
                }
                break;
            }
        }
        ?>
		<div class="oste-inline-edit-tracking" data-order="<?php echo esc_attr( $post_id ); ?>">
			<input type="text" name="oste_tracking"
				   placeholder="<?php esc_attr_e('Tracking', 'order-status-tracking-emails-for-woocommerce'); ?>"
				   value="<?php echo esc_attr($tracking); ?>"
				   style="width:120px;" />

			<select name="oste_carrier" style="width:140px;">
				<option value=""><?php esc_html_e('Select carrier', 'order-status-tracking-emails-for-woocommerce'); ?></option>
				<?php foreach ( (array) $carriers as $c ) :
					if ( ! isset( $c['nome'] ) ) continue; ?>
					<option value="<?php echo esc_attr( $c['nome'] ); ?>" <?php selected( $carrier, $c['nome'] ); ?>>
						<?php echo esc_html( $c['nome'] ); ?>
					</option>
				<?php endforeach; ?>
			</select>

			<button type="button" class="button button-small oste-save-track" style="margin-left:6px;">
				<?php esc_html_e('Save', 'order-status-tracking-emails-for-woocommerce'); ?>
			</button>

			<span class="oste-link-wrap" style="margin-left:8px;">
				<?php if ( ! empty( $tracking_url ) ) : ?>
					<a href="<?php echo esc_url($tracking_url); ?>" target="_blank" rel="noopener"
					   style="font-size:12px;color:#2271b1;text-decoration:underline;">
						<?php esc_html_e('Check Tracking', 'order-status-tracking-emails-for-woocommerce'); ?>
					</a>
				<?php endif; ?>
			</span>
		</div>


        <?php
    }
}, 10, 2);



// Handle AJAX
add_action('wp_ajax_oste_save_tracking_inline', function () {
    if ( ! current_user_can('manage_woocommerce') && ! current_user_can('edit_shop_orders') ) {
        wp_send_json_error(['error' => __('Forbidden', 'order-status-tracking-emails-for-woocommerce')], 403);
    }
    if ( ! check_ajax_referer('oste_save_tracking_inline', '_wpnonce', false) ) {
        wp_send_json_error(['error' => __('Invalid nonce', 'order-status-tracking-emails-for-woocommerce')], 400);
    }

    $order_id = isset($_POST['order_id']) ? absint($_POST['order_id']) : 0;
    if ( ! $order_id || ! wc_get_order($order_id) ) {
        wp_send_json_error(['error' => __('Order not found', 'order-status-tracking-emails-for-woocommerce')], 404);
    }

    $tracking = isset($_POST['tracking']) ? sanitize_text_field( wp_unslash($_POST['tracking']) ) : '';
    $carrier  = isset($_POST['carrier'])  ? sanitize_text_field( wp_unslash($_POST['carrier']) )  : '';

    $carriers = get_option('oste_tracking_carriers', []);
    $carriers = is_array($carriers) ? $carriers : [];
    $allowed  = array_column($carriers, 'nome');
    if ( $carrier && ! in_array($carrier, $allowed, true) ) {
        $carrier = '';
    }

    $tracking !== '' ? update_post_meta($order_id, '_oste_tracking', $tracking) : delete_post_meta($order_id, '_oste_tracking');
    $carrier  !== '' ? update_post_meta($order_id, '_oste_carrier',  $carrier)  : delete_post_meta($order_id, '_oste_carrier');

    wp_send_json_success();
});



add_action('woocommerce_admin_order_data_after_order_details', function($order){
    $carriers = get_option('oste_tracking_carriers', []);
    $carriers = is_array($carriers) ? $carriers : [];

    $tracking = get_post_meta($order->get_id(), '_oste_tracking', true);
    $carrier  = get_post_meta($order->get_id(), '_oste_carrier', true);

    $tracking_url = '';
    foreach ($carriers as $c) {
        if (isset($c['nome'], $c['url']) && $c['nome'] === $carrier && $tracking) {
            if ( function_exists( 'oste_build_tracking_url' ) ) {
                $tracking_url = oste_build_tracking_url( $c['url'], (string) $tracking );
            } else {
                $url = rtrim((string) $c['url'], '/');
                $tracking_url = $url . '/' . rawurlencode((string) $tracking);
            }
            break;
        }
    }
    ?>
    <p class="form-field form-field-wide">
        <?php wp_nonce_field('oste_save_tracking_meta', 'oste_tracking_nonce'); ?>

        <label for="oste_tracking">
            <b><?php esc_html_e('Shipping Tracking', 'order-status-tracking-emails-for-woocommerce'); ?></b>
        </label>

        <input type="text" name="oste_tracking" id="oste_tracking"
               value="<?php echo esc_attr($tracking); ?>"
               placeholder="<?php esc_attr_e('Tracking code', 'order-status-tracking-emails-for-woocommerce'); ?>"
               style="width:170px; margin-right:8px;">

        <select name="oste_carrier" style="width: 160px;">
            <option value=""><?php esc_html_e('Select carrier...', 'order-status-tracking-emails-for-woocommerce'); ?></option>
            <?php foreach ($carriers as $c) :
                if (!isset($c['nome'])) { continue; } ?>
                <option value="<?php echo esc_attr($c['nome']); ?>" <?php selected($carrier, $c['nome']); ?>>
                    <?php echo esc_html($c['nome']); ?>
                </option>
            <?php endforeach; ?>
        </select>

        <span style="font-size:10px;color:#888;">
            <?php esc_html_e('Set carriers in:', 'order-status-tracking-emails-for-woocommerce'); ?>
            <a href="<?php echo esc_url(admin_url('admin.php?page=oste-tracking-carriers')); ?>">
                <?php esc_html_e('Carrier Settings', 'order-status-tracking-emails-for-woocommerce'); ?>
            </a>
        </span>

        <?php if ($tracking_url): ?>
            <br>
            <a href="<?php echo esc_url($tracking_url); ?>" target="_blank" rel="noopener"
               style="display:inline-block; margin-top:7px; font-size:13px; color:#2271b1; text-decoration:underline;">
                <?php esc_html_e('Check Tracking', 'order-status-tracking-emails-for-woocommerce'); ?>
            </a>
        <?php endif; ?>
    </p>
    <?php
});


add_action('woocommerce_process_shop_order_meta', function ($order_id) {
    // Normalizza ID
    $order_id = absint($order_id);
    if ( ! $order_id ) {
        return;
    }

    // Permessi (uno dei due � ok)
    if ( ! current_user_can('manage_woocommerce') && ! current_user_can('edit_shop_order', $order_id) ) {
        return;
    }

    // Nonce hardening (POST � slashed)
    $nonce = isset($_POST['oste_tracking_nonce'])
        ? sanitize_text_field( wp_unslash( $_POST['oste_tracking_nonce'] ) )
        : '';

    if ( ! $nonce || ! wp_verify_nonce( $nonce, 'oste_save_tracking_meta' ) ) {
        return;
    }

    // Sanitizzazione input
    $tracking = isset($_POST['oste_tracking'])
        ? sanitize_text_field( wp_unslash( $_POST['oste_tracking'] ) )
        : '';

    $carrier  = isset($_POST['oste_carrier'])
        ? sanitize_text_field( wp_unslash( $_POST['oste_carrier'] ) )
        : '';

    // (Opzionale) valida il carrier rispetto a quelli configurati
    $carriers = get_option('oste_tracking_carriers', []);
    $carriers = is_array($carriers) ? $carriers : [];
    $allowed_carriers = array_column($carriers, 'nome');
    if ( $carrier && ! in_array($carrier, $allowed_carriers, true) ) {
        $carrier = '';
    }

    // Salvataggio (pulisci se vuoti)
    if ($tracking !== '') {
        update_post_meta($order_id, '_oste_tracking', $tracking);
    } else {
        delete_post_meta($order_id, '_oste_tracking');
    }

    if ($carrier !== '') {
        update_post_meta($order_id, '_oste_carrier', $carrier);
    } else {
        delete_post_meta($order_id, '_oste_carrier');
    }
}, 10, 1);

add_action('wp_ajax_oste_get_tracking_link', function () {
    if ( ! current_user_can('manage_woocommerce') && ! current_user_can('edit_shop_orders') ) {
        wp_send_json_error(['error' => __('Forbidden', 'order-status-tracking-emails-for-woocommerce')], 403);
    }
    if ( ! check_ajax_referer('oste_get_tracking_link', '_wpnonce', false) ) {
        wp_send_json_error(['error' => __('Invalid nonce', 'order-status-tracking-emails-for-woocommerce')], 400);
    }

    $order_id = isset($_POST['order_id']) ? absint($_POST['order_id']) : 0;
    $carrier  = isset($_POST['carrier'])  ? sanitize_text_field( wp_unslash($_POST['carrier']) )  : '';
    $tracking = isset($_POST['tracking']) ? sanitize_text_field( wp_unslash($_POST['tracking']) ) : '';

    if ( ! $order_id || ! $tracking || ! wc_get_order($order_id) ) {
        wp_send_json_error(['error' => __('Bad request', 'order-status-tracking-emails-for-woocommerce')], 400);
    }

    $carriers = get_option('oste_tracking_carriers', []);
    $carriers = is_array($carriers) ? $carriers : [];

    $tracking_url = '';
    foreach ($carriers as $c) {
        if ( isset($c['nome'], $c['url']) && $c['nome'] === $carrier ) {
            if ( function_exists( 'oste_build_tracking_url' ) ) {
                $tracking_url = oste_build_tracking_url( (string) $c['url'], (string) $tracking );
            } else {
                $base = esc_url_raw( (string) $c['url'], ['http','https'] );
                if ( ! $base ) break;
                $tracking_url = trailingslashit($base) . rawurlencode($tracking);
            }
            break;
        }
    }

    wp_send_json_success(['link' => esc_url_raw($tracking_url)]);
});


