<?php
if (!defined('ABSPATH')) exit;

/**
 * Recupera TUTTI gli stati ordine (standard + custom)
 */
function oste_get_tutti_gli_stati() {
    return wc_get_order_statuses();
}

/**
 * Recupera opzioni admin per uno stato (slug tipo 'wc-processing')
 */
function oste_get_opzioni_stato($slug) {
    $all = get_option('oste_gestione_email_stati_ordine', []);
    return $all[$slug] ?? [];
}

/**
 * Sostituisce variabili custom nel testo
 */
function oste_sostituisci_variabili_email($text, $order) {
    if (!$order) return $text;
    if (is_numeric($order)) $order = wc_get_order($order);

    $order_id = $order->get_id();
    $customer_name = $order->get_billing_first_name().' '.$order->get_billing_last_name();

	$carrier = get_post_meta($order_id, '_oste_carrier', true);

    $tracking_url = oste_get_tracking_link($order_id);
    $vars = [
        '{order_id}' => $order_id,
        '{customer_name}' => $customer_name,
		'{carrier}' => $carrier,
		'[link-tracking]' => $tracking_url ? '<a href="'.esc_url($tracking_url).'" target="_blank" rel="nofollow">'.esc_html__('Track your shipment', 'order-status-tracking-emails-for-woocommerce').'</a>' : '',

    ];
    return strtr($text, $vars);
}

/**
 * Recupera link tracking per un ordine
 */
function oste_get_tracking_link($order_id) {
    $carriers = get_option('oste_tracking_carriers', []);
    $carrier = get_post_meta($order_id, '_oste_carrier', true);
    $tracking = get_post_meta($order_id, '_oste_tracking', true);
    $tracking_url = '';
    foreach ($carriers as $c) {
        if ($c['nome'] === $carrier && $tracking) {
            $url = $c['url'];
            if ( function_exists( 'oste_build_tracking_url' ) ) {
                $tracking_url = oste_build_tracking_url( $url, $tracking );
            } else {
                $tracking_url = $url . '/' . urlencode($tracking);
            }
            break;
        }
    }
    return $tracking_url;
}


// Dopo tabella prodotti
add_action('woocommerce_order_details_after_order_table', function($order){
    $pos = get_option('oste_tracking_message_position', 'below');
    if ($pos === 'below') oste_visualizza_messaggio_tracking_frontend($order);
});

// Prima della tabella prodotti
add_action('woocommerce_order_details_before_order_table', function($order){
    $pos = get_option('oste_tracking_message_position', 'below');
    if ($pos === 'above') oste_visualizza_messaggio_tracking_frontend($order);
});
// Dopo indirizzo
add_action('woocommerce_order_details_after_customer_details', function($order){
    $pos = get_option('oste_tracking_message_position', 'below');
    if ($pos === 'after_customer_details') oste_visualizza_messaggio_tracking_frontend($order);
});

function oste_visualizza_messaggio_tracking_frontend($order) {
    if (!is_a($order, 'WC_Order')) return;
    if (is_admin()) return;
    if ( function_exists( 'is_order_received_page' ) && is_order_received_page() ) return;
    if (!is_user_logged_in() || $order->get_user_id() != get_current_user_id()) return;

    $custom_message = get_option('oste_tracking_custom_message', '');
    if (!$custom_message) return;

    $order_id      = $order->get_id();
    $customer_name = $order->get_billing_first_name().' '.$order->get_billing_last_name();
    $carrier       = get_post_meta($order_id, '_oste_carrier', true);
    $tracking      = get_post_meta($order_id, '_oste_tracking', true);

    // Ricava il link tracking.
    $tracking_url = oste_get_tracking_link( $order_id );

	$vars = [
		'{order_id}'        => esc_html($order_id),
		'{customer_name}'   => esc_html($customer_name),
		'[link-tracking]'   => $tracking_url ? '<a href="'.esc_url($tracking_url).'" target="_blank" rel="nofollow">'.esc_html__('Track your shipment', 'order-status-tracking-emails-for-woocommerce').'</a>' : '',
		'{carrier}'         => esc_html($carrier),
		'{tracking}'        => esc_html($tracking),
	];

	echo '<div class="woocommerce-info" style="margin:18px 0 5px 0;">'
		 . wp_kses_post( strtr(wpautop($custom_message), $vars) )
		 . '</div>';
}



