<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

function oste_get_base_statuses() {
    return [
        'processing' => __('Processing', 'order-status-tracking-emails-for-woocommerce'),
        'on-hold'    => __('On hold', 'order-status-tracking-emails-for-woocommerce'),
        'completed'  => __('Completed', 'order-status-tracking-emails-for-woocommerce'),
        'cancelled'  => __('Cancelled', 'order-status-tracking-emails-for-woocommerce'),
        'refunded'   => __('Refunded', 'order-status-tracking-emails-for-woocommerce'),
        'failed'     => __('Failed', 'order-status-tracking-emails-for-woocommerce'),
        'pending'    => __('Pending payment', 'order-status-tracking-emails-for-woocommerce'),
    ];
}


function oste_get_custom_statuses() {
    return get_option('oste_custom_statuses', []);
}
function oste_get_base_labels() {
    return get_option('oste_base_status_labels', []);
}
function oste_get_actions_settings() {
    return get_option('oste_order_actions_settings', []);
}

function oste_get_custom_statuses_slug() {
    $tutti = oste_get_tutti_gli_stati(); // ['wc-pending', 'wc-spedito', ...]
    $base = ['pending','processing','on-hold','completed','cancelled','refunded','failed'];
    $slugs = array_diff(array_keys($tutti), array_map(function($s){return 'wc-' . $s;}, $base));
    return array_map(function($slug) { return preg_replace('/^wc-/', '', $slug); }, $slugs); // ['spedito', ...]
}

/**
 * Build a tracking URL from a carrier base URL and tracking code.
 */
function oste_build_tracking_url( $base, $tracking ) {
	$base = (string) $base;
	$tracking = (string) $tracking;

	if ( '' === $base || '' === $tracking ) {
		return '';
	}

	$encoded = rawurlencode( $tracking );

	$placeholders = array(
		'[tracking]',
		'%5Btracking%5D',
		'%5btracking%5d',
		'%255Btracking%255D',
		'%255btracking%255d',
		'%tracking%',
	);
	$replaced = str_replace( $placeholders, $encoded, $base );
	if ( $replaced !== $base ) {
		return $replaced;
	}

	if ( strpos( $base, '?' ) !== false ) {
		$sep = ( substr( $base, -1 ) === '?' ? '' : '&' );
		return $base . $sep . 'tracking=' . $encoded;
	}

	if ( preg_match( '#[/?#]$#', $base ) ) {
		return $base . $encoded;
	}

	return $base . '/' . $encoded;
}


function oste_build_custom_email_css( array $opts, $show_site_name = '1' ) {
	$logo_width = ! empty( $opts['logo_width'] ) ? trim( $opts['logo_width'] ) : '200';
	if ( substr( $logo_width, -2 ) !== 'px' ) {
		$logo_width .= 'px';
	}

	$logo_align = ! empty( $opts['logo_align'] ) ? $opts['logo_align'] : 'center';
	$show_site_name = (string) ( $show_site_name ?? '1' );

	$custom_css = "
		/* Sfondo email principale */
		#outer_wrapper {
			background: {$opts['bg_color']} !important;
		}
		" . ( ! empty( $opts['bg_image'] ) ? "
		#outer_wrapper {
			background-image: url('{$opts['bg_image']}') !important;
			background-size: cover !important;
			background-repeat: no-repeat !important;
		}" : '' ) . "

		/* Corpo centrale email WooCommerce */
		#inner_wrapper {
			background: {$opts['inner_bg_color']} !important;
			border-radius: {$opts['inner_radius']}px !important;
			border: {$opts['inner_border_width']} {$opts['inner_border_style']} {$opts['inner_border_color']} !important;
			box-shadow: {$opts['inner_shadow_x']} {$opts['inner_shadow_y']} {$opts['inner_shadow_blur']} {$opts['inner_shadow_color']} !important;
			border-collapse: separate !important;
			overflow: hidden;
		}
		#inner_wrapper > tbody > tr > td,
		#inner_wrapper > tr > td {
			padding: {$opts['inner_padding']} !important;
			border-radius: {$opts['inner_radius']}px !important;
		}


		/* Contenitore ordini principale */
		#body_content_inner{
			background: {$opts['container_color']} !important;
			border-radius: {$opts['container_radius']}px !important;
			box-shadow: {$opts['container_shadow_x']} {$opts['container_shadow_y']} {$opts['container_shadow_blur']} {$opts['container_shadow_color']} !important;
			border: {$opts['container_border_width']} {$opts['container_border_style']} {$opts['container_border_color']} !important;
			padding: {$opts['container_padding']} !important;
		}
		
		/* Contenitore ordini interno */
		#body_content_inner_cell {
			background: {$opts['container_cell_color']} !important;
			border-radius: {$opts['container_cell_radius']}px !important;
			box-shadow: {$opts['container_cell_shadow_x']} {$opts['container_cell_shadow_y']} {$opts['container_cell_shadow_blur']} {$opts['container_cell_shadow_color']} !important;
			border: {$opts['container_cell_border_width']} {$opts['container_cell_border_style']} {$opts['container_cell_border_color']} !important;
			padding: {$opts['container_cell_padding']} !important;
		}

		/* Logo WooCommerce */
		#template_header_image, .template-header {
			text-align: {$logo_align} !important;
			padding: {$opts['logo_padding']} !important;
		}
		#template_header_image img {
			width: {$logo_width} !important;
			max-width: 100% !important;
			height: auto !important;
			margin-left: " . ( $logo_align === 'left' ? '0' : 'auto' ) . ";
			margin-right: " . ( $logo_align === 'right' ? '0' : 'auto' ) . ";
			display: block;
		}

		/* Spaziatura tra elementi */
		.template-container > *, .email-container > * {
			margin-bottom: {$opts['element_spacing']} !important;
		}

		/* Heading testo: h1 */
		#template_header h1, .email-heading, .template-header h1 {
			color: {$opts['heading_color']} !important;
			font-size: {$opts['heading_size']} !important;
			font-family: {$opts['heading_font']} !important;
			font-weight: {$opts['heading_weight']} !important;
			text-align: {$opts['heading_align']} !important;
			text-shadow: {$opts['heading_shadow_x']} {$opts['heading_shadow_y']} {$opts['heading_shadow_blur']} {$opts['heading_shadow_color']} !important;
			letter-spacing: {$opts['heading_letter_spacing']} !important;
			margin: {$opts['heading_margin']} !important;
		}

		#header_wrapper {
			background: {$opts['header_wrapper_bg']} !important;
			border-radius: {$opts['header_wrapper_radius']}px !important;
			border: {$opts['header_wrapper_border_width']}px {$opts['header_wrapper_border_style']} {$opts['header_wrapper_border_color']} !important;
		}

		#template_container {
			background: {$opts['template_container_bg']} !important;
			border-radius: {$opts['template_container_radius']}px !important;
			border: {$opts['template_container_border_width']}px {$opts['template_container_border_style']} {$opts['template_container_border_color']} !important;
			box-shadow: {$opts['template_container_box_shadow']} !important;
		}
		#template_container > tbody > tr > td,
		#template_container > tr > td {
			padding: {$opts['template_container_padding']} !important;
		}

		/* Testo */
		.email-body, #body_content_inner, #body_content, .content, .template-container, .email-container, td, p, span, div {
			color: {$opts['text_color']} !important;
			font-size: {$opts['text_size']} !important;
			font-family: {$opts['text_font']} !important;
			text-align: {$opts['text_align']} !important;
			line-height: {$opts['text_lineheight']} !important;
		}

		/* Email intro */
		.email-introduction, .email-introduction p {
			color: {$opts['order_intro_color']} !important;
			font-size: {$opts['order_intro_font_size']} !important;
			padding: {$opts['order_intro_padding']} !important;
		}

		/* Titolo Riepilogo Ordine */
		.email-order-detail-heading {
			color: {$opts['order_heading_color']} !important;
			font-family: {$opts['order_heading_font']} !important;
			font-size: {$opts['order_heading_size']} !important;
			font-weight: {$opts['order_heading_weight']} !important;
			text-align: {$opts['order_heading_align']} !important;
			margin: {$opts['order_heading_margin']} !important;
			display: block;
		}
		.email-logo-text {
			margin: 0 !important;
		}

		/* Tabella ordine (order-details + compatibili) */
		.email-order-details, .order-details, .woocommerce-table, .order_details, .order-details-table {
			background: {$opts['order_table_bg']} !important;
			border-radius: {$opts['order_table_radius']}px !important;
			border: {$opts['order_table_border_width']}px {$opts['order_table_border_style']} {$opts['order_table_border_color']} !important;
			box-shadow: {$opts['order_table_box_shadow']} !important;
			padding: {$opts['order_table_padding']} !important;
		}

		/* Celle della tabella ordini */
		.order-details td, .email-order-details td, .order_item, .order-details th {
			color: {$opts['order_cell_color']} !important;
			font-family: {$opts['order_cell_font']} !important;
			font-size: {$opts['order_cell_font_size']} !important;
			padding: {$opts['order_cell_padding']} !important;
			background: {$opts['order_cell_bg']} !important;
		}

		/* Prezzo e quantità */
		.woocommerce-Price-amount, .order-details .amount, .email-order-details .amount {
			color: {$opts['order_price_color']} !important;
			font-weight: {$opts['order_price_font_weight']} !important;
			font-size: {$opts['order_price_font_size']} !important;
		}

		/* Totali */
		.order-totals td, .order-totals-subtotal th, .order-totals-total th, .order-totals-payment_method, .order-totals-last th {
			color: {$opts['order_totals_color']} !important;
			font-family: {$opts['order_totals_font']} !important;
			font-weight: {$opts['order_totals_font_weight']} !important;
			font-size: {$opts['order_totals_font_size']} !important;
		}

		/* Meta prodotto */
		.email-order-item-meta, .order-item-data span {
			color: {$opts['order_item_meta_color']} !important;
			font-size: {$opts['order_item_meta_font_size']} !important;
		}

		/* Titolo indirizzi */
		.address-title,
		.woocommerce-column--billing .woocommerce-column__title,
		.woocommerce-column--shipping .woocommerce-column__title {
			color: {$opts['order_address_title_color']} !important;
			font-family: {$opts['order_address_font']} !important;
		}
		/* Testo indirizzo */
		.address,
		.woocommerce-column--billing .woocommerce-column__details,
		.woocommerce-column--shipping .woocommerce-column__details,
		.woocommerce-column--billing .woocommerce-column__details address,
		.woocommerce-column--shipping .woocommerce-column__details address,
		.woocommerce-column--billing .woocommerce-column__details p,
		.woocommerce-column--shipping .woocommerce-column__details p,
		address {
			color: {$opts['order_address_color']} !important;
			font-family: {$opts['order_address_font']} !important;
		}
		.address a,
		.address a:link,
		.address a:visited,
		.address a:hover,
		.woocommerce-column--billing .woocommerce-column__details a,
		.woocommerce-column--shipping .woocommerce-column__details a,
		address a,
		.mailto-link,
		.mailto-link:link,
		.mailto-link:visited,
		.mailto-link:hover,
		.oste-address-link,
		.oste-address-link:link,
		.oste-address-link:visited,
		.oste-address-link:hover {
			color: {$opts['order_address_link_color']} !important;
		}
		#addresses .font-family {
			color: {$opts['order_address_color']} !important;
			font-family: {$opts['order_address_font']} !important;
			font-size: {$opts['text_size']} !important;
			text-align: {$opts['text_align']} !important;
			line-height: {$opts['text_lineheight']} !important;
		}
		#addresses .font-family a,
		#addresses .font-family a:link,
		#addresses .font-family a:visited,
		#addresses .font-family a:hover {
			color: {$opts['order_address_link_color']} !important;
			font-family: {$opts['order_address_font']} !important;
			text-decoration: underline !important;
		}

		/* Dettagli ordine (riga sotto tabella, tipo riepilogo) */
		.email-additional-content p {
			color: {$opts['detail_color']} !important;
			font-family: {$opts['detail_font']} !important;
			font-size: {$opts['detail_size']} !important;
			padding: {$opts['detail_padding']} !important;
		}

		/* Footer */
		#template_footer, .template-footer, .email-footer, .footer, #credit p {
			background: {$opts['footer_bg']} !important;
			color: {$opts['footer_color']} !important;
			font-size: {$opts['footer_size']} !important;
			font-family: {$opts['footer_font']} !important;
			text-align: {$opts['footer_align']} !important;
		}

		/* Pulsanti */
		.button, .button-primary, .button-alt, .button--primary {
			background: {$opts['button_bg']} !important;
			color: {$opts['button_color']} !important;
			font-family: {$opts['button_font']} !important;
			font-size: {$opts['button_size']} !important;
			border-radius: {$opts['button_radius']} !important;
			font-weight: {$opts['button_weight']} !important;
			box-shadow: {$opts['button_shadow_x']} {$opts['button_shadow_y']} {$opts['button_shadow_blur']} {$opts['button_shadow_color']} !important;
			border: {$opts['button_border_width']} {$opts['button_border_style']} {$opts['button_border_color']} !important;
			padding: {$opts['button_padding']} !important;
		}

		/* Link */
		a, a:link {
			color: {$opts['link_color']} !important;
			text-decoration: {$opts['link_decoration']} !important;
		}
		a:hover {
			color: {$opts['link_hover_color']} !important;
		}

		/* Custom CSS extra */
		{$opts['custom_css']}
	";

	if ( '1' !== $show_site_name ) {
		$custom_css .= "
			/* Nasconde SOLO il nome sito */
			.email-logo-text { display: none !important; }
		";
	}

	return $custom_css;
}



add_filter('woocommerce_email_styles', function($css, $email) {
    $stored_opts = get_option('oste_email_styling', []);
    if ( isset($GLOBALS['oste_email_preview_styles']) && is_array($GLOBALS['oste_email_preview_styles']) ) {
        $stored_opts = $GLOBALS['oste_email_preview_styles'];
    }

    $opts = wp_parse_args($stored_opts, oste_email_styling_default_options());

    // Se non attivo, non aggiungere i custom CSS
    if (empty($opts['enable_custom_styles']) || $opts['enable_custom_styles'] != '1') {
        return $css;
    }

    // Recupera la scelta "mostra nome sito" dalle opzioni email
    $email_opts = get_option('oste_gestione_email_stati_ordine', []);
    $show_site_name = isset($email_opts['show_site_name']) ? $email_opts['show_site_name'] : '1';
    if ( isset($GLOBALS['oste_email_preview_show_site_name']) ) {
        $show_site_name = $GLOBALS['oste_email_preview_show_site_name'];
    }

    $custom_css = oste_build_custom_email_css($opts, $show_site_name);

    return $css . "\n" . $custom_css;
}, 10, 2);



// 1. LOGO - Usa il filtro per la url
add_filter('woocommerce_email_header_image', function($url) {
    $opts = wp_parse_args(get_option('oste_email_styling', []), oste_email_styling_default_options());

    // Se stili custom disattivati, lascia Woo gestire il logo
    if (empty($opts['enable_custom_styles']) || $opts['enable_custom_styles'] != '1') {
        return $url;
    }

    // Se hai specificato un logo, lo usi
    if (!empty($opts['logo_url'])) {
        return esc_url($opts['logo_url']);
    }
    return $url; // Fallback WooCommerce
});

/**
 * Use the plugin's template for email addresses so preview and real emails match.
 */
add_filter( 'woocommerce_locate_template', function( $template, $template_name, $template_path ) {
	$custom_templates = [
		'emails/email-addresses.php',
		'emails/email-header.php',
	];

	if ( in_array( $template_name, $custom_templates, true ) ) {
		$plugin_template = trailingslashit( OSTE_PLUGIN_DIR ) . 'templates/' . $template_name;
		if ( file_exists( $plugin_template ) ) {
			return $plugin_template;
		}
	}

	return $template;
}, 10, 3 );





