<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

add_action( 'admin_menu', function () {
	add_submenu_page(
		'oste-order-manager',
		__( 'Email Templates', 'order-status-tracking-emails-for-woocommerce' ),
		__( 'Email Templates', 'order-status-tracking-emails-for-woocommerce' ),
		'manage_options',
		'oste-email-templates',
		'oste_render_gestione_email_stati_ordine'
	);
}, 30);

add_action( 'admin_enqueue_scripts', function ( $hook_suffix ) {
	if ( 'oste-order-manager_page_oste-email-templates' !== $hook_suffix && 'woocommerce_page_oste-email-templates' !== $hook_suffix ) {
		return;
	}

	wp_enqueue_style( 'oste-admin-ui' );
} );

function oste_render_gestione_email_stati_ordine() {
	if ( ! current_user_can( 'manage_options' ) ) {
		wp_die( esc_html__( 'Sorry, you are not allowed to access this page.', 'order-status-tracking-emails-for-woocommerce' ) );
	}
    $stati = oste_get_tutti_gli_stati();
	$custom_statuses = oste_get_custom_statuses_slug();
	
	/* DEBUG */
	// echo '<pre style="color:blue">DEBUG custom_statuses: ';
	// print_r($custom_statuses);
	// echo '</pre>';

	$saved = get_option( 'oste_gestione_email_stati_ordine', array() );
	?>
	<div class="wrap oste-admin-wrap">
		<h1 class="wp-heading-inline"><?php esc_html_e( 'Email Templates per Order Status', 'order-status-tracking-emails-for-woocommerce' ); ?></h1>

		<form method="post" action="options.php">
			<?php settings_fields( 'oste_gestione_email_stati_ordine' ); ?>

		<!-- Accordion impostazioni per singolo stato -->
		<div class="oste-status-accordions">
			<?php
			$index = 0;
			foreach ( $stati as $slug => $label ) :
				$opts      = isset( $saved[ $slug ] ) ? (array) $saved[ $slug ] : array();
				$id_prefix = sanitize_key( $slug );
				$panel_id  = 'oste-status-panel-' . $id_prefix;
				$is_open   = 0 === $index;
				?>
			<div class="oste-status-accordion <?php echo $is_open ? 'is-open' : ''; ?>">
				<button type="button" class="oste-status-accordion__header" aria-expanded="<?php echo $is_open ? 'true' : 'false'; ?>" aria-controls="<?php echo esc_attr( $panel_id ); ?>">
					<span class="oste-status-accordion__label">
						<span class="oste-status-accordion__title"><?php echo esc_html( $label ); ?></span>
						<span class="oste-status-accordion__slug"><?php echo esc_html( '(' . $slug . ')' ); ?></span>
					</span>
					<span class="oste-status-accordion__indicator" aria-hidden="true"></span>
				</button>
				<div id="<?php echo esc_attr( $panel_id ); ?>" class="oste-status-accordion__body" <?php echo $is_open ? '' : 'hidden'; ?>>
					<table class="form-table">
						<tr>
							<th><?php esc_html_e( 'Manage email with plugin?', 'order-status-tracking-emails-for-woocommerce' ); ?></th>
							<td>
								<label class="oste-toggle-label">
									<span class="oste-toggle">
										<input type="checkbox" name="oste_gestione_email_stati_ordine[<?php echo esc_attr( $slug ); ?>][enabled]" value="1" <?php checked( $opts['enabled'] ?? '' ); ?> />
										<span class="oste-toggle-slider" aria-hidden="true"></span>
									</span>
									<span class="oste-status-accordion__hint"><?php esc_html_e( 'If disabled, only default WooCommerce behavior will be used.', 'order-status-tracking-emails-for-woocommerce' ); ?></span>
								</label>
							</td>
						</tr>

						<tr>
							<th><?php esc_html_e( 'Custom email subject', 'order-status-tracking-emails-for-woocommerce' ); ?></th>
							<td>
								<input type="text" name="oste_gestione_email_stati_ordine[<?php echo esc_attr( $slug ); ?>][subject]" value="<?php echo esc_attr( $opts['subject'] ?? '' ); ?>" style="width:100%;" autocomplete="off" />
								<p class="description">
									<?php esc_html_e( 'Available variables:', 'order-status-tracking-emails-for-woocommerce' ); ?>
									<code>{order_id}</code>, <code>{customer_name}</code>, <code>{carrier}</code>, <code>{tracking}</code>, <code>[link-tracking]</code>									
								</p>
							</td>
						</tr>

						<tr>
							<th><?php esc_html_e( 'Email heading (large title)', 'order-status-tracking-emails-for-woocommerce' ); ?></th>
							<td>
								<?php
								wp_editor(
									$opts['thanks'] ?? '',
									'oste_thanks_' . $id_prefix,
									array(
										'textarea_name' => 'oste_gestione_email_stati_ordine[' . $slug . '][thanks]',
										'textarea_rows' => 2,
										'media_buttons' => true,
										'editor_height' => 50,
									)
								);
								?>
								<p class="description">
									<?php esc_html_e( 'Overrides the large title at the top of the email (e.g. "Thank you for your order"). Appears before the intro text. You can use HTML, variables, bold, etc.', 'order-status-tracking-emails-for-woocommerce' ); ?>
								</p>
							</td>
						</tr>

						<tr>
							<th><?php esc_html_e( 'Introductory text (after the title)', 'order-status-tracking-emails-for-woocommerce' ); ?></th>
							<td>
								<?php
								wp_editor(
									$opts['intro'] ?? '',
									'oste_intro_' . $id_prefix,
									array(
										'textarea_name' => 'oste_gestione_email_stati_ordine[' . $slug . '][intro]',
										'textarea_rows' => 3,
										'media_buttons' => true,
										'editor_height' => 80,
									)
								);
								?>
								<p class="description">
									<?php esc_html_e( 'Shown right after the heading, above the "Hello xxx" greeting. You can use HTML, variables, and [link-tracking].', 'order-status-tracking-emails-for-woocommerce' ); ?>
								</p>
							</td>
						</tr>

						<tr>
							<th><?php esc_html_e( 'Extra content at the top (before order table)', 'order-status-tracking-emails-for-woocommerce' ); ?></th>
							<td>
								<?php
								wp_editor(
									$opts['extra_top'] ?? '',
									'oste_extra_top_' . $id_prefix,
									array(
										'textarea_name' => 'oste_gestione_email_stati_ordine[' . $slug . '][extra_top]',
										'textarea_rows' => 3,
										'media_buttons' => true,
										'editor_height' => 80,
									)
								);
								?>
								<p class="description">
									<?php esc_html_e( 'Appears just before the order table. Useful for notices, buttons, or additional info.', 'order-status-tracking-emails-for-woocommerce' ); ?>
								</p>
							</td>
						</tr>

						<tr>
							<th><?php esc_html_e( 'Extra content at the bottom (after order table)', 'order-status-tracking-emails-for-woocommerce' ); ?></th>
							<td>
								<?php
								wp_editor(
									$opts['extra'] ?? '',
									'oste_extra_' . $id_prefix,
									array(
										'textarea_name' => 'oste_gestione_email_stati_ordine[' . $slug . '][extra]',
										'textarea_rows' => 3,
										'media_buttons' => true,
										'editor_height' => 80,
									)
								);
								?>
								<p class="description">
									<?php esc_html_e( 'Appears below the order table and above the WooCommerce email footer.', 'order-status-tracking-emails-for-woocommerce' ); ?>
								</p>
							</td>
						</tr>

						<tr>
							<th><?php esc_html_e( 'Custom footer content (signature)', 'order-status-tracking-emails-for-woocommerce' ); ?></th>
							<td>
								<?php
								wp_editor(
									$opts['footer'] ?? '',
									'oste_footer_' . $id_prefix,
									array(
										'textarea_name' => 'oste_gestione_email_stati_ordine[' . $slug . '][footer]',
										'textarea_rows' => 3,
										'media_buttons' => true,
										'editor_height' => 80,
									)
								);
								?>
								<p class="description">
									<?php esc_html_e( 'Shown just above the default WooCommerce footer.', 'order-status-tracking-emails-for-woocommerce' ); ?>
								</p>
							</td>
						</tr>
					</table>
				</div>
			</div>
			<?php
			$index++;
			endforeach;
			?>
		</div>

			<!-- Tabella 2: header nome sito e footer globale -->
			<table class="form-table">
				<tr style="background:#e9ecef">
					<th colspan="2"><h2 style="margin-bottom: 0;"><?php esc_html_e( 'WooCommerce Email Header (site name)', 'order-status-tracking-emails-for-woocommerce' ); ?></h2></th>
				</tr>
				<tr>
					<th><?php esc_html_e( 'Show site name at the top of the email?', 'order-status-tracking-emails-for-woocommerce' ); ?></th>
					<td>
						<label class="oste-toggle">
							<input type="checkbox" name="oste_gestione_email_stati_ordine[show_site_name]" value="1" <?php checked( $saved['show_site_name'] ?? '1' ); ?> />
							<span class="oste-toggle-slider" aria-hidden="true"></span>
						</label>
						<?php
						$site_name = get_bloginfo( 'name', 'display' );
						$site_note = sprintf(
							/* translators: %s: Site name. */
							esc_html__( 'If enabled, the site name (“%s”) will appear at the top of the email. If disabled, it will be hidden (logo and branding remain).', 'order-status-tracking-emails-for-woocommerce' ),
							esc_html( $site_name )
						);
						?>
						<span><?php echo $site_note; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- already escaped via esc_html__ and esc_html() ?></span>
					</td>
				</tr>

				<tr style="background:#e9ecef">
					<th colspan="2"><h2 style="margin-bottom: 0;"><?php esc_html_e( 'Global WooCommerce Footer (applies to all emails)', 'order-status-tracking-emails-for-woocommerce' ); ?></h2></th>
				</tr>
				<tr>
					<th><?php esc_html_e( 'Enable global footer?', 'order-status-tracking-emails-for-woocommerce' ); ?></th>
					<td>
						<label class="oste-toggle">
							<input type="checkbox" name="oste_gestione_email_stati_ordine[use_global_footer]" value="1" <?php checked( $saved['use_global_footer'] ?? '' ); ?> />
							<span class="oste-toggle-slider" aria-hidden="true"></span>
						</label>
						<span><?php esc_html_e( 'If enabled, all WooCommerce emails will use the custom footer below. If disabled, the default WooCommerce footer will be shown.', 'order-status-tracking-emails-for-woocommerce' ); ?></span>
					</td>
				</tr>
				<tr>
					<th><?php esc_html_e( 'Global custom footer', 'order-status-tracking-emails-for-woocommerce' ); ?></th>
					<td>
						<?php
						wp_editor(
							$saved['global_footer_core'] ?? '',
							'oste_footer_core_global',
							array(
								'textarea_name' => 'oste_gestione_email_stati_ordine[global_footer_core]',
								'textarea_rows' => 2,
								'media_buttons' => true,
								'editor_height' => 60,
							)
						);
						?>
						<p class="description"><?php esc_html_e( 'Will appear in all emails if the global footer option is enabled.', 'order-status-tracking-emails-for-woocommerce' ); ?></p>
					</td>
				</tr>
			</table>

		<?php submit_button( __( 'Save Settings', 'order-status-tracking-emails-for-woocommerce' ) ); ?>
	</form>

	<script>
	(function(){
		function toggleAccordion(btn){
			var container = btn.closest('.oste-status-accordion');
			if(!container){ return; }
			var body = container.querySelector('.oste-status-accordion__body');
			var isOpen = container.classList.contains('is-open');
			if(isOpen){
				container.classList.remove('is-open');
				btn.setAttribute('aria-expanded', 'false');
				if(body){ body.setAttribute('hidden', ''); }
			}else{
				container.classList.add('is-open');
				btn.setAttribute('aria-expanded', 'true');
				if(body){ body.removeAttribute('hidden'); }
			}
		}

		document.addEventListener('DOMContentLoaded', function(){
			document.querySelectorAll('.oste-status-accordion__header').forEach(function(btn){
				btn.addEventListener('click', function(){ toggleAccordion(btn); });
				btn.addEventListener('keydown', function(evt){
					if(evt.key === 'Enter' || evt.key === ' '){
						evt.preventDefault();
						toggleAccordion(btn);
					}
				});
			});
		});
	})();
	</script>

	<hr>

		<div>
			<h3><?php esc_html_e( 'Available Variables Legend', 'order-status-tracking-emails-for-woocommerce' ); ?></h3>
			<ul>
				<li><code>{order_id}</code>: <?php esc_html_e( 'Order number', 'order-status-tracking-emails-for-woocommerce' ); ?></li>
				<li><code>{customer_name}</code>: <?php esc_html_e( 'Customer name', 'order-status-tracking-emails-for-woocommerce' ); ?></li>
				<li><code>[link-tracking]</code>: <?php esc_html_e( 'Tracking link (if available)', 'order-status-tracking-emails-for-woocommerce' ); ?></li>
			</ul>
			<hr>
			<strong><?php esc_html_e( 'Notes:', 'order-status-tracking-emails-for-woocommerce' ); ?></strong>
			<ul>
				<li><b><?php esc_html_e( 'Introductory text', 'order-status-tracking-emails-for-woocommerce' ); ?></b>: <?php esc_html_e( 'Appears right after the title, above the "Hello xxx" greeting.', 'order-status-tracking-emails-for-woocommerce' ); ?></li>
				<li><b><?php esc_html_e( 'Extra content at the bottom', 'order-status-tracking-emails-for-woocommerce' ); ?></b>: <?php esc_html_e( 'Shown after the order table and above the footer (e.g., "Thanks again...").', 'order-status-tracking-emails-for-woocommerce' ); ?></li>
				<li><b><?php esc_html_e( 'Custom footer content', 'order-status-tracking-emails-for-woocommerce' ); ?></b>: <?php esc_html_e( 'Shown just before the copyright.', 'order-status-tracking-emails-for-woocommerce' ); ?></li>
			</ul>
		</div>
	</div>
	<?php
}


add_action( 'admin_init', function () {
	register_setting(
		'oste_gestione_email_stati_ordine',
		'oste_gestione_email_stati_ordine',
		array( 'sanitize_callback' => 'oste_sanitize_email_stati_ordine' )
	);
} );

function oste_sanitize_email_stati_ordine( $input ) {
	if ( ! is_array( $input ) ) {
		return array();
	}

	$input  = wp_unslash( $input ); // arriva slashed
	$output = array();

	// Opzioni globali (checkbox root)
	if ( isset( $input['show_site_name'] ) ) {
		$output['show_site_name'] = '1' === (string) $input['show_site_name'] ? '1' : '0';
	}
	if ( isset( $input['use_global_footer'] ) ) {
		$output['use_global_footer'] = '1' === (string) $input['use_global_footer'] ? '1' : '0';
	}
	if ( isset( $input['global_footer_core'] ) ) {
		$output['global_footer_core'] = wp_kses_post( (string) $input['global_footer_core'] );
	}

	// Stati (chiavi dinamiche)
	foreach ( $input as $slug_raw => $values ) {
		// salta le chiavi globali già gestite
		if ( in_array( $slug_raw, array( 'show_site_name', 'use_global_footer', 'global_footer_core' ), true ) ) {
			continue;
		}

		$slug = sanitize_key( $slug_raw );

		if ( ! is_array( $values ) ) {
			continue;
		}

		// Preleva valori (tutti unslashed)
		$enabled   = isset( $values['enabled'] ) ? '1' : '0';
		$subject   = isset( $values['subject'] )   ? sanitize_text_field( (string) $values['subject'] )   : '';
		$thanks    = isset( $values['thanks'] )    ? wp_kses_post( (string) $values['thanks'] )           : '';
		$intro     = isset( $values['intro'] )     ? wp_kses_post( (string) $values['intro'] )            : '';
		$extra_top = isset( $values['extra_top'] ) ? wp_kses_post( (string) $values['extra_top'] )        : '';
		$extra     = isset( $values['extra'] )     ? wp_kses_post( (string) $values['extra'] )            : '';
		$footer    = isset( $values['footer'] )    ? wp_kses_post( (string) $values['footer'] )           : '';

		$output[ $slug ] = array(
			'enabled'   => $enabled,
			'subject'   => $subject,
			'thanks'    => $thanks,
			'intro'     => $intro,
			'extra_top' => $extra_top,
			'extra'     => $extra,
			'footer'    => $footer,
		);
	}

	return $output;
}


add_filter( 'pre_update_option_oste_gestione_email_stati_ordine', function ( $new, $old ) {
	$new = is_array( $new ) ? $new : array();
	$old = is_array( $old ) ? $old : array();

	// Normalizza i checkbox root mancanti
	foreach ( array( 'use_global_footer', 'show_site_name' ) as $cb ) {
		if ( ! isset( $new[ $cb ] ) ) {
			$new[ $cb ] = '0';
		}
	}

	// Se uno stato esisteva e ora manca 'enabled', forza a 0
	foreach ( $old as $slug => $arr ) {
		if ( is_array( $arr ) && isset( $arr['enabled'] ) && isset( $new[ $slug ] ) && ! isset( $new[ $slug ]['enabled'] ) ) {
			$new[ $slug ]['enabled'] = '0';
		}
	}

	return $new;
}, 10, 2 );
