<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

/**
 * Invia l'email custom quando un ordine entra in uno dei nostri stati custom.
 */
add_action( 'woocommerce_order_status_changed', function ( $order_id, $from_status, $to_status, $order = null ) {

	// Ottieni l'oggetto ordine
	if ( ! ( $order instanceof WC_Order ) ) {
		$order = wc_get_order( $order_id );
	}
	if ( ! $order ) {
		return;
	}

	$statuses = (array) oste_get_custom_statuses();
	$to_slug  = sanitize_key( str_replace( 'wc-', '', (string) $to_status ) );

	foreach ( $statuses as $status ) {
		$slug = isset( $status['slug'] ) ? sanitize_key( (string) $status['slug'] ) : '';
		if ( $to_slug !== $slug ) {
			continue;
		}

		// Campi configurati dall'admin (con fallback a stringa vuota)
		$options      = function_exists( 'oste_get_opzioni_stato' ) ? (array) oste_get_opzioni_stato( 'wc-' . $slug ) : [];

		$subject_raw = '';
		if ( ! empty( $status['email_subject'] ) ) {
			$subject_raw = (string) $status['email_subject'];
		} elseif ( ! empty( $options['subject'] ) ) {
			$subject_raw = (string) $options['subject'];
		}

		$heading_raw = '';
		if ( ! empty( $status['email_heading'] ) ) {
			$heading_raw = (string) $status['email_heading'];
		} elseif ( ! empty( $options['thanks'] ) ) {
			$heading_raw = (string) $options['thanks'];
		}

		$extra_raw = '';
		if ( ! empty( $status['email_extra'] ) ) {
			$extra_raw = (string) $status['email_extra'];
		} elseif ( ! empty( $options['extra'] ) ) {
			$extra_raw = (string) $options['extra'];
		}

		$add_raw = '';
		if ( ! empty( $status['additional_content'] ) ) {
			$add_raw = (string) $status['additional_content'];
		}

		$parse_vars = function( $raw ) use ( $order ) {
			if ( '' === $raw ) {
				return '';
			}

			if ( function_exists( 'oste_sostituisci_variabili_email' ) ) {
				return oste_sostituisci_variabili_email( $raw, $order );
			}

			return oste_replace_order_vars( $raw, $order );
		};

		$subject = wp_strip_all_tags( $parse_vars( $subject_raw ) );
		$heading = wp_strip_all_tags( $parse_vars( $heading_raw ) );
		$extra   = $parse_vars( $extra_raw );
		$add     = $parse_vars( $add_raw );
		// Email di destinazione
		$email_to = sanitize_email( (string) $order->get_billing_email() );
		if ( ! is_email( $email_to ) ) {
			return;
		}

		// Recupera una WC_Email reale per header/footer (la tua classe custom se presente, altrimenti ripiega su una core)
		$emails    = WC()->mailer()->get_emails();
		$email_obj = null;

		if ( isset( $emails['WC_Email_Customer_Custom_Order'] ) ) { // tua classe custom, se registrata
			$email_obj = $emails['WC_Email_Customer_Custom_Order'];
		} elseif ( isset( $emails['WC_Email_Customer_Processing_Order'] ) ) {
			$email_obj = $emails['WC_Email_Customer_Processing_Order'];
		} else {
			$email_obj = reset( $emails ); // qualunque WC_Email purchÃ© sia un oggetto valido
		}

		// Costruisci il corpo HTML usando il loader di WooCommerce
		$body = wc_get_template_html(
			'emails/customer-custom-order.php',
			array(
				'order'              => $order,
				'email'              => $email_obj,
				'email_heading'      => $heading,
				'sent_to_admin'      => false,
				'plain_text'         => false,
				'extra'              => $extra,
				'additional_content' => $add,
			),
			'', // path template override (vuoto = predefinito)
			OSTE_PLUGIN_DIR . 'templates/' // base path dei tuoi template nel plugin
		);

		// Invia: il template include giÃ  header/footer, quindi NIENTE wrap_message()
		WC()->mailer()->send( $email_to, $subject, $body );

		// Un solo match: esci dal foreach
		break;
	}
}, 10, 4 );

/**
 * Sostituisce variabili tipo %order_number% nel testo.
 *
 * @param string   $str
 * @param WC_Order $order
 * @return string
 */
function oste_replace_order_vars( $str, $order ) {
	$str = (string) $str;

	$order_number = ( $order instanceof WC_Order ) ? (string) $order->get_order_number() : '';

	$replacements = array(
		'%order_number%' => $order_number,
	);

	return strtr( $str, $replacements );
}

