<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class OSTE_Email_Customer_Custom_Order extends WC_Email {

    public function __construct() {
        $this->id             = 'oste_customer_custom_order';
        $this->title          = __( 'Custom Status Email', 'order-status-tracking-emails-for-woocommerce' );
        $this->description    = __( 'Email sent when an order enters a custom status.', 'order-status-tracking-emails-for-woocommerce' );

        $this->template_html  = 'emails/customer-custom-order.php';
        $this->template_plain = 'emails/plain/customer-custom-order.php';
        $this->template_base  = trailingslashit( OSTE_PLUGIN_DIR . 'templates' ); // â† aggiunta

        $this->customer_email = true;

        // Placeholder base (verranno completati nel trigger)
        $this->placeholders = array( // â† aggiunta
            '{site_title}'   => $this->get_blogname(),
            '{order_date}'   => '',
            '{order_number}' => '',
        );

        add_action( 'oste_trigger_custom_status_email', [ $this, 'trigger' ], 10, 2 );

        parent::__construct();

        $this->subject = __( '[{site_title}] Order {order_number} update', 'order-status-tracking-emails-for-woocommerce' );
        $this->heading = __( 'Order update', 'order-status-tracking-emails-for-woocommerce' );
    }

    public function trigger($order_id, $order = false) {
        if ($order_id && !$order) {
            $order = wc_get_order($order_id);
        }
        if (!$order) return;
        $this->object     = $order;
        $this->recipient  = $order->get_billing_email();
        $this->placeholders['{order_date}']   = wc_format_datetime($order->get_date_created());
        $this->placeholders['{order_number}'] = $order->get_order_number();

        if ($this->is_enabled() && $this->get_recipient()) {
            $this->send(
                $this->get_recipient(),
                $this->get_subject(),   // <-- Usa il metodo, NON la property!
                $this->get_content(),
                $this->get_headers(),
                $this->get_attachments()
            );
        }
    }

    // Prende il soggetto dalla configurazione admin
    public function get_subject() {
        $slug = 'wc-' . ($this->object ? $this->object->get_status() : '');
        $opts = get_option('oste_gestione_email_stati_ordine', []);
        if (!empty($opts[$slug]['subject'])) {
            return oste_sostituisci_variabili_email($opts[$slug]['subject'], $this->object);
        }
        return $this->subject;
    }

    // Prende l'heading dalla configurazione admin
    public function get_heading() {
        $slug = 'wc-' . ($this->object ? $this->object->get_status() : '');
        $opts = get_option('oste_gestione_email_stati_ordine', []);
        if (!empty($opts[$slug]['thanks'])) {
            return oste_sostituisci_variabili_email($opts[$slug]['thanks'], $this->object);
        }
        return $this->heading;
    }

    protected function get_template_args( $plain_text ) {
        $order = $this->object instanceof WC_Order ? $this->object : null;

        $extra = '';
        $intro = '';
        $additional_content = $this->get_additional_content();

        if ( $order ) {
            $slug = 'wc-' . $order->get_status();
            $opts = function_exists( 'oste_get_opzioni_stato' ) ? (array) oste_get_opzioni_stato( $slug ) : [];

            if ( ! empty( $opts['extra'] ) ) {
                $extra_source = (string) $opts['extra'];
                if ( function_exists( 'oste_sostituisci_variabili_email' ) ) {
                    $extra = oste_sostituisci_variabili_email( $extra_source, $order );
                } else {
                    $extra = $extra_source;
                }
            }

            if ( ! empty( $opts['intro'] ) ) {
                $intro_source = (string) $opts['intro'];
                if ( function_exists( 'oste_sostituisci_variabili_email' ) ) {
                    $intro = oste_sostituisci_variabili_email( $intro_source, $order );
                } else {
                    $intro = $intro_source;
                }
            }

            if ( $additional_content && function_exists( 'oste_sostituisci_variabili_email' ) ) {
                $additional_content = oste_sostituisci_variabili_email( $additional_content, $order );
            }
        }

        return [
            'order'              => $order,
            'email_heading'      => $this->get_heading(),
            'sent_to_admin'      => false,
            'plain_text'         => (bool) $plain_text,
            'email'              => $this,
            'extra'              => $extra,
            'intro'              => $intro,
            'additional_content' => $additional_content,
        ];
    }

    public function get_content_html() {
        return wc_get_template_html(
            $this->template_html,
            $this->get_template_args( false ),
            '',
            $this->template_base
        );
    }

    public function get_content_plain() {
        return wc_get_template_html(
            $this->template_plain,
            $this->get_template_args( true ),
            '',
            $this->template_base
        );
    }

}


