<?php
/**
 * Plugin Name:       Order & Abandoned Cart Notification for WABA NXC Panel
 * Description:       Send automated WhatsApp notifications for WooCommerce orders and abandoned carts using WABA NXC Panel API.
 * Version:           1.0.3
 * Author:            NXC Controls Pvt Ltd
 * Author URI:        https://waba.nxccontrols.in
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       order-notification-waba-nxc
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}

define( 'WABA_CHAT_VERSION', '1.0.3' );
define( 'WABA_CHAT_PATH', plugin_dir_path( __FILE__ ) );
define( 'WABA_CHAT_URL', plugin_dir_url( __FILE__ ) );

function waba_chat_activate() {
	if ( ! wp_next_scheduled( 'waba_chat_cart_recovery_event' ) ) {
		wp_schedule_event( time(), 'every_15_minutes', 'waba_chat_cart_recovery_event' );
	}
}

function waba_chat_deactivate() {
	wp_clear_scheduled_hook( 'waba_chat_cart_recovery_event' );
}

register_activation_hook( __FILE__, 'waba_chat_activate' );
register_deactivation_hook( __FILE__, 'waba_chat_deactivate' );

add_filter( 'cron_schedules', function( $schedules ) {
	$schedules['every_15_minutes'] = array(
		'interval' => 900,
		'display'  => __( 'Every 15 Minutes', 'order-notification-waba-nxc' ),
	);
	return $schedules;
});

require WABA_CHAT_PATH . 'includes/class-waba-core.php';

function waba_chat_run() {
	$plugin = new Waba_Chat_Core();
	$plugin->run();
}
waba_chat_run();
