<?php
class Waba_Chat_Public {
	private $plugin_name;
	private $version;
	public function __construct( $plugin_name, $version ) {
		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}

	public function enqueue_styles() {
		// Enqueue CSS if needed
	}

	public function enqueue_scripts() {
		$options = get_option( 'waba_chat_settings' );
		$whatsapp_number = isset( $options['whatsapp_number'] ) ? $options['whatsapp_number'] : '';

		if ( ! empty( $whatsapp_number ) ) {
			wp_enqueue_script( $this->plugin_name, WABA_CHAT_URL . 'assets/js/waba-chat.js', array( 'jquery' ), $this->version, true );
			wp_localize_script( $this->plugin_name, 'wabaChatSettings', array(
				'enable_widget' => true, // Can become a setting
				'whatsapp_number' => $whatsapp_number,
				'position' => 'right', // Can become a setting
				'icon_url' => WABA_CHAT_URL . 'assets/img/whatsapp-logo.svg' // We might need to provide this
			) );
			wp_add_inline_script( $this->plugin_name, 'WabaChat.init(wabaChatSettings);' );
		}
	}
}
