<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Waba_Chat_Core {
	protected $loader;
	protected $plugin_name;
	protected $version;

	public function __construct() {
		$this->plugin_name = 'waba-chat';
		$this->version = '1.0.3';
		$this->load_dependencies();
		$this->define_admin_hooks();
		$this->define_public_hooks();
	}

	private function load_dependencies() {
		require_once WABA_CHAT_PATH . 'includes/class-waba-loader.php';
		require_once WABA_CHAT_PATH . 'includes/class-waba-api.php';
		require_once WABA_CHAT_PATH . 'admin/class-waba-admin.php';
		require_once WABA_CHAT_PATH . 'public/class-waba-public.php';
		
		if ( class_exists( 'WooCommerce' ) ) {
			require_once WABA_CHAT_PATH . 'public/class-waba-woocommerce.php';
		}
		
		$this->loader = new Waba_Chat_Loader();
	}

	private function define_admin_hooks() {
		$plugin_admin = new Waba_Chat_Admin( $this->get_plugin_name(), $this->get_version() );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );
		$this->loader->add_action( 'admin_menu', $plugin_admin, 'add_admin_menu' );
		$this->loader->add_action( 'admin_init', $plugin_admin, 'register_settings' );
	}

	private function define_public_hooks() {
		$plugin_public = new Waba_Chat_Public( $this->get_plugin_name(), $this->get_version() );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );

		if ( class_exists( 'WooCommerce' ) ) {
			$plugin_wc = new Waba_Chat_Woocommerce( $this->get_plugin_name(), $this->get_version() );
			$this->loader->add_action( 'woocommerce_order_status_changed', $plugin_wc, 'handle_order_status_change', 10, 3 );
			$this->loader->add_action( 'woocommerce_cart_updated', $plugin_wc, 'capture_cart_update' );
			$this->loader->add_action( 'waba_chat_cart_recovery_event', $plugin_wc, 'process_abandoned_carts' );
		}
	}

	public function run() {
		$this->loader->run();
	}

	public function get_plugin_name() {
		return $this->plugin_name;
	}

	public function get_version() {
		return $this->version;
	}
}
