<?php
class Waba_Chat_Api {
	private $api_url;
	private $app_key;
	private $auth_key;

	public function __construct() {
		$options = get_option( 'waba_chat_settings' );
		$this->api_url  = isset( $options['api_url'] ) ? rtrim( $options['api_url'], '/' ) : '';
		$this->app_key  = isset( $options['app_key'] ) ? $options['app_key'] : '';
		$this->auth_key = isset( $options['auth_key'] ) ? $options['auth_key'] : '';
	}

	public function send_message( $to, $template_id, $language = 'en', $variables = array(), $buttons = array(), $file = null, $file_name = null ) {
		if ( empty( $this->api_url ) || empty( $this->app_key ) || empty( $this->auth_key ) ) {
			return new WP_Error( 'missing_config', __( 'Missing API Configuration', 'order-notification-waba-nxc' ) );
		}

		$endpoint = $this->api_url . '/api/create-message';
		
		$body = array(
			'appkey' => $this->app_key,
			'authkey' => $this->auth_key,
			'to' => $to,
			'template_id' => $template_id,
			'language' => $language,
		);

		if ( ! empty( $variables ) ) {
			$body['variables'] = $variables;
		}

		if ( ! empty( $buttons ) ) {
			$body['buttons'] = $buttons;
		}

		if ( ! empty( $file ) ) {
			$body['file'] = $file;
			if ( ! empty( $file_name ) ) {
				$body['file_name'] = $file_name;
			}
		}

		$response = wp_remote_post( $endpoint, array(
			'body'    => $body,
			'timeout' => 45,
		) );

		if ( is_wp_error( $response ) ) {
			return $response;
		}

		$response_code = wp_remote_retrieve_response_code( $response );
		$response_body = wp_remote_retrieve_body( $response );
		$result = json_decode( $response_body, true );

		if ( $response_code !== 200 ) {
			return new WP_Error( 'api_error', isset( $result['error'] ) ? $result['error'] : 'Unknown API Error', $result );
		}

		return $result;
	}

	public function get_templates() {
		if ( empty( $this->api_url ) || empty( $this->app_key ) || empty( $this->auth_key ) ) {
			return new WP_Error( 'missing_config', __( 'Missing API Configuration', 'order-notification-waba-nxc' ) );
		}

		$endpoint = $this->api_url . '/api/get_templates';
		
		$body = array(
			'appkey' => $this->app_key,
			'authkey' => $this->auth_key,
		);

		$response = wp_remote_post( $endpoint, array(
			'body'    => $body,
			'timeout' => 45,
		) );

		if ( is_wp_error( $response ) ) {
			return $response;
		}

		$response_code = wp_remote_retrieve_response_code( $response );
		$response_body = wp_remote_retrieve_body( $response );
		$result = json_decode( $response_body, true );

		if ( $response_code !== 200 ) {
			return new WP_Error( 'api_error', isset( $result['message_status'] ) ? $result['message_status'] : 'Unknown API Error', $result );
		}

		// Return only approved templates
		if ( isset( $result['data'] ) && is_array( $result['data'] ) ) {
			$approved_templates = array_filter( $result['data'], function( $template ) {
				return isset( $template['status'] ) && $template['status'] === 'APPROVED';
			});
			return array_values( $approved_templates );
		}

		return array();
	}
}
