var WabaChat = (function() {
    var config = {};

    function init(settings) {
        config = settings;
        if (config.enable_widget && config.whatsapp_number) {
            renderWidget();
        }
    }

    function renderWidget() {
        var container = document.createElement('div');
        container.id = 'waba-chat-widget';
        container.style.position = 'fixed';
        container.style.bottom = '20px';
        container.style[config.position === 'left' ? 'left' : 'right'] = '20px';
        container.style.zIndex = '9999';
        container.style.cursor = 'pointer';

        var link = document.createElement('a');
        link.href = 'https://wa.me/' + config.whatsapp_number;
        link.target = '_blank';
        link.style.display = 'block';
        link.style.width = '60px';
        link.style.height = '60px';
        link.style.borderRadius = '50%';
        link.style.backgroundColor = '#25D366';
        link.style.boxShadow = '0 4px 8px rgba(0,0,0,0.2)';
        link.style.textAlign = 'center';
        link.style.lineHeight = '60px';

        var icon = document.createElement('img');
        icon.src = config.icon_url || '../img/whatsapp-logo.svg'; // Default to local svg if config is missing
        icon.style.width = '35px';
        icon.style.height = '35px';
        icon.style.marginTop = '12px';
        
        link.appendChild(icon);
        container.appendChild(link);
        document.body.appendChild(container);
    }

    return {
        init: init
    };
})();
