jQuery(document).ready(function($) {
	$('.waba-refresh-templates').on('click', function(e) {
		e.preventDefault();
		
		var $button = $(this);
		var $wrapper = $button.closest('.waba-template-field-wrapper');
		var $select = $wrapper.find('.waba-template-select');
		var $loading = $wrapper.find('.waba-template-loading');
		var $error = $wrapper.find('.waba-template-error');
		
		// Show loading, hide errors
		$button.prop('disabled', true);
		$loading.show();
		$error.hide().text('');
		
		$.ajax({
			url: wabaAdmin.ajax_url,
			type: 'POST',
			data: {
				action: 'waba_fetch_templates',
				nonce: wabaAdmin.nonce
			},
			success: function(response) {
				if (response.success && response.data.templates) {
					// Store currently selected value
					var currentValue = $select.val();
					
					// Update all template selects
					$('.waba-template-select').each(function() {
						var $thisSelect = $(this);
						var thisCurrentValue = $thisSelect.val();
						
						// Clear and rebuild options
						$thisSelect.empty();
						$thisSelect.append('<option value="">-- Select Template --</option>');
						
						// Add templates as options
						$.each(response.data.templates, function(index, template) {
							var displayName = template.name;
							if (template.language) {
								displayName += ' [' + template.language + ']';
							}
							$thisSelect.append($('<option></option>')
								.attr('value', template.name)
								.attr('data-language', template.language || 'en_US')
								.text(displayName));
						});
						
						// Restore previous selection if it exists
						if (thisCurrentValue) {
							$thisSelect.val(thisCurrentValue);
						}
						
						// Update language hidden field
						var fieldName = $thisSelect.data('field');
						var selectedLanguage = $thisSelect.find('option:selected').data('language') || 'en_US';
						$('input[name="waba_chat_settings[' + fieldName + '_language]"]').val(selectedLanguage);
					});
					
					// Show success message briefly
					$error.css('color', '#46b450').text('Templates loaded successfully!').show();
					setTimeout(function() {
						$error.fadeOut();
					}, 3000);
				} else {
					$error.text(response.data.message || 'Failed to load templates').show();
				}
			},
			error: function() {
				$error.text('Network error occurred. Please try again.').show();
			},
			complete: function() {
				$button.prop('disabled', false);
				$loading.hide();
			}
		});
	});

	// Update language field when template selection changes
	$('.waba-template-select').on('change', function() {
		var $select = $(this);
		var fieldName = $select.data('field');
		var selectedLanguage = $select.find('option:selected').data('language') || 'en_US';
		$('input[name="waba_chat_settings[' + fieldName + '_language]"]').val(selectedLanguage);
	});

	// Handle Send Test button
	$('.waba-send-test').on('click', function(e) {
		e.preventDefault();
		
		var $button = $(this);
		var $wrapper = $button.closest('.waba-template-field-wrapper');
		var $select = $wrapper.find('.waba-template-select');
		var $loading = $wrapper.find('.waba-template-loading');
		var $error = $wrapper.find('.waba-template-error');
		
		var templateId = $select.val();
		var fieldName = $select.data('field');
		var templateLanguage = $select.find('option:selected').data('language') || 'en_US';
		var testPhone = $('input[name="waba_chat_settings[test_phone_number]"]').val();
		
		if (!templateId) {
			$error.css('color', '#dc3232').text('Please select a template first').show();
			return;
		}
		
		if (!testPhone) {
			$error.css('color', '#dc3232').text('Please enter a test phone number in the settings above').show();
			return;
		}
		
		// Show loading
		$button.prop('disabled', true);
		$loading.show();
		$error.hide().text('');
		
		$.ajax({
			url: wabaAdmin.ajax_url,
			type: 'POST',
			data: {
				action: 'waba_send_test_message',
				nonce: wabaAdmin.nonce,
				template_id: templateId,
				phone_number: testPhone,
				field_name: fieldName,
				language: templateLanguage
			},
			success: function(response) {
				if (response.success) {
					$error.css('color', '#46b450').text(response.data.message).show();
					setTimeout(function() {
						$error.fadeOut();
					}, 5000);
				} else {
					$error.css('color', '#dc3232').text(response.data.message || 'Failed to send test message').show();
				}
			},
			error: function() {
				$error.css('color', '#dc3232').text('Network error occurred. Please try again.').show();
			},
			complete: function() {
				$button.prop('disabled', false);
				$loading.hide();
			}
		});
	});
});
