<?php

namespace OAUP\Initializer;

use WP_Filesystem_Direct;

class Pages {
	private static $pages = array(
		'checkout',
		'equipment',
		'menu',
		'profile',
		'terms',
		'venues'
	);

	public static function register() {
		add_action('init', array(static::class, 'register_page_type'));
	}

	public static function register_page_type() {
		if (!class_exists('WP_Filesystem_Direct')) {
			require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-base.php';
			require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-direct.php';
		}

		$WP_Filesystem_Direct = new WP_Filesystem_Direct(false);

		$icon = $WP_Filesystem_Direct->get_contents(OAUP_PLUGIN_DIR . 'assets/icon.svg');

		register_post_type('order_arena_page', array(
			'labels' => array(
				'description' => __('Pages from Order Arena Plugin', 'order-arena'),
				'name' => __('Order Arena Pages', 'order-arena'),
				'singular_name' => __('Order Arena Page', 'order-arena'),
				'add_new' => __('Add New Order Arena Page', 'order-arena'),
				'add_new_item' => __('Add New Order Arena Page', 'order-arena'),
				'edit_item' => __('Edit Order Arena Page', 'order-arena'),
				'new_item' => __('New Order Arena Page', 'order-arena'),
				'view_item' => __('View Order Arena Page', 'order-arena'),
				'view_items' => __('View Order Arena Pages', 'order-arena'),
				'search_items' => __('Search Order Arena Pages', 'order-arena'),
				'all_items' => __('All Order Arena Pages', 'order-arena'),
				'not_found' => __('No Order Arena Pages found', 'order-arena'),
				'archives' => __('Order Arena Pages', 'order-arena'),
				'attributes' => __('Order Arena Page Attributes', 'order-arena'),
				'insert_into_item' => __('Insert into Order Arena Page', 'order-arena'),
				'uploaded_to_this_item' => __('Uploaded to this Order Arena Page', 'order-arena'),
				'featured_image' => __('Order Arena Page Image', 'order-arena'),
				'remove_featured_image' => __('Remove Order Arena Page Image', 'order-arena'),
				'use_featured_image' => __('Use Order Arena Page Image', 'order-arena'),
			),
			'has_archive' => true,
			'rewrite' => array(
				'slug' => 'oa',
				'with_front' => false
			),
			'public' => true,
			'hierarchical' => false,
			'publicly_queryable' => true,
			'show_ui' => true,
			'show_in_menu' => true,
			'show_in_rest' => false,
			'menu_position' => 6,
			'menu_icon' => $icon ? 'data:image/svg+xml;base64,' . base64_encode($icon) : 'dashicons-food',
			'capability_type' => 'page',
			'capabilities' => array(
				'create_posts' => false,
				// NOTE: Rename capabilities to disable them in admin panel
				'delete_posts' => 'delete_order_arena_pages',
				'delete_post' => 'delete_order_arena_page',
				'delete_private_posts' => 'delete_private_order_arena_pages',
				'delete_published_posts' => 'delete_published_order_arena_pages',
				'delete_others_posts' => 'delete_others_order_arena_pages',
			),
			'map_meta_cap' => true,
			'supports' => array(
				'title',
			),
			'can_export' => false
		));
	}

	public static function register_pages() {
		foreach (self::$pages as $page) {
			$post = get_page_by_path($page, OBJECT, 'order_arena_page');
			$page_template_slug = self::get_page_template_slug($page);

			if (!$post || $post->page_template != $page_template_slug || $post->post_status != 'publish') {
				$post_id = $post ? $post->ID : 0;
				$post_title = $post ? ($post->post_name == strtolower($post->post_title) ? null : $post->post_title) : null;

				self::register_page($page, $page_template_slug, $post_id, $post_title);
			}
		}
	}

	public static function unregister_pages() {
		$posts = get_posts(array('post_type' => 'order_arena_page'));

		foreach ($posts as $post) {
			wp_delete_post($post->ID, true);
		}
	}

	public static function unregister_old_pages() {
		$posts = get_posts(array('post_type' => 'order_arena_page'));

		foreach ($posts as $post) {
			if (!in_array($post->post_name, self::$pages)) {
				wp_delete_post($post->ID, true);
			}
		}
	}

	public static function refresh_pages() {
		self::register_pages();
		self::unregister_old_pages();
	}

	private static function get_page_template_slug($page) {
		if ($page && in_array($page, self::$pages)) {
			$page_template_slug = 'oa-' . $page . '-page-template.php';

			if (self::page_template_exists($page_template_slug)) {
				return $page_template_slug;
			}
		}

		return null;
	}

	private static function page_template_exists($page_template_slug) {
		return $page_template_slug && file_exists(OAUP_PLUGIN_DIR . 'php/Templates/' . $page_template_slug);
	}

	private static function register_page($page_name, $page_template_slug, $post_id = 0, $post_title = null) {
		if ($page_name && in_array($page_name, self::$pages) && self::page_template_exists($page_template_slug)) {
			$postarr = array(
				'id' => $post_id,
				'post_type' => 'order_arena_page',
				'post_title' => $post_title ?: ucfirst($page_name),
				'post_name' => $page_name,
				'post_status' => 'publish',
				'comment_status' => 'closed',
				'page_template' => $page_template_slug,
			);

			return wp_insert_post($postarr);
		}

		return false;
	}
}
