<?php

if ( !defined( 'ABSPATH' ) ) {
    exit;
    // Exit if accessed directly.
}
require_once ORADEL_PATH . 'includes/helpers.php';
class Oradel_Verdict_Widget extends \Elementor\Widget_Base {
    public function get_name() {
        return 'oradel_verdict';
    }

    public function get_title() {
        return esc_html__( 'Verdict', 'orange-addons-for-elementor' );
    }

    public function get_icon() {
        return 'eicon-review';
    }

    public function get_categories() {
        return ['oradel-plugin'];
    }

    public function get_keywords() {
        return ['verdict', 'review'];
    }

    public function get_custom_help_url() {
        return 'https://orange-addons.com/docs/';
    }

    public function get_style_depends() {
        return ['oea-verdict'];
    }

    protected function register_controls() {
        $this->start_controls_section( 'verdict_settings_section', [
            'label' => esc_html__( 'Settings', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        ] );
        $this->add_control( 'show_verdict_header', [
            'label'        => esc_html__( 'Show Header Block', 'orange-addons-for-elementor' ),
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => esc_html__( 'Show', 'orange-addons-for-elementor' ),
            'label_off'    => esc_html__( 'Hide', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'yes',
        ] );
        $this->add_control( 'show_verdict_details', [
            'label'        => esc_html__( 'Show Details Block', 'orange-addons-for-elementor' ),
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => esc_html__( 'Show', 'orange-addons-for-elementor' ),
            'label_off'    => esc_html__( 'Hide', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'yes',
        ] );
        $this->add_control( 'show_verdict_pros_cons', [
            'label'        => esc_html__( 'Show Pros and Cons Block', 'orange-addons-for-elementor' ),
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => esc_html__( 'Show', 'orange-addons-for-elementor' ),
            'label_off'    => esc_html__( 'Hide', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'yes',
        ] );
        $this->add_control( 'verdict_pros_cons_direction', [
            'label'   => esc_html__( 'Pros and Cons Direction', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'column',
            'options' => [
                'column' => esc_html__( 'Column', 'orange-addons-for-elementor' ),
                'row'    => esc_html__( 'Row', 'orange-addons-for-elementor' ),
            ],
        ] );
        $this->add_control( 'show_verdict_pros_cons_heading', [
            'label'        => esc_html__( 'Show Pros and Cons Heading', 'orange-addons-for-elementor' ),
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => esc_html__( 'Show', 'orange-addons-for-elementor' ),
            'label_off'    => esc_html__( 'Hide', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'no',
        ] );
        $this->add_control( 'verdict_title_html_tag', [
            'label'   => esc_html__( 'Title HTML Tag', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'span' => esc_html__( 'Span', 'orange-addons-for-elementor' ),
                'h1'   => esc_html__( 'H1', 'orange-addons-for-elementor' ),
                'h2'   => esc_html__( 'H2', 'orange-addons-for-elementor' ),
                'h3'   => esc_html__( 'H3', 'orange-addons-for-elementor' ),
                'h4'   => esc_html__( 'H4', 'orange-addons-for-elementor' ),
                'h5'   => esc_html__( 'H5', 'orange-addons-for-elementor' ),
                'h6'   => esc_html__( 'H6', 'orange-addons-for-elementor' ),
            ],
            'default' => 'span',
        ] );
        $this->add_control( 'show_verdict_website_button', [
            'label'        => esc_html__( 'Show Website Button', 'orange-addons-for-elementor' ),
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => esc_html__( 'Show', 'orange-addons-for-elementor' ),
            'label_off'    => esc_html__( 'Hide', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'yes',
        ] );
        $full_review_button_config = apply_filters( 'oradel_full_review_button_control_config', [
            'label'        => esc_html__( 'Show Full Review Button', 'orange-addons-for-elementor' ) . ' <i class="eicon-pro-icon"></i>',
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => esc_html__( 'Show', 'orange-addons-for-elementor' ),
            'label_off'    => esc_html__( 'Hide', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'no',
            'classes'      => 'elementor-control-disabled',
        ] );
        $this->add_control( 'show_verdict_full_review_button', $full_review_button_config );
        $premium_notice = apply_filters( 'oradel_full_review_button_premium_notice', Oradel_Plugin_Helper::create_premium_notice( 
            /* translators: %s: Premium upgrade URL */
            __( 'Full Review Button is available in the <a href="%s" target="_blank">Premium version</a>', 'orange-addons-for-elementor' ),
            'verdict',
            'info'
         ) );
        if ( $premium_notice !== null ) {
            $this->add_control( 'oea_premium_notice_show_verdict_full_review_button', $premium_notice );
        }
        $this->end_controls_section();
        $this->start_controls_section( 'content_section', [
            'label' => esc_html__( 'Content', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        ] );
        $this->add_control( 'verdict_title', [
            'label'       => esc_html__( 'Title', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => esc_html__( 'Default title', 'orange-addons-for-elementor' ),
            'placeholder' => esc_html__( 'Type your title here', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'verdict_description', [
            'label'       => esc_html__( 'Description', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::WYSIWYG,
            'default'     => esc_html__( 'Default description', 'orange-addons-for-elementor' ),
            'placeholder' => esc_html__( 'Type your description here', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'verdict_score_value', [
            'label'   => esc_html__( 'Score Value', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => 0,
            'max'     => 10,
            'step'    => 0.1,
            'default' => 9.9,
        ] );
        $this->add_control( 'verdict_score_text', [
            'label'       => esc_html__( 'Score Text', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => esc_html__( 'Excellent', 'orange-addons-for-elementor' ),
            'placeholder' => esc_html__( 'Type your text here', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'verdict_item_link', [
            'label'       => esc_html__( 'Link', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::URL,
            'options'     => ['url', 'is_external', 'nofollow'],
            'default'     => [
                'url'         => '',
                'is_external' => true,
                'nofollow'    => true,
            ],
            'label_block' => true,
            'condition'   => [
                'show_verdict_website_button' => 'yes',
            ],
        ] );
        $this->add_control( 'verdict_item_full_review_link', [
            'label'       => esc_html__( 'Review Link', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::URL,
            'options'     => ['url', 'is_external', 'nofollow'],
            'default'     => [
                'url'         => '',
                'is_external' => false,
                'nofollow'    => false,
            ],
            'label_block' => true,
            'condition'   => [
                'show_verdict_full_review_button' => 'yes',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'verdict_details_section', [
            'label' => esc_html__( 'Verdict Details', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        ] );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control( 'verdict_detail_title', [
            'label'       => esc_html__( 'Detail Title', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => esc_html__( 'Default Title', 'orange-addons-for-elementor' ),
            'label_block' => true,
        ] );
        $repeater->add_control( 'verdict_detail_score_value', [
            'label'   => esc_html__( 'Score Value', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => 0,
            'max'     => 10,
            'step'    => 0.1,
            'default' => 9.9,
        ] );
        $verdict_details_config = [
            'label'       => esc_html__( 'Details List', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::REPEATER,
            'fields'      => $repeater->get_controls(),
            'default'     => [
                [
                    'verdict_detail_title'       => esc_html__( 'Performance', 'orange-addons-for-elementor' ),
                    'verdict_detail_score_value' => 9.800000000000001,
                ],
                [
                    'verdict_detail_title'       => esc_html__( 'Support', 'orange-addons-for-elementor' ),
                    'verdict_detail_score_value' => 9.199999999999999,
                ],
                [
                    'verdict_detail_title'       => esc_html__( 'Security & Privacy', 'orange-addons-for-elementor' ),
                    'verdict_detail_score_value' => 7.6,
                ],
                [
                    'verdict_detail_title'       => esc_html__( 'Features', 'orange-addons-for-elementor' ),
                    'verdict_detail_score_value' => 8.4,
                ]
            ],
            'title_field' => '{{{ verdict_detail_title }}}',
        ];
        $this->add_control( 'verdict_details_list', $verdict_details_config );
        $this->end_controls_section();
        $this->start_controls_section( 'verdict_pros_section', [
            'label' => esc_html__( 'Verdict Pros', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        ] );
        $this->add_control( 'verdict_pros_heading', [
            'label'       => esc_html__( 'Pros Heading Text', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => esc_html__( 'Positive', 'orange-addons-for-elementor' ),
            'placeholder' => esc_html__( 'Type your title here', 'orange-addons-for-elementor' ),
            'condition'   => [
                'show_verdict_pros_cons_heading' => 'yes',
            ],
        ] );
        $this->add_control( 'verdict_pros_item_icon', [
            'label'       => esc_html__( 'Pros Item Icon', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::ICONS,
            'default'     => [
                'value'   => 'fas fa-plus',
                'library' => 'fa-solid',
            ],
            'recommended' => [
                'fa-solid' => [
                    'plus',
                    'arrow-alt-circle-up',
                    'smile',
                    'check',
                    'thumbs-up'
                ],
            ],
        ] );
        $repeaterPros = new \Elementor\Repeater();
        $repeaterPros->add_control( 'verdict_pros_title', [
            'label'       => esc_html__( 'Pros Title', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => esc_html__( 'Default Title', 'orange-addons-for-elementor' ),
            'label_block' => true,
        ] );
        $verdict_pros_config = [
            'label'       => esc_html__( 'Pros List', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::REPEATER,
            'fields'      => $repeaterPros->get_controls(),
            'default'     => [
                [
                    'verdict_pros_title' => esc_html__( 'Excellent performance', 'orange-addons-for-elementor' ),
                ],
                [
                    'verdict_pros_title' => esc_html__( 'Exceptional battery life', 'orange-addons-for-elementor' ),
                ],
                [
                    'verdict_pros_title' => esc_html__( 'Gorgeous OLED display', 'orange-addons-for-elementor' ),
                ],
                [
                    'verdict_pros_title' => esc_html__( 'Criminally portable', 'orange-addons-for-elementor' ),
                ]
            ],
            'title_field' => '{{{ verdict_pros_title }}}',
        ];
        $this->add_control( 'verdict_pros_list', $verdict_pros_config );
        $this->end_controls_section();
        $this->start_controls_section( 'verdict_cons_section', [
            'label' => esc_html__( 'Verdict Cons', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        ] );
        $this->add_control( 'verdict_cons_heading', [
            'label'       => esc_html__( 'Cons Heading Text', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => esc_html__( 'Negative', 'orange-addons-for-elementor' ),
            'placeholder' => esc_html__( 'Type your title here', 'orange-addons-for-elementor' ),
            'condition'   => [
                'show_verdict_pros_cons_heading' => 'yes',
            ],
        ] );
        $this->add_control( 'verdict_cons_item_icon', [
            'label'       => esc_html__( 'Cons Item Icon', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::ICONS,
            'default'     => [
                'value'   => 'fas fa-minus',
                'library' => 'fa-solid',
            ],
            'recommended' => [
                'fa-solid' => [
                    'minus',
                    'arrow-alt-circle-down',
                    'angry',
                    'times',
                    'thumbs-down'
                ],
            ],
        ] );
        $repeaterCons = new \Elementor\Repeater();
        $repeaterCons->add_control( 'verdict_cons_title', [
            'label'       => esc_html__( 'Cons Title', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => esc_html__( 'Default Title', 'orange-addons-for-elementor' ),
            'label_block' => true,
        ] );
        $verdict_cons_config = [
            'label'       => esc_html__( 'Cons List', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::REPEATER,
            'fields'      => $repeaterCons->get_controls(),
            'default'     => [
                [
                    'verdict_cons_title' => esc_html__( 'The worst port selection imaginable', 'orange-addons-for-elementor' ),
                ],
                [
                    'verdict_cons_title' => esc_html__( 'Very expensive', 'orange-addons-for-elementor' ),
                ],
                [
                    'verdict_cons_title' => esc_html__( 'Short key travel might cause fatigue over time', 'orange-addons-for-elementor' ),
                ],
                [
                    'verdict_cons_title' => esc_html__( 'Display has slow response time', 'orange-addons-for-elementor' ),
                ]
            ],
            'title_field' => '{{{ verdict_cons_title }}}',
        ];
        $this->add_control( 'verdict_cons_list', $verdict_cons_config );
        $this->end_controls_section();
        $this->start_controls_section( 'verdict_general_style', [
            'label' => esc_html__( 'General', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'verdict_block_border',
            'selector' => '{{WRAPPER}} .verdict-block',
        ] );
        $this->add_responsive_control( 'verdict_block_border_radius', [
            'label'      => esc_html__( 'Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'px',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), [
            'name'     => 'verdict_block_box_shadow',
            'label'    => esc_html__( 'Box Shadow', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .verdict-block',
        ] );
        $this->add_group_control( \Elementor\Group_Control_Background::get_type(), [
            'name'     => 'background',
            'types'    => ['classic', 'gradient'],
            'selector' => '{{WRAPPER}} .verdict-block',
            'image'    => [
                'condition' => [
                    'show_image' => 'never',
                ],
            ],
        ] );
        $this->add_responsive_control( 'verdict_block_padding', [
            'label'      => esc_html__( 'Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'verdict_typography_style', [
            'label' => esc_html__( 'Typography', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'verdict_header_typography',
            'label'    => esc_html__( 'Header', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .verdict-block .score-description-title',
        ] );
        $this->add_control( 'verdict_header_text_color', [
            'label'     => esc_html__( 'Header Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .score-description-title' => 'color: {{VALUE}}',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'verdict_score_value_typography',
            'label'    => esc_html__( 'Score Value', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .verdict-block .verdict-score .score-value',
        ] );
        $this->add_control( 'verdict_score_value_text_color', [
            'label'     => esc_html__( 'Score Value Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-score .score-value' => 'color: {{VALUE}}',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'verdict_score_text_typography',
            'label'    => esc_html__( 'Score Text', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .verdict-block .verdict-score .score-text',
        ] );
        $this->add_control( 'verdict_score_text_color', [
            'label'     => esc_html__( 'Score Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-score .score-text' => 'color: {{VALUE}}',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'verdict_button_typography',
            'label'    => esc_html__( 'Button', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .verdict-block .verdict-score .visit-website, {{WRAPPER}} .verdict-block .verdict-score .full-review',
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'verdict_description_typography',
            'label'    => esc_html__( 'Description', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .verdict-block .score-description p',
        ] );
        $this->add_control( 'verdict_description_text_color', [
            'label'     => esc_html__( 'Description Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .score-description p' => 'color: {{VALUE}}',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'verdict_details_typography',
            'label'    => esc_html__( 'Details', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .verdict-block .verdict-details .detail-item span',
        ] );
        $this->add_control( 'verdict_details_text_color', [
            'label'     => esc_html__( 'Details Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-details .detail-item span' => 'color: {{VALUE}}',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'verdict_pros_cons_heading_typography',
            'label'    => esc_html__( 'Pros and Cons Heading', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .verdict-block .verdict-pros .verdict-pros-heading, {{WRAPPER}} .verdict-block .verdict-cons .verdict-cons-heading',
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'verdict_pros_cons_typography',
            'label'    => esc_html__( 'Pros and Cons', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .verdict-block .verdict-pros .pros-item, {{WRAPPER}} .verdict-block .verdict-cons .cons-item',
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'verdict_header_block_style', [
            'label' => esc_html__( 'Header Block', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'verdict_header_block_border',
            'selector' => '{{WRAPPER}} .verdict-block .verdict-header',
        ] );
        $this->add_responsive_control( 'verdict_header_block_border_radius', [
            'label'      => esc_html__( 'Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'px',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block .verdict-header' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'verdict_header_block_padding', [
            'label'      => esc_html__( 'Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block .verdict-header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'verdict_header_block_margin', [
            'label'      => esc_html__( 'Margin', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block .verdict-header' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'verdict_score_block_style', [
            'label' => esc_html__( 'Score Block', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->start_controls_tabs( 'verdict_score_button_style_tabs' );
        $this->start_controls_tab( 'verdict_score_style_normal', [
            'label' => esc_html__( 'Normal', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'verdict_score_button_normal_color', [
            'label'     => esc_html__( 'Website Button Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-header .verdict-score .visit-website' => 'background-color: {{VALUE}}',
            ],
        ] );
        $this->add_control( 'verdict_button_text_normal_color', [
            'label'     => esc_html__( 'Website Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-header .verdict-score .visit-website' => 'color: {{VALUE}}',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'           => 'verdict_score_website_normal_button_border',
            'fields_options' => [
                'type' => [
                    'label' => esc_html__( 'Website Button Border', 'orange-addons-for-elementor' ),
                ],
            ],
            'selector'       => '{{WRAPPER}} .verdict-block .verdict-header .verdict-score .visit-website',
        ] );
        $this->add_control( 'hr_score_block', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_control( 'verdict_score_full_review_button_normal_color', [
            'label'     => esc_html__( 'Review Button Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-header .verdict-score .full-review' => 'background-color: {{VALUE}}',
            ],
        ] );
        $this->add_control( 'verdict_button_full_review_text_normal_color', [
            'label'     => esc_html__( 'Review Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-header .verdict-score .full-review' => 'color: {{VALUE}}',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'verdict_score_full_review_normal_button_border',
            'selector' => '{{WRAPPER}} .verdict-block .verdict-header .verdict-score .full-review',
        ] );
        $this->end_controls_tab();
        $this->start_controls_tab( 'verdict_score_style_hover', [
            'label' => esc_html__( 'Hover', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'verdict_score_button_hover_color', [
            'label'     => esc_html__( 'Website Button Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-header .verdict-score .visit-website:hover' => 'background-color: {{VALUE}}',
            ],
        ] );
        $this->add_control( 'verdict_button_text_hover_color', [
            'label'     => esc_html__( 'Website Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-header .verdict-score .visit-website:hover' => 'color: {{VALUE}}',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'verdict_score_website_hover_button_border',
            'selector' => '{{WRAPPER}} .verdict-block .verdict-header .verdict-score .visit-website:hover',
        ] );
        $this->add_control( 'hr_score_block2', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_control( 'verdict_score_full_review_button_hover_color', [
            'label'     => esc_html__( 'Review Button Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-header .verdict-score .full-review:hover' => 'background-color: {{VALUE}}',
            ],
        ] );
        $this->add_control( 'verdict_button_full_review_text_hover_color', [
            'label'     => esc_html__( 'Review Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-header .verdict-score .full-review:hover' => 'color: {{VALUE}}',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'verdict_score_full_review_hover_button_border',
            'selector' => '{{WRAPPER}} .verdict-block .verdict-header .verdict-score .full-review:hover',
        ] );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control( 'hr_score_block3', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_responsive_control( 'verdict_score_buttons_border_radius', [
            'label'      => esc_html__( 'Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'px',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block .verdict-header .verdict-score .full-review'   => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
                '{{WRAPPER}} .verdict-block .verdict-header .verdict-score .visit-website' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
                '{{WRAPPER}} .verdict-block .verdict-header .verdict-score .score-rating'  => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_control( 'verdict_score_item_transition', [
            'label'     => esc_html__( 'Transition', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::NUMBER,
            'min'       => 0.0,
            'max'       => 30,
            'step'      => 0.1,
            'default'   => 0.6,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-header .verdict-score .visit-website' => 'transition: all {{VALUE}}s ease;',
                '{{WRAPPER}} .verdict-block .verdict-header .verdict-score .full-review'   => 'transition: all {{VALUE}}s ease;',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'verdict_details_block_style', [
            'label' => esc_html__( 'Details Block', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'verdict_details_block_border',
            'selector' => '{{WRAPPER}} .verdict-block .verdict-details',
        ] );
        $this->add_responsive_control( 'verdict_details_block_border_radius', [
            'label'      => esc_html__( 'Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'px',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block .verdict-details' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'verdict_details_block_padding', [
            'label'      => esc_html__( 'Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block .verdict-details' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'verdict_details_block_margin', [
            'label'      => esc_html__( 'Margin', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block .verdict-details' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_control( 'hr_details_item', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_responsive_control( 'verdict_details_item_gap', [
            'label'      => esc_html__( 'Item Gap', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [
                'px',
                'em',
                'rem',
                '%'
            ],
            'range'      => [
                'px'  => [
                    'min'  => 0,
                    'max'  => 200,
                    'step' => 1,
                ],
                'em'  => [
                    'min'  => 0,
                    'max'  => 20,
                    'step' => 0.1,
                ],
                'rem' => [
                    'min'  => 0,
                    'max'  => 20,
                    'step' => 0.1,
                ],
                '%'   => [
                    'min'  => 0,
                    'max'  => 50,
                    'step' => 1,
                ],
            ],
            'default'    => [
                'unit' => 'px',
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block .verdict-details .progress-bar' => 'margin-bottom: {{SIZE}}{{UNIT}};',
            ],
        ] );
        $this->add_control( 'verdict_details_progress_bar_border', [
            'label'     => esc_html__( 'Progress Bar Border', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SELECT,
            'default'   => 'solid',
            'options'   => [
                ''       => esc_html__( 'Default', 'orange-addons-for-elementor' ),
                'none'   => esc_html__( 'None', 'orange-addons-for-elementor' ),
                'solid'  => esc_html__( 'Solid', 'orange-addons-for-elementor' ),
                'dashed' => esc_html__( 'Dashed', 'orange-addons-for-elementor' ),
                'dotted' => esc_html__( 'Dotted', 'orange-addons-for-elementor' ),
                'double' => esc_html__( 'Double', 'orange-addons-for-elementor' ),
            ],
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-details .progress-bar' => 'border-style: {{VALUE}};',
            ],
        ] );
        $this->add_control( 'verdict_details_progress_bar_color', [
            'label'     => esc_html__( 'Progress Bar Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-details .progress-bar .progress-fill' => 'background-color: {{VALUE}} !important',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'verdict_pros_cons_style', [
            'label' => esc_html__( 'Pros and Cons Block', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_control( 'verdict_pros_cons_item_icon_size', [
            'label'      => esc_html__( 'Icon Size', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'range'      => [
                'px'  => [
                    'min'  => 0,
                    'max'  => 100,
                    'step' => 1,
                ],
                'em'  => [
                    'min' => 0,
                    'max' => 10,
                ],
                'rem' => [
                    'min' => 0,
                    'max' => 10,
                ],
                '%'   => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default'    => [
                'unit' => 'px',
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block .verdict-pros .pros-item .pros-icon svg' => 'width: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .verdict-block .verdict-cons .cons-item .cons-icon svg' => 'width: {{SIZE}}{{UNIT}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'verdict_pros_cons_block_border',
            'selector' => '{{WRAPPER}} .verdict-block .pros-cons-row, {{WRAPPER}} .verdict-block .pros-cons-column',
        ] );
        $this->add_responsive_control( 'verdict_pros_cons_block_border_radius', [
            'label'      => esc_html__( 'Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'px',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block .pros-cons-row'    => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
                '{{WRAPPER}} .verdict-block .pros-cons-column' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'verdict_pros_cons_block_padding', [
            'label'      => esc_html__( 'Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block .pros-cons-row'    => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                '{{WRAPPER}} .verdict-block .pros-cons-column' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'verdict_pros_cons_block_margin', [
            'label'      => esc_html__( 'Margin', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block .pros-cons-row'    => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                '{{WRAPPER}} .verdict-block .pros-cons-column' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'verdict_pros_cons_item_gap', [
            'label'      => esc_html__( 'Item Gap', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [
                'px',
                'em',
                'rem',
                '%'
            ],
            'range'      => [
                'px'  => [
                    'min'  => 0,
                    'max'  => 200,
                    'step' => 1,
                ],
                'em'  => [
                    'min'  => 0,
                    'max'  => 20,
                    'step' => 0.1,
                ],
                'rem' => [
                    'min'  => 0,
                    'max'  => 20,
                    'step' => 0.1,
                ],
                '%'   => [
                    'min'  => 0,
                    'max'  => 50,
                    'step' => 1,
                ],
            ],
            'default'    => [
                'unit' => 'px',
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block .verdict-pros .pros-item' => 'margin-top: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .verdict-block .verdict-cons .cons-item' => 'margin-top: {{SIZE}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'verdict_pros_style', [
            'label' => esc_html__( 'Pros Block', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_control( 'verdict_pros_heading_color', [
            'label'     => esc_html__( 'Heading Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-pros .verdict-pros-heading' => 'color: {{VALUE}}',
            ],
            'condition' => [
                'show_verdict_pros_cons_heading' => 'yes',
            ],
        ] );
        $this->add_control( 'verdict_pros_text_color', [
            'label'     => esc_html__( 'Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-pros .pros-item' => 'color: {{VALUE}}',
            ],
        ] );
        $this->add_control( 'verdict_pros_icon_color', [
            'label'     => esc_html__( 'Icon Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-pros .pros-item .pros-icon svg' => 'fill: {{VALUE}}',
            ],
        ] );
        $this->add_control( 'verdict_pros_bg_color', [
            'label'     => esc_html__( 'Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-pros' => 'background-color: {{VALUE}}',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'verdict_pros_border',
            'selector' => '{{WRAPPER}} .verdict-block .verdict-pros',
        ] );
        $this->add_responsive_control( 'verdict_pros_block_border_radius', [
            'label'      => esc_html__( 'Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'px',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block .verdict-pros' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'verdict_pros_block_padding', [
            'label'      => esc_html__( 'Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block .verdict-pros' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'verdict_pros_block_margin', [
            'label'      => esc_html__( 'Margin', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block .verdict-pros' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'verdict_cons_style', [
            'label' => esc_html__( 'Cons Block', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_control( 'verdict_cons_heading_color', [
            'label'     => esc_html__( 'Heading Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-cons .verdict-cons-heading' => 'color: {{VALUE}}',
            ],
            'condition' => [
                'show_verdict_pros_cons_heading' => 'yes',
            ],
        ] );
        $this->add_control( 'verdict_cons_text_color', [
            'label'     => esc_html__( 'Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-cons .cons-item' => 'color: {{VALUE}}',
            ],
        ] );
        $this->add_control( 'verdict_cons_icon_color', [
            'label'     => esc_html__( 'Icon Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-cons .cons-item .cons-icon svg' => 'fill: {{VALUE}}',
            ],
        ] );
        $this->add_control( 'verdict_cons_bg_color', [
            'label'     => esc_html__( 'Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .verdict-block .verdict-cons' => 'background-color: {{VALUE}}',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'verdict_cons_border',
            'selector' => '{{WRAPPER}} .verdict-block .verdict-cons',
        ] );
        $this->add_responsive_control( 'verdict_cons_block_border_radius', [
            'label'      => esc_html__( 'Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'px',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block .verdict-cons' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'verdict_cons_block_padding', [
            'label'      => esc_html__( 'Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block .verdict-cons' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'verdict_cons_block_margin', [
            'label'      => esc_html__( 'Margin', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .verdict-block .verdict-cons' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $pros_cons_direction = ( $settings['verdict_pros_cons_direction'] === 'column' ? 'pros-cons-column' : 'pros-cons-row' );
        if ( !empty( $settings['verdict_item_link']['url'] ) ) {
            $this->add_link_attributes( 'verdict_item_link', $settings['verdict_item_link'] );
        }
        if ( !empty( $settings['verdict_item_full_review_link']['url'] ) ) {
            $this->add_link_attributes( 'verdict_item_full_review_link', $settings['verdict_item_full_review_link'] );
        }
        ?>

        <div class="verdict-block">
            <?php 
        if ( $settings['show_verdict_header'] === 'yes' ) {
            ?>
                <div class="verdict-header">
                    <div class="verdict-score">
                        <div class="score-rating">
                            <div class="score-value"><?php 
            echo esc_attr( $settings['verdict_score_value'] );
            ?></div>
                            <div class="score-text"><?php 
            echo esc_attr( $settings['verdict_score_text'] );
            ?></div>
                        </div>
                        <?php 
            if ( $settings['show_verdict_website_button'] === 'yes' ) {
                ?>
                            <a <?php 
                $this->print_render_attribute_string( 'verdict_item_link' );
                ?> class="visit-website">
                                <?php 
                esc_html_e( 'Visit Website', 'orange-addons-for-elementor' );
                ?>
                            </a>
                        <?php 
            }
            ?>
                        <?php 
            ?>
                    </div>
                    <div class="score-description">
                        <<?php 
            echo esc_attr( $settings['verdict_title_html_tag'] );
            ?> class="score-description-title">
                            <?php 
            echo esc_attr( $settings['verdict_title'] );
            ?>
                        </<?php 
            echo esc_attr( $settings['verdict_title_html_tag'] );
            ?>>
                        <p><?php 
            echo wp_kses_post( $settings['verdict_description'] );
            ?></p>
                    </div>
                </div>
            <?php 
        }
        ?>
            <?php 
        if ( $settings['show_verdict_details'] === 'yes' ) {
            ?>
                <div class="verdict-details">
                    <?php 
            if ( $settings['verdict_details_list'] ) {
                foreach ( $settings['verdict_details_list'] as $item ) {
                    $score_value = esc_attr( $item['verdict_detail_score_value'] );
                    $width = $score_value * 10;
                    if ( $score_value <= 2.5 ) {
                        $background_color = 'red';
                    } elseif ( $score_value > 2.5 && $score_value < 5 ) {
                        $background_color = 'orange';
                    } elseif ( $score_value >= 5 && $score_value <= 7.5 ) {
                        $background_color = 'yellow';
                    } elseif ( $score_value > 7.5 && $score_value < 9 ) {
                        $background_color = '#90ee90';
                    } else {
                        $background_color = '#10ab10';
                    }
                    ?>
                            <div class="detail-item">
                                <span><?php 
                    echo esc_attr( $item['verdict_detail_title'] );
                    ?></span>
                                <span><?php 
                    echo esc_html( $score_value );
                    ?> / 10</span>
                            </div>
                            <div class="progress-bar">
                                <div class="progress-fill"
                                    style="width: <?php 
                    echo esc_attr( $width );
                    ?>%; background-color: <?php 
                    echo esc_attr( $background_color );
                    ?>;">
                                </div>
                            </div>
                            <?php 
                }
            }
            ?>
                </div>
            <?php 
        }
        ?>
            <?php 
        if ( $settings['show_verdict_pros_cons'] === 'yes' ) {
            ?>
                <div class="<?php 
            echo esc_attr( $pros_cons_direction );
            ?>">
                    <div class="verdict-pros">
                        <?php 
            if ( $settings['show_verdict_pros_cons_heading'] === 'yes' ) {
                ?>
                            <div class="verdict-pros-heading"><?php 
                echo esc_attr( $settings['verdict_pros_heading'] );
                ?></div>
                        <?php 
            }
            ?>
                        <?php 
            if ( $settings['verdict_pros_list'] ) {
                foreach ( $settings['verdict_pros_list'] as $item ) {
                    ?>
                                <div class="pros-item">
                                    <span
                                        class="pros-icon"><?php 
                    \Elementor\Icons_Manager::render_icon( $settings['verdict_pros_item_icon'], [
                        'aria-hidden' => 'true',
                    ] );
                    ?></span>
                                    <span><?php 
                    echo esc_attr( $item['verdict_pros_title'] );
                    ?></span>
                                </div>
                                <?php 
                }
            }
            ?>
                    </div>
                    <div class="verdict-cons">
                        <?php 
            if ( $settings['show_verdict_pros_cons_heading'] === 'yes' ) {
                ?>
                            <div class="verdict-cons-heading"><?php 
                echo esc_attr( $settings['verdict_cons_heading'] );
                ?></div>
                        <?php 
            }
            ?>
                        <?php 
            if ( $settings['verdict_cons_list'] ) {
                foreach ( $settings['verdict_cons_list'] as $item ) {
                    ?>
                                <div class="cons-item">
                                    <span
                                        class="cons-icon"><?php 
                    \Elementor\Icons_Manager::render_icon( $settings['verdict_cons_item_icon'], [
                        'aria-hidden' => 'true',
                    ] );
                    ?></span>
                                    <span><?php 
                    echo esc_attr( $item['verdict_cons_title'] );
                    ?></span>
                                </div>
                                <?php 
                }
            }
            ?>
                    </div>
                </div>
            <?php 
        }
        ?>
        </div>

        <?php 
    }

}
