<?php

if ( !defined( 'ABSPATH' ) ) {
    exit;
    // Exit if accessed directly.
}
require_once ORADEL_PATH . 'includes/helpers.php';
class Oradel_Testimonials_Widget extends \Elementor\Widget_Base {
    public function get_name() {
        return 'oradel_testimonials';
    }

    public function get_title() {
        return __( 'Testimonials', 'orange-addons-for-elementor' );
    }

    public function get_icon() {
        return 'eicon-testimonial-carousel';
    }

    public function get_categories() {
        return ['oradel-plugin'];
    }

    public function get_custom_help_url() {
        return 'https://orange-addons.com/docs/';
    }

    public function get_style_depends() {
        return ['oea-testimonials'];
    }

    public function get_script_depends() {
        return ['oea-testimonials-slider', 'oea-testimonial-gallery'];
    }

    protected function register_controls() {
        $this->start_controls_section( 'content_section', [
            'label' => __( 'Content', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        ] );
        $this->add_control( 'header_text', [
            'label'   => __( 'Header Text', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::TEXT,
            'default' => __( 'What Users Say', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'show_header', [
            'label'        => __( 'Show Header', 'orange-addons-for-elementor' ),
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => __( 'Yes', 'orange-addons-for-elementor' ),
            'label_off'    => __( 'No', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'yes',
        ] );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control( 'name', [
            'label'   => __( 'Name', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::TEXT,
            'default' => __( 'John Doe', 'orange-addons-for-elementor' ),
        ] );
        $repeater->add_control( 'avatar', [
            'label'   => __( 'Avatar', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
        ] );
        $repeater->add_control( 'review_date', [
            'label'   => __( 'Review Date', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::DATE_TIME,
            'default' => gmdate( 'Y-m-d' ),
        ] );
        $repeater->add_control( 'review_text', [
            'label'   => __( 'Review Text', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::TEXTAREA,
            'default' => __( 'Great product!', 'orange-addons-for-elementor' ),
        ] );
        $repeater->add_control( 'star_rating', [
            'label'   => __( 'Star Rating', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => 0,
            'max'     => 5,
            'step'    => 0.1,
            'default' => 5,
        ] );
        $gallery_config = apply_filters( 'oradel_testimonial_gallery_control_config', [
            'label'   => __( 'Gallery Images', 'orange-addons-for-elementor' ) . ' <i class="eicon-pro-icon"></i>',
            'type'    => \Elementor\Controls_Manager::GALLERY,
            'default' => [],
            'classes' => 'elementor-control-disabled',
        ] );
        $repeater->add_control( 'gallery', $gallery_config );
        $premium_notice = apply_filters( 'oradel_testimonial_gallery_premium_notice', Oradel_Plugin_Helper::create_premium_notice( 
            /* translators: %s: Premium upgrade URL */
            __( 'Gallery Images are available in the <a href="%s" target="_blank">Premium version</a>', 'orange-addons-for-elementor' ),
            'testimonials'
         ) );
        if ( $premium_notice !== null ) {
            $repeater->add_control( 'oea_premium_notice_gallery', $premium_notice );
        }
        $this->add_control( 'testimonials', [
            'label'       => __( 'Testimonials', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::REPEATER,
            'fields'      => $repeater->get_controls(),
            'default'     => [[
                'name'        => __( 'John Smith', 'orange-addons-for-elementor' ),
                'review_text' => __( 'This plugin brought my site to life!', 'orange-addons-for-elementor' ),
                'star_rating' => '5',
            ]],
            'title_field' => '{{{ name }}}',
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'slider_settings', [
            'label' => __( 'Slider Settings', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        ] );
        $this->add_control( 'cards_per_view', [
            'label'   => __( 'Cards Per View', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '1' => __( '1 Card', 'orange-addons-for-elementor' ),
                '2' => __( '2 Cards', 'orange-addons-for-elementor' ),
                '3' => __( '3 Cards', 'orange-addons-for-elementor' ),
                '4' => __( '4 Cards', 'orange-addons-for-elementor' ),
            ],
            'default' => '3',
        ] );
        $this->add_control( 'auto_scroll', [
            'label'     => __( 'Auto Scroll', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SWITCHER,
            'label_on'  => __( 'Yes', 'orange-addons-for-elementor' ),
            'label_off' => __( 'No', 'orange-addons-for-elementor' ),
            'default'   => 'yes',
        ] );
        $this->add_control( 'auto_scroll_interval', [
            'label'     => __( 'Auto Scroll Interval (ms)', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::NUMBER,
            'default'   => 5000,
            'condition' => [
                'auto_scroll' => 'yes',
            ],
        ] );
        $this->add_control( 'prev_button_text', [
            'label'   => __( 'Previous Button Text', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::TEXT,
            'default' => __( 'Previous', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'prev_button_icon', [
            'label'   => __( 'Previous Button Icon', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::ICONS,
            'default' => [
                'value'   => 'fas fa-arrow-left',
                'library' => 'fa-solid',
            ],
        ] );
        $this->add_control( 'next_button_text', [
            'label'   => __( 'Next Button Text', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::TEXT,
            'default' => __( 'Next', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'next_button_icon', [
            'label'   => __( 'Next Button Icon', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::ICONS,
            'default' => [
                'value'   => 'fas fa-arrow-right',
                'library' => 'fa-solid',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'header_style_section', [
            'label' => __( 'Header', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_control( 'header_color', [
            'label'     => __( 'Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonials-section h2' => 'color: {{VALUE}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'header_typography',
            'selector' => '{{WRAPPER}} .testimonials-section h2',
        ] );
        $this->add_responsive_control( 'header_margin', [
            'label'      => __( 'Margin', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors'  => [
                '{{WRAPPER}} .testimonials-section h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'card_style_section', [
            'label' => __( 'Testimonial Card', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->start_controls_tabs( 'card_style_tabs' );
        $this->start_controls_tab( 'card_style_normal', [
            'label' => __( 'Normal', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'card_background_color', [
            'label'     => __( 'Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial-card' => 'background-color: {{VALUE}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'card_border',
            'label'    => __( 'Border', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .testimonial-card',
        ] );
        $this->add_responsive_control( 'card_border_radius', [
            'label'      => __( 'Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors'  => [
                '{{WRAPPER}} .testimonial-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), [
            'name'     => 'card_box_shadow',
            'label'    => __( 'Box Shadow', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .testimonial-card',
        ] );
        $this->add_responsive_control( 'card_padding', [
            'label'      => __( 'Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors'  => [
                '{{WRAPPER}} .testimonial-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_tab();
        $this->start_controls_tab( 'card_style_hover', [
            'label' => __( 'Hover', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'card_background_color_hover', [
            'label'     => __( 'Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial-card:hover' => 'background-color: {{VALUE}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'card_border_hover',
            'label'    => __( 'Border', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .testimonial-card:hover',
        ] );
        $this->add_responsive_control( 'card_border_radius_hover', [
            'label'      => __( 'Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors'  => [
                '{{WRAPPER}} .testimonial-card:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), [
            'name'     => 'card_box_shadow_hover',
            'label'    => __( 'Box Shadow', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .testimonial-card:hover',
        ] );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control( 'card_transition', [
            'label'     => __( 'Transition Duration', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SLIDER,
            'range'     => [
                'px' => [
                    'min'  => 0.1,
                    'max'  => 2,
                    'step' => 0.1,
                ],
            ],
            'default'   => [
                'size' => 0.3,
            ],
            'selectors' => [
                '{{WRAPPER}} .testimonial-card' => 'transition: all {{SIZE}}s ease;',
            ],
            'separator' => 'before',
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'author_style_section', [
            'label' => __( 'Author Name', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_control( 'author_name_color', [
            'label'     => __( 'Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial-author' => 'color: {{VALUE}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'author_name_typography',
            'selector' => '{{WRAPPER}} .testimonial-author',
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'date_style_section', [
            'label' => __( 'Review Date', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_control( 'date_color', [
            'label'     => __( 'Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial-date' => 'color: {{VALUE}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'date_typography',
            'selector' => '{{WRAPPER}} .testimonial-date',
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'review_text_style_section', [
            'label' => __( 'Review Text', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_control( 'review_text_color', [
            'label'     => __( 'Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial-text' => 'color: {{VALUE}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'review_text_typography',
            'selector' => '{{WRAPPER}} .testimonial-text',
        ] );
        $this->add_responsive_control( 'review_text_margin', [
            'label'      => __( 'Margin', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors'  => [
                '{{WRAPPER}} .testimonial-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'rating_style_section', [
            'label' => __( 'Rating', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_control( 'star_color', [
            'label'     => __( 'Star Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial-rating .fas.fa-star'              => 'color: {{VALUE}};',
                '{{WRAPPER}} .testimonial-rating .fas.fa-star.partial-star' => 'color: {{VALUE}};',
            ],
        ] );
        $this->add_control( 'empty_star_color', [
            'label'     => __( 'Empty Star Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial-rating .far.fa-star' => 'color: {{VALUE}};',
            ],
        ] );
        $this->add_responsive_control( 'star_size', [
            'label'     => __( 'Star Size', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SLIDER,
            'range'     => [
                'px' => [
                    'min' => 10,
                    'max' => 50,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .testimonial-rating i' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'star_spacing', [
            'label'     => __( 'Star Spacing', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SLIDER,
            'range'     => [
                'px' => [
                    'min' => 0,
                    'max' => 20,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .testimonial-rating i' => 'margin-right: {{SIZE}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'navigation_style_section', [
            'label' => __( 'Navigation Buttons', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->start_controls_tabs( 'navigation_style_tabs' );
        $this->start_controls_tab( 'navigation_style_normal', [
            'label' => __( 'Normal', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'navigation_text_color', [
            'label'     => __( 'Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonials-controls button' => 'color: {{VALUE}};',
            ],
        ] );
        $this->add_control( 'navigation_background_color', [
            'label'     => __( 'Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonials-controls button' => 'background-color: {{VALUE}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'navigation_border',
            'label'    => __( 'Border', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .testimonials-controls button',
        ] );
        $this->add_responsive_control( 'navigation_border_radius', [
            'label'      => __( 'Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors'  => [
                '{{WRAPPER}} .testimonials-controls button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_tab();
        $this->start_controls_tab( 'navigation_style_hover', [
            'label' => __( 'Hover', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'navigation_text_color_hover', [
            'label'     => __( 'Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonials-controls button:hover' => 'color: {{VALUE}};',
            ],
        ] );
        $this->add_control( 'navigation_background_color_hover', [
            'label'     => __( 'Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonials-controls button:hover' => 'background-color: {{VALUE}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'navigation_border_hover',
            'label'    => __( 'Border', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .testimonials-controls button:hover',
        ] );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'      => 'navigation_typography',
            'selector'  => '{{WRAPPER}} .testimonials-controls button',
            'separator' => 'before',
        ] );
        $this->add_control( 'navigation_transition', [
            'label'     => __( 'Transition Duration', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SLIDER,
            'range'     => [
                'px' => [
                    'min'  => 0.1,
                    'max'  => 2,
                    'step' => 0.1,
                ],
            ],
            'default'   => [
                'size' => 0.3,
            ],
            'selectors' => [
                '{{WRAPPER}} .testimonials-controls button' => 'transition: all {{SIZE}}s ease;',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'read_more_style_section', [
            'label' => __( 'Read More Button', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->start_controls_tabs( 'read_more_style_tabs' );
        $this->start_controls_tab( 'read_more_style_normal', [
            'label' => __( 'Normal', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'read_more_text_color', [
            'label'     => __( 'Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .read-more' => 'color: {{VALUE}};',
            ],
        ] );
        $this->add_control( 'read_more_background_color', [
            'label'     => __( 'Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .read-more' => 'background-color: {{VALUE}};',
            ],
        ] );
        $this->end_controls_tab();
        $this->start_controls_tab( 'read_more_style_hover', [
            'label' => __( 'Hover', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'read_more_text_color_hover', [
            'label'     => __( 'Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .read-more:hover' => 'color: {{VALUE}};',
            ],
        ] );
        $this->add_control( 'read_more_background_color_hover', [
            'label'     => __( 'Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .read-more:hover' => 'background-color: {{VALUE}};',
            ],
        ] );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'      => 'read_more_typography',
            'selector'  => '{{WRAPPER}} .read-more',
            'separator' => 'before',
        ] );
        $this->add_responsive_control( 'read_more_padding', [
            'label'      => __( 'Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors'  => [
                '{{WRAPPER}} .read-more' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'read_more_border',
            'label'    => __( 'Border', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .read-more',
        ] );
        $this->add_responsive_control( 'read_more_border_radius', [
            'label'      => __( 'Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors'  => [
                '{{WRAPPER}} .read-more' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $slider_class = 'testimonials-slider slider-' . esc_attr( $settings['cards_per_view'] );
        ?>
        <section id="testimonials" class="testimonials-section">
            <div class="container">
                <?php 
        if ( $settings['show_header'] === 'yes' ) {
            ?>
                    <h2><?php 
            echo esc_html( $settings['header_text'] );
            ?></h2>
                <?php 
        }
        ?>
                <div class="<?php 
        echo esc_attr( $slider_class );
        ?>"
                    data-auto-scroll="<?php 
        echo esc_attr( $settings['auto_scroll'] );
        ?>"
                    data-interval="<?php 
        echo esc_attr( $settings['auto_scroll_interval'] );
        ?>">
                    <div class="testimonials-track">
                        <?php 
        foreach ( $settings['testimonials'] as $index => $item ) {
            ?>
                            <div class="testimonial-card">
                                <div class="testimonial-header">
                                    <div class="testimonial-avatar">
                                        <img src="<?php 
            echo esc_url( $item['avatar']['url'] );
            ?>"
                                            alt="<?php 
            echo esc_attr( $item['name'] );
            ?>">
                                    </div>
                                    <div class="testimonial-meta">
                                        <div class="testimonial-author"><?php 
            echo esc_html( $item['name'] );
            ?></div>
                                        <div class="testimonial-date">
                                            <?php 
            echo esc_html( gmdate( 'F j, Y', strtotime( $item['review_date'] ) ) );
            ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="testimonial-rating">
                                    <?php 
            $rating = floatval( $item['star_rating'] );
            $full_stars = floor( $rating );
            $fraction = $rating - $full_stars;
            for ($i = 1; $i <= 5; $i++) {
                if ( $i <= $full_stars ) {
                    echo '<i class="fas fa-star"></i>';
                } elseif ( $i == $full_stars + 1 && $fraction > 0 ) {
                    echo '<span class="star-wrapper"><i class="far fa-star"></i><i class="fas fa-star partial-star" style="width: ' . esc_attr( $fraction * 100 ) . '%"></i></span>';
                } else {
                    echo '<i class="far fa-star"></i>';
                }
            }
            ?>
                                </div>
                                <div class="testimonial-text-wrapper">
                                    <p class="testimonial-text"><?php 
            echo esc_html( $item['review_text'] );
            ?></p>
                                    <button class="read-more" style="display: none;">Read More</button>
                                </div>

                                <?php 
            ?>
                            </div>
                        <?php 
        }
        ?>
                    </div>
                </div>
                <div class="testimonials-controls">
                    <button class="prev-testimonial">
                        <?php 
        if ( !empty( $settings['prev_button_icon']['value'] ) ) {
            ?>
                            <i class="<?php 
            echo esc_attr( $settings['prev_button_icon']['value'] );
            ?>"></i>
                        <?php 
        }
        ?>
                        <?php 
        echo esc_html( $settings['prev_button_text'] );
        ?>
                    </button>
                    <button class="next-testimonial">
                        <?php 
        echo esc_html( $settings['next_button_text'] );
        ?>
                        <?php 
        if ( !empty( $settings['next_button_icon']['value'] ) ) {
            ?>
                            <i class="<?php 
            echo esc_attr( $settings['next_button_icon']['value'] );
            ?>"></i>
                        <?php 
        }
        ?>
                    </button>
                </div>
            </div>
        </section>
        <?php 
    }

}
