<?php

if ( !defined( 'ABSPATH' ) ) {
    exit;
    // Exit if accessed directly.
}
require_once ORADEL_PATH . 'includes/helpers.php';
class Oradel_Pros_Cons_Widget extends \Elementor\Widget_Base {
    private static function get_upgrade_url() {
        return Oradel_Plugin_Helper::get_widget_upgrade_url( 'pros-cons' );
    }

    public function get_name() {
        return 'oradel_pros_cons';
    }

    public function get_title() {
        return esc_html__( 'Pros And Cons', 'orange-addons-for-elementor' );
    }

    public function get_icon() {
        return 'eicon-check';
    }

    public function get_categories() {
        return ['oradel-plugin'];
    }

    public function get_keywords() {
        return ['pros and cons'];
    }

    public function get_custom_help_url() {
        return 'https://orange-addons.com/docs/';
    }

    public function get_style_depends() {
        return ['oea-pros-cons'];
    }

    protected function register_controls() {
        $this->start_controls_section( 'content_section', [
            'label' => esc_html__( 'Settings', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        ] );
        $this->add_control( 'pros_title', [
            'label'       => esc_html__( 'Pros Title', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => esc_html__( 'Pros', 'orange-addons-for-elementor' ),
            'placeholder' => esc_html__( 'Type your title here', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'cons_title', [
            'label'       => esc_html__( 'Cons Title', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => esc_html__( 'Cons', 'orange-addons-for-elementor' ),
            'placeholder' => esc_html__( 'Type your title here', 'orange-addons-for-elementor' ),
        ] );
        $show_description_config = apply_filters( 'oradel_show_description_control_config', [
            'label'        => esc_html__( 'Show Description', 'orange-addons-for-elementor' ) . ' <i class="eicon-pro-icon"></i>',
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => esc_html__( 'Show', 'orange-addons-for-elementor' ),
            'label_off'    => esc_html__( 'Hide', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'no',
            'classes'      => 'elementor-control-disabled',
        ] );
        $this->add_control( 'show_description', $show_description_config );
        $premium_notice = apply_filters( 'oradel_show_description_premium_notice', Oradel_Plugin_Helper::create_premium_notice( 
            /* translators: %s: Premium upgrade URL */
            __( 'Show Description is available in the <a href="%s" target="_blank">Premium version</a>', 'orange-addons-for-elementor' ),
            'pros-cons',
            'info'
         ) );
        if ( $premium_notice !== null ) {
            $this->add_control( 'oea_premium_show_description_notice', $premium_notice );
        }
        $this->add_control( 'title_html_tag', [
            'label'   => esc_html__( 'Heading Tag', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'span',
            'options' => [
                'span' => esc_html__( 'Span', 'orange-addons-for-elementor' ),
                'h2'   => esc_html__( 'H2', 'orange-addons-for-elementor' ),
                'h3'   => esc_html__( 'H3', 'orange-addons-for-elementor' ),
                'h4'   => esc_html__( 'H4', 'orange-addons-for-elementor' ),
                'h5'   => esc_html__( 'H5', 'orange-addons-for-elementor' ),
                'h6'   => esc_html__( 'H6', 'orange-addons-for-elementor' ),
            ],
        ] );
        $this->add_control( 'list_type', [
            'label'   => esc_html__( 'List Type', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'ul',
            'options' => [
                'ul' => esc_html__( 'Unordered', 'orange-addons-for-elementor' ),
                'ol' => esc_html__( 'Ordered', 'orange-addons-for-elementor' ),
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'pros_section', [
            'label' => esc_html__( 'Pros', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        ] );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control( 'pros_item_title', [
            'label'       => esc_html__( 'Title', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => esc_html__( 'Pros Title', 'orange-addons-for-elementor' ),
            'label_block' => true,
        ] );
        $repeater->add_control( 'pros_item_content', [
            'label'      => esc_html__( 'Content', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::WYSIWYG,
            'default'    => esc_html__( 'Pros Content', 'orange-addons-for-elementor' ),
            'show_label' => false,
        ] );
        $pros_list_config = [
            'label'       => esc_html__( 'Pros List', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::REPEATER,
            'fields'      => $repeater->get_controls(),
            'default'     => [[
                'pros_title'   => esc_html__( 'Title #1', 'orange-addons-for-elementor' ),
                'pros_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'orange-addons-for-elementor' ),
            ], [
                'pros_title'   => esc_html__( 'Title #2', 'orange-addons-for-elementor' ),
                'pros_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'orange-addons-for-elementor' ),
            ]],
            'title_field' => '{{{ pros_item_title }}}',
        ];
        $this->add_control( 'pros_list', $pros_list_config );
        $this->end_controls_section();
        $this->start_controls_section( 'cons_section', [
            'label' => esc_html__( 'Cons', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        ] );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control( 'cons_item_title', [
            'label'       => esc_html__( 'Title', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => esc_html__( 'Cons Title', 'orange-addons-for-elementor' ),
            'label_block' => true,
        ] );
        $repeater->add_control( 'cons_item_content', [
            'label'      => esc_html__( 'Content', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::WYSIWYG,
            'default'    => esc_html__( 'Cons Content', 'orange-addons-for-elementor' ),
            'show_label' => false,
        ] );
        $cons_list_config = [
            'label'       => esc_html__( 'Cons List', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::REPEATER,
            'fields'      => $repeater->get_controls(),
            'default'     => [[
                'pros_title'   => esc_html__( 'Title #1', 'orange-addons-for-elementor' ),
                'pros_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'orange-addons-for-elementor' ),
            ], [
                'pros_title'   => esc_html__( 'Title #2', 'orange-addons-for-elementor' ),
                'pros_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'orange-addons-for-elementor' ),
            ]],
            'title_field' => '{{{ cons_item_title }}}',
        ];
        $this->add_control( 'cons_list', $cons_list_config );
        $this->end_controls_section();
        $this->start_controls_section( 'pros_cons_style', [
            'label' => esc_html__( 'General', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_responsive_control( 'pros_cons_block_padding', [
            'label'      => esc_html__( 'Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pros-cons' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Background::get_type(), [
            'name'           => 'pros_cons_block_background',
            'types'          => ['classic', 'gradient'],
            'selector'       => '{{WRAPPER}} .oea-pros-cons',
            'fields_options' => [
                'background' => [
                    'label' => esc_html__( 'Background', 'orange-addons-for-elementor' ),
                ],
                'image'      => [
                    'condition' => [
                        'show_image' => 'never',
                    ],
                ],
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'pros_cons_border',
            'selector' => '{{WRAPPER}} .oea-pros-cons',
        ] );
        $this->add_responsive_control( 'pros_cons_border_radius', [
            'label'      => esc_html__( 'Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'px',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pros-cons' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), [
            'name'     => 'pros_cons_blocks_shadow',
            'label'    => esc_html__( 'Blocks Shadow', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .oea-pros-cons .oea-pros, {{WRAPPER}} .oea-pros-cons .oea-cons',
        ] );
        $this->add_responsive_control( 'title_icon_spacing', [
            'label'      => esc_html__( 'Title Icon Spacing', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', 'em', 'rem'],
            'range'      => [
                'px'  => [
                    'min'  => 0,
                    'max'  => 50,
                    'step' => 1,
                ],
                'em'  => [
                    'min'  => 0,
                    'max'  => 5,
                    'step' => 0.1,
                ],
                'rem' => [
                    'min'  => 0,
                    'max'  => 5,
                    'step' => 0.1,
                ],
            ],
            'default'    => [
                'unit' => 'px',
                'size' => 5,
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pros-title .oea-icon, {{WRAPPER}} .oea-cons-title .oea-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'pros_cons_item', [
            'label' => esc_html__( 'List Items', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_responsive_control( 'list_padding', [
            'label'      => esc_html__( 'List Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'px',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pros-cons ul, {{WRAPPER}} .oea-pros-cons ol' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'list_margin', [
            'label'      => esc_html__( 'List Margin', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'px',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pros-cons ul, {{WRAPPER}} .oea-pros-cons ol' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'item_padding', [
            'label'      => esc_html__( 'Item Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'px',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pros-cons .oea-pros li, {{WRAPPER}} .oea-pros-cons .oea-cons li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'list_item_typography',
            'label'    => esc_html__( 'Item Typography', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .oea-pros-cons .oea-pros li, {{WRAPPER}} .oea-pros-cons .oea-cons li',
        ] );
        $this->add_control( 'list_item_color', [
            'label'     => esc_html__( 'Item Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .oea-pros-cons .oea-pros li, {{WRAPPER}} .oea-pros-cons .oea-cons li' => 'color: {{VALUE}}',
            ],
        ] );
        $this->add_responsive_control( 'item_icon_margin', [
            'label'      => esc_html__( 'Icon Spacing', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [
                'px',
                'em',
                'rem',
                '%'
            ],
            'range'      => [
                'px'  => [
                    'min'  => 0,
                    'max'  => 200,
                    'step' => 1,
                ],
                'em'  => [
                    'min'  => 0,
                    'max'  => 20,
                    'step' => 0.1,
                ],
                'rem' => [
                    'min'  => 0,
                    'max'  => 20,
                    'step' => 0.1,
                ],
                '%'   => [
                    'min'  => 0,
                    'max'  => 50,
                    'step' => 1,
                ],
            ],
            'default'    => [
                'unit' => 'px',
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pros-cons li .oea-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
            ],
        ] );
        $this->add_control( 'list_item_icon_size', [
            'label'      => esc_html__( 'Icon Size', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'range'      => [
                'px'  => [
                    'min'  => 0,
                    'max'  => 100,
                    'step' => 1,
                ],
                'em'  => [
                    'min' => 0,
                    'max' => 10,
                ],
                'rem' => [
                    'min' => 0,
                    'max' => 10,
                ],
                '%'   => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default'    => [
                'unit' => 'px',
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pros-cons li .oea-icon svg' => 'width: {{SIZE}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'pros_style', [
            'label' => esc_html__( 'Pros', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'pros_typography',
            'label'    => esc_html__( 'Title Typography', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .oea-pros .oea-pros-title',
        ] );
        $this->add_control( 'pros_text_color', [
            'label'     => esc_html__( 'Title Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .oea-pros .oea-pros-title'     => 'color: {{VALUE}}',
                '{{WRAPPER}} .oea-pros-title .oea-icon svg' => 'fill: {{VALUE}}',
            ],
        ] );
        $this->add_control( 'pros_text_align', [
            'label'     => esc_html__( 'Title Alignment', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::CHOOSE,
            'options'   => [
                'flex-start' => [
                    'title' => esc_html__( 'Left', 'orange-addons-for-elementor' ),
                    'icon'  => 'eicon-text-align-left',
                ],
                'center'     => [
                    'title' => esc_html__( 'Center', 'orange-addons-for-elementor' ),
                    'icon'  => 'eicon-text-align-center',
                ],
                'flex-end'   => [
                    'title' => esc_html__( 'Right', 'orange-addons-for-elementor' ),
                    'icon'  => 'eicon-text-align-right',
                ],
            ],
            'default'   => 'flex-start',
            'toggle'    => true,
            'selectors' => [
                '{{WRAPPER}} .oea-pros .oea-pros-title' => 'justify-content: {{VALUE}};',
            ],
        ] );
        $this->add_responsive_control( 'pros_title_padding', [
            'label'      => esc_html__( 'Title Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pros .oea-pros-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'pros_title_margin', [
            'label'      => esc_html__( 'Title Margin', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pros .oea-pros-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Background::get_type(), [
            'name'           => 'pros_title_background',
            'types'          => ['classic', 'gradient'],
            'selector'       => '{{WRAPPER}} .oea-pros .oea-pros-title',
            'fields_options' => [
                'background' => [
                    'label' => esc_html__( 'Title Background', 'orange-addons-for-elementor' ),
                ],
                'image'      => [
                    'condition' => [
                        'show_image' => 'never',
                    ],
                ],
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'pros_title_border',
            'label'    => esc_html__( 'Title Border', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .oea-pros-cons .oea-pros .oea-pros-title',
        ] );
        $this->add_responsive_control( 'pros_border_radius', [
            'label'      => esc_html__( 'Title Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'px',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pros .oea-pros-title' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_control( 'hr_pros_title_icon', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_control( 'show_pros_icon', [
            'label'        => esc_html__( 'Show Title Icon', 'orange-addons-for-elementor' ),
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => esc_html__( 'Show', 'orange-addons-for-elementor' ),
            'label_off'    => esc_html__( 'Hide', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'no',
        ] );
        $this->add_control( 'pros_title_icon', [
            'label'       => esc_html__( 'Icon', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::ICONS,
            'default'     => [
                'value'   => 'fas fa-circle',
                'library' => 'fa-solid',
            ],
            'recommended' => [
                'fa-solid'   => ['circle', 'dot-circle', 'square-full'],
                'fa-regular' => ['circle', 'dot-circle', 'square-full'],
            ],
            'condition'   => [
                'show_pros_icon' => 'yes',
            ],
        ] );
        $this->add_control( 'pros_title_icon_size', [
            'label'      => esc_html__( 'Icon Size', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'range'      => [
                'px'  => [
                    'min'  => 0,
                    'max'  => 100,
                    'step' => 1,
                ],
                'em'  => [
                    'min' => 0,
                    'max' => 10,
                ],
                'rem' => [
                    'min' => 0,
                    'max' => 10,
                ],
                '%'   => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default'    => [
                'unit' => 'px',
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pros-title .oea-icon svg' => 'width: {{SIZE}}{{UNIT}};',
            ],
            'condition'  => [
                'show_pros_icon' => 'yes',
            ],
        ] );
        $this->add_control( 'hr_pros_block', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_responsive_control( 'pros_block_padding', [
            'label'      => esc_html__( 'Block Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pros-cons .oea-pros' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'pros_block_margin', [
            'label'      => esc_html__( 'Block Margin', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pros-cons .oea-pros' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Background::get_type(), [
            'name'           => 'pros_block_background',
            'types'          => ['classic', 'gradient'],
            'selector'       => '{{WRAPPER}} .oea-pros-cons .oea-pros',
            'fields_options' => [
                'background' => [
                    'label' => esc_html__( 'Block Background', 'orange-addons-for-elementor' ),
                ],
                'image'      => [
                    'condition' => [
                        'show_image' => 'never',
                    ],
                ],
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'pros_block_border',
            'label'    => esc_html__( 'Block Border', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .oea-pros-cons .oea-pros',
        ] );
        $this->add_responsive_control( 'pros_block_radius', [
            'label'      => esc_html__( 'Block Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'px',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pros-cons .oea-pros' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_control( 'hr_pros_item', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_control( 'pros_item_icon', [
            'label'       => esc_html__( 'List Item Icon', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::ICONS,
            'default'     => [
                'value'   => 'fas fa-plus',
                'library' => 'fa-solid',
            ],
            'recommended' => [
                'fa-solid' => [
                    'plus',
                    'arrow-alt-circle-up',
                    'smile',
                    'check',
                    'thumbs-up'
                ],
            ],
        ] );
        $this->add_control( 'pros_item_icon_color', [
            'label'     => esc_html__( 'Icon Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .oea-pros li svg' => 'fill: {{VALUE}}',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'cons_style', [
            'label' => esc_html__( 'Cons', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'cons_typography',
            'selector' => '{{WRAPPER}} .oea-cons .oea-cons-title',
        ] );
        $this->add_control( 'cons_text_color', [
            'label'     => esc_html__( 'Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .oea-cons .oea-cons-title'     => 'color: {{VALUE}}',
                '{{WRAPPER}} .oea-cons-title .oea-icon svg' => 'fill: {{VALUE}}',
            ],
        ] );
        $this->add_control( 'cons_text_align', [
            'label'     => esc_html__( 'Alignment', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::CHOOSE,
            'options'   => [
                'flex-start' => [
                    'title' => esc_html__( 'Left', 'orange-addons-for-elementor' ),
                    'icon'  => 'eicon-text-align-left',
                ],
                'center'     => [
                    'title' => esc_html__( 'Center', 'orange-addons-for-elementor' ),
                    'icon'  => 'eicon-text-align-center',
                ],
                'flex-end'   => [
                    'title' => esc_html__( 'Right', 'orange-addons-for-elementor' ),
                    'icon'  => 'eicon-text-align-right',
                ],
            ],
            'default'   => 'flex-start',
            'toggle'    => true,
            'selectors' => [
                '{{WRAPPER}} .oea-cons .oea-cons-title' => 'justify-content: {{VALUE}};',
            ],
        ] );
        $this->add_responsive_control( 'cons_title_padding', [
            'label'      => esc_html__( 'Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-cons .oea-cons-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'cons_title_margin', [
            'label'      => esc_html__( 'Margin', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-cons .oea-cons-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Background::get_type(), [
            'name'           => 'cons_title_background',
            'types'          => ['classic', 'gradient'],
            'selector'       => '{{WRAPPER}} .oea-cons .oea-cons-title',
            'fields_options' => [
                'image' => [
                    'condition' => [
                        'show_image' => 'never',
                    ],
                ],
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'cons_title_border',
            'selector' => '{{WRAPPER}} .oea-pros-cons .oea-cons .oea-cons-title',
        ] );
        $this->add_responsive_control( 'cons_border_radius', [
            'label'      => esc_html__( 'Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'px',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-cons .oea-cons-title' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_control( 'hr_cons_title_icon', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_control( 'show_cons_icon', [
            'label'        => esc_html__( 'Show Title Icon', 'orange-addons-for-elementor' ),
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => esc_html__( 'Show', 'orange-addons-for-elementor' ),
            'label_off'    => esc_html__( 'Hide', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'no',
        ] );
        $this->add_control( 'cons_title_icon', [
            'label'       => esc_html__( 'Icon', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::ICONS,
            'default'     => [
                'value'   => 'fas fa-circle',
                'library' => 'fa-solid',
            ],
            'recommended' => [
                'fa-solid'   => ['circle', 'dot-circle', 'square-full'],
                'fa-regular' => ['circle', 'dot-circle', 'square-full'],
            ],
            'condition'   => [
                'show_cons_icon' => 'yes',
            ],
        ] );
        $this->add_control( 'cons_title_icon_size', [
            'label'      => esc_html__( 'Icon Size', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'range'      => [
                'px'  => [
                    'min'  => 0,
                    'max'  => 100,
                    'step' => 1,
                ],
                'em'  => [
                    'min' => 0,
                    'max' => 10,
                ],
                'rem' => [
                    'min' => 0,
                    'max' => 10,
                ],
                '%'   => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default'    => [
                'unit' => 'px',
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-cons-title .oea-icon svg' => 'width: {{SIZE}}{{UNIT}};',
            ],
            'condition'  => [
                'show_cons_icon' => 'yes',
            ],
        ] );
        $this->add_control( 'hr_cons_block', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_responsive_control( 'cons_block_padding', [
            'label'      => esc_html__( 'Block Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pros-cons .oea-cons' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'cons_block_margin', [
            'label'      => esc_html__( 'Block Margin', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'rem',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pros-cons .oea-cons' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Background::get_type(), [
            'name'           => 'cons_block_background',
            'types'          => ['classic', 'gradient'],
            'selector'       => '{{WRAPPER}} .oea-pros-cons .oea-cons',
            'fields_options' => [
                'background' => [
                    'label' => esc_html__( 'Block Background', 'orange-addons-for-elementor' ),
                ],
                'image'      => [
                    'condition' => [
                        'show_image' => 'never',
                    ],
                ],
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'cons_block_border',
            'label'    => esc_html__( 'Block Border', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .oea-pros-cons .oea-cons',
        ] );
        $this->add_responsive_control( 'cons_block_radius', [
            'label'      => esc_html__( 'Block Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [
                'px',
                '%',
                'em',
                'rem'
            ],
            'default'    => [
                'unit'     => 'px',
                'isLinked' => true,
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pros-cons .oea-cons' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_control( 'hr_cons_item', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_control( 'cons_item_icon', [
            'label'       => esc_html__( 'List Item Icon', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::ICONS,
            'default'     => [
                'value'   => 'fas fa-minus',
                'library' => 'fa-solid',
            ],
            'recommended' => [
                'fa-solid' => [
                    'minus',
                    'arrow-alt-circle-down',
                    'angry',
                    'times',
                    'thumbs-down'
                ],
            ],
        ] );
        $this->add_control( 'cons_item_icon_color', [
            'label'     => esc_html__( 'Icon Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .oea-cons li svg' => 'fill: {{VALUE}}',
            ],
        ] );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $list_type_class = ( $settings['list_type'] === 'ol' ? 'ol-list' : '' );
        ?>

        <div class="oea-pros-cons">
            <div class="oea-pros">
                <div class="oea-pros-title">
                    <?php 
        if ( $settings['show_pros_icon'] === 'yes' ) {
            ?>
                        <span class="oea-icon">
                            <?php 
            \Elementor\Icons_Manager::render_icon( $settings['pros_title_icon'], [
                'aria-hidden' => 'true',
            ] );
            ?>
                        </span>
                    <?php 
        }
        ?>
                    <?php 
        echo esc_attr( $settings['pros_title'] );
        ?>
                </div>
                <<?php 
        echo esc_attr( $settings['list_type'] );
        ?>>
                    <?php 
        if ( $settings['pros_list'] ) {
            foreach ( $settings['pros_list'] as $item ) {
                ?>
                            <li class="<?php 
                echo esc_attr( $list_type_class );
                ?>">
                                <span class="oea-icon <?php 
                echo esc_attr( $list_type_class );
                ?>">
                                    <?php 
                \Elementor\Icons_Manager::render_icon( $settings['pros_item_icon'], [
                    'aria-hidden' => 'true',
                ] );
                ?>
                                </span>
                                <<?php 
                echo esc_attr( $settings['title_html_tag'] );
                ?>><?php 
                echo esc_attr( $item['pros_item_title'] );
                ?>
                                </<?php 
                echo esc_attr( $settings['title_html_tag'] );
                ?>>
                            </li>
                            <?php 
                ?>
                            <?php 
            }
        }
        ?>
                </<?php 
        echo esc_attr( $settings['list_type'] );
        ?>>
            </div>
            <div class="oea-cons">
                <div class="oea-cons-title"><?php 
        if ( $settings['show_cons_icon'] === 'yes' ) {
            ?>
                        <span class="oea-icon">
                            <?php 
            \Elementor\Icons_Manager::render_icon( $settings['cons_title_icon'], [
                'aria-hidden' => 'true',
            ] );
            ?>
                        </span>
                    <?php 
        }
        ?>
                    <?php 
        echo esc_attr( $settings['cons_title'] );
        ?>
                </div>
                <<?php 
        echo esc_attr( $settings['list_type'] );
        ?>>
                    <?php 
        if ( $settings['cons_list'] ) {
            foreach ( $settings['cons_list'] as $item ) {
                ?>
                            <li class="<?php 
                echo esc_attr( $list_type_class );
                ?>">
                                <span class="oea-icon <?php 
                echo esc_attr( $list_type_class );
                ?>">
                                    <?php 
                \Elementor\Icons_Manager::render_icon( $settings['cons_item_icon'], [
                    'aria-hidden' => 'true',
                ] );
                ?>
                                </span>
                                <<?php 
                echo esc_attr( $settings['title_html_tag'] );
                ?>><?php 
                echo esc_attr( $item['cons_item_title'] );
                ?></<?php 
                echo esc_attr( $settings['title_html_tag'] );
                ?>>
                            </li>
                            <?php 
                ?>
                            <?php 
            }
        }
        ?>
                </<?php 
        echo esc_attr( $settings['list_type'] );
        ?>>
            </div>
        </div>

        <?php 
    }

}
