<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Oradel_Pricing_Plans_Widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'oradel_pricing_plans';
    }

    public function get_title()
    {
        return __('Pricing Plans', 'orange-addons-for-elementor');
    }

    public function get_icon()
    {
        return 'eicon-price-table';
    }

    public function get_categories()
    {
        return ['oradel-plugin'];
    }

    public function get_custom_help_url()
    {
        return 'https://orange-addons.com/docs/';
    }

    public function get_style_depends()
    {
        return ['oea-pricing'];
    }

    public function get_script_depends()
    {
        return ['oea-pricing-toggle', 'oea-mobile-pricing-slider'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_title',
            [
                'label' => __('Title', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Pricing Plans', 'orange-addons-for-elementor'),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_toggle_settings',
            [
                'label' => __('Toggle Settings', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_pricing_toggle',
            [
                'label' => __('Show Pricing Toggle', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'orange-addons-for-elementor'),
                'label_off' => __('No', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'default_pricing',
            [
                'label' => __('Default Pricing', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'yearly',
                'options' => [
                    'yearly' => __('Yearly', 'orange-addons-for-elementor'),
                    'lifetime' => __('Lifetime', 'orange-addons-for-elementor'),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_pricing',
            [
                'label' => __('Pricing Plans', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'plan_title',
            [
                'label' => __('Plan Title', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Starter', 'orange-addons-for-elementor'),
            ]
        );

        $repeater->add_control(
            'yearly_price',
            [
                'label' => __('Yearly Price', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '$19/year',
            ]
        );

        $repeater->add_control(
            'lifetime_price',
            [
                'label' => __('Lifetime Price', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '$99',
            ]
        );

        $repeater->add_control(
            'features',
            [
                'label' => __('Features', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => "5 Premium Widgets\nEmail Support\n1 Site License",
                'description' => __('Enter each feature on a new line', 'orange-addons-for-elementor'),
            ]
        );

        $repeater->add_control(
            'highlight',
            [
                'label' => __('Highlight Plan', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
            ]
        );

        $repeater->add_control(
            'button_text',
            [
                'label' => __('Button Text', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Choose Plan', 'orange-addons-for-elementor'),
            ]
        );

        $repeater->add_control(
            'yearly_button_link',
            [
                'label' => __('Yearly Button Link', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => ['url' => '#'],
            ]
        );

        $repeater->add_control(
            'lifetime_button_link',
            [
                'label' => __('Lifetime Button Link', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => ['url' => '#'],
            ]
        );

        $this->add_control(
            'pricing_plans',
            [
                'label' => __('Pricing Plans', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'plan_title' => __('Starter', 'orange-addons-for-elementor'),
                        'yearly_price' => '$19/year',
                        'lifetime_price' => '$99',
                        'features' => "5 Premium Widgets\nEmail Support (Business Hours)\n1 Site License",
                    ],
                    [
                        'plan_title' => __('Pro', 'orange-addons-for-elementor'),
                        'yearly_price' => '$49/year',
                        'lifetime_price' => '$199',
                        'features' => "15 Premium Widgets\nPriority Email Support\n5 Site Licenses",
                        'highlight' => 'yes',
                    ],
                    [
                        'plan_title' => __('Elite', 'orange-addons-for-elementor'),
                        'yearly_price' => '$89/year',
                        'lifetime_price' => '$299',
                        'features' => "All Premium Widgets\n24/7 Premium Support\nUnlimited Site Licenses",
                    ],
                ],
                'title_field' => '{{{ plan_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_header_style',
            [
                'label' => __('Section Header', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'section_title_color',
            [
                'label' => __('Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333333',
                'selectors' => [
                    '{{WRAPPER}} #pricing h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'section_title_typography',
                'selector' => '{{WRAPPER}} #pricing h2',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'toggle_style',
            [
                'label' => __('Toggle Container', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'toggle_background',
            [
                'label' => __('Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#f1f1f1',
                'selectors' => [
                    '{{WRAPPER}} .toggle-container' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'toggle_border',
                'selector' => '{{WRAPPER}} .toggle-container',
            ]
        );

        $this->add_control(
            'toggle_border_radius',
            [
                'label' => __('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => '30',
                    'right' => '30',
                    'bottom' => '30',
                    'left' => '30',
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .toggle-container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'toggle_shadow',
                'selector' => '{{WRAPPER}} .toggle-container',
            ]
        );

        $this->start_controls_tabs('toggle_button_styles');

        $this->start_controls_tab(
            'toggle_button_normal',
            ['label' => __('Normal', 'orange-addons-for-elementor')]
        );

        $this->add_control(
            'toggle_button_color',
            [
                'label' => __('Text Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#666666',
                'selectors' => [
                    '{{WRAPPER}} .toggle-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'toggle_button_background',
            [
                'label' => __('Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'transparent',
                'selectors' => [
                    '{{WRAPPER}} .toggle-btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'toggle_button_border',
                'selector' => '{{WRAPPER}} .toggle-btn',
            ]
        );

        $this->add_control(
            'toggle_button_radius',
            [
                'label' => __('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .toggle-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'toggle_button_hover',
            ['label' => __('Hover', 'orange-addons-for-elementor')]
        );

        $this->add_control(
            'toggle_button_hover_color',
            [
                'label' => __('Text Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .toggle-btn:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'toggle_button_hover_background',
            [
                'label' => __('Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .toggle-btn:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'toggle_button_hover_border',
                'selector' => '{{WRAPPER}} .toggle-btn:hover',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'toggle_button_active',
            ['label' => __('Active', 'orange-addons-for-elementor')]
        );

        $this->add_control(
            'toggle_button_active_color',
            [
                'label' => __('Text Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .toggle-btn.active' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'toggle_button_active_background',
            [
                'label' => __('Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .toggle-slider' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'toggle_button_active_border',
                'selector' => '{{WRAPPER}} .toggle-btn.active',
            ]
        );

        $this->add_control(
            'toggle_button_active_radius',
            [
                'label' => __('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .toggle-btn.active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'price_card_style',
            [
                'label' => __('Price Card', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('price_card_styles');

        $this->start_controls_tab(
            'price_card_normal',
            ['label' => __('Normal', 'orange-addons-for-elementor')]
        );

        $this->add_control(
            'card_background',
            [
                'label' => __('Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .price-card' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'card_border',
                'selector' => '{{WRAPPER}} .price-card',
            ]
        );

        $this->add_control(
            'card_border_radius',
            [
                'label' => __('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .price-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'card_box_shadow',
                'selector' => '{{WRAPPER}} .price-card',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'price_card_hover',
            ['label' => __('Hover', 'orange-addons-for-elementor')]
        );

        $this->add_control(
            'card_background_hover',
            [
                'label' => __('Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price-card:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'card_border_hover',
                'selector' => '{{WRAPPER}} .price-card:hover',
            ]
        );

        $this->add_control(
            'card_border_radius_hover',
            [
                'label' => __('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .price-card:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'card_box_shadow_hover',
                'selector' => '{{WRAPPER}} .price-card:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'plan_title_heading',
            [
                'label' => __('Plan Title', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'plan_title_color',
            [
                'label' => __('Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price-card h3' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'plan_title_typography',
                'selector' => '{{WRAPPER}} .price-card h3',
            ]
        );

        $this->add_control(
            'price_heading',
            [
                'label' => __('Price', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'price_color',
            [
                'label' => __('Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price-card .price' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'price_typography',
                'selector' => '{{WRAPPER}} .price-card .price',
            ]
        );

        $this->add_control(
            'features_heading',
            [
                'label' => __('Features', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'features_color',
            [
                'label' => __('Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price-card ul li' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'features_typography',
                'selector' => '{{WRAPPER}} .price-card ul li',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'button_style',
            [
                'label' => __('Button', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'button_animation',
            [
                'label' => __('Enable Pulse Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'orange-addons-for-elementor'),
                'label_off' => __('No', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
                'prefix_class' => 'pulse-button-',
            ]
        );

        $this->start_controls_tabs('button_styles');

        $this->start_controls_tab(
            'button_normal',
            ['label' => __('Normal', 'orange-addons-for-elementor')]
        );

        $this->add_control(
            'button_text_color',
            [
                'label' => __('Text Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .price-card .btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_background_color',
            [
                'label' => __('Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff8800',
                'selectors' => [
                    '{{WRAPPER}} .price-card .btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .price-card .btn',
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => __('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .price-card .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_box_shadow',
                'selector' => '{{WRAPPER}} .price-card .btn',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_hover',
            ['label' => __('Hover', 'orange-addons-for-elementor')]
        );

        $this->add_control(
            'button_hover_text_color',
            [
                'label' => __('Text Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price-card .btn:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_hover_background_color',
            [
                'label' => __('Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price-card .btn:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'button_hover_border',
                'selector' => '{{WRAPPER}} .price-card .btn:hover',
            ]
        );

        $this->add_control(
            'button_hover_border_radius',
            [
                'label' => __('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .price-card .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_hover_box_shadow',
                'selector' => '{{WRAPPER}} .price-card .btn:hover',
            ]
        );

        $this->add_control(
            'button_hover_scale',
            [
                'label' => __('Hover Scale', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 2,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'size' => 1.05,
                ],
                'selectors' => [
                    '{{WRAPPER}} .price-card .btn:hover' => 'transform: scale({{SIZE}});',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'section_spacing_settings',
            [
                'label' => __('Spacing & Transitions', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'transition_duration',
            [
                'label' => __('Transition Duration', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0.1,
                        'max' => 2,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'size' => 0.3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .price-card' => 'transition: all {{SIZE}}s ease-in-out;',
                    '{{WRAPPER}} .price-card .btn' => 'transition: all {{SIZE}}s ease-in-out;',
                    '{{WRAPPER}} .toggle-btn' => 'transition: all {{SIZE}}s ease-in-out;',
                    '{{WRAPPER}} .toggle-slider' => 'transition: all {{SIZE}}s ease-in-out;',
                ],
            ]
        );

        $this->add_responsive_control(
            'section_padding',
            [
                'label' => __('Section Padding', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'separator' => 'before',
                'selectors' => [
                    '{{WRAPPER}} #pricing' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'section_title_margin',
            [
                'label' => __('Title Margin', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} #pricing h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'toggle_container_margin',
            [
                'label' => __('Toggle Container Margin', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .toggle-container' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'price_card_padding',
            [
                'label' => __('Card Padding', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .price-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'price_card_margin',
            [
                'label' => __('Card Margin', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .price-card' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'plan_title_margin',
            [
                'label' => __('Plan Title Margin', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .price-card h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'price_margin',
            [
                'label' => __('Price Margin', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .price-card .price' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'features_list_margin',
            [
                'label' => __('Features List Margin', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .price-card ul' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'features_item_margin',
            [
                'label' => __('Features Item Margin', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .price-card ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_margin',
            [
                'label' => __('Button Margin', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .price-card .btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => __('Button Padding', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .price-card .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'highlight_card_settings',
            [
                'label' => __('Highlight Card', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('highlight_card_styles');

        $this->start_controls_tab(
            'highlight_card_normal',
            ['label' => __('Normal', 'orange-addons-for-elementor')]
        );

        $this->add_control(
            'highlight_card_background',
            [
                'label' => __('Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price-card.highlight' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'highlight_card_border',
                'label' => __('Border', 'orange-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .price-card.highlight',
            ]
        );

        $this->add_control(
            'highlight_card_border_radius',
            [
                'label' => __('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .price-card.highlight' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'highlight_card_shadow',
                'selector' => '{{WRAPPER}} .price-card.highlight',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'highlight_card_hover',
            ['label' => __('Hover', 'orange-addons-for-elementor')]
        );

        $this->add_control(
            'highlight_card_background_hover',
            [
                'label' => __('Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price-card.highlight:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'highlight_card_border_hover',
                'label' => __('Border', 'orange-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .price-card.highlight:hover',
            ]
        );

        $this->add_control(
            'highlight_card_border_radius_hover',
            [
                'label' => __('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .price-card.highlight:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'highlight_card_shadow_hover',
                'selector' => '{{WRAPPER}} .price-card.highlight:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'highlight_card_animation',
            [
                'label' => __('Enable Pulse Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'orange-addons-for-elementor'),
                'label_off' => __('No', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'highlight_card_scale',
            [
                'label' => __('Scale', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 1.5,
                        'step' => 0.05,
                    ],
                ],
                'default' => [
                    'size' => 1.05,
                ],
                'selectors' => [
                    '{{WRAPPER}} .price-card.highlight:not(.pulse)' => 'transform: scale({{SIZE}}) !important;',
                    '{{WRAPPER}} .price-card.highlight:not(.pulse):hover' => 'transform: scale({{SIZE}}) !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'highlight_card_padding',
            [
                'label' => __('Padding', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .price-card.highlight' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'highlight_card_margin',
            [
                'label' => __('Margin', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .price-card.highlight' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $show_toggle = $settings['show_pricing_toggle'] === 'yes';
        $default_pricing = $settings['default_pricing'];
        ?>
                <section id="pricing" class="section">
                    <div class="container">
                        <h2><?php echo esc_html($settings['title']); ?></h2>

                        <?php if ($show_toggle): ?>
                                <div class="pricing-toggle">
                                    <div class="toggle-container <?php echo $default_pricing === 'lifetime' ? 'active-lifetime' : ''; ?>">
                                        <button class="toggle-btn active" data-period="yearly">Yearly</button>
                                        <button class="toggle-btn" data-period="lifetime">Lifetime</button>
                                        <div class="toggle-slider"></div>
                                    </div>
                                </div>
                        <?php endif; ?>

                        <div class="pricing-grid" data-default-period="<?php echo esc_attr($default_pricing); ?>">
                            <?php foreach ($settings['pricing_plans'] as $index => $plan): ?>
                                    <div class="price-card <?php
                                    echo $plan['highlight'] === 'yes' ? 'highlight' : '';
                                    echo $plan['highlight'] === 'yes' && $settings['highlight_card_animation'] === 'yes' ? ' pulse' : '';
                                    ?>" style="animation-delay: <?php echo esc_attr(0.1 * ($index + 1)); ?>s;">
                                        <h3><?php echo esc_html($plan['plan_title']); ?></h3>
                                        <p class="price" data-yearly="<?php echo esc_attr($plan['yearly_price']); ?>"
                                            data-lifetime="<?php echo esc_attr($plan['lifetime_price']); ?>">
                                            <?php echo esc_html($default_pricing === 'yearly' ? $plan['yearly_price'] : $plan['lifetime_price']); ?>
                                        </p>
                                        <ul>
                                            <?php
                                            $features = explode("\n", $plan['features']);
                                            foreach ($features as $feature):
                                                if (trim($feature)):
                                                    ?>
                                                            <li><?php echo esc_html(trim($feature)); ?></li>
                                                    <?php endif;
                                            endforeach; ?>
                                        </ul>
                                        <?php
                                        $current_link = $default_pricing === 'yearly' ? $plan['yearly_button_link'] : $plan['lifetime_button_link'];
                                        $link_attrs = '';

                                        if (!empty($current_link['url'])) {
                                            if ($current_link['is_external']) {
                                                $link_attrs .= ' target="_blank"';
                                            }
                                            if ($current_link['nofollow']) {
                                                $link_attrs .= ' rel="nofollow"';
                                            }
                                            if (!empty($current_link['custom_attributes'])) {
                                                $custom_attrs = explode(',', $current_link['custom_attributes']);
                                                foreach ($custom_attrs as $attr) {
                                                    $attr = trim($attr);
                                                    if (!empty($attr)) {
                                                        $link_attrs .= ' ' . esc_attr($attr);
                                                    }
                                                }
                                            }
                                        }
                                        ?>
                                        <a href="<?php echo esc_url($current_link['url']); ?>"
                                            class="btn price-button <?php echo $settings['button_animation'] === 'yes' ? ' animated' : ''; ?>"<?php echo wp_kses_post($link_attrs); ?>
                                            <?php if ($show_toggle): ?>
                                                    data-yearly-url="<?php echo esc_url($plan['yearly_button_link']['url']); ?>"
                                                    data-yearly-target="<?php echo $plan['yearly_button_link']['is_external'] ? '_blank' : ''; ?>"
                                                    data-yearly-rel="<?php echo $plan['yearly_button_link']['nofollow'] ? 'nofollow' : ''; ?>"
                                                    data-lifetime-url="<?php echo esc_url($plan['lifetime_button_link']['url']); ?>"
                                                    data-lifetime-target="<?php echo $plan['lifetime_button_link']['is_external'] ? '_blank' : ''; ?>"
                                                    data-lifetime-rel="<?php echo $plan['lifetime_button_link']['nofollow'] ? 'nofollow' : ''; ?>" <?php endif; ?>>
                                            <?php echo esc_html($plan['button_text']); ?>
                                        </a>
                                    </div>
                            <?php endforeach; ?>
                        </div>
                        <?php if (count($settings['pricing_plans']) > 1): ?>
                                <div class="pricing-navigation">
                                    <button class="pricing-prev" aria-label="Previous plan">
                                        <i class="fas fa-chevron-left"></i>
                                    </button>
                                    <div class="pricing-dots">
                                        <?php foreach ($settings['pricing_plans'] as $index => $plan): ?>
                                                <div class="pricing-dot <?php echo $index === 0 ? 'active' : ''; ?>"
                                                    data-index="<?php echo esc_attr($index); ?>">
                                                </div>
                                        <?php endforeach; ?>
                                    </div>
                                    <button class="pricing-next" aria-label="Next plan">
                                        <i class="fas fa-chevron-right"></i>
                                    </button>
                                </div>
                        <?php endif; ?>
                    </div>
                </section>
                <?php
    }
}