<?php

if ( !defined( 'ABSPATH' ) ) {
    exit;
    // Exit if accessed directly.
}
require_once ORADEL_PATH . 'includes/helpers.php';
class Oradel_Posts_Grid_Widget extends \Elementor\Widget_Base {
    public static function get_premium_options_for_styling() {
        return [
            'pagination_type'         => ['infinite_scroll'],
            'post_hover_effect'       => [
                'pulse',
                'bounce',
                'flash',
                'expand_contract',
                'shake',
                'zoom_rotate',
                'hover',
                'wave',
                'zoom_fade',
                'circle_shake',
                'slide_up_fade',
                'stretch_vertical',
                'stretch_horizontal',
                'zigzag',
                'whirl',
                'shine'
            ],
            'pagination_hover_effect' => [
                'tilt',
                'pulse',
                'flash',
                'bounce',
                'shake',
                'wave'
            ],
        ];
    }

    public function get_name() {
        return 'oradel_posts_grid';
    }

    public function get_title() {
        return esc_html__( 'Posts Grid', 'orange-addons-for-elementor' );
    }

    public function get_icon() {
        return 'eicon-posts-grid';
    }

    public function get_categories() {
        return ['oradel-plugin'];
    }

    public function get_keywords() {
        return ['posts grid'];
    }

    public function get_custom_help_url() {
        return 'https://orange-addons.com/docs/';
    }

    public function get_style_depends() {
        return ['oea-posts-grid'];
    }

    public function get_script_depends() {
        return ['oea-post-grid', 'oea-taxonomy-menu', 'oea-scroll-animations'];
    }

    protected function oea_get_taxonomy_terms( $taxonomy ) {
        $terms = get_terms( [
            'taxonomy'   => $taxonomy,
            'hide_empty' => false,
        ] );
        $options = [];
        if ( !is_wp_error( $terms ) ) {
            foreach ( $terms as $term ) {
                $options[$term->term_id] = $term->name;
            }
        }
        return $options;
    }

    protected function oea_get_posts_by_type( $post_type ) {
        $posts = get_posts( [
            'post_type'      => $post_type,
            'posts_per_page' => -1,
            'post_status'    => 'publish',
        ] );
        $options = [];
        foreach ( $posts as $post ) {
            $options[$post->ID] = $post->post_title;
        }
        return $options;
    }

    protected function register_controls() {
        $this->start_controls_section( 'content_section', [
            'label' => esc_html__( 'Settings', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        ] );
        $this->add_control( 'post_skin', [
            'label'   => esc_html__( 'Select Post Skin', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'classic' => esc_html__( 'Classic', 'orange-addons-for-elementor' ),
                'cards'   => esc_html__( 'Cards', 'orange-addons-for-elementor' ),
                'list'    => esc_html__( 'List', 'orange-addons-for-elementor' ),
            ],
            'default' => 'classic',
        ] );
        $post_types = get_post_types( [
            'public'            => true,
            'show_in_nav_menus' => true,
        ], 'objects' );
        $post_type_options = [];
        $post_type_options = array_merge( $post_types, [
            'current_query' => esc_html__( 'Current Query', 'orange-addons-for-elementor' ),
        ] );
        foreach ( $post_types as $post_type ) {
            $post_type_options[$post_type->name] = $post_type->label;
        }
        $this->add_control( 'post_type', [
            'label'   => esc_html__( 'Post Type', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'post',
            'options' => $post_type_options,
        ] );
        $taxonomies = get_taxonomies( [], 'objects' );
        foreach ( $post_types as $post_type_key => $post_type_label ) {
            foreach ( $taxonomies as $taxonomy => $object ) {
                if ( !in_array( $post_type_key, $object->object_type ) ) {
                    continue;
                }
                $this->add_control( $taxonomy . '_ids', [
                    'label'       => $object->label,
                    'type'        => \Elementor\Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple'    => true,
                    'options'     => $this->oea_get_taxonomy_terms( $taxonomy ),
                    'condition'   => [
                        'post_type' => $post_type_key,
                    ],
                ] );
            }
            $this->add_control( $post_type_key . '_exclude_posts', [
                'label'       => __( 'Exclude', 'orange-addons-for-elementor' ),
                'type'        => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple'    => true,
                'options'     => $this->oea_get_posts_by_type( $post_type_key ),
                'condition'   => [
                    'post_type' => $post_type_key,
                ],
            ] );
        }
        $this->add_control( 'posts_per_page', [
            'label'   => __( 'Posts Per Page', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => 5,
        ] );
        $this->add_control( 'post_offset', [
            'label'       => esc_html__( 'Offset', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::NUMBER,
            'default'     => 0,
            'min'         => 0,
            'description' => esc_html__( 'Number of posts to skip at the beginning', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'no_posts_found_text', [
            'label'   => __( 'No Posts Found Text', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::TEXT,
            'default' => __( 'No posts found', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'hr_3', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_control( 'posts_order_by', [
            'label'   => esc_html__( 'Order By', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'date',
            'options' => [
                'date'          => esc_html__( 'Date', 'orange-addons-for-elementor' ),
                'title'         => esc_html__( 'Title', 'orange-addons-for-elementor' ),
                'comment_count' => esc_html__( 'Comment Count', 'orange-addons-for-elementor' ),
                'modified'      => esc_html__( 'Date Modified', 'orange-addons-for-elementor' ),
                'author'        => esc_html__( 'Author Name', 'orange-addons-for-elementor' ),
                'rand'          => esc_html__( 'Random', 'orange-addons-for-elementor' ),
            ],
        ] );
        $this->add_control( 'posts_order', [
            'label'   => esc_html__( 'Order', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'DESC',
            'options' => [
                'ASC'  => esc_html__( 'Ascending', 'orange-addons-for-elementor' ),
                'DESC' => esc_html__( 'Descending', 'orange-addons-for-elementor' ),
            ],
        ] );
        $this->add_control( 'exclude_no_image_posts', [
            'label'        => esc_html__( 'Exclude Posts Without Image', 'orange-addons-for-elementor' ),
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => esc_html__( 'Yes', 'orange-addons-for-elementor' ),
            'label_off'    => esc_html__( 'No', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'no',
        ] );
        $this->add_control( 'ignore_sticky_posts', [
            'label'        => __( 'Ignore Sticky Posts', 'orange-addons-for-elementor' ),
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => __( 'Yes', 'orange-addons-for-elementor' ),
            'label_off'    => __( 'No', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'yes',
        ] );
        $open_in_new_tab_config = apply_filters( 'oradel_open_in_new_tab_control_config', [
            'label'        => esc_html__( 'Open in New Tab', 'orange-addons-for-elementor' ) . ' <i class="eicon-pro-icon"></i>',
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => esc_html__( 'Yes', 'orange-addons-for-elementor' ),
            'label_off'    => esc_html__( 'No', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'no',
            'classes'      => 'elementor-control-disabled',
        ] );
        $this->add_control( 'open_in_new_tab', $open_in_new_tab_config );
        $premium_notice = apply_filters( 'oradel_open_in_new_tab_premium_notice', Oradel_Plugin_Helper::create_premium_notice( 
            /* translators: %s: Premium upgrade URL */
            __( 'This feature is available in the <a href="%s" target="_blank">Premium version</a>', 'orange-addons-for-elementor' ),
            'posts-grid',
            'info'
         ) );
        if ( $premium_notice !== null ) {
            $this->add_control( 'oea_premium_notice_open_in_new_tab', $premium_notice );
        }
        $lazy_loading_config = apply_filters( 'oradel_lazy_loading_control_config', [
            'label'        => esc_html__( 'Enable Lazy Loading', 'orange-addons-for-elementor' ) . ' <i class="eicon-pro-icon"></i>',
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => esc_html__( 'Yes', 'orange-addons-for-elementor' ),
            'label_off'    => esc_html__( 'No', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'no',
            'classes'      => 'elementor-control-disabled',
        ] );
        $this->add_control( 'lazy_loading', $lazy_loading_config );
        $premium_notice = apply_filters( 'oradel_lazy_loading_premium_notice', Oradel_Plugin_Helper::create_premium_notice( 
            /* translators: %s: Premium upgrade URL */
            __( 'This feature is available in the <a href="%s" target="_blank">Premium version</a>', 'orange-addons-for-elementor' ),
            'posts-grid',
            'info'
         ) );
        if ( $premium_notice !== null ) {
            $this->add_control( 'oea_premium_notice_lazy_loading', $premium_notice );
        }
        $this->end_controls_section();
        $this->start_controls_section( 'layout_section', [
            'label' => esc_html__( 'Layout', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        ] );
        $this->add_control( 'posts_per_row', [
            'label'   => __( 'Columns', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => 3,
        ] );
        $this->add_control( 'post_column_gap', [
            'label'      => esc_html__( 'Column Gap', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', 'rem', 'em'],
            'range'      => [
                'px'  => [
                    'min'  => 0,
                    'max'  => 200,
                    'step' => 1,
                ],
                'rem' => [
                    'min'  => 1,
                    'max'  => 30,
                    'step' => 0.5,
                ],
                'em'  => [
                    'min'  => 1,
                    'max'  => 30,
                    'step' => 0.5,
                ],
            ],
            'default'    => [
                'unit' => 'px',
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-post-grid' => 'column-gap: {{SIZE}}{{UNIT}};',
            ],
        ] );
        $this->add_control( 'post_row_gap', [
            'label'      => esc_html__( 'Row Gap', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', 'rem', 'em'],
            'range'      => [
                'px'  => [
                    'min'  => 0,
                    'max'  => 200,
                    'step' => 1,
                ],
                'rem' => [
                    'min'  => 1,
                    'max'  => 30,
                    'step' => 0.5,
                ],
                'em'  => [
                    'min'  => 1,
                    'max'  => 30,
                    'step' => 0.5,
                ],
            ],
            'default'    => [
                'unit' => 'px',
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-post-grid' => 'row-gap: {{SIZE}}{{UNIT}};',
            ],
        ] );
        $this->add_control( 'category_position', [
            'label'   => esc_html__( 'Category Position', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'bottom',
            'options' => [
                'top'    => esc_html__( 'On Image', 'orange-addons-for-elementor' ),
                'bottom' => esc_html__( 'After Image', 'orange-addons-for-elementor' ),
            ],
        ] );
        $this->add_control( 'categories_count', [
            'label'       => esc_html__( 'Categories Count', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::NUMBER,
            'default'     => 1,
            'min'         => 1,
            'max'         => 10,
            'description' => esc_html__( 'Number of categories to display if post has multiple categories', 'orange-addons-for-elementor' ),
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'image_settings_section', [
            'label' => esc_html__( 'Image', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'show_image', [
            'label'        => esc_html__( 'Show Image', 'orange-addons-for-elementor' ),
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => esc_html__( 'Show', 'orange-addons-for-elementor' ),
            'label_off'    => esc_html__( 'Hide', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'yes',
        ] );
        $this->add_control( 'image_size', [
            'label'   => __( 'Image Size', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'full',
            'options' => $this->get_image_sizes(),
        ] );
        $this->add_responsive_control( 'image_height', [
            'label'      => esc_html__( 'Image Height', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [
                'px',
                '%',
                'rem',
                'em'
            ],
            'range'      => [
                'px'  => [
                    'min'  => 50,
                    'max'  => 800,
                    'step' => 10,
                ],
                '%'   => [
                    'min' => 10,
                    'max' => 100,
                ],
                'rem' => [
                    'min'  => 1,
                    'max'  => 50,
                    'step' => 0.5,
                ],
                'em'  => [
                    'min'  => 1,
                    'max'  => 50,
                    'step' => 0.5,
                ],
            ],
            'default'    => [
                'unit' => 'px',
            ],
            'selectors'  => [
                '{{WRAPPER}} .post .post-image-wrapper' => 'height: {{SIZE}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'post_elements_section', [
            'label' => esc_html__( 'Post Elements Order', 'orange-addons-for-elementor' ),
        ] );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control( 'element_type', [
            'label'       => esc_html__( 'Element Type', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::SELECT,
            'options'     => [
                'title'     => esc_html__( 'Title', 'orange-addons-for-elementor' ),
                'category'  => esc_html__( 'Category', 'orange-addons-for-elementor' ),
                'author'    => esc_html__( 'Author', 'orange-addons-for-elementor' ),
                'date'      => esc_html__( 'Date', 'orange-addons-for-elementor' ),
                'comments'  => esc_html__( 'Comments', 'orange-addons-for-elementor' ),
                'excerpt'   => esc_html__( 'Excerpt', 'orange-addons-for-elementor' ),
                'read_more' => esc_html__( 'Read More', 'orange-addons-for-elementor' ),
            ],
            'default'     => 'title',
            'label_block' => true,
        ] );
        $repeater->add_control( 'read_more_text', [
            'label'       => esc_html__( 'Text', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => esc_html__( 'Read more', 'orange-addons-for-elementor' ),
            'condition'   => [
                'element_type' => 'read_more',
            ],
            'label_block' => true,
        ] );
        $repeater->add_control( 'title_tag', [
            'label'       => esc_html__( 'HTML Tag for Title', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::SELECT,
            'options'     => [
                'h2'   => esc_html__( 'H2', 'orange-addons-for-elementor' ),
                'h3'   => esc_html__( 'H3', 'orange-addons-for-elementor' ),
                'h4'   => esc_html__( 'H4', 'orange-addons-for-elementor' ),
                'h5'   => esc_html__( 'H5', 'orange-addons-for-elementor' ),
                'h6'   => esc_html__( 'H6', 'orange-addons-for-elementor' ),
                'p'    => esc_html__( 'Paragraph', 'orange-addons-for-elementor' ),
                'div'  => esc_html__( 'Div', 'orange-addons-for-elementor' ),
                'span' => esc_html__( 'Span', 'orange-addons-for-elementor' ),
            ],
            'default'     => 'h2',
            'condition'   => [
                'element_type' => 'title',
            ],
            'label_block' => true,
        ] );
        $repeater->add_control( 'title_lines', [
            'label'     => __( 'Title Lines', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::NUMBER,
            'min'       => 1,
            'max'       => 5,
            'selectors' => [
                '{{WRAPPER}} .oea-post-grid .post-title' => '-webkit-line-clamp: {{UNIT}};',
            ],
            'condition' => [
                'element_type' => 'title',
            ],
        ] );
        $repeater->add_control( 'excerpt_lines', [
            'label'     => __( 'Excerpt Lines', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::NUMBER,
            'default'   => 3,
            'min'       => 1,
            'max'       => 20,
            'selectors' => [
                '{{WRAPPER}} .oea-post-grid .post-excerpt' => '-webkit-line-clamp: {{UNIT}};',
            ],
            'condition' => [
                'element_type' => 'excerpt',
            ],
        ] );
        $repeater->add_control( 'hide_on_devices', [
            'label'       => esc_html__( 'Hide on Devices', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::SELECT2,
            'multiple'    => true,
            'options'     => [
                'desktop' => esc_html__( 'Desktop', 'orange-addons-for-elementor' ),
                'tablet'  => esc_html__( 'Tablet', 'orange-addons-for-elementor' ),
                'mobile'  => esc_html__( 'Mobile', 'orange-addons-for-elementor' ),
            ],
            'label_block' => true,
            'description' => esc_html__( 'Choose devices where this element should be hidden.', 'orange-addons-for-elementor' ),
        ] );
        $repeater->add_control( 'text_before_author', [
            'label'       => esc_html__( 'Text Before Author', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => esc_html__( 'By ', 'orange-addons-for-elementor' ),
            'condition'   => [
                'element_type' => 'author',
            ],
            'label_block' => true,
        ] );
        $repeater->add_control( 'author_icon_enabled', [
            'label'        => __( 'Enable Author Icon', 'orange-addons-for-elementor' ),
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => __( 'Yes', 'orange-addons-for-elementor' ),
            'label_off'    => __( 'No', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'no',
            'condition'    => [
                'element_type' => 'author',
            ],
        ] );
        $repeater->add_control( 'author_link_enabled', [
            'label'        => __( 'Enable Author Link', 'orange-addons-for-elementor' ),
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => __( 'Yes', 'orange-addons-for-elementor' ),
            'label_off'    => __( 'No', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'no',
            'condition'    => [
                'element_type' => 'author',
            ],
        ] );
        $this->add_control( 'post_elements_order', [
            'label'       => esc_html__( 'Post Elements', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::REPEATER,
            'fields'      => $repeater->get_controls(),
            'default'     => [
                [
                    'element_type' => 'title',
                ],
                [
                    'element_type' => 'category',
                ],
                [
                    'element_type' => 'author',
                ],
                [
                    'element_type' => 'date',
                ],
                [
                    'element_type' => 'comments',
                ],
                [
                    'element_type' => 'excerpt',
                ]
            ],
            'title_field' => '{{{ element_type }}}',
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'filters_section', [
            'label' => esc_html__( 'Filters', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        ] );
        $this->add_control( 'filters_menu_type', [
            'label'       => __( 'Menu Type', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::SELECT,
            'options'     => [
                'without_heading' => __( 'Without Heading', 'orange-addons-for-elementor' ),
                'with_heading'    => __( 'With Heading', 'orange-addons-for-elementor' ),
            ],
            'default'     => 'without_heading',
            'description' => __( 'In the editor mode, the menu might not look correct as JavaScript does not refresh dynamically.', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'category_heading', [
            'label'       => __( 'Category Heading', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => __( 'News', 'orange-addons-for-elementor' ),
            'placeholder' => __( 'Enter category name', 'orange-addons-for-elementor' ),
            'condition'   => [
                'filters_menu_type' => 'with_heading',
            ],
        ] );
        $this->add_control( 'additional_menu_class', [
            'label'   => __( 'Menu Style', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => [
                ''        => __( 'Default', 'orange-addons-for-elementor' ),
                'classic' => __( 'Classic', 'orange-addons-for-elementor' ),
            ],
            'default' => '',
        ] );
        $this->add_control( 'menu_reversed', [
            'label'        => __( 'Menu Reversed', 'orange-addons-for-elementor' ),
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => __( 'Yes', 'orange-addons-for-elementor' ),
            'label_off'    => __( 'No', 'orange-addons-for-elementor' ),
            'return_value' => 'reversed',
            'default'      => '',
            'condition'    => [
                'filters_menu_type' => 'with_heading',
            ],
        ] );
        $this->add_control( 'show_term_menu', [
            'label'     => esc_html__( 'Show Filters', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SWITCHER,
            'label_on'  => esc_html__( 'Yes', 'orange-addons-for-elementor' ),
            'label_off' => esc_html__( 'No', 'orange-addons-for-elementor' ),
            'default'   => 'yes',
        ] );
        $this->add_control( 'taxonomy_type', [
            'label'   => esc_html__( 'Taxonomy Type', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => $this->oea_get_all_taxonomies(),
            'default' => 'category',
        ] );
        $this->add_control( 'hide_empty_taxonomies', [
            'label'       => esc_html__( 'Hide Empty Taxonomies', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::SWITCHER,
            'label_on'    => esc_html__( 'Yes', 'orange-addons-for-elementor' ),
            'label_off'   => esc_html__( 'No', 'orange-addons-for-elementor' ),
            'default'     => 'yes',
            'description' => esc_html__( 'Enable this option to hide empty taxonomy terms from the menu.', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'filters_align', [
            'label'     => esc_html__( 'Filters Alignment', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::CHOOSE,
            'options'   => [
                'left'   => [
                    'title' => esc_html__( 'Left', 'orange-addons-for-elementor' ),
                    'icon'  => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'orange-addons-for-elementor' ),
                    'icon'  => 'eicon-text-align-center',
                ],
                'right'  => [
                    'title' => esc_html__( 'Right', 'orange-addons-for-elementor' ),
                    'icon'  => 'eicon-text-align-right',
                ],
            ],
            'default'   => 'left',
            'toggle'    => true,
            'selectors' => [
                '{{WRAPPER}} .oea-taxonomy-menu' => 'justify-content: {{VALUE}};',
            ],
            'condition' => [
                'filters_menu_type' => 'without_heading',
            ],
        ] );
        $this->add_control( 'filters_first_tab', [
            'label'       => esc_html__( 'First Tab Label', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => esc_html__( 'All Posts', 'orange-addons-for-elementor' ),
            'placeholder' => esc_html__( 'Type your title here', 'orange-addons-for-elementor' ),
        ] );
        $show_term_count_config = apply_filters( 'oradel_show_term_count_control_config', [
            'label'        => esc_html__( 'Show Term Count', 'orange-addons-for-elementor' ) . ' <i class="eicon-pro-icon"></i>',
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => esc_html__( 'Yes', 'orange-addons-for-elementor' ),
            'label_off'    => esc_html__( 'No', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'no',
            'classes'      => 'elementor-control-disabled',
        ] );
        $this->add_control( 'show_term_count', $show_term_count_config );
        $premium_notice = apply_filters( 'oradel_show_term_count_premium_notice', Oradel_Plugin_Helper::create_premium_notice( 
            /* translators: %s: Premium upgrade URL */
            __( 'This feature is available in the <a href="%s" target="_blank">Premium version</a>', 'orange-addons-for-elementor' ),
            'posts-grid',
            'info'
         ) );
        if ( $premium_notice !== null ) {
            $this->add_control( 'oea_premium_notice_show_term_count', $premium_notice );
        }
        $this->end_controls_section();
        $this->start_controls_section( 'pagination_section', [
            'label' => esc_html__( 'Pagination', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        ] );
        $this->add_control( 'enable_pagination', [
            'label'        => __( 'Enable Pagination', 'orange-addons-for-elementor' ),
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => __( 'Yes', 'orange-addons-for-elementor' ),
            'label_off'    => __( 'No', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'yes',
        ] );
        $pagination_type_options = apply_filters( 'oradel_pagination_type_options', [
            'simple'          => esc_html__( 'Simple Pagination', 'orange-addons-for-elementor' ),
            'numbers'         => esc_html__( 'Numbered', 'orange-addons-for-elementor' ),
            'load_more'       => esc_html__( 'Load More Button', 'orange-addons-for-elementor' ),
            'infinite_scroll' => esc_html__( 'Infinite Scroll', 'orange-addons-for-elementor' ) . ' (Premium)',
        ] );
        $this->add_control( 'pagination_type', [
            'label'   => esc_html__( 'Pagination Type', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'simple',
            'options' => $pagination_type_options,
        ] );
        $premium_notice = apply_filters( 'oradel_pagination_type_premium_notice', array_merge( Oradel_Plugin_Helper::create_premium_notice( 
            /* translators: %s: Premium upgrade URL */
            __( 'Infinite Scroll is available in the <a href="%s" target="_blank">Premium version</a>', 'orange-addons-for-elementor' ),
            'posts-grid',
            'info'
         ), [
            'condition' => [
                'pagination_type' => 'infinite_scroll',
            ],
        ] ) );
        if ( $premium_notice !== null ) {
            $this->add_control( 'oea_premium_pagination_type_notice', $premium_notice );
        }
        $this->add_control( 'simple_pagination_alignment', [
            'label'     => __( 'Pagination Alignment', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SELECT,
            'options'   => [
                'center'        => __( 'Center', 'orange-addons-for-elementor' ),
                'left'          => __( 'Left', 'orange-addons-for-elementor' ),
                'right'         => __( 'Right', 'orange-addons-for-elementor' ),
                'space-between' => __( 'Space Between', 'orange-addons-for-elementor' ),
            ],
            'default'   => 'center',
            'condition' => [
                'pagination_type' => 'simple',
            ],
        ] );
        $this->add_control( 'numbered_pagination_alignment', [
            'label'     => esc_html__( 'Pagination Alignment', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::CHOOSE,
            'options'   => [
                'left'   => [
                    'title' => esc_html__( 'Left', 'orange-addons-for-elementor' ),
                    'icon'  => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'orange-addons-for-elementor' ),
                    'icon'  => 'eicon-text-align-center',
                ],
                'right'  => [
                    'title' => esc_html__( 'Right', 'orange-addons-for-elementor' ),
                    'icon'  => 'eicon-text-align-right',
                ],
            ],
            'default'   => 'left',
            'toggle'    => true,
            'selectors' => [
                '{{WRAPPER}} .oea-pagination-numbers' => 'justify-content: {{VALUE}};',
            ],
            'condition' => [
                'pagination_type' => 'numbered',
            ],
        ] );
        $this->add_control( 'prev_button_text', [
            'label'       => __( 'Previous Button Text', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => __( 'Prev', 'orange-addons-for-elementor' ),
            'placeholder' => __( 'Enter Previous Button Text', 'orange-addons-for-elementor' ),
            'condition'   => [
                'pagination_type' => 'simple',
            ],
        ] );
        $this->add_control( 'prev_button_icon', [
            'label'     => __( 'Previous Button Icon', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::ICONS,
            'default'   => [
                'value'   => 'fas fa-arrow-left',
                'library' => 'fa-solid',
            ],
            'condition' => [
                'pagination_type' => 'simple',
            ],
        ] );
        $this->add_control( 'next_button_text', [
            'label'       => __( 'Next Button Text', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => __( 'Next', 'orange-addons-for-elementor' ),
            'placeholder' => __( 'Enter Next Button Text', 'orange-addons-for-elementor' ),
            'condition'   => [
                'pagination_type' => 'simple',
            ],
        ] );
        $this->add_control( 'next_button_icon', [
            'label'     => __( 'Next Button Icon', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::ICONS,
            'default'   => [
                'value'   => 'fas fa-arrow-right',
                'library' => 'fa-solid',
            ],
            'condition' => [
                'pagination_type' => 'simple',
            ],
        ] );
        $this->add_control( 'load_more_style', [
            'label'     => __( 'Load More Style', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SELECT,
            'options'   => [
                'classic'    => __( 'Classic Button', 'orange-addons-for-elementor' ),
                'full_width' => __( 'Full-Width Button', 'orange-addons-for-elementor' ),
            ],
            'default'   => 'classic',
            'condition' => [
                'pagination_type' => 'load_more',
            ],
        ] );
        $this->add_control( 'load_more_text', [
            'label'     => __( 'Load More Button Text', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::TEXT,
            'default'   => __( 'Load More', 'orange-addons-for-elementor' ),
            'condition' => [
                'pagination_type' => 'load_more',
            ],
        ] );
        $this->add_control( 'pagination_align', [
            'label'     => esc_html__( 'Pagination Alignment', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::CHOOSE,
            'options'   => [
                'left'   => [
                    'title' => esc_html__( 'Left', 'orange-addons-for-elementor' ),
                    'icon'  => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'orange-addons-for-elementor' ),
                    'icon'  => 'eicon-text-align-center',
                ],
                'right'  => [
                    'title' => esc_html__( 'Right', 'orange-addons-for-elementor' ),
                    'icon'  => 'eicon-text-align-right',
                ],
            ],
            'default'   => 'center',
            'toggle'    => true,
            'selectors' => [
                '{{WRAPPER}} .oea-load-more-wrapper'  => 'justify-content: {{VALUE}};',
                '{{WRAPPER}} .oea-pagination'         => 'justify-content: {{VALUE}};',
                '{{WRAPPER}} .oea-pagination-numbers' => 'justify-content: {{VALUE}};',
            ],
        ] );
        $this->add_control( 'loading_icon_color', [
            'label'     => esc_html__( 'Loading Icon Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .loading-icon div'                      => 'background-color: {{VALUE}}',
                '{{WRAPPER}} .oea-post-grid .loading-overlay::after' => 'border-top-color: {{VALUE}}',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_typography', [
            'label' => esc_html__( 'Typography', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'title_typography',
            'label'    => esc_html__( 'Title Typography', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .post-title',
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'category_typography',
            'label'    => esc_html__( 'Category Typography', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .post-category',
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'author_typography',
            'label'    => esc_html__( 'Author Typography', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .post-author span',
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'date_typography',
            'label'    => esc_html__( 'Date Typography', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .post-date span',
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'comments_typography',
            'label'    => esc_html__( 'Comments Typography', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .post-comments span',
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'read_more_typography',
            'label'    => esc_html__( 'Read More Typography', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .read-more',
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'excerpt_typography',
            'label'    => esc_html__( 'Excerpt Typography', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .post-excerpt',
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'filters_typography',
            'label'    => esc_html__( 'Filters Typography', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .taxonomy-menu-item',
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'filters_heading_typography',
            'label'    => esc_html__( 'Filters Heading Typography', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .oea-taxonomy-heading-text',
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'pagination_typography',
            'label'    => esc_html__( 'Pagination Typography', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .oea-pagination-numbers, {{WRAPPER}} .oea-pagination, {{WRAPPER}} .oea-load-more-wrapper .button-text',
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_colors', [
            'label' => esc_html__( 'Colors', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->start_controls_tabs( 'tabs_colors' );
        $this->start_controls_tab( 'tab_colors_normal', [
            'label' => esc_html__( 'Normal', 'orange-addons-for-elementor' ),
        ] );
        $normal_elements = [
            'title'               => '.post-title a',
            'category'            => '.post-category',
            'author'              => '.post-author span',
            'comments'            => '.post-comments span',
            'date'                => '.post-date span',
            'excerpt'             => '.post-excerpt',
            'read_more'           => '.read-more',
            'filters'             => '.taxonomy-menu-item',
            'filters_heading'     => '.oea-taxonomy-heading',
            'more_filters_button' => '.dropdown-toggle',
            'pagination'          => '.oea-pagination-numbers .oea-page-number, .oea-pagination .next-page-button,  .oea-pagination .prev-page-button, .oea-load-more-wrapper .button-text',
        ];
        $color_labels = [
            'title'               => esc_html__( 'Title Color', 'orange-addons-for-elementor' ),
            'category'            => esc_html__( 'Category Color', 'orange-addons-for-elementor' ),
            'author'              => esc_html__( 'Author Color', 'orange-addons-for-elementor' ),
            'comments'            => esc_html__( 'Comments Color', 'orange-addons-for-elementor' ),
            'date'                => esc_html__( 'Date Color', 'orange-addons-for-elementor' ),
            'excerpt'             => esc_html__( 'Excerpt Color', 'orange-addons-for-elementor' ),
            'read_more'           => esc_html__( 'Read More Color', 'orange-addons-for-elementor' ),
            'filters'             => esc_html__( 'Filters Color', 'orange-addons-for-elementor' ),
            'filters_heading'     => esc_html__( 'Filters Heading Color', 'orange-addons-for-elementor' ),
            'more_filters_button' => esc_html__( 'More Filters Button Color', 'orange-addons-for-elementor' ),
            'pagination'          => esc_html__( 'Pagination Color', 'orange-addons-for-elementor' ),
        ];
        foreach ( $normal_elements as $label => $selector ) {
            $this->add_control( "{$label}_color", [
                'label'     => ( isset( $color_labels[$label] ) ? $color_labels[$label] : esc_html__( 'Color', 'orange-addons-for-elementor' ) ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    "{{WRAPPER}} {$selector}" => 'color: {{VALUE}};',
                ],
            ] );
        }
        $this->add_control( 'hr', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_control( 'filters_bg_color', [
            'label'     => esc_html__( 'Filters Item Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .oea-taxonomy-menu .taxonomy-menu-item' => 'background: {{VALUE}}',
            ],
        ] );
        $this->add_control( 'taxonomy_heading_bg_color', [
            'label'     => esc_html__( 'Filters Heading Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .oea-taxonomy-heading' => 'background: {{VALUE}}',
            ],
        ] );
        $this->add_control( 'more_button_bg_color', [
            'label'     => esc_html__( 'More Button Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .oea-taxonomy-menu .dropdown-toggle' => 'background: {{VALUE}}',
            ],
        ] );
        $this->add_control( 'post_bg_color', [
            'label'     => esc_html__( 'Post Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .post' => 'background: {{VALUE}}',
            ],
        ] );
        $this->add_control( 'category_bg_color', [
            'label'     => esc_html__( 'Category Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .post .post-category' => 'background: {{VALUE}}',
            ],
        ] );
        $this->add_control( 'pagination_bg_color', [
            'label'     => esc_html__( 'Pagination Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .oea-pagination-numbers .oea-page-number, .oea-pagination .prev-page-button, .oea-pagination .next-page-button, .oea-load-more-wrapper .oea-load-more' => 'background-color: {{VALUE}} !important',
            ],
        ] );
        $this->end_controls_tab();
        $this->start_controls_tab( 'tab_colors_hover', [
            'label' => esc_html__( 'Hover', 'orange-addons-for-elementor' ),
        ] );
        $hover_elements = [
            'filters'             => '.taxonomy-menu-item:hover',
            'more_filters_button' => '.dropdown-toggle:hover',
            'pagination'          => '.oea-pagination-numbers .oea-page-number:hover,  .oea-pagination .next-page-button:hover,  .oea-pagination .prev-page-button:hover, .oea-load-more:hover .button-text',
            'title'               => '.post:hover:not(.no-touch-hover.touch-device .post:hover) .post-title a',
            'author'              => '.post:not(.no-touch-hover.touch-device .post) .post-author:hover span',
        ];
        $hover_color_labels = [
            'filters'             => esc_html__( 'Filters Color', 'orange-addons-for-elementor' ),
            'more_filters_button' => esc_html__( 'More Filters Button Color', 'orange-addons-for-elementor' ),
            'pagination'          => esc_html__( 'Pagination Color', 'orange-addons-for-elementor' ),
            'title'               => esc_html__( 'Title Color', 'orange-addons-for-elementor' ),
            'author'              => esc_html__( 'Author Color', 'orange-addons-for-elementor' ),
        ];
        foreach ( $hover_elements as $label => $selector ) {
            $this->add_control( "{$label}_hover_color", [
                'label'     => ( isset( $hover_color_labels[$label] ) ? $hover_color_labels[$label] : esc_html__( 'Color', 'orange-addons-for-elementor' ) ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    "{{WRAPPER}} {$selector}" => 'color: {{VALUE}};',
                ],
            ] );
        }
        $this->add_control( 'title_hover_transition', [
            'label'       => esc_html__( 'Title Hover Transition', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::SLIDER,
            'size_units'  => ['s', 'ms'],
            'range'       => [
                's'  => [
                    'min'  => 0,
                    'max'  => 3,
                    'step' => 0.1,
                ],
                'ms' => [
                    'min'  => 0,
                    'max'  => 3000,
                    'step' => 50,
                ],
            ],
            'default'     => [
                'unit' => 's',
                'size' => 0.3,
            ],
            'selectors'   => [
                '{{WRAPPER}} .post-title a' => 'transition: color {{SIZE}}{{UNIT}} ease;',
            ],
            'description' => esc_html__( 'Set the transition duration for the title color change on hover.', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'hr2', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_control( 'filters_bg_hover_color', [
            'label'     => esc_html__( 'Filters Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .oea-taxonomy-menu .taxonomy-menu-item:hover' => 'background: {{VALUE}}',
            ],
        ] );
        $this->add_control( 'more_button_bg_hover_color', [
            'label'     => esc_html__( 'More Button Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .oea-taxonomy-menu .dropdown-toggle:hover' => 'background: {{VALUE}}',
            ],
        ] );
        $this->add_control( 'post_bg_hover_color', [
            'label'     => esc_html__( 'Post Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .post:hover:not(.no-touch-hover.touch-device .post:hover)' => 'background: {{VALUE}}',
            ],
        ] );
        $this->add_control( 'pagination_bg_hover_color', [
            'label'     => esc_html__( 'Pagination Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .oea-pagination-numbers .oea-page-number:hover, .oea-load-more-wrapper .oea-load-more:hover, .oea-pagination .next-page-button:hover, .oea-pagination .prev-page-button:hover' => 'background-color: {{VALUE}} !important',
            ],
        ] );
        $this->end_controls_tab();
        $this->start_controls_tab( 'tab_colors_active', [
            'label' => esc_html__( 'Active', 'orange-addons-for-elementor' ),
        ] );
        $active_elements = [
            'filters'    => '.taxonomy-menu-item.active',
            'pagination' => '.oea-pagination-numbers .oea-page-number.active, .oea-pagination.active',
        ];
        $active_color_labels = [
            'filters'    => esc_html__( 'Filters Active Color', 'orange-addons-for-elementor' ),
            'pagination' => esc_html__( 'Pagination Active Color', 'orange-addons-for-elementor' ),
        ];
        foreach ( $active_elements as $label => $selector ) {
            $this->add_control( "{$label}_active_color", [
                'label'     => ( isset( $active_color_labels[$label] ) ? $active_color_labels[$label] : esc_html__( 'Active Color', 'orange-addons-for-elementor' ) ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    "{{WRAPPER}} {$selector}" => 'color: {{VALUE}};',
                ],
            ] );
        }
        $this->add_control( 'hr3', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_control( 'filters_bg_active_color', [
            'label'     => esc_html__( 'Filters Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .oea-taxonomy-menu .taxonomy-menu-item.active' => 'background-color: {{VALUE}} !important',
            ],
        ] );
        $this->add_control( 'pagination_bg_active_color', [
            'label'     => esc_html__( 'Pagination Background Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .oea-pagination-numbers .oea-page-number.active, .oea-pagination.active' => 'background-color: {{VALUE}} !important',
            ],
        ] );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section( 'section_post_styles', [
            'label' => esc_html__( 'Post Box', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->start_controls_tabs( 'tabs_post_styles' );
        $this->start_controls_tab( 'tab_post_normal', [
            'label' => esc_html__( 'Normal', 'orange-addons-for-elementor' ),
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'post_border',
            'label'    => esc_html__( 'Border', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .post',
        ] );
        $this->add_control( 'post_border_radius', [
            'label'      => esc_html__( 'Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors'  => [
                '{{WRAPPER}} .post' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), [
            'name'     => 'post_box_shadow',
            'label'    => esc_html__( 'Box Shadow', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .post',
        ] );
        $this->add_responsive_control( 'post_padding', [
            'label'      => esc_html__( 'Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors'  => [
                '{{WRAPPER}} .post' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_tab();
        $this->start_controls_tab( 'tab_post_hover', [
            'label' => esc_html__( 'Hover', 'orange-addons-for-elementor' ),
        ] );
        $this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), [
            'name'     => 'post_box_shadow_hover',
            'label'    => esc_html__( 'Box Shadow', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .post:hover:not(.no-touch-hover.touch-device .post:hover)',
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'post_border_hover',
            'label'    => esc_html__( 'Border', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .post:hover:not(.no-touch-hover.touch-device .post:hover)',
        ] );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control( 'hr4', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $hover_effect_options = apply_filters( 'oradel_post_hover_effect_options', [
            'none'               => __( 'None', 'orange-addons-for-elementor' ),
            'translate_up'       => __( 'Translate Up', 'orange-addons-for-elementor' ),
            'translate_down'     => __( 'Translate Down', 'orange-addons-for-elementor' ),
            'scale_up'           => __( 'Scale Up', 'orange-addons-for-elementor' ),
            'scale_down'         => __( 'Scale Down', 'orange-addons-for-elementor' ),
            'rotate'             => __( 'Rotate', 'orange-addons-for-elementor' ),
            'tilt'               => __( 'Tilt', 'orange-addons-for-elementor' ),
            'darken'             => __( 'Darken', 'orange-addons-for-elementor' ),
            'lighten'            => __( 'Lighten', 'orange-addons-for-elementor' ),
            'pulse'              => __( 'Pulse (Animation)', 'orange-addons-for-elementor' ) . ' (Premium)',
            'bounce'             => __( 'Bounce (Animation)', 'orange-addons-for-elementor' ) . ' (Premium)',
            'flash'              => __( 'Flash (Animation)', 'orange-addons-for-elementor' ) . ' (Premium)',
            'expand_contract'    => __( 'Expand and Contract (Animation)', 'orange-addons-for-elementor' ) . ' (Premium)',
            'shake'              => __( 'Shake (Animation)', 'orange-addons-for-elementor' ) . ' (Premium)',
            'zoom_rotate'        => __( 'Zoom and Rotate (Animation)', 'orange-addons-for-elementor' ) . ' (Premium)',
            'hover'              => __( 'Hover', 'orange-addons-for-elementor' ) . ' (Premium)',
            'wave'               => __( 'Wave (Animation)', 'orange-addons-for-elementor' ) . ' (Premium)',
            'zoom_fade'          => __( 'Zoom and Fade (Animation)', 'orange-addons-for-elementor' ) . ' (Premium)',
            'circle_shake'       => __( 'Circle Shake (Animation)', 'orange-addons-for-elementor' ) . ' (Premium)',
            'slide_up_fade'      => __( 'Slide Up and Fade (Animation)', 'orange-addons-for-elementor' ) . ' (Premium)',
            'stretch_vertical'   => __( 'Stretch Vertical (Animation)', 'orange-addons-for-elementor' ) . ' (Premium)',
            'stretch_horizontal' => __( 'Stretch Horizontal (Animation)', 'orange-addons-for-elementor' ) . ' (Premium)',
            'zigzag'             => __( 'Zigzag (Animation)', 'orange-addons-for-elementor' ) . ' (Premium)',
            'whirl'              => __( 'Whirl (Animation)', 'orange-addons-for-elementor' ) . ' (Premium)',
            'shine'              => __( 'Shine (Animation)', 'orange-addons-for-elementor' ) . ' (Premium)',
        ] );
        $this->add_control( 'post_hover_effect', [
            'label'   => __( 'Hover Effect', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'translate_up',
            'options' => $hover_effect_options,
        ] );
        $premium_notice = apply_filters( 'oradel_post_hover_effect_premium_notice', Oradel_Plugin_Helper::create_premium_notice( 
            /* translators: %s: Premium upgrade URL */
            __( 'Advanced hover animations are available in the <a href="%s" target="_blank">Premium version</a>', 'orange-addons-for-elementor' ),
            'posts-grid',
            'info'
         ) );
        if ( $premium_notice !== null ) {
            $this->add_control( 'oea_premium_post_hover_effect_notice', $premium_notice );
        }
        $this->add_control( 'post_hover_effect_transition_duration', [
            'label'       => __( 'Transition Duration (seconds)', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::NUMBER,
            'default'     => 0.4,
            'min'         => 0,
            'step'        => 0.1,
            'selectors'   => [
                '{{WRAPPER}} .oea-post-grid .post' => 'transition: all {{VALUE}}s ease;',
            ],
            'description' => __( 'Set the duration of the transition effect for both hover and return states.', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'hr_mobile_hover', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_control( 'disable_hover_on_touch', [
            'label'        => __( 'Disable Hover on Touch Devices', 'orange-addons-for-elementor' ),
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => __( 'Yes', 'orange-addons-for-elementor' ),
            'label_off'    => __( 'No', 'orange-addons-for-elementor' ),
            'return_value' => 'yes',
            'default'      => 'no',
            'description'  => __( 'Disable all hover effects on mobile devices and tablets that don\'t support hover.', 'orange-addons-for-elementor' ),
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_category_styles', [
            'label' => esc_html__( 'Category', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->start_controls_tabs( 'tabs_category_styles' );
        $this->start_controls_tab( 'tab_category_normal', [
            'label' => esc_html__( 'Normal', 'orange-addons-for-elementor' ),
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'category_border',
            'label'    => esc_html__( 'Border', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .post-category',
        ] );
        $this->add_control( 'category_border_radius', [
            'label'      => esc_html__( 'Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors'  => [
                '{{WRAPPER}} .post-category' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'category_padding', [
            'label'      => esc_html__( 'Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors'  => [
                '{{WRAPPER}} .post-category' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'category_margin', [
            'label'      => esc_html__( 'Margin', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors'  => [
                '{{WRAPPER}} .post-category' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_tab();
        $this->start_controls_tab( 'tab_category_hover', [
            'label' => esc_html__( 'Hover', 'orange-addons-for-elementor' ),
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'category_border_hover',
            'label'    => esc_html__( 'Border', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .post:hover:not(.no-touch-hover.touch-device .post:hover) .post-category',
        ] );
        $this->add_control( 'category_border_radius_hover', [
            'label'      => esc_html__( 'Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors'  => [
                '{{WRAPPER}} .post:hover:not(.no-touch-hover.touch-device .post:hover) .post-category' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control( 'hr_category', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_control( 'category_transition', [
            'label'       => esc_html__( 'Transition Duration', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::SLIDER,
            'size_units'  => ['s', 'ms'],
            'range'       => [
                's'  => [
                    'min'  => 0,
                    'max'  => 5,
                    'step' => 0.1,
                ],
                'ms' => [
                    'min'  => 0,
                    'max'  => 5000,
                    'step' => 100,
                ],
            ],
            'default'     => [
                'unit' => 's',
                'size' => 0.4,
            ],
            'selectors'   => [
                '{{WRAPPER}} .post-category' => 'transition: all {{SIZE}}{{UNIT}} ease;',
            ],
            'description' => esc_html__( 'Set the duration for smooth transition effects on category hover.', 'orange-addons-for-elementor' ),
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_image_styles', [
            'label' => esc_html__( 'Image', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_control( 'image_overlay_color', [
            'label'     => __( 'Image Overlay Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '',
            'selectors' => [
                '{{WRAPPER}} .post-image-wrapper .post-image-overlay' => 'background-color: {{VALUE}};',
            ],
        ] );
        $this->add_control( 'image_overlay_hover_color', [
            'label'     => __( 'Image Overlay Hover Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '',
            'selectors' => [
                '{{WRAPPER}} .oea-post-grid-cards .post-image-wrapper .post-overlay' => 'background-color: {{VALUE}};',
            ],
            'condition' => [
                'post_skin' => 'cards',
            ],
        ] );
        $this->add_control( 'image_hover_effect', [
            'label'   => esc_html__( 'Image Hover Effect', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'none'       => esc_html__( 'None', 'orange-addons-for-elementor' ),
                'scale'      => esc_html__( 'Scale', 'orange-addons-for-elementor' ),
                'blur'       => esc_html__( 'Blur', 'orange-addons-for-elementor' ),
                'grayscale'  => esc_html__( 'Grayscale', 'orange-addons-for-elementor' ),
                'sepia'      => esc_html__( 'Sepia', 'orange-addons-for-elementor' ),
                'invert'     => esc_html__( 'Invert Colors', 'orange-addons-for-elementor' ),
                'brightness' => esc_html__( 'Brightness', 'orange-addons-for-elementor' ),
                'contrast'   => esc_html__( 'Contrast', 'orange-addons-for-elementor' ),
            ],
            'default' => 'scale',
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'post_image_border',
            'selector' => '{{WRAPPER}} .post-image-wrapper',
        ] );
        $this->add_control( 'image_border_radius', [
            'label'       => __( 'Image Border Radius', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units'  => ['px', '%'],
            'default'     => [
                'top'    => 0,
                'right'  => 0,
                'bottom' => 0,
                'left'   => 0,
                'unit'   => 'px',
            ],
            'range'       => [
                'px' => [
                    'min' => 0,
                    'max' => 100,
                ],
                '%'  => [
                    'min' => 0,
                    'max' => 50,
                ],
            ],
            'selectors'   => [
                '{{WRAPPER}} .post-image-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'description' => __( 'Set the border radius for each corner of the image.', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'image_transition', [
            'label'      => __( 'Transition', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['s', 'ms'],
            'range'      => [
                's'  => [
                    'min'  => 0,
                    'max'  => 20,
                    'step' => 0.1,
                ],
                'ms' => [
                    'min'  => 0,
                    'max'  => 3000,
                    'step' => 100,
                ],
            ],
            'default'    => [
                'unit' => 's',
            ],
            'selectors'  => [
                '{{WRAPPER}} .post-image-wrapper .post-image' => 'transition: all {{SIZE}}{{UNIT}} ease;',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_filters_style', [
            'label' => __( 'Filters', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_responsive_control( 'taxonomy_menu_height', [
            'label'      => __( 'Menu Height', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', '%', 'vh'],
            'range'      => [
                'px' => [
                    'min' => 0,
                    'max' => 500,
                ],
                '%'  => [
                    'min' => 0,
                    'max' => 100,
                ],
                'vh' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-taxonomy-menu' => 'height: {{SIZE}}{{UNIT}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'taxonomy_menu_border',
            'label'    => __( 'Menu Border', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .oea-taxonomy-menu',
        ] );
        $this->add_control( 'taxonomy_menu_border_radius', [
            'label'      => __( 'Menu Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors'  => [
                '{{WRAPPER}} .oea-taxonomy-menu' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), [
            'name'     => 'taxonomy_menu_box_shadow',
            'label'    => __( 'Menu Box Shadow', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .oea-taxonomy-menu',
        ] );
        $this->add_responsive_control( 'taxonomy_menu_padding', [
            'label'      => __( 'Menu Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors'  => [
                '{{WRAPPER}} .oea-taxonomy-menu' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Background::get_type(), [
            'name'           => 'filters_menu_background',
            'fields_options' => [
                'background' => [
                    'label' => __( 'Filters Menu Background', 'orange-addons-for-elementor' ),
                ],
            ],
            'types'          => ['classic', 'gradient'],
            'selector'       => '{{WRAPPER}} .oea-taxonomy-menu',
        ] );
        $this->add_control( 'filters_transition', [
            'label'      => __( 'Transition', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['s', 'ms'],
            'range'      => [
                's'  => [
                    'min'  => 0,
                    'max'  => 20,
                    'step' => 0.1,
                ],
                'ms' => [
                    'min'  => 0,
                    'max'  => 3000,
                    'step' => 100,
                ],
            ],
            'default'    => [
                'unit' => 's',
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-taxonomy-menu .dropdown-toggle,
                    {{WRAPPER}} .oea-taxonomy-menu .taxonomy-menu-item .term-count,  
                    {{WRAPPER}} .oea-taxonomy-menu .taxonomy-menu-item' => 'transition: all {{SIZE}}{{UNIT}} ease;',
            ],
        ] );
        $this->add_control( 'hr11', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->start_controls_tabs( 'tabs_filters_style' );
        $this->start_controls_tab( 'tab_filters_normal', [
            'label' => __( 'Normal', 'orange-addons-for-elementor' ),
        ] );
        $this->add_responsive_control( 'links_and_toggle_height', [
            'label'      => __( 'Menu Item and More Button Height', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['%', 'px', 'vh'],
            'range'      => [
                '%'  => [
                    'min' => 0,
                    'max' => 100,
                ],
                'px' => [
                    'min' => 0,
                    'max' => 500,
                ],
                'vh' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default'    => [
                'unit' => '%',
            ],
            'selectors'  => [
                '{{WRAPPER}} ul.links'         => 'height: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .dropdown-toggle' => 'height: {{SIZE}}{{UNIT}};',
            ],
        ] );
        $this->add_control( 'taxonomy_menu_item_margin_right', [
            'label'      => __( 'Menu Item Margin Right', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', '%', 'em'],
            'range'      => [
                'px' => [
                    'min' => 0,
                    'max' => 100,
                ],
                '%'  => [
                    'min' => 0,
                    'max' => 50,
                ],
                'em' => [
                    'min' => 0,
                    'max' => 5,
                ],
            ],
            'selectors'  => [
                '{{WRAPPER}} .links .taxonomy-menu-item' => 'margin-right: {{SIZE}}{{UNIT}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'           => 'taxonomy_menu_item_border',
            'fields_options' => [
                'border' => [
                    'label' => __( 'Menu Item Border', 'orange-addons-for-elementor' ),
                ],
            ],
            'selector'       => '{{WRAPPER}} .links .taxonomy-menu-item',
        ] );
        $this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), [
            'name'     => 'taxonomy_menu_item_box_shadow',
            'label'    => __( 'Menu Item Shadow', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .links .taxonomy-menu-item',
        ] );
        $this->add_control( 'taxonomy_menu_item_border_radius', [
            'label'      => __( 'Menu Item Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors'  => [
                '{{WRAPPER}} .links .taxonomy-menu-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_control( 'hr5', [
            'type'      => \Elementor\Controls_Manager::DIVIDER,
            'condition' => [
                'show_term_count' => 'yes',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'           => 'term_count_border',
            'label'          => __( 'Term Count Border', 'orange-addons-for-elementor' ),
            'fields_options' => [
                'border' => [
                    'label' => __( 'Term Count Border', 'orange-addons-for-elementor' ),
                ],
            ],
            'selector'       => '{{WRAPPER}} .term-count',
            'condition'      => [
                'show_term_count' => 'yes',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), [
            'name'      => 'term_count_box_shadow',
            'label'     => __( 'Term Count Shadow', 'orange-addons-for-elementor' ),
            'selector'  => '{{WRAPPER}} .term-count',
            'condition' => [
                'show_term_count' => 'yes',
            ],
        ] );
        $this->add_control( 'term_count_border_radius', [
            'label'      => __( 'Term Count Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors'  => [
                '{{WRAPPER}} .term-count' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'condition'  => [
                'show_term_count' => 'yes',
            ],
        ] );
        $this->add_control( 'hr6', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'           => 'dropdown_toggle_border',
            'fields_options' => [
                'border' => [
                    'label' => __( 'More Button Border', 'orange-addons-for-elementor' ),
                ],
            ],
            'selector'       => '{{WRAPPER}} .oea-taxonomy-menu .dropdown-toggle',
        ] );
        $this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), [
            'name'     => 'dropdown_toggle_box_shadow',
            'label'    => __( 'More Button Shadow', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .oea-taxonomy-menu .dropdown-toggle',
        ] );
        $this->add_control( 'dropdown_toggle_border_radius', [
            'label'      => __( 'More Button Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors'  => [
                '{{WRAPPER}} .oea-taxonomy-menu .dropdown-toggle' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_control( 'hr9', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'           => 'hidden_links_border',
            'selector'       => '{{WRAPPER}} .oea-taxonomy-menu .hidden-links',
            'fields_options' => [
                'border' => [
                    'label' => __( 'Hidden Links Border', 'orange-addons-for-elementor' ),
                ],
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), [
            'name'     => 'hidden_links_box_shadow',
            'label'    => __( 'Hidden Links Shadow', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .oea-taxonomy-menu .hidden-links',
        ] );
        $this->add_control( 'hidden_links_border_radius', [
            'label'      => __( 'Hidden Links Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors'  => [
                '{{WRAPPER}} .oea-taxonomy-menu .hidden-links' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_tab();
        $this->start_controls_tab( 'tab_filters_hover', [
            'label' => __( 'Hover', 'orange-addons-for-elementor' ),
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'           => 'taxonomy_menu_item_border_hover',
            'label'          => __( 'Menu Item Border (Hover)', 'orange-addons-for-elementor' ),
            'fields_options' => [
                'border' => [
                    'label' => __( 'Menu Item Border', 'orange-addons-for-elementor' ),
                ],
            ],
            'selector'       => '{{WRAPPER}} .links .taxonomy-menu-item:hover',
        ] );
        $this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), [
            'name'     => 'taxonomy_menu_item_box_shadow_hover',
            'label'    => __( 'Menu Item Shadow', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .links .taxonomy-menu-item:hover',
        ] );
        $this->add_control( 'hr7', [
            'type'      => \Elementor\Controls_Manager::DIVIDER,
            'condition' => [
                'show_term_count' => 'yes',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'           => 'term_count_border_hover',
            'fields_options' => [
                'border' => [
                    'label' => __( 'Term Count Border', 'orange-addons-for-elementor' ),
                ],
            ],
            'selector'       => '{{WRAPPER}} .term-count:hover',
            'condition'      => [
                'show_term_count' => 'yes',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), [
            'name'      => 'term_count_box_shadow_hover',
            'label'     => __( 'Term Count Shadow', 'orange-addons-for-elementor' ),
            'selector'  => '{{WRAPPER}} .term-count:hover',
            'condition' => [
                'show_term_count' => 'yes',
            ],
        ] );
        $this->add_control( 'hr8', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'           => 'dropdown_toggle_border_hover',
            'fields_options' => [
                'border' => [
                    'label' => __( 'More Button Border', 'orange-addons-for-elementor' ),
                ],
            ],
            'selector'       => '{{WRAPPER}} .oea-taxonomy-menu .dropdown-toggle:hover',
        ] );
        $this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), [
            'name'     => 'dropdown_toggle_box_shadow_hover',
            'label'    => __( 'More Button Shadow', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .oea-taxonomy-menu .dropdown-toggle:hover',
        ] );
        $this->add_control( 'hr10', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'           => 'hidden_links_border_hover',
            'selector'       => '{{WRAPPER}} .oea-taxonomy-menu .hidden-links:hover',
            'fields_options' => [
                'border' => [
                    'label' => __( 'Hidden Links Border', 'orange-addons-for-elementor' ),
                ],
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), [
            'name'     => 'hidden_links_box_shadow_hover',
            'label'    => __( 'Hidden Links Shadow', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .oea-taxonomy-menu .hidden-links:hover',
        ] );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section( 'section_pagination_style', [
            'label' => __( 'Pagination', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->start_controls_tabs( 'tabs_pagination_style' );
        $this->start_controls_tab( 'tab_pagination_normal', [
            'label' => __( 'Normal', 'orange-addons-for-elementor' ),
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'pagination_border',
            'label'    => __( 'Border', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .oea-pagination-numbers .oea-page-number, 
                               {{WRAPPER}} .oea-pagination .prev-page-button, 
                               {{WRAPPER}} .oea-pagination .next-page-button, 
                               {{WRAPPER}} .oea-load-more-wrapper .oea-load-more',
        ] );
        $this->add_control( 'pagination_border_radius', [
            'label'      => __( 'Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors'  => [
                '{{WRAPPER}} .oea-pagination-numbers .oea-page-number, 
                     {{WRAPPER}} .oea-pagination .prev-page-button, 
                     {{WRAPPER}} .oea-pagination .next-page-button, 
                     {{WRAPPER}} .oea-load-more-wrapper .oea-load-more' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), [
            'name'     => 'pagination_box_shadow',
            'label'    => __( 'Box Shadow', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .oea-pagination-numbers .oea-page-number, 
                               {{WRAPPER}} .oea-pagination .prev-page-button, 
                               {{WRAPPER}} .oea-pagination .next-page-button, 
                               {{WRAPPER}} .oea-load-more-wrapper .oea-load-more',
        ] );
        $this->end_controls_tab();
        $this->start_controls_tab( 'tab_pagination_hover', [
            'label' => __( 'Hover', 'orange-addons-for-elementor' ),
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'pagination_border_hover',
            'label'    => __( 'Border (Hover)', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .oea-pagination-numbers .oea-page-number:hover, 
                               {{WRAPPER}} .oea-pagination .prev-page-button:hover, 
                               {{WRAPPER}} .oea-pagination .next-page-button:hover, 
                               {{WRAPPER}} .oea-load-more-wrapper .oea-load-more:hover',
        ] );
        $this->add_control( 'pagination_border_radius_hover', [
            'label'      => __( 'Border Radius (Hover)', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors'  => [
                '{{WRAPPER}} .oea-pagination-numbers .oea-page-number:hover, 
                     {{WRAPPER}} .oea-pagination .prev-page-button:hover, 
                     {{WRAPPER}} .oea-pagination .next-page-button:hover, 
                     {{WRAPPER}} .oea-load-more-wrapper .oea-load-more:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), [
            'name'     => 'pagination_box_shadow_hover',
            'label'    => __( 'Box Shadow (Hover)', 'orange-addons-for-elementor' ),
            'selector' => '{{WRAPPER}} .oea-pagination-numbers .oea-page-number:hover, 
                               {{WRAPPER}} .oea-pagination .prev-page-button:hover, 
                               {{WRAPPER}} .oea-pagination .next-page-button:hover, 
                               {{WRAPPER}} .oea-load-more-wrapper .oea-load-more:hover',
        ] );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control( 'hr12', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_control( 'pagination_transition', [
            'label'      => __( 'Transition', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['s', 'ms'],
            'range'      => [
                's'  => [
                    'min'  => 0,
                    'max'  => 20,
                    'step' => 0.1,
                ],
                'ms' => [
                    'min'  => 0,
                    'max'  => 3000,
                    'step' => 100,
                ],
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pagination-numbers .oea-page-number, 
                     {{WRAPPER}} .oea-pagination .prev-page-button, 
                     {{WRAPPER}} .oea-pagination .next-page-button, 
                     {{WRAPPER}} .oea-load-more .button-text,
                     {{WRAPPER}} .oea-load-more-wrapper .oea-load-more' => 'transition: all {{SIZE}}{{UNIT}} ease !important;',
            ],
        ] );
        $this->add_responsive_control( 'pagination_padding', [
            'label'      => __( 'Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors'  => [
                '{{WRAPPER}} .oea-pagination-numbers .oea-page-number, 
                     {{WRAPPER}} .oea-pagination .prev-page-button, 
                     {{WRAPPER}} .oea-pagination .next-page-button, 
                     {{WRAPPER}} .oea-load-more-wrapper .oea-load-more' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'load_more_margin_top', [
            'label'      => __( 'Load More Margin Top', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', '%', 'em'],
            'range'      => [
                'px' => [
                    'min' => 0,
                    'max' => 200,
                ],
                '%'  => [
                    'min' => 0,
                    'max' => 20,
                ],
                'em' => [
                    'min' => 0,
                    'max' => 10,
                ],
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-load-more-wrapper' => 'margin-top: {{SIZE}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'pagination_icon_size', [
            'label'      => __( 'Icon Size', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', 'em'],
            'range'      => [
                'px' => [
                    'min' => 10,
                    'max' => 100,
                ],
                'em' => [
                    'min' => 0.5,
                    'max' => 5,
                ],
            ],
            'selectors'  => [
                '{{WRAPPER}} .oea-pagination .prev-page-button i, 
                     {{WRAPPER}} .oea-pagination .next-page-button i' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
            'condition'  => [
                'pagination_type' => 'simple',
            ],
        ] );
        $pagination_hover_options = apply_filters( 'oradel_pagination_hover_effect_options', [
            'none'           => __( 'None', 'orange-addons-for-elementor' ),
            'scale'          => __( 'Scale (Zoom In)', 'orange-addons-for-elementor' ),
            'rotate'         => __( 'Rotate (Spin)', 'orange-addons-for-elementor' ),
            'translate_up'   => __( 'Translate Up', 'orange-addons-for-elementor' ),
            'translate_down' => __( 'Translate Down', 'orange-addons-for-elementor' ),
            'tilt'           => __( 'Tilt (Perspective Shift)', 'orange-addons-for-elementor' ) . ' (Premium)',
            'pulse'          => __( 'Pulse', 'orange-addons-for-elementor' ) . ' (Premium)',
            'flash'          => __( 'Flash', 'orange-addons-for-elementor' ) . ' (Premium)',
            'bounce'         => __( 'Bounce', 'orange-addons-for-elementor' ) . ' (Premium)',
            'shake'          => __( 'Shake', 'orange-addons-for-elementor' ) . ' (Premium)',
            'wave'           => __( 'Wave', 'orange-addons-for-elementor' ) . ' (Premium)',
        ] );
        $this->add_control( 'pagination_hover_effect', [
            'label'     => __( 'Pagination Hover Effect', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SELECT,
            'default'   => 'translate_up',
            'options'   => $pagination_hover_options,
            'selectors' => [
                '{{WRAPPER}} .oea-pagination-numbers .oea-page-number, 
                     {{WRAPPER}} .oea-pagination .prev-page-button, 
                     {{WRAPPER}} .oea-pagination .next-page-button, 
                     {{WRAPPER}} .oea-load-more-wrapper .oea-load-more' => 'data-pagination_hover_effect: {{VALUE}};',
            ],
        ] );
        $premium_notice = apply_filters( 'oradel_pagination_hover_effect_premium_notice', Oradel_Plugin_Helper::create_premium_notice( 
            /* translators: %s: Premium upgrade URL */
            __( 'Advanced pagination hover animations are available in the <a href="%s" target="_blank">Premium version</a>', 'orange-addons-for-elementor' ),
            'posts-grid',
            'info'
         ) );
        if ( $premium_notice !== null ) {
            $this->add_control( 'oea_premium_pagination_hover_effect_notice', $premium_notice );
        }
        $this->end_controls_section();
    }

    protected function oea_get_all_taxonomies() {
        $taxonomies = get_taxonomies( [
            'public' => true,
        ], 'objects' );
        $options = [];
        foreach ( $taxonomies as $taxonomy ) {
            $options[$taxonomy->name] = $taxonomy->label;
        }
        return $options;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $post_type = $settings['post_type'];
        $posts_per_page = $settings['posts_per_page'];
        $posts_per_row = $settings['posts_per_row'];
        $paged = ( get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1 );
        $pagination_type = apply_filters(
            'oradel_enable_pagination_type_render',
            $settings['pagination_type'],
            $settings['pagination_type'],
            $settings
        );
        $order_by = ( !empty( $settings['posts_order_by'] ) ? $settings['posts_order_by'] : 'date' );
        $order = ( !empty( $settings['posts_order'] ) ? $settings['posts_order'] : 'DESC' );
        $offset = ( !empty( $settings['post_offset'] ) ? absint( $settings['post_offset'] ) : 0 );
        $exclude_posts = ( !empty( $settings[$post_type . '_exclude_posts'] ) ? $settings[$post_type . '_exclude_posts'] : [] );
        $exclude_no_image = !empty( $settings['exclude_no_image_posts'] ) && $settings['exclude_no_image_posts'] === 'yes';
        $ignore_sticky_posts = !empty( $settings['ignore_sticky_posts'] ) && $settings['ignore_sticky_posts'] === 'yes';
        $no_posts_text = ( !empty( $settings['no_posts_found_text'] ) ? $settings['no_posts_found_text'] : __( 'No posts found', 'orange-addons-for-elementor' ) );
        $hide_empty_taxonomies = $settings['hide_empty_taxonomies'] === 'yes';
        $enable_pagination = !empty( $settings['enable_pagination'] ) && $settings['enable_pagination'] === 'yes';
        $taxonomy_type = $settings['taxonomy_type'];
        $taxonomies_to_include = ( !empty( $settings[$taxonomy_type . '_ids'] ) ? $settings[$taxonomy_type . '_ids'] : [] );
        $image_hover_effect = ( isset( $settings['image_hover_effect'] ) ? $settings['image_hover_effect'] : 'none' );
        $show_term_count = apply_filters(
            'oradel_enable_show_term_count_render',
            false,
            isset( $settings['show_term_count'] ) && $settings['show_term_count'] === 'yes',
            $settings
        );
        $show_term_menu = isset( $settings['show_term_menu'] ) && $settings['show_term_menu'] === 'yes';
        $category_heading = ( !empty( $settings['category_heading'] ) ? $settings['category_heading'] : __( 'Category', 'orange-addons-for-elementor' ) );
        $open_in_new_tab = apply_filters(
            'oradel_enable_open_in_new_tab_render',
            'no',
            ( !empty( $settings['open_in_new_tab'] ) && $settings['open_in_new_tab'] === 'yes' ? 'yes' : 'no' ),
            $settings
        );
        $terms_args = [
            'taxonomy'   => $taxonomy_type,
            'hide_empty' => $hide_empty_taxonomies,
        ];
        if ( !empty( $taxonomies_to_include ) ) {
            $terms_args['include'] = $taxonomies_to_include;
        }
        $terms = get_terms( $terms_args );
        if ( $show_term_menu && !is_wp_error( $terms ) && !empty( $terms ) ) {
            $widget_id = $this->get_id();
            $menu_classes = ['oea-taxonomy-menu'];
            if ( $settings['filters_menu_type'] === 'without_heading' ) {
                $menu_classes[] = 'no-heading';
            }
            if ( !empty( $settings['additional_menu_class'] ) ) {
                $menu_classes[] = esc_attr( $settings['additional_menu_class'] );
            }
            if ( !empty( $settings['menu_reversed'] ) ) {
                $menu_classes[] = 'reversed';
            }
            $menu_class_string = implode( ' ', $menu_classes );
            echo '<nav class="' . esc_attr( $menu_class_string ) . '" data-widget-id="' . esc_attr( $widget_id ) . '">';
            if ( $settings['filters_menu_type'] === 'with_heading' ) {
                echo '<h2 class="oea-taxonomy-heading"><span class="oea-taxonomy-heading-text">' . esc_html( $category_heading ) . '</span></h2>';
            }
            echo '<ul class="links" data-taxonomy="' . esc_attr( $taxonomy_type ) . '" data-widget-id="' . esc_attr( $widget_id ) . '">';
            echo '<li class="taxonomy-menu-item active" data-term-id="all">' . esc_attr( $settings['filters_first_tab'] ) . '</li>';
            foreach ( $terms as $term ) {
                $term_count = $term->count;
                echo '<li class="taxonomy-menu-item" data-term-id="' . esc_attr( $term->term_id ) . '"><span class="term-name">' . esc_html( $term->name ) . '</span>';
                echo '</li>';
            }
            echo '</ul>';
            echo '<div class="dropdown-toggle"><span class="text">More</span>';
            echo '<ul class="hidden-links hidden"></ul></div>';
            echo '</nav>';
        }
        $actual_posts_per_page = $posts_per_page;
        if ( $paged === 1 && !$ignore_sticky_posts ) {
            $sticky_posts = get_option( 'sticky_posts' );
            if ( !empty( $sticky_posts ) ) {
                $actual_posts_per_page = max( 1, $posts_per_page - count( $sticky_posts ) );
            }
        }
        $args = [
            'posts_per_page'      => $actual_posts_per_page,
            'paged'               => $paged,
            'orderby'             => $order_by,
            'order'               => $order,
            'offset'              => $offset,
            'ignore_sticky_posts' => $ignore_sticky_posts,
        ];
        if ( $paged > 1 ) {
            unset($args['offset']);
        }
        if ( !empty( $exclude_posts ) ) {
            // Limit the number of excluded posts for performance reasons
            // WordPress VIP recommends avoiding large post__not_in arrays
            $exclude_posts = array_slice( $exclude_posts, 0, 100 );
            $args['post__not_in'] = $exclude_posts;
            // phpcs:ignore WordPressVIPMinimum.Performance.WPQueryParams.PostNotIn_post__not_in -- Limited to 100 posts for performance
        }
        if ( $exclude_no_image ) {
            // Note: meta_query can be slow on large databases
            // Consider adding database indexes for _thumbnail_id meta_key for better performance
            // This query excludes posts that don't have a featured image
            $args['meta_query'] = [
                // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_query -- Necessary for filtering posts with featured images
                [
                    'key'     => '_thumbnail_id',
                    'compare' => 'EXISTS',
                ],
            ];
        }
        if ( $post_type === 'current_query' ) {
            global $wp_query;
            $args = array_merge( $wp_query->query_vars, $args );
        } else {
            $args['post_type'] = $post_type;
            $tax_query = [];
            $taxonomies = get_taxonomies( [], 'objects' );
            foreach ( $taxonomies as $taxonomy => $object ) {
                $control_id = $taxonomy . '_ids';
                if ( !empty( $settings[$control_id] ) ) {
                    $tax_query[] = [
                        'taxonomy' => $taxonomy,
                        'field'    => 'term_id',
                        'terms'    => $settings[$control_id],
                        'operator' => 'IN',
                    ];
                }
            }
            if ( !empty( $tax_query ) ) {
                // Note: tax_query can be slow on large databases with complex taxonomy relationships
                // Consider limiting the number of taxonomy terms and using proper database indexes
                $args['tax_query'] = $tax_query;
                // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_tax_query -- Necessary for category filtering
            }
        }
        $query = new \WP_Query($args);
        $is_last_page = $paged >= $query->max_num_pages;
        if ( $query->have_posts() ) {
            $widget_id = $this->get_id();
            $post_skin = ( isset( $settings['post_skin'] ) ? $settings['post_skin'] : 'classic' );
            $args = [
                'post_elements_order' => $settings['post_elements_order'],
                'category_position'   => $settings['category_position'],
                'categories_count'    => ( !empty( $settings['categories_count'] ) ? $settings['categories_count'] : 1 ),
                'post_skin'           => $post_skin,
                'show_image'          => $settings['show_image'],
                'image_size'          => $settings['image_size'],
                'order_by'            => $order_by,
                'order'               => $order,
                'exclude_posts'       => $exclude_posts,
                'tax_query'           => $tax_query,
                'is_last_page'        => ( $is_last_page ? 'true' : 'false' ),
                'open_in_new_tab'     => $open_in_new_tab,
                'no_posts_text'       => $no_posts_text,
                'image_hover_effect'  => $image_hover_effect,
                'widget_id'           => $widget_id,
                'pagination_type'     => $pagination_type,
            ];
            $data_attributes = '';
            foreach ( $args as $key => $value ) {
                $attr_value = ( is_array( $value ) ? json_encode( $value ) : $value );
                $data_attributes .= 'data-' . esc_attr( $key ) . '="' . esc_attr( $attr_value ) . '" ';
            }
            $data_attributes .= 'data-exclude_no_image="' . esc_attr( ( $exclude_no_image ? 'true' : 'false' ) ) . '" ';
            $data_attributes .= 'data-ignore_sticky_posts="' . esc_attr( ( $ignore_sticky_posts ? 'true' : 'false' ) ) . '" ';
            $data_attributes .= 'data-posts_per_page="' . esc_attr( $posts_per_page ) . '"';
            $container_classes = 'oea-post-grid oea-post-grid-cols-' . esc_attr( $posts_per_row );
            if ( !empty( $settings['disable_hover_on_touch'] ) && $settings['disable_hover_on_touch'] === 'yes' ) {
                $container_classes .= ' no-touch-hover';
            }
            echo '<div id="oea-posts-' . esc_attr( $widget_id ) . '" data-post_hover_effect="' . esc_attr( $settings['post_hover_effect'] ) . '" class="' . esc_attr( $container_classes ) . '"  ' . wp_kses_post( $data_attributes ) . '>';
            while ( $query->have_posts() ) {
                $query->the_post();
                if ( $post_skin === 'cards' ) {
                    include ORADEL_TEMPLATES . 'posts-grid-cards.php';
                } else {
                    if ( $post_skin === 'classic' ) {
                        include ORADEL_TEMPLATES . 'posts-grid-classic.php';
                    } else {
                        if ( $post_skin === 'list' ) {
                            include ORADEL_TEMPLATES . 'posts-grid-list.php';
                        }
                    }
                }
            }
            echo '</div>';
            if ( $enable_pagination ) {
                $this->render_pagination(
                    $pagination_type,
                    $query,
                    $paged,
                    $posts_per_page,
                    $settings
                );
            }
            wp_reset_postdata();
        } else {
            echo '<div class="oea-no-posts-found">' . esc_html( $no_posts_text ) . '</div>';
        }
    }

    private function render_pagination(
        $pagination_type,
        $query,
        $paged,
        $posts_per_page,
        $settings
    ) {
        $pagination_alignment = $settings['simple_pagination_alignment'];
        $button_class = 'oea-load-more' . (( $settings['load_more_style'] === 'full_width' ? ' oea-load-more-full-width' : '' ));
        $pagination_hover_effect = $settings['pagination_hover_effect'] ?? 'translate_up';
        $total_pages = $query->max_num_pages;
        if ( $total_pages <= 1 ) {
            return;
        }
        if ( $pagination_type === 'simple' ) {
            $widget_id = $this->get_id();
            $prev_page = $paged - 1;
            $next_page = $paged + 1;
            $is_first_page = $paged <= 1;
            $prev_icon = ( !empty( $settings['prev_button_icon']['value'] ) ? '<i class="' . esc_attr( $settings['prev_button_icon']['value'] ) . '"></i>' : '' );
            $next_icon = ( !empty( $settings['next_button_icon']['value'] ) ? '<i class="' . esc_attr( $settings['next_button_icon']['value'] ) . '"></i>' : '' );
            echo '<div class="oea-pagination" data-pagination_hover_effect="' . esc_attr( $pagination_hover_effect ) . '" data-widget-id="' . esc_attr( $widget_id ) . '" style="justify-content: ' . esc_attr( $pagination_alignment ) . ';">';
            echo '<a href="#" style="display:none;" class="prev-page-button" data-page="' . esc_attr( $prev_page ) . '" data-widget-id="' . esc_attr( $widget_id ) . '">' . wp_kses_post( $prev_icon ) . ' ' . esc_html( $settings['prev_button_text'] ) . '</a> ';
            $next_button_style = ( $pagination_alignment === 'space-between' && $is_first_page ? 'margin-left: auto;' : '' );
            echo '<a href="#" class="next-page-button" style="' . esc_attr( $next_button_style ) . '" data-page="' . esc_attr( $next_page ) . '" data-widget-id="' . esc_attr( $widget_id ) . '">' . esc_html( $settings['next_button_text'] ) . ' ' . wp_kses_post( $next_icon ) . '</a>';
            echo '</div>';
        } elseif ( $pagination_type === 'load_more' ) {
            $widget_id = $this->get_id();
            echo '<div class="oea-load-more-wrapper" data-pagination_hover_effect="' . esc_attr( $pagination_hover_effect ) . '" data-widget-id="' . esc_attr( $widget_id ) . '">';
            echo '<button id="oea-load-more-' . esc_attr( $widget_id ) . '" class="' . esc_attr( $button_class ) . '" data-page="2" data-posts-per-page="' . esc_attr( $posts_per_page ) . '" data-widget-id="' . esc_attr( $widget_id ) . '">';
            echo '<span class="button-text">' . esc_attr( $settings['load_more_text'] ) . '</span>';
            echo '</button>';
            echo '<div style="display:none;" class="loading-icon"><div></div><div></div><div></div><div></div><div></div></div>';
            echo '</div>';
        } elseif ( $pagination_type === 'infinite_scroll' ) {
        } elseif ( $pagination_type === 'numbers' ) {
            $total_pages = $query->max_num_pages;
            if ( $total_pages > 1 ) {
                $widget_id = $this->get_id();
                echo '<div class="oea-pagination-numbers" data-pagination_hover_effect="' . esc_attr( $pagination_hover_effect ) . '" data-total_pages="' . esc_attr( $total_pages ) . '" data-widget-id="' . esc_attr( $widget_id ) . '">';
                for ($i = 1; $i <= $total_pages; $i++) {
                    $active_class = ( $i === $paged ? ' active' : '' );
                    echo '<a href="#" class="oea-page-number' . esc_attr( $active_class ) . '" data-page="' . esc_attr( $i ) . '" data-widget-id="' . esc_attr( $widget_id ) . '">' . esc_html( $i ) . '</a>';
                }
                echo '</div>';
            }
        }
    }

    protected function get_image_sizes() {
        $sizes = get_intermediate_image_sizes();
        $result = [];
        foreach ( $sizes as $size ) {
            $result[$size] = ucwords( str_replace( ['-', '_'], ' ', $size ) );
        }
        $result['full'] = __( 'Full', 'orange-addons-for-elementor' );
        return $result;
    }

}
