<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

require_once ORADEL_PATH . 'includes/helpers.php';

class Oradel_Offer_Listing_Widget extends \Elementor\Widget_Base
{

    public static function get_premium_options_for_styling()
    {
        return [
            'mobile_layout_type' => ['horizontal_swipe'],
            'item_hover_animation' => [
                'oea-hover-shake',
                'oea-hover-bounce',
                'oea-hover-pulse',
                'oea-hover-float',
                'oea-hover-wobble',
                'oea-hover-swing',
            ],
        ];
    }

    public function get_name()
    {
        return 'oradel_offer_listing';
    }


    public function get_title()
    {
        return esc_html__('Offer Listing', 'orange-addons-for-elementor');
    }


    public function get_icon()
    {
        return 'eicon-call-to-action';
    }


    public function get_categories()
    {
        return ['oradel-plugin'];
    }


    public function get_keywords()
    {
        return ['offer listing'];
    }


    public function get_custom_help_url()
    {
        return 'https://orange-addons.com/docs/';
    }

    public function get_style_depends()
    {
        return ['oea-offer-listing'];
    }

    public function get_script_depends()
    {
        return ['oea-offer-listing', 'oea-scroll-animations'];
    }

    private function get_premium_hover_animations()
    {
        return [
            'oea-hover-shake' => esc_html__('Shake (Premium)', 'orange-addons-for-elementor'),
            'oea-hover-bounce' => esc_html__('Bounce (Premium)', 'orange-addons-for-elementor'),
            'oea-hover-pulse' => esc_html__('Pulse (Premium)', 'orange-addons-for-elementor'),
            'oea-hover-float' => esc_html__('Float (Premium)', 'orange-addons-for-elementor'),
            'oea-hover-wobble' => esc_html__('Wobble (Premium)', 'orange-addons-for-elementor'),
            'oea-hover-swing' => esc_html__('Swing (Premium)', 'orange-addons-for-elementor'),
        ];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__('Choose Image', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'item_score',
            [
                'label' => esc_html__('Score', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 10,
                'step' => 0.1,
                'default' => 10,
            ]
        );

        $repeater->add_control(
            'item_title',
            [
                'label' => esc_html__('Title', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('List Title', 'orange-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'item_badge',
            [
                'label' => esc_html__('Badge', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('List Title', 'orange-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'item_content',
            [
                'label' => esc_html__('Description', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('Default description', 'orange-addons-for-elementor'),
                'placeholder' => esc_html__('Type your description here', 'orange-addons-for-elementor'),
            ]
        );

        $repeater->add_control(
            'item_price',
            [
                'label' => esc_html__('Price', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('US$1,599.00', 'orange-addons-for-elementor'),
                'placeholder' => esc_html__('Your price', 'orange-addons-for-elementor'),
            ]
        );

        $repeater->add_control(
            'item_old_price',
            [
                'label' => esc_html__('Old Price', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('1900', 'orange-addons-for-elementor'),
                'placeholder' => esc_html__('Your old price', 'orange-addons-for-elementor'),
            ]
        );

        $repeater->add_control(
            'item_button_text',
            [
                'label' => esc_html__('Button Text', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Buy It Now', 'orange-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'item_link',
            [
                'label' => esc_html__('Button Link', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'show_coupon',
            [
                'label' => esc_html__('Show Coupon', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'orange-addons-for-elementor'),
                'label_off' => esc_html__('Hide', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $repeater->add_control(
            'item_coupon',
            [
                'label' => esc_html__('Coupon', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('ORANGE25', 'orange-addons-for-elementor'),
                'label_block' => true,
                'condition' => [
                    'show_coupon' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'show_coupon_icon',
            [
                'label' => esc_html__('Show Coupon Icon', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'orange-addons-for-elementor'),
                'label_off' => esc_html__('Hide', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'show_coupon' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'item_coupon_icon',
            [
                'label' => esc_html__('Coupon Icon', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-circle',
                    'library' => 'fa-solid',
                ],
                'recommended' => [
                    'fa-solid' => [
                        'circle',
                        'dot-circle',
                        'square-full',
                    ],
                    'fa-regular' => [
                        'circle',
                        'dot-circle',
                        'square-full',
                    ],
                ],
                'condition' => [
                    'show_coupon_icon' => 'yes',
                    'show_coupon' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'item_coupon_text',
            [
                'label' => esc_html__('Coupon Description', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('8 days left', 'orange-addons-for-elementor'),
                'label_block' => true,
                'condition' => [
                    'show_coupon' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'show_disclaimer',
            [
                'label' => esc_html__('Show Disclaimer Block', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'orange-addons-for-elementor'),
                'label_off' => esc_html__('Hide', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $repeater->add_control(
            'item_disclaimer',
            [
                'label' => esc_html__('Disclaimer', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 10,
                'default' => esc_html__('Default disclaimer', 'orange-addons-for-elementor'),
                'placeholder' => esc_html__('Type your diclaimer here', 'orange-addons-for-elementor'),
                'condition' => [
                    'show_disclaimer' => 'yes',
                ],
            ]
        );

        $repeater->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'selector' => '{{WRAPPER}} .oea-offer-listing {{CURRENT_ITEM}}.item',
            ]
        );

        $this->add_control(
            'offer_list',
            [
                'label' => esc_html__('Offer List', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'item_title' => esc_html__('Title #1', 'orange-addons-for-elementor'),
                        'item_content' => esc_html__('Item content. Click the edit button to change this text.', 'orange-addons-for-elementor'),
                    ],
                    [
                        'item_title' => esc_html__('Title #2', 'orange-addons-for-elementor'),
                        'item_content' => esc_html__('Item content. Click the edit button to change this text.', 'orange-addons-for-elementor'),
                    ],
                ],
                'title_field' => '{{{ item_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'offer_listing_style',
            [
                'label' => esc_html__('Style', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $mobile_layout_options = apply_filters('oradel_mobile_layout_options', [
            'vertical' => esc_html__('Vertical', 'orange-addons-for-elementor'),
            'horizontal_swipe' => esc_html__('Horizontal', 'orange-addons-for-elementor') . ' (Premium)',
        ]);

        $this->add_control(
            'mobile_layout_type',
            [
                'label' => esc_html__('Mobile Layout', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'vertical',
                'options' => $mobile_layout_options,
                'description' => esc_html__('Choose how the offer list should display on mobile devices', 'orange-addons-for-elementor'),
            ]
        );

        $premium_notice = apply_filters(
            'oradel_mobile_layout_premium_notice',
            Oradel_Plugin_Helper::create_premium_notice(
                /* translators: %s: Premium upgrade URL */
                __('Horizontal Swipe is available in the <a href="%s" target="_blank">Premium version</a>', 'orange-addons-for-elementor'),
                'offer-listing'
            )
        );

        if ($premium_notice !== null) {
            $this->add_control('oea_premium_mobile_layout_notice', $premium_notice);
        }

        $this->add_responsive_control(
            'offer_item_margin_bottom',
            [
                'label' => esc_html__('Gap', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 0.1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 0.1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'rem',
                    'size' => 1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .offer-list' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'offer_style_tabs'
        );

        $this->start_controls_tab(
            'offer_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'offer_listing_normal_border',
                'selector' => '{{WRAPPER}} .oea-offer-listing .item',
                'fields_options' => [
                    'border' => [
                        'responsive' => true,
                    ],
                    'width' => [
                        'selectors' => [
                            '{{WRAPPER}} .oea-offer-listing' => '--offer-listing-border-width-top: {{TOP}}{{UNIT}}; --offer-listing-border-width-right: {{RIGHT}}{{UNIT}}; --offer-listing-border-width-bottom: {{BOTTOM}}{{UNIT}}; --offer-listing-border-width-left: {{LEFT}}{{UNIT}};',
                        ],
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'offer_listing_normal_border_radius',
            [
                'label' => esc_html__('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'offer_listing_normal_box_shadow',
                'selector' => '{{WRAPPER}} .oea-offer-listing .item',
                'fields_options' => [
                    'box_shadow' => [
                        'responsive' => true,
                    ],
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'offer_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'offer_listing_hover_border',
                'selector' => '{{WRAPPER}} .oea-offer-listing .item:hover',
                'fields_options' => [
                    'border' => [
                        'responsive' => true,
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'offer_listing_hover_border_radius',
            [
                'label' => esc_html__('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item:hover' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'offer_listing_hover_box_shadow',
                'selector' => '{{WRAPPER}} .oea-offer-listing .item:hover',
                'fields_options' => [
                    'box_shadow' => [
                        'responsive' => true,
                    ],
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'offer_listing_typography',
            [
                'label' => esc_html__('Typography', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => 'Title',
                'selector' => '{{WRAPPER}} .oea-offer-listing .title',
            ]
        );

        $this->add_control(
            'title_text_color',
            [
                'label' => esc_html__('Title Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'badge_typography',
                'label' => 'Badge',
                'selector' => '{{WRAPPER}} .oea-offer-listing .badge',
            ]
        );

        $this->add_control(
            'badge_text_color',
            [
                'label' => esc_html__('Badge Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .badge-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => 'Content',
                'selector' => '{{WRAPPER}} .oea-offer-listing .text',
            ]
        );

        $this->add_control(
            'content_text_color',
            [
                'label' => esc_html__('Description Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'disclaimer_typography',
                'label' => 'Disclaimer',
                'selector' => '{{WRAPPER}} .oea-offer-listing .disclaimer',
            ]
        );

        $this->add_control(
            'disclaimer_text_color',
            [
                'label' => esc_html__('Disclaimer Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .disclaimer' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'score_typography',
                'label' => 'Score',
                'selector' => '{{WRAPPER}} .oea-offer-listing .score',
            ]
        );

        $this->add_control(
            'score_text_color',
            [
                'label' => esc_html__('Score Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .score span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'price_typography',
                'label' => 'Price',
                'selector' => '{{WRAPPER}} .oea-offer-listing .price',
            ]
        );

        $this->add_control(
            'price_text_color',
            [
                'label' => esc_html__('Price Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .price' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'old_price_typography',
                'label' => 'Old Price',
                'selector' => '{{WRAPPER}} .oea-offer-listing del',
                'exclude' => ['text_decoration'], // phpcs:ignore WordPressVIPMinimum.Performance.WPQueryParams.PostNotIn_exclude -- This is Elementor Typography control config, not WordPress Query
            ]
        );

        $this->add_control(
            'old_price_text_color',
            [
                'label' => esc_html__('Old Price Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .price del' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'label' => 'Button',
                'selector' => '{{WRAPPER}} .oea-offer-listing .button',
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label' => esc_html__('Button Text Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .button a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'coupon_typography',
                'label' => 'Coupon',
                'selector' => '{{WRAPPER}} .oea-offer-listing .coupon-text',
            ]
        );

        $this->add_control(
            'coupon_text_color',
            [
                'label' => esc_html__('Coupon Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .coupon .coupon-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'coupon_time_typography',
                'label' => 'Coupon Time',
                'selector' => '{{WRAPPER}} .oea-offer-listing .time-offer',
            ]
        );

        $this->add_control(
            'coupon_time_text_color',
            [
                'label' => esc_html__('Coupon Time Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .time-offer' => 'color: {{VALUE}}',
                ],
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'animations_section',
            [
                'label' => esc_html__('Animations', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'entrance_animations_heading',
            [
                'label' => esc_html__('Entrance Animations', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'item_animation',
            [
                'label' => esc_html__('Entrance Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => esc_html__('None', 'orange-addons-for-elementor'),
                    'oea-fade-in' => esc_html__('Fade In', 'orange-addons-for-elementor'),
                    'oea-fade-in-up' => esc_html__('Fade In Up', 'orange-addons-for-elementor'),
                    'oea-fade-in-down' => esc_html__('Fade In Down', 'orange-addons-for-elementor'),
                    'oea-fade-in-left' => esc_html__('Fade In Left', 'orange-addons-for-elementor'),
                    'oea-fade-in-right' => esc_html__('Fade In Right', 'orange-addons-for-elementor'),
                    'oea-zoom-in' => esc_html__('Zoom In', 'orange-addons-for-elementor'),
                    'oea-bounce-in' => esc_html__('Bounce In', 'orange-addons-for-elementor'),
                    'oea-flip-in' => esc_html__('Flip In', 'orange-addons-for-elementor'),
                    'oea-rotate-in' => esc_html__('Rotate In', 'orange-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'item_animation_duration',
            [
                'label' => esc_html__('Entrance Duration', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => [
                        'min' => 0.1,
                        'max' => 3,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 's',
                    'size' => 0.8,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item-animation-wrapper' => 'animation-duration: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'item_animation!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'item_animation_delay_increment',
            [
                'label' => esc_html__('Delay Between Items', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => [
                        'min' => 0,
                        'max' => 2,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 's',
                    'size' => 0.2,
                ],
                'condition' => [
                    'item_animation!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'animation_on_scroll',
            [
                'label' => esc_html__('Animate Only When Visible', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'orange-addons-for-elementor'),
                'label_off' => esc_html__('No', 'orange-addons-for-elementor'),
                'default' => '',
                'description' => esc_html__('Animation will start only when element enters the viewport.', 'orange-addons-for-elementor'),
                'condition' => [
                    'item_animation!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'disable_animation_mobile',
            [
                'label' => esc_html__('Disable Animation on Mobile', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'orange-addons-for-elementor'),
                'label_off' => esc_html__('No', 'orange-addons-for-elementor'),
                'default' => 'yes',
                'description' => esc_html__('Turn off animation effects on mobile devices for better performance.', 'orange-addons-for-elementor'),
                'condition' => [
                    'item_animation!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'hover_animations_heading',
            [
                'label' => esc_html__('Hover Animations', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $hover_animation_options = apply_filters('oradel_offer_hover_animation_options', [
            'none' => esc_html__('None', 'orange-addons-for-elementor'),
            'oea-hover-scale' => esc_html__('Scale', 'orange-addons-for-elementor'),
            'oea-hover-lift' => esc_html__('Lift Up', 'orange-addons-for-elementor'),
            'oea-hover-rotate' => esc_html__('Rotate', 'orange-addons-for-elementor'),
            'oea-hover-flip' => esc_html__('Flip', 'orange-addons-for-elementor'),
        ] + $this->get_premium_hover_animations());

        $this->add_control(
            'item_hover_animation',
            [
                'label' => esc_html__('Hover Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => $hover_animation_options,
                'prefix_class' => 'oea-offer-hover-',
                'render_type' => 'template',
            ]
        );

        $premium_notice = apply_filters(
            'oradel_offer_hover_animation_premium_notice',
            Oradel_Plugin_Helper::create_premium_notice(
                /* translators: %s: Premium upgrade URL */
                __('More hover animations are available in the <a href="%s" target="_blank">Premium version</a>', 'orange-addons-for-elementor'),
                'offer-listing'
            )
        );

        if ($premium_notice !== null) {
            $this->add_control('oea_premium_hover_notice', $premium_notice);
        }

        $this->add_control(
            'hover_animation_duration',
            [
                'label' => esc_html__('Hover Duration', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => [
                        'min' => 0.1,
                        'max' => 2,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 's',
                    'size' => 0.3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item' => 'transition-duration: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'item_hover_animation!' => 'none',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'offer_listing_padding',
            [
                'label' => esc_html__('Padding', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'offer_padding_tabs'
        );

        $this->start_controls_tab(
            'offer_padding_normal_tab',
            [
                'label' => esc_html__('Normal', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_responsive_control(
            'offer_all_block_padding',
            [
                'label' => esc_html__('Offer Block', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item .wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'offer_score_padding',
            [
                'label' => esc_html__('Score', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item .wrapper .score' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'offer_score_text_padding',
            [
                'label' => esc_html__('Score Text', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'rem',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item .wrapper .score span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'offer_image_padding',
            [
                'label' => esc_html__('Image', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'rem',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item .wrapper .image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'offer_content_padding',
            [
                'label' => esc_html__('Content', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'rem',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item .wrapper .content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'offer_cta_padding',
            [
                'label' => esc_html__('Call To Action', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'rem',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item .wrapper .cta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'offer_disclaimer_padding',
            [
                'label' => esc_html__('Disclaimer', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'rem',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item .disclaimer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'offer_title_padding',
            [
                'label' => esc_html__('Title', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'rem',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item .wrapper .content .title h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'offer_badge_padding',
            [
                'label' => esc_html__('Badge', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'rem',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item .wrapper .content .title .badge' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'offer_badge_text_padding',
            [
                'label' => esc_html__('Badge Text', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'rem',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item .wrapper .content .title .badge .badge-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'offer_description_padding',
            [
                'label' => esc_html__('Description', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'rem',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item .wrapper .content .text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'offer_price_padding',
            [
                'label' => esc_html__('Price', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'rem',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item .wrapper .cta .price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'offer_button_padding',
            [
                'label' => esc_html__('Button', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'rem',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item .wrapper .cta .button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'offer_coupon_padding',
            [
                'label' => esc_html__('Coupon', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'rem',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item .wrapper .cta .coupon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'offer_time_offer_padding',
            [
                'label' => esc_html__('Coupon Time', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'rem',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item .wrapper .cta .time-offer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );



        $this->end_controls_tab();

        $this->start_controls_tab(
            'offer_padding_hover_tab',
            [
                'label' => esc_html__('Hover', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_responsive_control(
            'offer_all_block_hover_padding',
            [
                'label' => esc_html__('Offer Block', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item:hover .wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'offer_listing_background',
            [
                'label' => esc_html__('Background', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'all_content_background',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .oea-offer-listing .wrapper',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Content', 'orange-addons-for-elementor'),
                    ],
                    'image' => [
                        'condition' => ['show_image' => 'never'],
                    ],
                ],
            ]
        );

        $this->add_control(
            'badge_background_color',
            [
                'label' => esc_html__('Badge', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .badge-text' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'button_background',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .oea-offer-listing .cta .button',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button', 'orange-addons-for-elementor'),
                    ],
                    'image' => [
                        'condition' => ['show_image' => 'never'],
                    ],
                ],
            ]
        );

        $this->add_control(
            'disclaimer_background_color',
            [
                'label' => esc_html__('Disclaimer', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .disclaimer' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'image_block_style',
            [
                'label' => esc_html__('Image Block', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'image_block_border',
                'selector' => '{{WRAPPER}} .oea-offer-listing .image',
            ]
        );

        $this->add_responsive_control(
            'image_block_border_radius',
            [
                'label' => esc_html__('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .image' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_block_margin',
            [
                'label' => esc_html__('Margin', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_block_padding',
            [
                'label' => esc_html__('Padding', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_block_style',
            [
                'label' => esc_html__('Content Block', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'content_block_border',
                'selector' => '{{WRAPPER}} .oea-offer-listing .content',
            ]
        );

        $this->add_responsive_control(
            'content_block_border_radius',
            [
                'label' => esc_html__('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .content' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_block_margin',
            [
                'label' => esc_html__('Margin', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_block_padding',
            [
                'label' => esc_html__('Padding', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'price_block_style',
            [
                'label' => esc_html__('Price Block', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'price_block_border',
                'selector' => '{{WRAPPER}} .oea-offer-listing .cta',
            ]
        );

        $this->add_responsive_control(
            'price_block_border_radius',
            [
                'label' => esc_html__('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .cta' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'price_block_margin',
            [
                'label' => esc_html__('Margin', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .cta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'price_block_padding',
            [
                'label' => esc_html__('Padding', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .cta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'offer_listing_transitions',
            [
                'label' => esc_html__('Transition', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'offer_listing_all_transition',
            [
                'label' => esc_html__('All', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0.0,
                'max' => 30,
                'step' => 0.1,
                'default' => 0.6,
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item' => '--all-transition: {{VALUE}}s;',
                ]
            ]
        );

        $this->add_control(
            'offer_listing_border_transition',
            [
                'label' => esc_html__('Border', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0.0,
                'max' => 30,
                'step' => 0.1,
                'default' => 0.6,
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item' => '--border-transition: {{VALUE}}s;',
                ]
            ]
        );

        $this->add_control(
            'offer_listing_shadow_transition',
            [
                'label' => esc_html__('Shadow', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0.0,
                'max' => 30,
                'step' => 0.1,
                'default' => 0.6,
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item' => '--shadow-transition: {{VALUE}}s;',
                ]
            ]
        );

        $this->add_control(
            'offer_listing_padding_transition',
            [
                'label' => esc_html__('Padding', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0.0,
                'max' => 30,
                'step' => 0.1,
                'default' => 0.6,
                'selectors' => [
                    '{{WRAPPER}} .oea-offer-listing .item .wrapper' => '--padding-transition: {{VALUE}}s;',
                ]
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $mobile_layout_type = apply_filters(
            'oradel_enable_mobile_layout_render',
            $settings['mobile_layout_type'],
            $settings['mobile_layout_type'],
            $settings
        );

        $wrapper_classes = 'oea-offer-listing';
        if (!empty($settings['animation_on_scroll']) && $settings['animation_on_scroll'] === 'yes') {
            $wrapper_classes .= ' oea-animate-on-scroll';
        }
        if (!empty($settings['disable_animation_mobile']) && $settings['disable_animation_mobile'] === 'yes') {
            $wrapper_classes .= ' oea-disable-animation-mobile';
        }
        if ('horizontal_swipe' === $mobile_layout_type) {
            $wrapper_classes .= ' oea-mobile-horizontal-swipe';
        }

        $animation_delay = !empty($settings['item_animation_delay_increment']['size']) ? $settings['item_animation_delay_increment']['size'] : 0.2;
        ?>

        <div class="<?php echo esc_attr($wrapper_classes); ?>" data-animation-delay="<?php echo esc_attr($animation_delay); ?>">
            <div class="offer-list">
                <?php if ($settings['offer_list']) {
                    foreach ($settings['offer_list'] as $index => $item) {
                        $score_class = $item['item_score'] > 9 ? 'score-green' : ($item['item_score'] >= 7 ? 'score-light-green' : ($item['item_score'] >= 5 ? 'score-yellow' : ($item['item_score'] >= 3 ? 'score-orange' : 'score-red')));
                        if (!empty($item['item_link']['url'])) {
                            $this->add_link_attributes('item_link', $item['item_link']);
                        }

                        $animation_class = '';
                        $animation_style = '';
                        if (!empty($settings['item_animation']) && $settings['item_animation'] !== 'none') {
                            $animation_class = $settings['item_animation'];
                            if (!empty($settings['item_animation_delay_increment']['size'])) {
                                $delay = $settings['item_animation_delay_increment']['size'] * $index;
                                $animation_style = 'animation-delay: ' . $delay . 's;';
                            }
                        }

                        $hover_animation_class = '';
                        if (!empty($settings['item_hover_animation']) && $settings['item_hover_animation'] !== 'none') {
                            $hover_animation_class = $settings['item_hover_animation'];
                        }
                        ?>
                        <div class="item-animation-wrapper <?php echo esc_attr($animation_class); ?>"
                            data-index="<?php echo esc_attr($index); ?>" <?php if ($animation_style)
                                   echo 'style="' . esc_attr($animation_style) . '"'; ?>>
                            <div
                                class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?> item <?php echo esc_attr($hover_animation_class); ?>">
                                <div class="wrapper">
                                    <div class="score"><span
                                            class="<?php echo esc_attr($score_class); ?>"><?php echo esc_attr($item['item_score']); ?></span>
                                    </div>
                                    <div class=" image">
                                        <figure><img decoding="async" src="<?php echo esc_attr($item['image']['url']); ?>"
                                                class=" attachment-full size-full" alt="" loading="lazy" width="600" height="289">
                                        </figure>
                                    </div>

                                    <div class="content">
                                        <h3 class="title">
                                            <?php echo esc_attr($item['item_title']); ?>
                                        </h3><span class="badge"><span class="badge-text"><?php echo esc_attr($item['item_badge']); ?>
                                            </span></span>
                                        <div class="text">
                                            <?php echo wp_kses_post($item['item_content']); ?>
                                        </div>
                                    </div>
                                    <div class="cta">
                                        <div class="price"><span
                                                class="rh_regular_price"><?php echo esc_attr($item['item_price']); ?></span><del
                                                class="">
                                                <?php echo esc_attr($item['item_old_price']); ?></del> </div>
                                        <div class="button"><a <?php $this->print_render_attribute_string('item_link'); ?>>
                                                <?php echo esc_attr($item['item_button_text']); ?>
                                            </a>
                                        </div>
                                        <?php if ($item['show_coupon'] === "yes"): ?>
                                            <div class="coupon ">
                                                <input class="coupon-text" readonly=""
                                                    value="<?php echo esc_attr($item['item_coupon']); ?>">
                                                <?php if ($item['show_coupon_icon'] === "yes"): ?>
                                                    <?php \Elementor\Icons_Manager::render_icon($item['item_coupon_icon'], ['aria-hidden' => 'true']); ?>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                        <div class="time-offer">
                                            <?php echo esc_attr($item['item_coupon_text']); ?>
                                        </div>
                                    </div>
                                </div>
                                <?php if ($item['show_disclaimer'] === "yes"): ?>
                                    <div class="disclaimer"><?php echo wp_kses_post($item['item_disclaimer']); ?></div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php
                        $this->remove_render_attribute('item_link');
                    }
                } ?>

            </div>
        </div>

        <?php

    }

}