<?php
if (!defined('ABSPATH')) {
    exit;
}

class Oradel_Iconbox_Widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'oradel_iconbox';
    }

    public function get_title()
    {
        return __('Icon Box', 'orange-addons-for-elementor');
    }

    public function get_icon()
    {
        return 'eicon-icon-box';
    }

    public function get_categories()
    {
        return ['oradel-plugin'];
    }

    public function get_custom_help_url()
    {
        return 'https://orange-addons.com/docs/';
    }

    public function get_style_depends()
    {
        return ['oea-iconbox', 'oea-advanced-heading'];
    }

    public function get_script_depends()
    {
        return ['oea-scroll-animations'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'icon',
            [
                'label' => __('Icon', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-lightbulb',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $this->add_control(
            'benefit_title',
            [
                'label' => __('Title', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Vivid Design', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'benefit_description',
            [
                'label' => __('Description', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Bright, eye-catching widgets', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'show_icon',
            [
                'label' => __('Show Icon', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_title',
            [
                'label' => __('Show Title', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_description',
            [
                'label' => __('Show Description', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_section',
            [
                'label' => __('Style', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'box_padding',
            [
                'label' => __('Padding', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'default' => [
                    'top' => '30',
                    'right' => '30',
                    'bottom' => '30',
                    'left' => '30',
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-iconbox' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_alignment',
            [
                'label' => __('Alignment', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => __('Left', 'orange-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'orange-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-end' => [
                        'title' => __('Right', 'orange-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .oea-iconbox' => 'display: flex; flex-direction: column; align-items: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'elements_spacing',
            [
                'label' => __('Spacing Between Elements', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-iconbox h3' => 'margin-top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .oea-iconbox p' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('card_style_tabs');

        $this->start_controls_tab(
            'card_normal',
            [
                'label' => __('Normal', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'card_background',
            [
                'label' => __('Card Background', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF',
                'selectors' => [
                    '{{WRAPPER}} .oea-iconbox' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'card_border',
                'selector' => '{{WRAPPER}} .oea-iconbox',
            ]
        );

        $this->add_control(
            'card_border_radius',
            [
                'label' => __('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => 10,
                    'right' => 10,
                    'bottom' => 10,
                    'left' => 10,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-iconbox' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'card_shadow',
                'selector' => '{{WRAPPER}} .oea-iconbox',
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __('Icon Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'var(--main-color)',
                'selectors' => [
                    '{{WRAPPER}} .oea-iconbox .oea-iconbox-icon i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .oea-iconbox .oea-iconbox-icon svg' => 'fill: {{VALUE}};',
                ],
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __('Icon Size', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 40,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-iconbox .oea-iconbox-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .oea-iconbox .oea-iconbox-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#1F2937',
                'selectors' => [
                    '{{WRAPPER}} .oea-iconbox h3' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'show_title' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => __('Description Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#1F2937',
                'selectors' => [
                    '{{WRAPPER}} .oea-iconbox p' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'show_description' => 'yes',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'card_hover',
            [
                'label' => __('Hover', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'card_background_hover',
            [
                'label' => __('Card Background', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-iconbox:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'card_border_hover',
                'selector' => '{{WRAPPER}} .oea-iconbox:hover',
            ]
        );

        $this->add_control(
            'card_border_radius_hover',
            [
                'label' => __('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => 10,
                    'right' => 10,
                    'bottom' => 10,
                    'left' => 10,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-iconbox:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'card_shadow_hover',
                'selector' => '{{WRAPPER}} .oea-iconbox:hover',
            ]
        );

        $this->add_control(
            'icon_color_hover',
            [
                'label' => __('Icon Color Hover', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-iconbox:hover .oea-iconbox-icon i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .oea-iconbox:hover .oea-iconbox-icon svg' => 'fill: {{VALUE}};',
                ],
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_size_hover',
            [
                'label' => __('Icon Size Hover', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-iconbox:hover .oea-iconbox-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .oea-iconbox:hover .oea-iconbox-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title_color_hover',
            [
                'label' => __('Title Color Hover', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-iconbox:hover h3' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'show_title' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'description_color_hover',
            [
                'label' => __('Description Color Hover', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-iconbox:hover p' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'show_description' => 'yes',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'transition_duration',
            [
                'label' => __('Transition Duration', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => [
                        'min' => 0,
                        'max' => 3,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 's',
                    'size' => 0.3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-iconbox, {{WRAPPER}} .oea-iconbox .oea-iconbox-icon i, {{WRAPPER}} .oea-iconbox .oea-iconbox-icon svg, {{WRAPPER}} .oea-iconbox h3, {{WRAPPER}} .oea-iconbox p' => 'transition: all {{SIZE}}{{UNIT}} ease-in-out;',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'orange-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .oea-iconbox h3',
                'condition' => [
                    'show_title' => 'yes',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'label' => __('Description Typography', 'orange-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .oea-iconbox p',
                'condition' => [
                    'show_description' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'animations_section',
            [
                'label' => __('Animations', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'continuous_animation_heading',
            [
                'label' => __('Continuous Animation (Entire Box)', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'continuous_animation',
            [
                'label' => __('Animation Type', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'description' => __('Note: Enabling continuous animation might override or conflict with some hover effects.', 'orange-addons-for-elementor'),
                'options' => [
                    'none' => __('None', 'orange-addons-for-elementor'),
                    'oea-continuous-pulse' => __('Pulse', 'orange-addons-for-elementor'),
                    'oea-continuous-bounce' => __('Bounce', 'orange-addons-for-elementor'),
                    'oea-continuous-flash' => __('Flash', 'orange-addons-for-elementor'),
                    'oea-continuous-shake' => __('Shake', 'orange-addons-for-elementor'),
                    'oea-continuous-wave' => __('Wave', 'orange-addons-for-elementor'),
                    'oea-continuous-float' => __('Float', 'orange-addons-for-elementor'),
                    'oea-continuous-tada' => __('Tada', 'orange-addons-for-elementor'),
                    'oea-continuous-swing' => __('Swing', 'orange-addons-for-elementor'),
                    'oea-continuous-wobble' => __('Wobble', 'orange-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'hover_effect_heading',
            [
                'label' => __('Hover Animation (Entire Box)', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'hover_effect',
            [
                'label' => __('Hover Animation Type', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => __('None', 'orange-addons-for-elementor'),
                    'oea-hover-lift' => __('Lift Up', 'orange-addons-for-elementor'),
                    'oea-hover-grow' => __('Grow', 'orange-addons-for-elementor'),
                    'oea-hover-rotate' => __('Rotate Clockwise', 'orange-addons-for-elementor'),
                    'oea-hover-rotate-ccw' => __('Rotate Counter-Clockwise', 'orange-addons-for-elementor'),
                    'oea-hover-shadow-pop' => __('Shadow Pop', 'orange-addons-for-elementor'),
                    'oea-hover-glow-main' => __('Glow (Main Color)', 'orange-addons-for-elementor'),
                    'oea-hover-pulse-gentle' => __('Gentle Pulse (on hover)', 'orange-addons-for-elementor'),
                    'oea-hover-shake-gentle' => __('Gentle Shake (on hover)', 'orange-addons-for-elementor'),
                    'oea-hover-float-gentle' => __('Gentle Float (on hover)', 'orange-addons-for-elementor'),
                    'oea-hover-fade' => __('Fade', 'orange-addons-for-elementor'),
                    'oea-hover-skew' => __('Skew', 'orange-addons-for-elementor'),
                    'oea-hover-flip' => __('Flip', 'orange-addons-for-elementor'),
                    'oea-hover-wobble' => __('Wobble', 'orange-addons-for-elementor'),
                    'oea-hover-tada' => __('Tada', 'orange-addons-for-elementor'),
                    'oea-hover-swing' => __('Swing', 'orange-addons-for-elementor'),
                    'oea-hover-rubberband' => __('RubberBand', 'orange-addons-for-elementor'),
                    'oea-hover-heartbeat' => __('HeartBeat', 'orange-addons-for-elementor'),
                    'oea-hover-jello' => __('Jello', 'orange-addons-for-elementor'),
                    'oea-hover-bounce' => __('Bounce', 'orange-addons-for-elementor'),
                    'oea-hover-flash' => __('Flash', 'orange-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'hover_effect_duration',
            [
                'label' => __('Hover Animation Duration (s)', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => [
                        'min' => 0.1,
                        'max' => 3,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 's',
                    'size' => 0.5,
                ],
                'condition' => [
                    'hover_effect!' => 'none',
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-iconbox[data-hover-effect]:not([data-hover-effect="none"])' => '--oea-hover-animation-duration: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'hover_effect_delay',
            [
                'label' => __('Hover Animation Delay (s)', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => [
                        'min' => 0,
                        'max' => 3,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 's',
                    'size' => 0,
                ],
                'condition' => [
                    'hover_effect!' => 'none',
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-iconbox[data-hover-effect]:not([data-hover-effect="none"])' => '--oea-hover-animation-delay: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'card_entrance_animation_heading',
            [
                'label' => __('Card Entrance Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'card_entrance_animation',
            [
                'label' => __('Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => __('None', 'orange-addons-for-elementor'),
                    'oea-fade-in' => __('Fade In', 'orange-addons-for-elementor'),
                    'oea-fade-in-up' => __('Fade In Up', 'orange-addons-for-elementor'),
                    'oea-fade-in-down' => __('Fade In Down', 'orange-addons-for-elementor'),
                    'oea-fade-in-left' => __('Fade In Left', 'orange-addons-for-elementor'),
                    'oea-fade-in-right' => __('Fade In Right', 'orange-addons-for-elementor'),
                    'oea-zoom-in' => __('Zoom In', 'orange-addons-for-elementor'),
                    'oea-bounce-in' => __('Bounce In', 'orange-addons-for-elementor'),
                    'oea-flip-in' => __('Flip In', 'orange-addons-for-elementor'),
                    'oea-rotate-in' => __('Rotate In', 'orange-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'card_entrance_animation_duration',
            [
                'label' => __('Animation Duration (s)', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => [
                        'min' => 0.1,
                        'max' => 5,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 's',
                    'size' => 0.8,
                ],
                'condition' => [
                    'card_entrance_animation!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'card_entrance_animation_delay',
            [
                'label' => __('Animation Delay (s)', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => [
                        'min' => 0,
                        'max' => 5,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 's',
                    'size' => 0,
                ],
                'condition' => [
                    'card_entrance_animation!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'icon_animation_heading',
            [
                'label' => __('Icon Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'icon_animation',
            [
                'label' => __('Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => __('None', 'orange-addons-for-elementor'),
                    'oea-fade-in' => __('Fade In', 'orange-addons-for-elementor'),
                    'oea-fade-in-up' => __('Fade In Up', 'orange-addons-for-elementor'),
                    'oea-fade-in-down' => __('Fade In Down', 'orange-addons-for-elementor'),
                    'oea-fade-in-left' => __('Fade In Left', 'orange-addons-for-elementor'),
                    'oea-fade-in-right' => __('Fade In Right', 'orange-addons-for-elementor'),
                    'oea-zoom-in' => __('Zoom In', 'orange-addons-for-elementor'),
                    'oea-bounce-in' => __('Bounce In', 'orange-addons-for-elementor'),
                    'oea-flip-in' => __('Flip In', 'orange-addons-for-elementor'),
                    'oea-rotate-in' => __('Rotate In', 'orange-addons-for-elementor'),
                ],
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'icon_animation_duration',
            [
                'label' => __('Animation Duration (s)', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => [
                        'min' => 0.1,
                        'max' => 5,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 's',
                    'size' => 0.8,
                ],
                'condition' => [
                    'show_icon' => 'yes',
                    'icon_animation!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'icon_animation_delay',
            [
                'label' => __('Animation Delay (s)', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => [
                        'min' => 0,
                        'max' => 5,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 's',
                    'size' => 0,
                ],
                'condition' => [
                    'show_icon' => 'yes',
                    'icon_animation!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'title_animation_heading',
            [
                'label' => __('Title Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'show_title' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title_animation',
            [
                'label' => __('Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => __('None', 'orange-addons-for-elementor'),
                    'oea-fade-in' => __('Fade In', 'orange-addons-for-elementor'),
                    'oea-fade-in-up' => __('Fade In Up', 'orange-addons-for-elementor'),
                    'oea-fade-in-down' => __('Fade In Down', 'orange-addons-for-elementor'),
                    'oea-fade-in-left' => __('Fade In Left', 'orange-addons-for-elementor'),
                    'oea-fade-in-right' => __('Fade In Right', 'orange-addons-for-elementor'),
                    'oea-zoom-in' => __('Zoom In', 'orange-addons-for-elementor'),
                    'oea-bounce-in' => __('Bounce In', 'orange-addons-for-elementor'),
                    'oea-flip-in' => __('Flip In', 'orange-addons-for-elementor'),
                    'oea-rotate-in' => __('Rotate In', 'orange-addons-for-elementor'),
                ],
                'condition' => [
                    'show_title' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title_animation_duration',
            [
                'label' => __('Animation Duration (s)', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => [
                        'min' => 0.1,
                        'max' => 5,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 's',
                    'size' => 0.8,
                ],
                'condition' => [
                    'show_title' => 'yes',
                    'title_animation!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'title_animation_delay',
            [
                'label' => __('Animation Delay (s)', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => [
                        'min' => 0,
                        'max' => 5,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 's',
                    'size' => 0.2,
                ],
                'condition' => [
                    'show_title' => 'yes',
                    'title_animation!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'description_animation_heading',
            [
                'label' => __('Description Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'show_description' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'description_animation',
            [
                'label' => __('Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => __('None', 'orange-addons-for-elementor'),
                    'oea-fade-in' => __('Fade In', 'orange-addons-for-elementor'),
                    'oea-fade-in-up' => __('Fade In Up', 'orange-addons-for-elementor'),
                    'oea-fade-in-down' => __('Fade In Down', 'orange-addons-for-elementor'),
                    'oea-fade-in-left' => __('Fade In Left', 'orange-addons-for-elementor'),
                    'oea-fade-in-right' => __('Fade In Right', 'orange-addons-for-elementor'),
                    'oea-zoom-in' => __('Zoom In', 'orange-addons-for-elementor'),
                    'oea-bounce-in' => __('Bounce In', 'orange-addons-for-elementor'),
                    'oea-flip-in' => __('Flip In', 'orange-addons-for-elementor'),
                    'oea-rotate-in' => __('Rotate In', 'orange-addons-for-elementor'),
                ],
                'condition' => [
                    'show_description' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'description_animation_duration',
            [
                'label' => __('Animation Duration (s)', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => [
                        'min' => 0.1,
                        'max' => 5,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 's',
                    'size' => 0.8,
                ],
                'condition' => [
                    'show_description' => 'yes',
                    'description_animation!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'description_animation_delay',
            [
                'label' => __('Animation Delay (s)', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => [
                        'min' => 0,
                        'max' => 5,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 's',
                    'size' => 0.4,
                ],
                'condition' => [
                    'show_description' => 'yes',
                    'description_animation!' => 'none',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $outer_wrapper_classes = ['oea-iconbox-wrapper'];
        $outer_wrapper_style = '';
        $has_any_entrance_animation = false;

        if (!empty($settings['card_entrance_animation']) && $settings['card_entrance_animation'] !== 'none') {
            $outer_wrapper_classes[] = $settings['card_entrance_animation'];
            if (!empty($settings['card_entrance_animation_duration']['size'])) {
                $outer_wrapper_style .= 'animation-duration:' . $settings['card_entrance_animation_duration']['size'] . 's;';
            }
            if (!empty($settings['card_entrance_animation_delay']['size']) || $settings['card_entrance_animation_delay']['size'] === 0 || $settings['card_entrance_animation_delay']['size'] === '0') {
                $outer_wrapper_style .= 'animation-delay:' . $settings['card_entrance_animation_delay']['size'] . 's;';
            }
            $has_any_entrance_animation = true;
        }

        $iconbox_internal_classes = ['oea-iconbox'];
        if (!empty($settings['continuous_animation']) && $settings['continuous_animation'] !== 'none') {
            $iconbox_internal_classes[] = $settings['continuous_animation'];
        }

        $iconbox_data_attributes = [];
        if (!empty($settings['hover_effect']) && $settings['hover_effect'] !== 'none') {
            $iconbox_data_attributes[] = 'data-hover-effect="' . esc_attr($settings['hover_effect']) . '"';
        }

        $icon_animation_class = '';
        $icon_animation_style = '';
        if ($settings['show_icon'] === 'yes' && !empty($settings['icon_animation']) && $settings['icon_animation'] !== 'none') {
            $icon_animation_class = ' ' . $settings['icon_animation'];
            if (!empty($settings['icon_animation_duration']['size'])) {
                $icon_animation_style .= 'animation-duration:' . $settings['icon_animation_duration']['size'] . 's;';
            }
            if (!empty($settings['icon_animation_delay']['size']) || $settings['icon_animation_delay']['size'] === 0 || $settings['icon_animation_delay']['size'] === '0') {
                $icon_animation_style .= 'animation-delay:' . $settings['icon_animation_delay']['size'] . 's;';
            }
            $has_any_entrance_animation = true;
        }

        $title_animation_class = '';
        $title_animation_style = '';
        if ($settings['show_title'] === 'yes' && !empty($settings['title_animation']) && $settings['title_animation'] !== 'none') {
            $title_animation_class = ' ' . $settings['title_animation'];
            if (!empty($settings['title_animation_duration']['size'])) {
                $title_animation_style .= 'animation-duration:' . $settings['title_animation_duration']['size'] . 's;';
            }
            if (!empty($settings['title_animation_delay']['size']) || $settings['title_animation_delay']['size'] === 0 || $settings['title_animation_delay']['size'] === '0') {
                $title_animation_style .= 'animation-delay:' . $settings['title_animation_delay']['size'] . 's;';
            }
            $has_any_entrance_animation = true;
        }

        $description_animation_class = '';
        $description_animation_style = '';
        if ($settings['show_description'] === 'yes' && !empty($settings['description_animation']) && $settings['description_animation'] !== 'none') {
            $description_animation_class = ' ' . $settings['description_animation'];
            if (!empty($settings['description_animation_duration']['size'])) {
                $description_animation_style .= 'animation-duration:' . $settings['description_animation_duration']['size'] . 's;';
            }
            if (!empty($settings['description_animation_delay']['size']) || $settings['description_animation_delay']['size'] === 0 || $settings['description_animation_delay']['size'] === '0') {
                $description_animation_style .= 'animation-delay:' . $settings['description_animation_delay']['size'] . 's;';
            }
            $has_any_entrance_animation = true;
        }

        if ($has_any_entrance_animation) {
            $outer_wrapper_classes[] = 'oea-animate-on-scroll';
        }

        $outer_wrapper_classes = array_unique($outer_wrapper_classes);
        $iconbox_internal_classes = array_unique($iconbox_internal_classes);
        $iconbox_data_attr_string = implode(' ', $iconbox_data_attributes);

        ?>
        <div class="<?php echo esc_attr(implode(' ', $outer_wrapper_classes)); ?>"
            style="<?php echo esc_attr($outer_wrapper_style); ?>">
            <div class="<?php echo esc_attr(implode(' ', $iconbox_internal_classes)); ?>" <?php echo wp_kses_post($iconbox_data_attr_string); ?>>
                <?php if ($settings['show_icon'] === 'yes'): ?>
                    <div class="oea-iconbox-icon<?php echo esc_attr($icon_animation_class); ?>"
                        style="<?php echo esc_attr($icon_animation_style); ?>">
                        <?php \Elementor\Icons_Manager::render_icon($settings['icon'], ['aria-hidden' => 'true']); ?>
                    </div>
                <?php endif; ?>
                <?php if ($settings['show_title'] === 'yes'): ?>
                    <h3 class="<?php echo esc_attr($title_animation_class); ?>"
                        style="<?php echo esc_attr($title_animation_style); ?>">
                        <?php echo esc_html($settings['benefit_title']); ?>
                    </h3>
                <?php endif; ?>
                <?php if ($settings['show_description'] === 'yes'): ?>
                    <p class="<?php echo esc_attr($description_animation_class); ?>"
                        style="<?php echo esc_attr($description_animation_style); ?>">
                        <?php echo esc_html($settings['benefit_description']); ?>
                    </p>
                <?php endif; ?>
            </div>
        </div>
        <?php
    }
}