<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

require_once ORADEL_PATH . 'includes/helpers.php';

class Oradel_Hero_Widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'oradel_hero';
    }

    public function get_title()
    {
        return __('Hero Block', 'orange-addons-for-elementor');
    }

    public function get_icon()
    {
        return 'eicon-ehp-hero';
    }

    public function get_categories()
    {
        return ['oradel-plugin'];
    }

    public function get_custom_help_url()
    {
        return 'https://orange-addons.com/docs/';
    }

    public function get_style_depends()
    {
        return ['oea-hero-block'];
    }

    public function get_script_depends()
    {
        return ['oea-scroll-animations', 'oea-hero-slider'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_text',
            [
                'label' => __('Hero Text', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'hero_title',
            [
                'label' => __('Title', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'orange-addons-for-elementor',
            ]
        );

        $this->add_control(
            'hero_description',
            [
                'label' => __('Description', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => 'A lightweight Elementor addon to energize your WordPress site with vibrant, modern widgets.',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_slider',
            [
                'label' => __('Slider Images', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'slider_image',
            [
                'label' => __('Image', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'slider_images',
            [
                'label' => __('Slides', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_control(
            'auto_slide',
            [
                'label' => __('Auto Slide', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'orange-addons-for-elementor'),
                'label_off' => __('No', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_interval',
            [
                'label' => __('Slide Interval (ms)', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1000,
                'max' => 20000,
                'step' => 500,
                'default' => 5000,
                'condition' => [
                    'auto_slide' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_button',
            [
                'label' => __('Button', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_second_button',
            [
                'label' => __('Show Second Button', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'orange-addons-for-elementor'),
                'label_off' => __('No', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => __('Primary Button Text', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Explore Widgets',
            ]
        );

        $this->add_control(
            'button_link',
            [
                'label' => __('Primary Button Link', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '#widgets',
                ],
            ]
        );

        $this->add_control(
            'second_button_text',
            [
                'label' => __('Secondary Button Text', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'Learn More',
                'condition' => [
                    'show_second_button' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'second_button_link',
            [
                'label' => __('Secondary Button Link', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '#learn-more',
                ],
                'condition' => [
                    'show_second_button' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_background_style',
            [
                'label' => __('Background Styles', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'background_type',
            [
                'label' => __('Background Type', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'gradient',
                'options' => [
                    'gradient' => __('Gradient', 'orange-addons-for-elementor'),
                    'solid' => __('Color', 'orange-addons-for-elementor'),
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'gradient_background',
                'types' => ['gradient'],
                'selector' => '{{WRAPPER}} #hero::before',
                'condition' => [
                    'background_type' => 'gradient',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'solid_video_background',
                'types' => ['classic'],
                'exclude' => ['gradient'], // phpcs:ignore WordPressVIPMinimum.Performance.WPQueryParams.PostNotIn_exclude -- This is Elementor Group Control config, not WordPress Query
                'selector' => '{{WRAPPER}} #hero',
                'condition' => [
                    'background_type' => ['solid'],
                ],
            ]
        );

        $this->add_control(
            'solid_overlay_type',
            [
                'label' => __('Overlay Type', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => __('None', 'orange-addons-for-elementor'),
                    'color' => __('Color', 'orange-addons-for-elementor'),
                    'gradient' => __('Gradient', 'orange-addons-for-elementor'),
                ],
                'condition' => [
                    'background_type' => 'solid',
                    'solid_video_background_image[url]!' => '',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'solid_overlay_color',
            [
                'label' => __('Overlay Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'background_type' => 'solid',
                    'solid_video_background_image[url]!' => '',
                    'solid_overlay_type' => 'color',
                ],
                'selectors' => [
                    '{{WRAPPER}} #hero.oea-solid-overlay-active::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'solid_gradient_overlay',
                'types' => ['gradient'],
                'selector' => '{{WRAPPER}} #hero.oea-solid-gradient-overlay-active::after',
                'condition' => [
                    'background_type' => 'solid',
                    'solid_video_background_image[url]!' => '',
                    'solid_overlay_type' => 'gradient',
                ],
            ]
        );

        $this->add_control(
            'enable_solid_gradient_overlay_animation',
            [
                'label' => __('Gradient Overlay Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('On', 'orange-addons-for-elementor'),
                'label_off' => __('Off', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'background_type' => 'solid',
                    'solid_video_background_image[url]!' => '',
                    'solid_overlay_type' => 'gradient',
                ],
            ]
        );

        $this->add_control(
            'enable_gradient_animation',
            [
                'label' => __('Gradient Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('On', 'orange-addons-for-elementor'),
                'label_off' => __('Off', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'background_type' => 'gradient',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_text_style',
            [
                'label' => __('Text Styles', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'text_align',
            [
                'label' => __('Text Alignment', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'orange-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'orange-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'orange-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .oea-hero-text' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_direction',
            [
                'label' => __('Content Direction', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'column',
                'options' => [
                    'row' => __('Horizontal', 'orange-addons-for-elementor'),
                    'column' => __('Vertical', 'orange-addons-for-elementor'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-hero-content .oea-hero-text' => 'flex-direction: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_gap',
            [
                'label' => __('Gap Between Text & Image', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'vw'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 10,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 10,
                    ],
                    'vw' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-hero-content' => 'gap: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'heading_title_style',
            [
                'label' => __('Title', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .oea-hero-text .oea-title-text',
            ]
        );

        $this->add_responsive_control(
            'title_margin_bottom',
            [
                'label' => __('Margin Bottom', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-hero-text .oea-title-text' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-hero-text .oea-title-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'heading_description_style',
            [
                'label' => __('Description', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'selector' => '{{WRAPPER}} .oea-hero-text .oea-description-text',
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => __('Description Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-hero-text .oea-description-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_slider_style',
            [
                'label' => __('Slider Style', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'show_slider',
            [
                'label' => __('Show Slider', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'orange-addons-for-elementor'),
                'label_off' => __('Hide', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->start_controls_tabs('slider_nav_style_tabs');

        $this->start_controls_tab(
            'slider_nav_style_normal',
            [
                'label' => __('Normal', 'orange-addons-for-elementor'),
                'condition' => [
                    'show_slider' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'slider_nav_color',
            [
                'label' => __('Navigation Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-slider-controls button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slider_nav_bg_color',
            [
                'label' => __('Navigation Background', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-slider-controls button' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slider_nav_border_color',
            [
                'label' => __('Navigation Border Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-slider-controls button' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slider_nav_border_width',
            [
                'label' => __('Navigation Border Width', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .oea-slider-controls button' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slider_nav_border_radius',
            [
                'label' => __('Navigation Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .oea-slider-controls button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'slider_nav_style_hover',
            [
                'label' => __('Hover', 'orange-addons-for-elementor'),
                'condition' => [
                    'show_slider' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'slider_nav_hover_color',
            [
                'label' => __('Navigation Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-slider-controls button:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slider_nav_hover_bg_color',
            [
                'label' => __('Navigation Background', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-slider-controls button:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slider_nav_hover_border_color',
            [
                'label' => __('Navigation Border Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-slider-controls button:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slider_nav_hover_border_width',
            [
                'label' => __('Navigation Border Width', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .oea-slider-controls button:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slider_nav_hover_border_radius',
            [
                'label' => __('Navigation Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .oea-slider-controls button:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'slider_nav_transition',
            [
                'label' => __('Transition Duration', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0.1,
                        'max' => 2,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'size' => 0.3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-slider-controls button' => 'transition-duration: {{SIZE}}s;',
                ],
                'separator' => 'before',
                'condition' => [
                    'show_slider' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_button_style',
            [
                'label' => __('Button Style', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'buttons_width',
            [
                'label' => __('Buttons Width', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 350,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 20,
                        'step' => 0.1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 20,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 220,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-hero-button .oea-btn' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs('button_style_tabs');

        $this->start_controls_tab(
            'button_style_normal',
            [
                'label' => __('Normal', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label' => __('Text Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_background_color',
            [
                'label' => __('Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .oea-btn',
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => __('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .oea-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_box_shadow',
                'selector' => '{{WRAPPER}} #hero .oea-btn',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_style_hover',
            [
                'label' => __('Hover', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'button_hover_text_color',
            [
                'label' => __('Text Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-btn:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_hover_background_color',
            [
                'label' => __('Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-btn:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'button_hover_border',
                'selector' => '{{WRAPPER}} .oea-btn:hover',
            ]
        );

        $this->add_control(
            'button_hover_border_radius',
            [
                'label' => __('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .oea-btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_hover_box_shadow',
                'selector' => '{{WRAPPER}} #hero .oea-btn:hover',
            ]
        );

        $this->add_control(
            'button_hover_transform',
            [
                'label' => __('Transform Scale', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 2,
                        'step' => 0.01,
                    ],
                ],
                'default' => [
                    'size' => 1.05,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-btn:hover' => 'transform: scale({{SIZE}}); /* Applied only when no hover effect */',
                ],
                'condition' => [
                    'button_animation!' => 'yes',
                    'button_hover_animation_effect' => 'none',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'button_transition',
            [
                'label' => __('Transition Duration', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0.1,
                        'max' => 2,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'size' => 0.3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-btn' => 'transition: {{SIZE}}s;',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'button_animation',
            [
                'label' => __('Enable Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'orange-addons-for-elementor'),
                'label_off' => __('No', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('Note: Some hover effects may not work if this animation is enabled.', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'button_hover_animation_effect',
            [
                'label' => __('Hover Animation Effect', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => __('None', 'orange-addons-for-elementor'),
                    'pulse' => __('Pulse', 'orange-addons-for-elementor'),
                    'float' => __('Float', 'orange-addons-for-elementor'),
                    'shake' => __('Shake', 'orange-addons-for-elementor'),
                    'tada' => __('Tada', 'orange-addons-for-elementor'),
                    'swing' => __('Swing', 'orange-addons-for-elementor'),
                    'wobble' => __('Wobble', 'orange-addons-for-elementor'),
                    'lift_up' => __('Lift Up', 'orange-addons-for-elementor'),
                    'scale' => __('Scale', 'orange-addons-for-elementor'),
                    'rotate' => __('Rotate', 'orange-addons-for-elementor'),
                    'tilt' => __('Tilt', 'orange-addons-for-elementor'),
                    'translate_down' => __('Translate Down', 'orange-addons-for-elementor'),
                    'shadow' => __('Shadow', 'orange-addons-for-elementor'),
                    'wave' => __('Wave', 'orange-addons-for-elementor'),
                ],
                'separator' => 'before',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_second_button_style',
            [
                'label' => __('Second Button Style', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_second_button' => 'yes',
                ],
            ]
        );

        $this->start_controls_tabs('second_button_style_tabs');

        $this->start_controls_tab(
            'second_button_style_normal',
            [
                'label' => __('Normal', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'second_button_text_color',
            [
                'label' => __('Text Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-btn-secondary' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'second_button_background_color',
            [
                'label' => __('Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-btn-secondary' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'second_button_border',
                'selector' => '{{WRAPPER}} .oea-btn-secondary',
            ]
        );

        $this->add_control(
            'second_button_border_radius',
            [
                'label' => __('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .oea-btn-secondary' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'second_button_box_shadow',
                'selector' => '{{WRAPPER}} #hero .oea-btn-secondary',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'second_button_style_hover',
            [
                'label' => __('Hover', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'second_button_hover_text_color',
            [
                'label' => __('Text Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-btn-secondary:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'second_button_hover_background_color',
            [
                'label' => __('Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-btn-secondary:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'second_button_hover_border',
                'selector' => '{{WRAPPER}} .oea-btn-secondary:hover',
            ]
        );

        $this->add_control(
            'second_button_hover_border_radius',
            [
                'label' => __('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .oea-btn-secondary:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'second_button_hover_box_shadow',
                'selector' => '{{WRAPPER}} #hero .oea-btn-secondary:hover',
            ]
        );

        $this->add_control(
            'second_button_hover_transform',
            [
                'label' => __('Transform Scale', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 2,
                        'step' => 0.01,
                    ],
                ],
                'default' => [
                    'size' => 1.05,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-btn-secondary:hover' => 'transform: scale({{SIZE}}); /* Applied only when no hover effect */',
                ],
                'condition' => [
                    'second_button_animation!' => 'yes',
                    'second_button_hover_animation_effect' => 'none',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'second_button_transition',
            [
                'label' => __('Transition Duration', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0.1,
                        'max' => 2,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'size' => 0.3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-btn-secondary' => 'transition: {{SIZE}}s;',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'second_button_animation',
            [
                'label' => __('Enable Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'orange-addons-for-elementor'),
                'label_off' => __('No', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('Note: Some hover effects may not work if this animation is enabled.', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'second_button_hover_animation_effect',
            [
                'label' => __('Hover Animation Effect', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => __('None', 'orange-addons-for-elementor'),
                    'pulse' => __('Pulse', 'orange-addons-for-elementor'),
                    'float' => __('Float', 'orange-addons-for-elementor'),
                    'shake' => __('Shake', 'orange-addons-for-elementor'),
                    'tada' => __('Tada', 'orange-addons-for-elementor'),
                    'swing' => __('Swing', 'orange-addons-for-elementor'),
                    'wobble' => __('Wobble', 'orange-addons-for-elementor'),
                    'lift_up' => __('Lift Up', 'orange-addons-for-elementor'),
                    'scale' => __('Scale', 'orange-addons-for-elementor'),
                    'rotate' => __('Rotate', 'orange-addons-for-elementor'),
                    'tilt' => __('Tilt', 'orange-addons-for-elementor'),
                    'translate_down' => __('Translate Down', 'orange-addons-for-elementor'),
                    'shadow' => __('Shadow', 'orange-addons-for-elementor'),
                    'wave' => __('Wave', 'orange-addons-for-elementor'),
                ],
                'separator' => 'before',
                'condition' => [
                    'show_second_button' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'buttons_gap',
            [
                'label' => __('Buttons Gap', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-hero-button' => 'gap: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
                'condition' => [
                    'show_second_button' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_animations_hero',
            [
                'label' => __('Animations', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_animation_type',
            [
                'label' => __('Title Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => __('None', 'orange-addons-for-elementor'),
                    'oea-fade-in' => __('Fade In', 'orange-addons-for-elementor'),
                    'oea-fade-in-up' => __('Fade In Up', 'orange-addons-for-elementor'),
                    'oea-fade-in-down' => __('Fade In Down', 'orange-addons-for-elementor'),
                    'oea-fade-in-left' => __('Fade In Left', 'orange-addons-for-elementor'),
                    'oea-fade-in-right' => __('Fade In Right', 'orange-addons-for-elementor'),
                    'oea-zoom-in' => __('Zoom In', 'orange-addons-for-elementor'),
                    'oea-bounce-in' => __('Bounce In', 'orange-addons-for-elementor'),
                    'oea-flip-in' => __('Flip In', 'orange-addons-for-elementor'),
                    'oea-rotate-in' => __('Rotate In', 'orange-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'title_animation_duration',
            [
                'label' => __('Title Animation Duration', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => ['s' => ['min' => 0.1, 'max' => 3, 'step' => 0.1]],
                'default' => ['unit' => 's', 'size' => 0.8],
                'selectors' => ['{{WRAPPER}} .oea-title-text' => 'animation-duration: {{SIZE}}{{UNIT}};'],
                'condition' => ['title_animation_type!' => 'none'],
            ]
        );

        $this->add_control(
            'title_animation_delay',
            [
                'label' => __('Title Animation Delay', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => ['s' => ['min' => 0, 'max' => 2, 'step' => 0.1]],
                'default' => ['unit' => 's', 'size' => 0],
                'selectors' => ['{{WRAPPER}} .oea-title-text' => 'animation-delay: {{SIZE}}{{UNIT}};'],
                'condition' => ['title_animation_type!' => 'none'],
            ]
        );

        $this->add_control(
            'animations_hr_title',
            ['type' => \Elementor\Controls_Manager::DIVIDER]
        );

        $this->add_control(
            'description_animation_type',
            [
                'label' => __('Description Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => __('None', 'orange-addons-for-elementor'),
                    'oea-fade-in' => __('Fade In', 'orange-addons-for-elementor'),
                    'oea-fade-in-up' => __('Fade In Up', 'orange-addons-for-elementor'),
                    'oea-fade-in-down' => __('Fade In Down', 'orange-addons-for-elementor'),
                    'oea-fade-in-left' => __('Fade In Left', 'orange-addons-for-elementor'),
                    'oea-fade-in-right' => __('Fade In Right', 'orange-addons-for-elementor'),
                    'oea-zoom-in' => __('Zoom In', 'orange-addons-for-elementor'),
                    'oea-bounce-in' => __('Bounce In', 'orange-addons-for-elementor'),
                    'oea-flip-in' => __('Flip In', 'orange-addons-for-elementor'),
                    'oea-rotate-in' => __('Rotate In', 'orange-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'description_animation_duration',
            [
                'label' => __('Description Animation Duration', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => ['s' => ['min' => 0.1, 'max' => 3, 'step' => 0.1]],
                'default' => ['unit' => 's', 'size' => 0.8],
                'selectors' => ['{{WRAPPER}} .oea-description-text' => 'animation-duration: {{SIZE}}{{UNIT}};'],
                'condition' => ['description_animation_type!' => 'none'],
            ]
        );

        $this->add_control(
            'description_animation_delay',
            [
                'label' => __('Description Animation Delay', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => ['s' => ['min' => 0, 'max' => 2, 'step' => 0.1]],
                'default' => ['unit' => 's', 'size' => 0.2],
                'selectors' => ['{{WRAPPER}} .oea-description-text' => 'animation-delay: {{SIZE}}{{UNIT}};'],
                'condition' => ['description_animation_type!' => 'none'],
            ]
        );

        $this->add_control(
            'animations_hr_desc',
            ['type' => \Elementor\Controls_Manager::DIVIDER]
        );

        $this->add_control(
            'slider_animation_type',
            [
                'label' => __('Slider Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => __('None', 'orange-addons-for-elementor'),
                    'oea-fade-in' => __('Fade In', 'orange-addons-for-elementor'),
                    'oea-fade-in-up' => __('Fade In Up', 'orange-addons-for-elementor'),
                    'oea-fade-in-down' => __('Fade In Down', 'orange-addons-for-elementor'),
                    'oea-fade-in-left' => __('Fade In Left', 'orange-addons-for-elementor'),
                    'oea-fade-in-right' => __('Fade In Right', 'orange-addons-for-elementor'),
                    'oea-zoom-in' => __('Zoom In', 'orange-addons-for-elementor'),
                    'oea-bounce-in' => __('Bounce In', 'orange-addons-for-elementor'),
                    'oea-flip-in' => __('Flip In', 'orange-addons-for-elementor'),
                    'oea-rotate-in' => __('Rotate In', 'orange-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'slider_animation_duration',
            [
                'label' => __('Slider Animation Duration', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => ['s' => ['min' => 0.1, 'max' => 3, 'step' => 0.1]],
                'default' => ['unit' => 's', 'size' => 0.8],
                'selectors' => ['{{WRAPPER}} .oea-hero-images' => 'animation-duration: {{SIZE}}{{UNIT}};'],
                'condition' => ['slider_animation_type!' => 'none'],
            ]
        );

        $this->add_control(
            'slider_animation_delay',
            [
                'label' => __('Slider Animation Delay', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => ['s' => ['min' => 0, 'max' => 2, 'step' => 0.1]],
                'default' => ['unit' => 's', 'size' => 0.4],
                'selectors' => ['{{WRAPPER}} .oea-hero-images' => 'animation-delay: {{SIZE}}{{UNIT}};'],
                'condition' => ['slider_animation_type!' => 'none'],
            ]
        );

        $this->add_control(
            'animations_hr_slider',
            ['type' => \Elementor\Controls_Manager::DIVIDER]
        );

        $this->add_control(
            'buttons_animation_type',
            [
                'label' => __('Buttons Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => __('None', 'orange-addons-for-elementor'),
                    'oea-fade-in' => __('Fade In', 'orange-addons-for-elementor'),
                    'oea-fade-in-up' => __('Fade In Up', 'orange-addons-for-elementor'),
                    'oea-fade-in-down' => __('Fade In Down', 'orange-addons-for-elementor'),
                    'oea-fade-in-left' => __('Fade In Left', 'orange-addons-for-elementor'),
                    'oea-fade-in-right' => __('Fade In Right', 'orange-addons-for-elementor'),
                    'oea-zoom-in' => __('Zoom In', 'orange-addons-for-elementor'),
                    'oea-bounce-in' => __('Bounce In', 'orange-addons-for-elementor'),
                    'oea-flip-in' => __('Flip In', 'orange-addons-for-elementor'),
                    'oea-rotate-in' => __('Rotate In', 'orange-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'buttons_animation_duration',
            [
                'label' => __('Buttons Animation Duration', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => ['s' => ['min' => 0.1, 'max' => 3, 'step' => 0.1]],
                'default' => ['unit' => 's', 'size' => 0.8],
                'selectors' => ['{{WRAPPER}} .oea-hero-button' => 'animation-duration: {{SIZE}}{{UNIT}};'],
                'condition' => ['buttons_animation_type!' => 'none'],
            ]
        );

        $this->add_control(
            'buttons_animation_delay',
            [
                'label' => __('Buttons Animation Delay', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => ['s' => ['min' => 0, 'max' => 2, 'step' => 0.1]],
                'default' => ['unit' => 's', 'size' => 0.6],
                'selectors' => ['{{WRAPPER}} .oea-hero-button' => 'animation-delay: {{SIZE}}{{UNIT}};'],
                'condition' => ['buttons_animation_type!' => 'none'],
            ]
        );

        $this->add_control(
            'animations_hr_scroll',
            ['type' => \Elementor\Controls_Manager::DIVIDER]
        );

        $this->add_control(
            'animation_on_scroll_hero',
            [
                'label' => __('Animate Only When Visible', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'orange-addons-for-elementor'),
                'label_off' => __('No', 'orange-addons-for-elementor'),
                'default' => '',
                'description' => __('Animation will start only when element enters the viewport.', 'orange-addons-for-elementor'),
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $this->add_render_attribute('hero', [
            'id' => 'hero',
            'class' => 'section',
            'data-background-type' => $settings['background_type']
        ]);

        if ($settings['background_type'] === 'gradient' && $settings['enable_gradient_animation'] === 'yes') {
            $this->add_render_attribute('hero', 'class', 'oea-gradient-animation');
        }

        if ($settings['background_type'] === 'solid' && !empty($settings['solid_video_background_image']['url'])) {
            if (isset($settings['solid_overlay_type'])) {
                if ($settings['solid_overlay_type'] === 'color') {
                    $this->add_render_attribute('hero', 'class', 'oea-solid-overlay-active');
                } elseif ($settings['solid_overlay_type'] === 'gradient') {
                    $this->add_render_attribute('hero', 'class', 'oea-solid-gradient-overlay-active');
                    if (isset($settings['enable_solid_gradient_overlay_animation']) && $settings['enable_solid_gradient_overlay_animation'] === 'yes') {
                        $this->add_render_attribute('hero', 'class', 'oea-solid-gradient-overlay-animation');
                    }
                }
            }
        }

        if (!empty($settings['animation_on_scroll_hero']) && $settings['animation_on_scroll_hero'] === 'yes') {
            $this->add_render_attribute('hero', 'class', 'oea-animate-on-scroll');
        }

        $title_animation_class = '';
        if (!empty($settings['title_animation_type']) && $settings['title_animation_type'] !== 'none') {
            $title_animation_class = $settings['title_animation_type'];
        }
        $this->add_render_attribute('hero_title_attrs', 'class', 'oea-title-text');
        if ($title_animation_class) {
            $this->add_render_attribute('hero_title_attrs', 'class', $title_animation_class);
        }


        $description_animation_class = '';
        if (!empty($settings['description_animation_type']) && $settings['description_animation_type'] !== 'none') {
            $description_animation_class = $settings['description_animation_type'];
        }
        $this->add_render_attribute('hero_description_attrs', 'class', 'oea-description-text');
        if ($description_animation_class) {
            $this->add_render_attribute('hero_description_attrs', 'class', $description_animation_class);
        }


        $slider_animation_class = '';
        if (!empty($settings['slider_animation_type']) && $settings['slider_animation_type'] !== 'none') {
            $slider_animation_class = $settings['slider_animation_type'];
        }
        $this->add_render_attribute('hero_slider_attrs', 'class', 'oea-hero-images');
        if ($slider_animation_class) {
            $this->add_render_attribute('hero_slider_attrs', 'class', $slider_animation_class);
        }


        $buttons_animation_class = '';
        if (!empty($settings['buttons_animation_type']) && $settings['buttons_animation_type'] !== 'none') {
            $buttons_animation_class = $settings['buttons_animation_type'];
        }
        $this->add_render_attribute('hero_buttons_attrs', 'class', 'oea-hero-button');
        if ($buttons_animation_class) {
            $this->add_render_attribute('hero_buttons_attrs', 'class', $buttons_animation_class);
        }

        $this->add_render_attribute('primary_button', 'href', esc_url($settings['button_link']['url']));
        $primary_button_classes = ['oea-btn'];
        if ($settings['button_animation'] === 'yes') {
            $primary_button_classes[] = 'animated';
        }
        if (!empty($settings['button_hover_animation_effect']) && $settings['button_hover_animation_effect'] !== 'none') {
            $primary_button_classes[] = 'oea-btn-hover-effect-' . $settings['button_hover_animation_effect'];
        }
        $this->add_render_attribute('primary_button', 'class', $primary_button_classes);

        if ($settings['show_second_button'] === 'yes') {
            $this->add_render_attribute('secondary_button', 'href', esc_url($settings['second_button_link']['url']));
            $secondary_button_classes = ['oea-btn', 'oea-btn-secondary'];
            if ($settings['second_button_animation'] === 'yes') {
                $secondary_button_classes[] = 'animated';
            }
            if (!empty($settings['second_button_hover_animation_effect']) && $settings['second_button_hover_animation_effect'] !== 'none') {
                $secondary_button_classes[] = 'oea-btn-hover-effect-' . $settings['second_button_hover_animation_effect'];
            }
            $this->add_render_attribute('secondary_button', 'class', $secondary_button_classes);
        }

        ?>
        <section <?php echo wp_kses_post($this->get_render_attribute_string('hero')); ?>>
            <div class="oea-container">
                <div class="oea-hero-content">
                    <div class="oea-hero-text">
                        <h1 <?php echo wp_kses_post($this->get_render_attribute_string('hero_title_attrs')); ?>>
                            <?php echo esc_html($settings['hero_title']); ?>
                        </h1>
                        <p <?php echo wp_kses_post($this->get_render_attribute_string('hero_description_attrs')); ?>>
                            <?php echo esc_html($settings['hero_description']); ?>
                        </p>
                    </div>
                    <?php if ($settings['show_slider'] === 'yes'): ?>
                        <div <?php echo wp_kses_post($this->get_render_attribute_string('hero_slider_attrs')); ?>>
                            <div class="oea-slider-container" data-widget-id="<?php echo esc_attr($this->get_id()); ?>">
                                <div class="oea-slider-track" data-auto-slide="<?php echo esc_attr($settings['auto_slide']); ?>"
                                    data-slide-interval="<?php echo esc_attr($settings['slide_interval']); ?>">
                                    <?php foreach ($settings['slider_images'] as $index => $slide): ?>
                                        <img src="<?php echo esc_url($slide['slider_image']['url']); ?>"
                                            alt="Preview <?php echo esc_attr($index + 1); ?>"
                                            class="<?php echo $index === 0 ? 'oea-active' : ''; ?>">
                                    <?php endforeach; ?>
                                </div>
                                <div class="oea-slider-controls">
                                    <button id="prevSlide-<?php echo esc_attr($this->get_id()); ?>"><i
                                            class="fas fa-chevron-left"></i></button>
                                    <button id="nextSlide-<?php echo esc_attr($this->get_id()); ?>"><i
                                            class="fas fa-chevron-right"></i></button>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <div <?php echo wp_kses_post($this->get_render_attribute_string('hero_buttons_attrs')); ?>>
                    <a <?php echo wp_kses_post($this->get_render_attribute_string('primary_button')); ?>>
                        <?php echo esc_html($settings['button_text']); ?>
                    </a>
                    <?php if ($settings['show_second_button'] === 'yes'): ?>
                        <a <?php echo wp_kses_post($this->get_render_attribute_string('secondary_button')); ?>>
                            <?php echo esc_html($settings['second_button_text']); ?>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </section>
        <?php
    }
}