<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

require_once ORADEL_PATH . 'includes/helpers.php';

class Oradel_Comparison_Table_Widget extends \Elementor\Widget_Base
{



    public function get_name()
    {
        return 'oradel_comparison_table';
    }


    public function get_title()
    {
        return esc_html__('Comparison Table', 'orange-addons-for-elementor');
    }


    public function get_icon()
    {
        return 'eicon-table';
    }


    public function get_categories()
    {
        return ['oradel-plugin'];
    }


    public function get_keywords()
    {
        return ['comparison', 'table'];
    }


    public function get_custom_help_url()
    {
        return 'https://orange-addons.com/docs/';
    }

    public function get_style_depends()
    {
        return ['oea-comparison-table'];
    }

    public function get_script_depends()
    {
        return ['oea-equal-height', 'oea-comparison-table'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_rows',
            [
                'label' => __('Rows', 'orange-addons-for-elementor'),
            ]
        );

        $repeater_rows = new \Elementor\Repeater();

        $repeater_rows->add_control(
            'row_name',
            [
                'label' => __('Row Name', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Row Name', 'orange-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $rows_config = [
            'label' => __('Rows', 'orange-addons-for-elementor'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater_rows->get_controls(),
            'default' => [
                [
                    'row_name' => __('Row 1', 'orange-addons-for-elementor'),
                ],
            ],
            'title_field' => '{{{ row_name }}}',
        ];

        $this->add_control('rows', $rows_config);

        $this->end_controls_section();

        $this->start_controls_section(
            'section_columns',
            [
                'label' => __('Columns', 'orange-addons-for-elementor'),
            ]
        );

        $repeater_columns = new \Elementor\Repeater();

        $repeater_columns->add_control(
            'column_name',
            [
                'label' => __('Column Name', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Column Name', 'orange-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $repeater_columns->add_control(
            'column_short_description',
            [
                'label' => __('Short Description', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Short Description', 'orange-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $repeater_columns->add_control(
            'column_button_text',
            [
                'label' => __('Button Text', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Check Price', 'orange-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $repeater_columns->add_control(
            'column_button_link',
            [
                'label' => esc_html__('Button Link', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => false,
                    'nofollow' => true,
                ],
                'label_block' => true,
            ]
        );

        $repeater_columns->add_control(
            'column_rating',
            [
                'label' => __('Column Rating', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
            ]
        );

        $repeater_columns->add_control(
            'column_image',
            [
                'label' => esc_html__('Choose Image', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater_columns->add_control(
            'column_cells',
            [
                'label' => __('Column Cells', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'description' => __('Enter cell content separated by "***".', 'orange-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'columns',
            [
                'label' => __('Columns', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater_columns->get_controls(),
                'default' => [
                    [
                        'column_name' => __('Column 1', 'orange-addons-for-elementor'),
                    ],
                ],
                'title_field' => '{{{ column_name }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'comparison_table_general_style',
            [
                'label' => esc_html__('General', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'comparison_table_wrapper_border',
                'selector' => '{{WRAPPER}} .oea-comparison-table-wrapper',
            ]
        );

        $this->add_responsive_control(
            'comparison_table_wrapper_border_radius',
            [
                'label' => esc_html__('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table-wrapper' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'comparison_table_wrapper_box_shadow',
                'selector' => '{{WRAPPER}} .oea-comparison-table-wrapper',
            ]
        );

        $this->add_control(
            'hr_general',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'cell_border_style',
            [
                'label' => esc_html__('Cells Border Style', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('Default', 'orange-addons-for-elementor'),
                    'none' => esc_html__('None', 'orange-addons-for-elementor'),
                    'solid' => esc_html__('Solid', 'orange-addons-for-elementor'),
                    'dashed' => esc_html__('Dashed', 'orange-addons-for-elementor'),
                    'dotted' => esc_html__('Dotted', 'orange-addons-for-elementor'),
                    'double' => esc_html__('Double', 'orange-addons-for-elementor'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table th' => 'border-style: {{VALUE}};',
                    '{{WRAPPER}} .oea-comparison-table td' => 'border-style: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'cell_border_color',
            [
                'label' => esc_html__('Cell Border Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table th, {{WRAPPER}} .oea-comparison-table td' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'comparison_table_typography_style',
            [
                'label' => esc_html__('Typography', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'item_title_typography',
                'label' => esc_html__('Item Title', 'orange-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .oea-comparison-table .oea-column-name',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'item_button_typography',
                'label' => esc_html__('Item Button', 'orange-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .oea-comparison-table .button',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'item_short_description_typography',
                'label' => esc_html__('Item Short Description', 'orange-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .oea-comparison-table .oea-column-short-description',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'table_text_typography',
                'label' => esc_html__('Table Text', 'orange-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .oea-comparison-table tr:not(:first-child) td:not(:first-child), {{WRAPPER}} .oea-comparison-table tr:not(:first-child) th:not(:first-child)',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'table_first_column_typography',
                'label' => esc_html__('First Column Text', 'orange-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .oea-comparison-table td:first-child',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'comparison_table_color',
            [
                'label' => esc_html__('Color', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'table_color_tabs'
        );

        $this->start_controls_tab(
            'table_color_normal_tab',
            [
                'label' => esc_html__('Normal', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'item_title_color',
            [
                'label' => esc_html__('Title Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table .oea-column-name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_button_text_color',
            [
                'label' => esc_html__('Button Text Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table .button a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_button_background_color',
            [
                'label' => esc_html__('Button Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table .button' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_short_description_color',
            [
                'label' => esc_html__('Short Description Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table .oea-column-short-description' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'table_text_color',
            [
                'label' => esc_html__('Table Text Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table tr:not(:first-child) td:not(:first-child), {{WRAPPER}} .oea-comparison-table tr:not(:first-child) th:not(:first-child)' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'first_column_text_color',
            [
                'label' => esc_html__('First Column Text Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table td:first-child' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'table_rating_color',
            [
                'label' => esc_html__('Rating Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table th .rating-stars .full-star' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .oea-comparison-table th .rating-stars .partial-star' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .oea-comparison-table th .rating-numbers' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hr_color',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'first_row_background_color',
            [
                'label' => esc_html__('First Row Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table th' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'first_column_background_color',
            [
                'label' => esc_html__('First Column Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table td:first-child' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'table_background_color',
            [
                'label' => esc_html__('Table Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table tr' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'table_even_row_background_color',
            [
                'label' => esc_html__('Even Row Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table tr:nth-child(even)' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'table_color_hover_tab',
            [
                'label' => esc_html__('Hover', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'item_button_hover_text_color',
            [
                'label' => esc_html__('Button Text Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table .button:hover a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_button_hover_background_color',
            [
                'label' => esc_html__('Button Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table .button:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hr_color_hover',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'table_hover_background_color',
            [
                'label' => esc_html__('Table Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table tr:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'table_even_row_hover_background_color',
            [
                'label' => esc_html__('Even Row Background Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table tr:nth-child(even):hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'comparison_table_padding',
            [
                'label' => esc_html__('Padding', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'table_thread_padding',
            [
                'label' => esc_html__('Thread', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'rem',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table th' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'table_cell_padding',
            [
                'label' => esc_html__('Cells', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'rem',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'settings_section',
            [
                'label' => __('Settings', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'table_layout',
            [
                'label' => esc_html__('Table Layout', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'auto',
                'options' => [
                    'auto' => esc_html__('Auto', 'orange-addons-for-elementor'),
                    'fixed' => esc_html__('Fixed', 'orange-addons-for-elementor'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table' => 'table-layout: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'rating_text',
            [
                'label' => esc_html__('Rating Text', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Rating: ', 'orange-addons-for-elementor'),
                'placeholder' => esc_html__('Rating: ', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'featured_second_column',
            [
                'label' => esc_html__('Featured Second Column', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'orange-addons-for-elementor'),
                'label_off' => esc_html__('No', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $sticky_column_config = apply_filters('oradel_sticky_column_control_config', [
            'label' => esc_html__('Sticky First Column', 'orange-addons-for-elementor') . ' <i class="eicon-pro-icon"></i>',
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__('Yes', 'orange-addons-for-elementor'),
            'label_off' => esc_html__('No', 'orange-addons-for-elementor'),
            'return_value' => 'yes',
            'default' => 'no',
            'classes' => 'elementor-control-disabled',
        ]);

        $this->add_control('sticky_first_column', $sticky_column_config);

        $premium_notice = apply_filters(
            'oradel_sticky_column_premium_notice',
            Oradel_Plugin_Helper::create_premium_notice(
                /* translators: %s: Premium upgrade URL */
                __('This feature is available in the <a href="%s" target="_blank">Premium version</a>', 'orange-addons-for-elementor'),
                'comparison-table',
                'info'
            )
        );

        if ($premium_notice !== null) {
            $this->add_control('oea_premium_notice_sticky_column', $premium_notice);
        }

        $this->add_control(
            'sticky_first_column_disable_shadow',
            [
                'label' => __('Disable Sticky Column Shadow', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'orange-addons-for-elementor'),
                'label_off' => __('No', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [
                    'sticky_first_column' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'featured_second_column_border_color',
            [
                'label' => esc_html__('Featured Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .oea-comparison-table.featured-second-column td:nth-child(2)' => 'border-left-color: {{VALUE}}; border-right-color: {{VALUE}};',
                    '{{WRAPPER}} .oea-comparison-table.featured-second-column th:nth-child(2)' => 'border-left-color: {{VALUE}}; border-right-color: {{VALUE}}; box-shadow: inset 0px 2px 0px {{VALUE}};',
                    '{{WRAPPER}} .oea-comparison-table.featured-second-column tr:last-child td:nth-child(2)' => 'box-shadow: inset 0px -2px 0px {{VALUE}};',
                ],
                'condition' => ['featured_second_column' => 'yes']
            ]
        );

        $this->add_control(
            'show_short_description',
            [
                'label' => esc_html__('Show Short Description', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'orange-addons-for-elementor'),
                'label_off' => esc_html__('Hide', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_rating',
            [
                'label' => esc_html__('Show Rating', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'orange-addons-for-elementor'),
                'label_off' => esc_html__('Hide', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'column_rating_style',
            [
                'label' => esc_html__('Rating Style', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'stars',
                'condition' => ['show_rating' => 'yes'],
                'options' => [
                    'stars' => esc_html__('Stars', 'orange-addons-for-elementor'),
                    'numbers' => esc_html__('Numbers', 'orange-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'show_button',
            [
                'label' => esc_html__('Show Button', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'orange-addons-for-elementor'),
                'label_off' => esc_html__('Hide', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'hide_scrollbar',
            [
                'label' => esc_html__('Hide Scrollbar', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'orange-addons-for-elementor'),
                'label_off' => esc_html__('No', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->end_controls_section();
    }

    protected function render_stars($rating)
    {
        $full_star = '<span class="full-star">&#9733;</span>';
        $empty_star = '<span class="empty-star">&#9733;</span>';
        $stars_output = '';

        for ($i = 1; $i <= 10; $i++) {
            if ($rating >= $i) {
                $stars_output .= $full_star;
            } elseif ($rating < $i && $rating > ($i - 1)) {
                $percent_filled = ($rating - ($i - 1)) * 100;
                $stars_output .= '<span class="star-wrapper" style="position: relative; display: inline-block;">';
                $stars_output .= $empty_star;
                $stars_output .= '<span class="partial-star" style="width: ' . esc_attr($percent_filled) . '%; overflow: hidden; position: absolute; top: 0; left: 0; white-space: nowrap;">&#9733;</span>';
                $stars_output .= '</span>';
            } else {
                $stars_output .= $empty_star;
            }
        }

        return $stars_output;
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $rows = $settings['rows'];
        $columns = $settings['columns'];

        $table_wrapper_class = $settings['hide_scrollbar'] === 'yes' ? 'no-scrollbar' : '';

        $sticky_first_column_enabled = apply_filters(
            'oradel_enable_sticky_column_render',
            false,
            isset($settings['sticky_first_column']) && $settings['sticky_first_column'] === 'yes',
            $settings
        );

        $column_classes = implode(' ', array_filter([
            $settings['featured_second_column'] === 'yes' ? 'featured-second-column' : '',
            $sticky_first_column_enabled ? 'sticky-first-column' : '',
            $sticky_first_column_enabled && $settings['sticky_first_column_disable_shadow'] === 'yes' ? 'disable-shadow' : ''
        ]));

        if (!empty($rows) && !empty($columns)) {
            echo '<div class="oea-comparison-table-wrapper ' . esc_attr($table_wrapper_class) . '"><table class="oea-comparison-table ' . esc_attr($column_classes) . '">';

            echo '<tr><th></th>';
            foreach ($columns as $column) {
                if (!empty($column['column_button_link']['url'])) {
                    $this->add_link_attributes('column_button_link', $column['column_button_link']);
                }
                echo '<th>';

                if (!empty($column['column_image']['url'])) {
                    echo '<div class="oea-column-image"><img class="oea-comparison-table-image" src="' . esc_url($column['column_image']['url']) . '" alt="' . esc_attr($column['column_name']) . '"></div>';
                }
                ?>
                <div class="oea-column-name"><?php echo esc_attr($column['column_name']); ?></div>
                <?php if ($settings['show_short_description'] === "yes"): ?>
                    <div class="oea-column-short-description"><?php echo esc_attr($column['column_short_description']); ?></div>
                <?php endif; ?>
                <?php
                if ($settings['show_rating'] === "yes" && isset($column['column_rating']['size']) && $column['column_rating']['size'] > 0) {
                    $rating = $column['column_rating']['size'];
                    if ($settings['column_rating_style'] === 'stars') {
                        echo '<div class="rating-stars" title="' . esc_attr($settings['rating_text']) . esc_attr($rating) . '/10">' . wp_kses_post($this->render_stars($rating)) . '</div>';
                    } else {
                        echo '<div class="rating-numbers">' . esc_html($settings['rating_text']) . esc_html($rating) . '/10</div>';
                    }
                }
                ?>
                <?php if ($settings['show_button'] === "yes"): ?>
                    <div class="button"><a <?php $this->print_render_attribute_string('column_button_link'); ?>><?php echo esc_attr($column['column_button_text']); ?></a>
                    </div>
                <?php endif; ?>
                </th>
                <?php
                $this->remove_render_attribute('column_button_link');
            }
            echo '</tr>';

            foreach ($rows as $row_index => $row) {
                echo '<tr>';
                echo '<td>' . esc_html($row['row_name']) . '</td>';

                foreach ($columns as $column) {
                    $cleaned_content = preg_replace('/<br\s*\/?>|\n/', '', $column['column_cells']);
                    $cells = explode('***', $cleaned_content);
                    $cell_content = isset($cells[$row_index]) ? wp_kses_post($cells[$row_index]) : '';
                    echo '<td>' . wp_kses_post($cell_content) . '</td>';
                }

                echo '</tr>';
            }

            echo '<tr>';
            echo '<td></td>';

            foreach ($columns as $column) {
                if (!empty($column['column_button_link']['url'])) {
                    $this->add_link_attributes('column_button_link', $column['column_button_link']);
                }
                ?>
                <td>
                    <div class="button">
                        <a <?php $this->print_render_attribute_string('column_button_link'); ?>>
                            <?php echo esc_attr($column['column_button_text']); ?>
                        </a>
                    </div>
                </td>
                <?php
                $this->remove_render_attribute('column_button_link');
            }
            echo '</tr>';

            echo '</table></div>';
        }
    }
}